/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Vector;
import jltl2ba.APSet;
import jltl2ba.SimpleLTL;
import jltl2dstar.DRA;
import jltl2dstar.DRAOptimizations;
import jltl2dstar.LTL2DRA;
import jltl2dstar.NBA;
import jltl2dstar.Options_LTL2DRA;
import prism.PrismException;

public class Scheduler {
    private LTL2DRA _ltl2dra;
    private boolean _opt_limits;
    private double _alpha;
    private boolean _stat_NBA;

    public Scheduler(LTL2DRA lTL2DRA, boolean bl, double d) {
        this._ltl2dra = lTL2DRA;
        this._opt_limits = bl;
        this._alpha = d;
        this._stat_NBA = false;
    }

    public int calcLimit(int n) {
        if (n == 0) {
            return n;
        }
        if (this.flagOptLimits()) {
            double d = (double)n * this._alpha + 1.0;
            n = d > 2.147483647E9 ? 0 : (int)d;
        }
        return n;
    }

    public DRA calculate(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA) throws PrismException {
        if (options_LTL2DRA.verbose_scheduler) {
            System.err.println(simpleLTL);
        }
        Tree_Start tree_Start = new Tree_Start(simpleLTL, aPSet, options_LTL2DRA, this);
        if (options_LTL2DRA.verbose_scheduler) {
            tree_Start.printTree(System.err, 0);
        }
        tree_Start.calculate(0, 0);
        DRA dRA = tree_Start._automaton;
        if (dRA != null) {
            dRA.setComment(tree_Start._comment + this.getTimingInformation());
        }
        return dRA;
    }

    public String getTimingInformation() {
        return "";
    }

    public LTL2DRA getLTL2DRA() {
        return this._ltl2dra;
    }

    public boolean flagOptLimits() {
        return this._opt_limits;
    }

    public boolean flagStatNBA() {
        return this._stat_NBA;
    }

    public void flagStatNBA(boolean bl) {
        this._stat_NBA = bl;
    }

    public static class Tree_Start
    extends Tree {
        public Tree_Start(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA, Scheduler scheduler) {
            super(simpleLTL, aPSet, options_LTL2DRA, scheduler);
            this.generateTree();
        }

        @Override
        public void generateTree() {
            Tree_Rabin tree_Rabin = null;
            Tree_Streett tree_Streett = null;
            if (this._options.automata == Options_LTL2DRA.AutomataType.RABIN || this._options.automata == Options_LTL2DRA.AutomataType.RABIN_AND_STREETT) {
                tree_Rabin = new Tree_Rabin(this._ltl, this._apset, this._options, this._sched);
            }
            if (this._options.automata == Options_LTL2DRA.AutomataType.STREETT || this._options.automata == Options_LTL2DRA.AutomataType.RABIN_AND_STREETT) {
                tree_Streett = new Tree_Streett(this._ltl.negate().simplify(), this._apset, this._options, this._sched);
            }
            if (tree_Rabin != null && tree_Streett != null) {
                int n = tree_Rabin.guestimate();
                int n2 = tree_Streett.guestimate();
                if (this._options.verbose_scheduler) {
                    System.err.println("NBA-Estimates: Rabin: " + n + " Streett: " + n2);
                }
                if (n <= n2) {
                    this.addChild(tree_Rabin);
                    this.addChild(tree_Streett);
                } else {
                    this.addChild(tree_Streett);
                    this.addChild(tree_Rabin);
                }
            } else {
                if (tree_Rabin != null) {
                    this.addChild(tree_Rabin);
                }
                if (tree_Streett != null) {
                    this.addChild(tree_Streett);
                }
            }
        }
    }

    public static abstract class Tree {
        protected SimpleLTL _ltl;
        protected Options_LTL2DRA _options;
        protected int priority;
        protected DRA _automaton;
        protected String _comment;
        protected Scheduler _sched;
        protected APSet _apset;
        protected Vector<Tree> children;

        public Tree(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA, Scheduler scheduler) {
            this._ltl = simpleLTL;
            this._apset = aPSet;
            this._options = options_LTL2DRA;
            this._sched = scheduler;
            this.children = new Vector();
        }

        public void printTree(PrintStream printStream, int n) {
            for (int i = 0; i < n; ++i) {
                printStream.print(" ");
            }
            printStream.println(this.getClass().getName() + " = " + this + "(" + this._ltl + ")");
            for (Tree tree : this.children) {
                tree.printTree(printStream, n + 1);
            }
        }

        public abstract void generateTree();

        public int guestimate() {
            return 0;
        }

        public void hook_after_calculate() {
        }

        public void calculate(int n, int n2) throws PrismException {
            if (this._options.verbose_scheduler) {
                System.err.println("Calculate (" + n + "): " + this.getClass().getName());
            }
            this.calculateChildren(n, n2);
            boolean bl = true;
            for (Tree tree : this.children) {
                if (tree._automaton == null) continue;
                if (bl) {
                    this._automaton = tree._automaton;
                    this._comment = tree._comment;
                } else if (this._automaton.size() > tree._automaton.size()) {
                    this._automaton = tree._automaton;
                    this._comment = tree._comment;
                }
                bl = false;
            }
            this.hook_after_calculate();
        }

        public void addChild(Tree tree) {
            if (tree == null) {
                return;
            }
            this.children.add(tree);
        }

        private void calculateChildren(int n, int n2) throws PrismException {
            if (this._sched.flagOptLimits()) {
                int n3 = 0;
                for (Tree tree : this.children) {
                    int n4 = n3 != 0 ? (n2 > 0 ? (this._sched.calcLimit(n3) < n2 ? this._sched.calcLimit(n3) : n2) : this._sched.calcLimit(n3)) : n2;
                    if (this._options.verbose_scheduler) {
                        System.err.println(" Limit (with alpha) = " + n4);
                    }
                    try {
                        tree.calculate(n + 1, n4);
                        if (tree._automaton == null) continue;
                        if (n3 == 0 || tree._automaton.size() < n3) {
                            DRA dRA = tree._automaton;
                            n3 = dRA.size();
                            continue;
                        }
                        tree._automaton = null;
                    }
                    catch (PrismException prismException) {
                        tree._automaton = null;
                        throw prismException;
                    }
                }
            } else {
                for (Tree tree : this.children) {
                    tree.calculate(n + 1, n2);
                }
            }
        }
    }

    public static class Tree_Streett
    extends Tree {
        private Tree_Rabin _tree_rabin;

        public Tree_Streett(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA, Scheduler scheduler) {
            super(simpleLTL, aPSet, options_LTL2DRA, scheduler);
            this.generateTree();
        }

        @Override
        public int guestimate() {
            if (this.children.get(0) != null) {
                return ((Tree)this.children.get(0)).guestimate();
            }
            return 0;
        }

        public NBA getNBA() {
            if (this._tree_rabin != null) {
                return this._tree_rabin.getNBA();
            }
            return null;
        }

        @Override
        public void generateTree() {
            Options_LTL2DRA options_LTL2DRA = this._options;
            options_LTL2DRA.automata = Options_LTL2DRA.AutomataType.RABIN;
            this._tree_rabin = new Tree_Rabin(this._ltl, this._apset, options_LTL2DRA, this._sched);
            this.addChild(this._tree_rabin);
        }

        @Override
        public void calculate(int n, int n2) throws PrismException {
            if (this._options.verbose_scheduler) {
                System.err.println("Calculate (" + n + "): " + this.getClass().getName());
            }
            try {
                ((Tree)this.children.get(0)).calculate(n, n2);
            }
            catch (PrismException prismException) {
                this._automaton = null;
                throw prismException;
            }
            this._automaton = ((Tree)this.children.get((int)0))._automaton;
            this._comment = "Streett{" + ((Tree)this.children.get((int)0))._comment + "}";
            if (this._automaton != null) {
                this._automaton.considerAsStreett(true);
            }
            this.hook_after_calculate();
        }
    }

    public static class Tree_Union
    extends Tree {
        private Tree_Rabin _left_tree = null;
        private Tree_Rabin _right_tree = null;
        private SimpleLTL _left;
        private SimpleLTL _right;

        public Tree_Union(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA, Scheduler scheduler) {
            super(simpleLTL, aPSet, options_LTL2DRA, scheduler);
            this._left = this._ltl.left;
            this._right = this._ltl.right;
            this.generateTree();
        }

        @Override
        public void generateTree() {
            Options_LTL2DRA options_LTL2DRA = this._options.clone();
            options_LTL2DRA.recursion();
            this._left_tree = new Tree_Rabin(this._left, this._apset, options_LTL2DRA, this._sched);
            this.addChild(this._left_tree);
            this._right_tree = new Tree_Rabin(this._right, this._apset, options_LTL2DRA, this._sched);
            this.addChild(this._right_tree);
        }

        @Override
        public void calculate(int n, int n2) throws PrismException {
            if (this._options.verbose_scheduler) {
                System.err.println("Calculate (" + n + "): " + this.getClass().getName());
            }
            try {
                ((Tree)this.children.get(0)).calculate(n + 1, n2);
                ((Tree)this.children.get(1)).calculate(n + 1, n2);
            }
            catch (PrismException prismException) {
                this._automaton = null;
                throw prismException;
            }
            if (((Tree)this.children.get((int)0))._automaton == null || ((Tree)this.children.get((int)1))._automaton == null) {
                return;
            }
            boolean bl = this._sched.getLTL2DRA().getOptions().union_trueloop;
            this._automaton = ((Tree)this.children.get((int)0))._automaton.calculateUnion(((Tree)this.children.get((int)1))._automaton, bl, this._options.detailed_states);
            this._comment = "Union{" + ((Tree)this.children.get((int)0))._comment + "," + ((Tree)this.children.get((int)1))._comment + "}";
            if (this._options.optimizeAcceptance) {
                this._automaton.optimizeAcceptanceCondition();
            }
            if (this._options.bisim) {
                DRAOptimizations dRAOptimizations = new DRAOptimizations();
                this._automaton = dRAOptimizations.optimizeBisimulation(this._automaton, false, this._options.detailed_states, false);
            }
            this.hook_after_calculate();
        }
    }

    public static class Tree_Safra
    extends Tree {
        private NBA _nba;

        public Tree_Safra(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA, Scheduler scheduler) {
            super(simpleLTL, aPSet, options_LTL2DRA, scheduler);
            this.generateTree();
        }

        @Override
        public void generateTree() {
        }

        public void generateNBA() {
            if (this._nba == null) {
                try {
                    this._nba = this._ltl.toNBA(this._apset);
                }
                catch (PrismException prismException) {
                    this._nba = null;
                    System.err.println("Scheduler.generateNBA() : " + prismException);
                }
            }
        }

        public NBA getNBA() {
            this.generateNBA();
            return this._nba;
        }

        @Override
        public int guestimate() {
            this.generateNBA();
            if (this._nba != null) {
                return this._nba.size();
            }
            return 0;
        }

        @Override
        public void calculate(int n, int n2) throws PrismException {
            if (this._options.verbose_scheduler) {
                System.err.println("Calculate (" + n + "): " + this.getClass().getName());
                System.err.println(" Limit = " + n2);
            }
            this.generateNBA();
            if (this._nba == null) {
                throw new PrismException("Couldn't create NBA from LTL formula");
            }
            this._automaton = this._sched.getLTL2DRA().nba2dra(this._nba, n2, this._options.detailed_states);
            this._comment = "Safra[NBA=" + this._nba.size() + "]";
            if (this._options.optimizeAcceptance) {
                this._automaton.optimizeAcceptanceCondition();
            }
            if (this._options.bisim) {
                DRAOptimizations dRAOptimizations = new DRAOptimizations();
                this._automaton = dRAOptimizations.optimizeBisimulation(this._automaton, false, this._options.detailed_states, false);
            }
        }
    }

    public static class Tree_Rabin
    extends Tree {
        private Tree_Safra _tree_normal = null;
        private Tree_Union _tree_union = null;

        public Tree_Rabin(SimpleLTL simpleLTL, APSet aPSet, Options_LTL2DRA options_LTL2DRA, Scheduler scheduler) {
            super(simpleLTL, aPSet, options_LTL2DRA, scheduler);
            this.generateTree();
        }

        @Override
        public int guestimate() {
            if (this._tree_normal != null) {
                return this._tree_normal.guestimate();
            }
            return 0;
        }

        @Override
        public void hook_after_calculate() {
            if (this._tree_normal != null && this._sched.flagStatNBA()) {
                this._comment = this._comment + "+NBAstd=" + this.guestimate();
            }
        }

        @Override
        public void generateTree() {
            if (this._options.allow_union && this._ltl.kind == SimpleLTL.LTLType.OR) {
                this._tree_union = new Tree_Union(this._ltl, this._apset, this._options, this._sched);
                this.addChild(this._tree_union);
            }
            if (!this._options.only_union || !this._options.allow_union) {
                this._tree_normal = new Tree_Safra(this._ltl, this._apset, this._options, this._sched);
                this.addChild(this._tree_normal);
            }
        }

        public NBA getNBA() {
            if (this._tree_normal != null) {
                return this._tree_normal.getNBA();
            }
            return null;
        }
    }
}

