/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import jdd.DebugJDD;
import jdd.JDD;

public class JDDNode {
    private long ptr;

    protected static native boolean DDN_IsConstant(long var0);

    protected static native int DDN_GetIndex(long var0);

    protected static native double DDN_GetValue(long var0);

    protected static native long DDN_GetThen(long var0);

    protected static native long DDN_GetElse(long var0);

    protected JDDNode(long l) {
        this.ptr = l;
    }

    public long ptr() {
        return this.ptr;
    }

    public boolean isConstant() {
        return JDDNode.DDN_IsConstant(this.ptr);
    }

    public int getIndex() {
        return JDDNode.DDN_GetIndex(this.ptr);
    }

    public double getValue() {
        if (DebugJDD.debugEnabled) {
            return DebugJDD.nodeGetValue(this);
        }
        return JDDNode.DDN_GetValue(this.ptr);
    }

    public JDDNode getThen() {
        if (DebugJDD.debugEnabled) {
            return DebugJDD.nodeGetThen(this);
        }
        long l = JDDNode.DDN_GetThen(this.ptr);
        if (l == 0L) {
            if (this.isConstant()) {
                throw new RuntimeException("Trying to access the 'then' child of a constant MTBDD node");
            }
            throw new RuntimeException("getThen: CUDD returned NULL, but node is not a constant node. Out of memory or corrupted MTBDD?");
        }
        return new JDDNode(l);
    }

    public JDDNode getElse() {
        if (DebugJDD.debugEnabled) {
            return DebugJDD.nodeGetElse(this);
        }
        long l = JDDNode.DDN_GetElse(this.ptr);
        if (l == 0L) {
            if (this.isConstant()) {
                throw new RuntimeException("Trying to access the 'else' child of a constant MTBDD node");
            }
            throw new RuntimeException("getElse: CUDD returned NULL, but node is not a constant node. Out of memory or corrupted MTBDD?");
        }
        return new JDDNode(l);
    }

    public boolean equals(Object object) {
        return object instanceof JDDNode && ((JDDNode)object).ptr == this.ptr;
    }

    public int hashCode() {
        return (int)this.ptr;
    }

    public String toString() {
        String string = "" + this.ptr;
        if (this.ptr != 0L) {
            if (this.isConstant()) {
                string = string + " value=" + this.getValue();
            }
            string = string + " references=" + DebugJDD.getRefCount(this);
        }
        return string;
    }

    public JDDNode copy() {
        if (DebugJDD.debugEnabled) {
            return DebugJDD.Copy(this);
        }
        JDDNode jDDNode = new JDDNode(this.ptr());
        JDD.Ref(jDDNode);
        return jDDNode;
    }

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

