/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.Product;
import explicit.rewards.StateRewards;
import java.util.ArrayList;

public class StateRewardsSimple<Value>
extends StateRewards<Value> {
    protected ArrayList<Value> stateRewards;

    public StateRewardsSimple() {
        this.stateRewards = new ArrayList();
    }

    public StateRewardsSimple(StateRewardsSimple<Value> stateRewardsSimple) {
        this.setEvaluator(stateRewardsSimple.getEvaluator());
        this.stateRewards = stateRewardsSimple.stateRewards == null ? null : new ArrayList<Value>(stateRewardsSimple.stateRewards);
    }

    public void setStateReward(int n, Value Value2) {
        if (this.getEvaluator().isZero(Value2) && n >= this.stateRewards.size()) {
            return;
        }
        int n2 = n - this.stateRewards.size() + 1;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                this.stateRewards.add(this.getEvaluator().zero());
            }
        }
        this.stateRewards.set(n, Value2);
    }

    public void addToStateReward(int n, Value Value2) {
        this.setStateReward(n, this.getEvaluator().add(this.getStateReward(n), Value2));
    }

    @Override
    public Value getStateReward(int n) {
        try {
            return this.stateRewards.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return this.getEvaluator().zero();
        }
    }

    @Override
    public StateRewards<Value> liftFromModel(Product<?> product) {
        Object obj = product.getProductModel();
        int n = obj.getNumStates();
        StateRewardsSimple<Value> stateRewardsSimple = new StateRewardsSimple<Value>();
        stateRewardsSimple.setEvaluator(this.getEvaluator());
        for (int i = 0; i < n; ++i) {
            stateRewardsSimple.setStateReward(i, this.getStateReward(product.getModelState(i)));
        }
        return stateRewardsSimple;
    }

    @Override
    public StateRewardsSimple<Value> deepCopy() {
        return new StateRewardsSimple<Value>(this);
    }
}

