/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.Product;
import explicit.rewards.StateRewards;
import java.util.Arrays;

public class StateRewardsArray
extends StateRewards<Double> {
    protected double[] stateRewards;

    public StateRewardsArray(int n) {
        this.stateRewards = new double[n];
    }

    public StateRewardsArray(StateRewardsArray stateRewardsArray) {
        this.stateRewards = Arrays.copyOf(stateRewardsArray.stateRewards, stateRewardsArray.stateRewards.length);
    }

    public void setStateReward(int n, double d) {
        this.stateRewards[n] = d;
    }

    public void addToStateReward(int n, double d) {
        int n2 = n;
        this.stateRewards[n2] = this.stateRewards[n2] + d;
    }

    @Override
    public Double getStateReward(int n) {
        return this.stateRewards[n];
    }

    @Override
    public StateRewards<Double> liftFromModel(Product<?> product) {
        Object obj = product.getProductModel();
        int n = obj.getNumStates();
        StateRewardsArray stateRewardsArray = new StateRewardsArray(n);
        for (int i = 0; i < n; ++i) {
            stateRewardsArray.setStateReward(i, this.stateRewards[product.getModelState(i)]);
        }
        return stateRewardsArray;
    }

    public StateRewardsArray deepCopy() {
        return new StateRewardsArray(this);
    }
}

