/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.Product;
import explicit.rewards.MDPRewards;
import explicit.rewards.RewardsExplicit;
import java.util.ArrayList;
import java.util.List;

public class MDPRewardsSimple<Value>
extends RewardsExplicit<Value>
implements MDPRewards<Value> {
    protected int numStates;
    protected List<Value> stateRewards;
    protected List<List<Value>> transRewards;
    protected Value zeroReplacement;

    public MDPRewardsSimple(int n) {
        this.numStates = n;
        this.stateRewards = null;
        this.transRewards = null;
    }

    public MDPRewardsSimple(MDPRewardsSimple<Value> mDPRewardsSimple) {
        int n;
        this.setEvaluator(mDPRewardsSimple.getEvaluator());
        this.numStates = mDPRewardsSimple.numStates;
        if (mDPRewardsSimple.stateRewards == null) {
            this.stateRewards = null;
        } else {
            this.stateRewards = new ArrayList<Value>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                this.stateRewards.add(mDPRewardsSimple.stateRewards.get(n));
            }
        }
        if (mDPRewardsSimple.transRewards == null) {
            this.transRewards = null;
        } else {
            this.transRewards = new ArrayList<List<Value>>(this.numStates);
            for (n = 0; n < this.numStates; ++n) {
                List<Value> list = mDPRewardsSimple.transRewards.get(n);
                if (list == null) {
                    this.transRewards.add(null);
                    continue;
                }
                int n2 = list.size();
                ArrayList<Value> arrayList = new ArrayList<Value>(n2);
                this.transRewards.add(arrayList);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(list.get(i));
                }
            }
        }
        this.setZeroReplacement(mDPRewardsSimple.getZeroReplacement());
    }

    public void setStateReward(int n, Value Value2) {
        if (this.stateRewards == null) {
            this.stateRewards = new ArrayList<Value>(this.numStates);
            for (int i = 0; i < this.numStates; ++i) {
                this.stateRewards.add(this.getEvaluator().zero());
            }
        }
        this.stateRewards.set(n, Value2);
    }

    public void addToStateReward(int n, Value Value2) {
        this.setStateReward(n, this.getEvaluator().add(this.getStateReward(n), Value2));
    }

    public void setTransitionReward(int n, int n2, Value Value2) {
        List<Object> list;
        int n3;
        if (this.transRewards == null) {
            this.transRewards = new ArrayList<List<Value>>(this.numStates);
            for (n3 = 0; n3 < this.numStates; ++n3) {
                this.transRewards.add(null);
            }
        }
        if (this.transRewards.get(n) == null) {
            list = new ArrayList();
            this.transRewards.set(n, list);
        } else {
            list = this.transRewards.get(n);
        }
        n3 = n2 - list.size() + 1;
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                list.add(this.getEvaluator().zero());
            }
        }
        list.set(n2, Value2);
    }

    public void addToTransitionReward(int n, int n2, Value Value2) {
        this.setTransitionReward(n, n2, this.getEvaluator().add(this.getTransitionReward(n, n2), Value2));
    }

    public void clearRewards(int n) {
        this.setStateReward(n, this.getEvaluator().zero());
        if (this.transRewards != null && this.transRewards.size() > n) {
            this.transRewards.set(n, null);
        }
    }

    public void setZeroReplacement(Value Value2) {
        this.zeroReplacement = Value2;
    }

    public Value getZeroReplacement() {
        if (this.zeroReplacement == null) {
            this.zeroReplacement = this.getEvaluator().zero();
        }
        return this.zeroReplacement;
    }

    @Override
    public Value getStateReward(int n) {
        if (this.stateRewards == null) {
            return this.getZeroReplacement();
        }
        return !this.getEvaluator().isZero(this.stateRewards.get(n)) ? this.stateRewards.get(n) : this.getZeroReplacement();
    }

    @Override
    public Value getTransitionReward(int n, int n2) {
        List<Value> list;
        if (this.transRewards == null || (list = this.transRewards.get(n)) == null) {
            return this.getZeroReplacement();
        }
        if (list.size() <= n2) {
            return this.getZeroReplacement();
        }
        return !this.getEvaluator().isZero(list.get(n2)) ? list.get(n2) : this.getZeroReplacement();
    }

    @Override
    public MDPRewards<Value> liftFromModel(Product<?> product) {
        int n;
        Object obj = product.getProductModel();
        int n2 = obj.getNumStates();
        MDPRewardsSimple<Value> mDPRewardsSimple = new MDPRewardsSimple<Value>(n2);
        mDPRewardsSimple.setEvaluator(this.getEvaluator());
        if (this.stateRewards != null) {
            for (n = 0; n < n2; ++n) {
                mDPRewardsSimple.setStateReward(n, this.stateRewards.get(product.getModelState(n)));
            }
        }
        if (this.transRewards != null) {
            for (n = 0; n < n2; ++n) {
                List<Value> list = this.transRewards.get(product.getModelState(n));
                if (list == null) continue;
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    mDPRewardsSimple.setTransitionReward(n, i, list.get(i));
                }
            }
        }
        return mDPRewardsSimple;
    }

    public String toString() {
        return "st: " + this.stateRewards + "; tr:" + this.transRewards;
    }

    @Override
    public boolean hasTransitionRewards() {
        return this.transRewards != null;
    }
}

