/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.CSG;
import explicit.DTMC;
import explicit.MDP;
import explicit.Model;
import explicit.SMG;
import explicit.STPG;
import explicit.rewards.CSGRewards;
import explicit.rewards.CSGRewardsSimple;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.MDPRewardsSimple;
import explicit.rewards.Rewards;
import explicit.rewards.SMGRewards;
import explicit.rewards.SMGRewardsSimple;
import explicit.rewards.STPGRewards;
import explicit.rewards.STPGRewardsSimple;
import explicit.rewards.StateRewards;
import explicit.rewards.StateRewardsArray;
import explicit.rewards.StateRewardsConstant;
import explicit.rewards.StateRewardsSimple;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import parser.State;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import prism.Evaluator;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.RewardGenerator;

public class ConstructRewards
extends PrismComponent {
    protected ModulesFile modulesFile;
    protected boolean allowNegative = false;

    public ConstructRewards(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public void allowNegativeRewards() {
        this.allowNegative = true;
    }

    public <Value> Rewards<Value> buildRewardStructure(Model<Value> model, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        Rewards<Value> rewards = null;
        switch (model.getModelType()) {
            case DTMC: 
            case CTMC: 
            case IDTMC: {
                rewards = this.buildMCRewardStructure((DTMC)model, rewardGenerator, n);
                break;
            }
            case MDP: 
            case POMDP: 
            case IMDP: {
                rewards = this.buildMDPRewardStructure((MDP)model, rewardGenerator, n);
                break;
            }
            case STPG: {
                rewards = this.buildSTPGRewardStructure((STPG)model, rewardGenerator, n);
                break;
            }
            case SMG: {
                rewards = this.buildSMGRewardStructure((SMG)model, rewardGenerator, n);
                break;
            }
            case CSG: {
                rewards = this.buildCSGRewardStructure((CSG)model, rewardGenerator, n);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot build rewards for " + model.getModelType() + "s");
            }
        }
        return rewards;
    }

    public <Value> Rewards<Value> buildMCRewardStructure(DTMC<Value> dTMC, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        if (rewardGenerator.rewardStructHasTransitionRewards(n)) {
            throw new PrismNotSupportedException("Explicit engine does not yet handle transition rewards for D/CTMCs");
        }
        boolean bl = rewardGenerator.getRewardEvaluator().one() instanceof Double;
        int n2 = dTMC.getNumStates();
        List<State> list = dTMC.getStatesList();
        StateRewards stateRewards = null;
        StateRewardsArray stateRewardsArray = null;
        StateRewardsSimple<Value> stateRewardsSimple = null;
        if (bl) {
            stateRewardsArray = new StateRewardsArray(n2);
            stateRewards = stateRewardsArray;
        } else {
            stateRewardsSimple = new StateRewardsSimple<Value>();
            stateRewards = stateRewardsSimple;
        }
        stateRewards.setEvaluator(rewardGenerator.getRewardEvaluator());
        for (int i = 0; i < n2; ++i) {
            if (!rewardGenerator.rewardStructHasStateRewards(n)) continue;
            Value Value2 = this.getAndCheckStateReward(i, rewardGenerator, n, list);
            if (bl) {
                stateRewardsArray.addToStateReward(i, (Double)Value2);
                continue;
            }
            stateRewardsSimple.addToStateReward(i, Value2);
        }
        return stateRewards;
    }

    public <Value> Rewards<Value> buildMDPRewardStructure(MDP<Value> mDP, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        int n2 = mDP.getNumStates();
        List<State> list = mDP.getStatesList();
        MDPRewardsSimple<Value> mDPRewardsSimple = null;
        mDPRewardsSimple = new MDPRewardsSimple<Value>(n2);
        mDPRewardsSimple.setEvaluator(rewardGenerator.getRewardEvaluator());
        for (int i = 0; i < n2; ++i) {
            if (rewardGenerator.rewardStructHasStateRewards(n)) {
                Value Value2 = this.getAndCheckStateReward(i, rewardGenerator, n, list);
                mDPRewardsSimple.addToStateReward(i, Value2);
            }
            if (!rewardGenerator.rewardStructHasTransitionRewards(n) || mDP.isDeadlockState(i)) continue;
            int n3 = mDP.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                Value Value3 = this.getAndCheckStateActionReward(i, mDP.getAction(i, j), rewardGenerator, n, list);
                mDPRewardsSimple.addToTransitionReward(i, j, Value3);
            }
        }
        return mDPRewardsSimple;
    }

    public <Value> STPGRewards<Value> buildSTPGRewardStructure(STPG<Value> sTPG, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        int n2 = sTPG.getNumStates();
        List<State> list = sTPG.getStatesList();
        STPGRewardsSimple<Value> sTPGRewardsSimple = null;
        sTPGRewardsSimple = new STPGRewardsSimple<Value>(n2);
        sTPGRewardsSimple.setEvaluator(rewardGenerator.getRewardEvaluator());
        for (int i = 0; i < n2; ++i) {
            if (rewardGenerator.rewardStructHasStateRewards(n)) {
                Value Value2 = this.getAndCheckStateReward(i, rewardGenerator, n, list);
                sTPGRewardsSimple.addToStateReward(i, Value2);
            }
            if (!rewardGenerator.rewardStructHasTransitionRewards(n) || sTPG.isDeadlockState(i)) continue;
            int n3 = sTPG.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                Value Value3 = this.getAndCheckStateActionReward(i, sTPG.getAction(i, j), rewardGenerator, n, list);
                sTPGRewardsSimple.addToTransitionReward(i, j, Value3);
            }
        }
        return sTPGRewardsSimple;
    }

    public <Value> SMGRewards<Value> buildSMGRewardStructure(SMG<Value> sMG, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        int n2 = sMG.getNumStates();
        List<State> list = sMG.getStatesList();
        SMGRewardsSimple<Value> sMGRewardsSimple = null;
        sMGRewardsSimple = new SMGRewardsSimple<Value>(n2);
        sMGRewardsSimple.setEvaluator(rewardGenerator.getRewardEvaluator());
        for (int i = 0; i < n2; ++i) {
            if (rewardGenerator.rewardStructHasStateRewards(n)) {
                Value Value2 = this.getAndCheckStateReward(i, rewardGenerator, n, list);
                sMGRewardsSimple.addToStateReward(i, Value2);
            }
            if (!rewardGenerator.rewardStructHasTransitionRewards(n) || sMG.isDeadlockState(i)) continue;
            int n3 = sMG.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                Value Value3 = this.getAndCheckStateActionReward(i, sMG.getAction(i, j), rewardGenerator, n, list);
                sMGRewardsSimple.addToTransitionReward(i, j, Value3);
            }
        }
        return sMGRewardsSimple;
    }

    public <Value> CSGRewards<Value> buildCSGRewardStructure(CSG<Value> cSG, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        int n2 = cSG.getNumStates();
        List<State> list = cSG.getStatesList();
        CSGRewardsSimple<Value> cSGRewardsSimple = null;
        cSGRewardsSimple = new CSGRewardsSimple<Value>(n2);
        cSGRewardsSimple.setEvaluator(rewardGenerator.getRewardEvaluator());
        for (int i = 0; i < n2; ++i) {
            if (rewardGenerator.rewardStructHasStateRewards(n)) {
                Value Value2 = this.getAndCheckStateReward(i, rewardGenerator, n, list);
                cSGRewardsSimple.addToStateReward(i, Value2);
            }
            if (!rewardGenerator.rewardStructHasTransitionRewards(n) || cSG.isDeadlockState(i)) continue;
            int n3 = cSG.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                Value Value3 = this.getAndCheckStateActionReward(i, cSG.getIndexes(i, j), rewardGenerator, n, list);
                cSGRewardsSimple.addToTransitionReward(i, j, Value3);
            }
        }
        return cSGRewardsSimple;
    }

    private <Value> Value getAndCheckStateReward(int n, RewardGenerator<Value> rewardGenerator, int n2, List<State> list) throws PrismException {
        Evaluator<Value> evaluator = rewardGenerator.getRewardEvaluator();
        Value Value2 = evaluator.zero();
        Comparable<State> comparable = null;
        if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE)) {
            State state;
            comparable = state = list.get(n);
            Value2 = rewardGenerator.getStateReward(n2, state);
        } else if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE_INDEX)) {
            comparable = n;
            Value2 = rewardGenerator.getStateReward(n2, n);
        } else {
            throw new PrismException("Unknown reward lookup mechanism for reward generator");
        }
        this.checkStateReward(Value2, evaluator, comparable, null);
        return Value2;
    }

    private <Value> Value getAndCheckStateActionReward(int n, Object object, RewardGenerator<Value> rewardGenerator, int n2, List<State> list) throws PrismException {
        Evaluator<Value> evaluator = rewardGenerator.getRewardEvaluator();
        Value Value2 = evaluator.zero();
        Comparable<State> comparable = null;
        if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE)) {
            State state;
            comparable = state = list.get(n);
            Value2 = rewardGenerator.getStateActionReward(n2, state, object);
        } else if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE_INDEX)) {
            comparable = n;
            Value2 = rewardGenerator.getStateActionReward(n2, n, object);
        } else {
            throw new PrismException("Unknown reward lookup mechanism for reward generator");
        }
        this.checkTransitionReward(Value2, evaluator, comparable, null);
        return Value2;
    }

    public Rewards<Double> buildRewardStructure(Model<Double> model, RewardStruct rewardStruct, Values values) throws PrismException {
        switch (model.getModelType()) {
            case DTMC: 
            case CTMC: {
                return this.buildMCRewardStructure((DTMC)model, rewardStruct, values);
            }
            case MDP: 
            case POMDP: {
                return this.buildMDPRewardStructure((MDP)model, rewardStruct, values);
            }
            case STPG: {
                return this.buildSTPGRewardStructure((STPG)model, rewardStruct, values);
            }
            case SMG: {
                return this.buildSMGRewardStructure((SMG)model, rewardStruct, values);
            }
            case CSG: {
                return this.buildCSGRewardStructure((CSG)model, rewardStruct, values);
            }
        }
        throw new PrismNotSupportedException("Cannot build rewards for " + model.getModelType() + "s");
    }

    public MCRewards<Double> buildMCRewardStructure(DTMC<Double> dTMC, RewardStruct rewardStruct, Values values) throws PrismException {
        if (rewardStruct.getNumTransItems() > 0) {
            throw new PrismNotSupportedException("Explicit engine does not yet handle transition rewards for D/CTMCs");
        }
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            this.checkStateReward(d, null, rewardStruct.getReward(0));
            return new StateRewardsConstant<Double>(d);
        }
        int n = dTMC.getNumStates();
        List<State> list = dTMC.getStatesList();
        StateRewardsArray stateRewardsArray = new StateRewardsArray(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            for (int j = 0; j < n; ++j) {
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                double d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                this.checkStateReward(d, list.get(j), rewardStruct.getReward(i));
                stateRewardsArray.addToStateReward(j, d);
            }
        }
        return stateRewardsArray;
    }

    public MDPRewards<Double> buildMDPRewardStructure(MDP<Double> mDP, RewardStruct rewardStruct, Values values) throws PrismException {
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            this.checkStateReward(d, null, rewardStruct.getReward(0));
            return new StateRewardsConstant<Double>(d);
        }
        int n = mDP.getNumStates();
        List<State> list = mDP.getStatesList();
        MDPRewardsSimple<Double> mDPRewardsSimple = new MDPRewardsSimple<Double>(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            for (int j = 0; j < n; ++j) {
                double d;
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                    if (mDP.isDeadlockState(j)) continue;
                    int n3 = mDP.getNumChoices(j);
                    for (int k = 0; k < n3; ++k) {
                        Object object = mDP.getAction(j, k);
                        if (!(object == null ? string.isEmpty() : object.equals(string))) continue;
                        d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                        this.checkTransitionReward(d, list.get(j), rewardStruct.getReward(i));
                        mDPRewardsSimple.addToTransitionReward(j, k, d);
                    }
                    continue;
                }
                d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                this.checkStateReward(d, list.get(j), rewardStruct.getReward(i));
                mDPRewardsSimple.addToStateReward(j, d);
            }
        }
        return mDPRewardsSimple;
    }

    public STPGRewards<Double> buildSTPGRewardStructure(STPG<Double> sTPG, RewardStruct rewardStruct, Values values) throws PrismException {
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            this.checkStateReward(d, null, rewardStruct.getReward(0));
            return new StateRewardsConstant<Double>(d);
        }
        int n = sTPG.getNumStates();
        List<State> list = sTPG.getStatesList();
        STPGRewardsSimple<Double> sTPGRewardsSimple = new STPGRewardsSimple<Double>(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            for (int j = 0; j < n; ++j) {
                double d;
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                    int n3 = sTPG.getNumChoices(j);
                    for (int k = 0; k < n3; ++k) {
                        Object object = sTPG.getAction(j, k);
                        d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                        this.checkTransitionReward(d, list.get(j), rewardStruct.getReward(i));
                        if (!(object == null ? string.isEmpty() : object.equals(string))) continue;
                        sTPGRewardsSimple.addToTransitionReward(j, k, d);
                    }
                    continue;
                }
                d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                this.checkStateReward(d, list.get(j), rewardStruct.getReward(i));
                sTPGRewardsSimple.addToStateReward(j, d);
            }
        }
        return sTPGRewardsSimple;
    }

    public SMGRewards<Double> buildSMGRewardStructure(SMG<Double> sMG, RewardStruct rewardStruct, Values values) throws PrismException {
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            this.checkStateReward(d, null, rewardStruct.getReward(0));
            return new StateRewardsConstant<Double>(d);
        }
        int n = sMG.getNumStates();
        List<State> list = sMG.getStatesList();
        SMGRewardsSimple<Double> sMGRewardsSimple = new SMGRewardsSimple<Double>(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            for (int j = 0; j < n; ++j) {
                double d;
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                    int n3 = sMG.getNumChoices(j);
                    for (int k = 0; k < n3; ++k) {
                        Object object = sMG.getAction(j, k);
                        if (!(object == null ? string.isEmpty() : object.equals(string))) continue;
                        d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                        this.checkTransitionReward(d, list.get(j), rewardStruct.getReward(i));
                        sMGRewardsSimple.addToTransitionReward(j, k, d);
                    }
                    continue;
                }
                d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                this.checkStateReward(d, list.get(j), rewardStruct.getReward(i));
                sMGRewardsSimple.addToStateReward(j, d);
            }
        }
        return sMGRewardsSimple;
    }

    public CSGRewards<Double> buildCSGRewardStructure(CSG<Double> cSG, RewardStruct rewardStruct, Values values) throws PrismException {
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            this.checkStateReward(d, null, rewardStruct.getReward(0));
            return (CSGRewards)((Object)new StateRewardsConstant<Double>(d));
        }
        int n = cSG.getNumStates();
        List<State> list = cSG.getStatesList();
        CSGRewardsSimple<Double> cSGRewardsSimple = new CSGRewardsSimple<Double>(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            bitSet2.clear();
            if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                Iterator<Integer> iterator = rewardStruct.getRewardStructItem(i).getSynchIndices().iterator();
                while (iterator.hasNext()) {
                    int n3 = iterator.next();
                    if (n3 == 0) continue;
                    bitSet2.set(n3);
                }
            }
            for (int j = 0; j < n; ++j) {
                double d;
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                    int n4 = cSG.getNumChoices(j);
                    for (int k = 0; k < n4; ++k) {
                        bitSet.clear();
                        for (Object object : (Iterator<Integer>)cSG.getIndexes(j, k)) {
                            if (object == -1) continue;
                            bitSet.set((int)object);
                        }
                        BitSet bitSet3 = (BitSet)bitSet2.clone();
                        bitSet3.andNot(bitSet);
                        if (!bitSet2.isEmpty() && (bitSet2.isEmpty() || !bitSet3.isEmpty())) continue;
                        d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                        this.checkTransitionReward(d, list.get(j), rewardStruct.getReward(i));
                        cSGRewardsSimple.addToTransitionReward(j, k, d);
                    }
                    continue;
                }
                d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                this.checkStateReward(d, list.get(j), rewardStruct.getReward(i));
                cSGRewardsSimple.addToStateReward(j, d);
            }
        }
        return cSGRewardsSimple;
    }

    public MCRewards<Double> buildMCRewardsFromPrismExplicit(DTMC<Double> dTMC, File file, File file2) throws PrismException {
        int n = 0;
        StateRewardsArray stateRewardsArray = new StateRewardsArray(dTMC.getNumStates());
        if (file != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string = bufferedReader.readLine();
                n = 1;
                if (string == null) {
                    throw new PrismException("Missing first line of state rewards file");
                }
                string = bufferedReader.readLine();
                ++n;
                while (string != null) {
                    if ((string = string.trim()).length() > 0) {
                        String[] stringArray = string.split(" ");
                        int n2 = Integer.parseInt(stringArray[0]);
                        double d = Double.parseDouble(stringArray[1]);
                        this.checkStateReward(d, n2, null);
                        stateRewardsArray.setStateReward(n2, d);
                    }
                    string = bufferedReader.readLine();
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read state rewards from file \"" + file + "\"" + iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in state rewards file (line " + n + ") for MDP");
            }
        }
        if (file2 != null) {
            throw new PrismNotSupportedException("Explicit engine does not yet handle transition rewards for D/CTMCs");
        }
        return stateRewardsArray;
    }

    public MDPRewards<Double> buildMDPRewardsFromPrismExplicit(MDP<Double> mDP, File file, File file2) throws PrismException {
        double d;
        int n;
        String[] stringArray;
        String string;
        BufferedReader bufferedReader;
        int n2 = 0;
        MDPRewardsSimple<Double> mDPRewardsSimple = new MDPRewardsSimple<Double>(mDP.getNumStates());
        if (file != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    string = bufferedReader.readLine();
                    n2 = 1;
                    if (string == null) {
                        throw new PrismException("Missing first line of state rewards file");
                    }
                    string = bufferedReader.readLine();
                    ++n2;
                    while (string != null) {
                        if ((string = string.trim()).length() > 0) {
                            stringArray = string.split(" ");
                            n = Integer.parseInt(stringArray[0]);
                            d = Double.parseDouble(stringArray[1]);
                            this.checkStateReward(d, n, null);
                            mDPRewardsSimple.setStateReward(n, d);
                        }
                        string = bufferedReader.readLine();
                        ++n2;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read state rewards from file \"" + file + "\"" + iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in state rewards file (line " + n2 + ") for MDP");
            }
        }
        if (file2 != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                try {
                    string = bufferedReader.readLine();
                    n2 = 1;
                    if (string == null) {
                        throw new PrismException("Missing first line of transition rewards file");
                    }
                    string = bufferedReader.readLine();
                    ++n2;
                    while (string != null) {
                        if ((string = string.trim()).length() > 0) {
                            stringArray = string.split(" ");
                            n = Integer.parseInt(stringArray[0]);
                            int n3 = Integer.parseInt(stringArray[1]);
                            d = Double.parseDouble(stringArray[3]);
                            this.checkTransitionReward(d, n, null);
                            mDPRewardsSimple.setTransitionReward(n, n3, d);
                        }
                        string = bufferedReader.readLine();
                        ++n2;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read transition rewards from file \"" + file2 + "\"" + iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in transition rewards file (line " + n2 + ") for MDP");
            }
        }
        return mDPRewardsSimple;
    }

    private <Value> void checkStateReward(Value Value2, Evaluator<Value> evaluator, Object object, ASTElement aSTElement) throws PrismException {
        Object object2 = null;
        if (!evaluator.isFinite(Value2)) {
            object2 = "State reward is not finite";
        } else if (!this.allowNegative && !evaluator.geq(Value2, evaluator.zero())) {
            object2 = "State reward is negative (" + Value2 + ")";
        }
        if (object2 != null) {
            if (object != null) {
                object2 = (String)object2 + " at state " + object;
            }
            if (aSTElement != null) {
                throw new PrismLangException((String)object2, aSTElement);
            }
            throw new PrismException((String)object2);
        }
    }

    private <Value> void checkTransitionReward(Value Value2, Evaluator<Value> evaluator, Object object, ASTElement aSTElement) throws PrismException {
        Object object2 = null;
        if (!evaluator.isFinite(Value2)) {
            object2 = "Transition reward is not finite";
        } else if (!this.allowNegative && !evaluator.geq(Value2, evaluator.zero())) {
            object2 = "Transition reward is negative (" + Value2 + ")";
        }
        if (object2 != null) {
            if (object != null) {
                object2 = (String)object2 + " at state " + object;
            }
            if (aSTElement != null) {
                throw new PrismLangException((String)object2, aSTElement);
            }
            throw new PrismException((String)object2);
        }
    }

    private <Value> void checkStateReward(double d, Object object, ASTElement aSTElement) throws PrismException {
        this.checkStateReward(d, Evaluator.forDouble(), object, aSTElement);
    }

    private <Value> void checkTransitionReward(double d, Object object, ASTElement aSTElement) throws PrismException {
        this.checkTransitionReward(d, Evaluator.forDouble(), object, aSTElement);
    }
}

