/*
 * Decompiled with CFR 0.152.
 */
package explicit.graphviz;

import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;

public class ShowRewardDecorator<Value>
implements Decorator {
    private Rewards<Value> rewards;
    private boolean showZero;

    public ShowRewardDecorator(Rewards<Value> rewards) {
        this(rewards, false);
    }

    public ShowRewardDecorator(Rewards<Value> rewards, boolean bl) {
        this.rewards = rewards;
        this.showZero = bl;
    }

    @Override
    public Decoration decorateState(int n, Decoration decoration) {
        Value Value2 = this.rewards.getEvaluator().zero();
        if (this.rewards instanceof MCRewards) {
            Value2 = ((MCRewards)this.rewards).getStateReward(n);
        } else if (this.rewards instanceof MDPRewards) {
            Value2 = ((MDPRewards)this.rewards).getStateReward(n);
        }
        if (this.rewards.getEvaluator().isZero(Value2) && !this.showZero) {
            return decoration;
        }
        decoration.labelAddBelow("+" + Value2);
        return decoration;
    }

    @Override
    public Decoration decorateTransition(int n, int n2, Decoration decoration) {
        if (!(this.rewards instanceof MDPRewards)) {
            return decoration;
        }
        Object Value2 = ((MDPRewards)this.rewards).getTransitionReward(n, n2);
        if (this.rewards.getEvaluator().isZero(Value2) && !this.showZero) {
            return decoration;
        }
        decoration.labelAddBelow("+" + Value2);
        return decoration;
    }
}

