/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.iterable.Reducible;
import common.iterable.SingletonIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public abstract class SuccessorsIterator
implements PrimitiveIterator.OfInt {
    public abstract boolean successorsAreDistinct();

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract int nextInt();

    public SuccessorsIterator distinct() {
        if (this.successorsAreDistinct()) {
            return this;
        }
        return new SuccessorsIteratorFromOfInt(Reducible.extend(this).distinct(), true);
    }

    public IntStream stream() {
        return StreamSupport.intStream(Spliterators.spliteratorUnknownSize(this, this.successorsAreDistinct() ? 1 : 0), false);
    }

    public static SuccessorsIterator from(Iterator<Integer> iterator, boolean bl) {
        return new SuccessorsIteratorFromIterator(iterator, bl);
    }

    public static SuccessorsIterator from(PrimitiveIterator.OfInt ofInt, boolean bl) {
        return new SuccessorsIteratorFromOfInt(ofInt, bl);
    }

    public static SuccessorsIterator fromSingleton(int n) {
        return new SuccessorsIteratorFromOfInt(new SingletonIterator.OfInt(n), true);
    }

    public static SuccessorsIterator empty() {
        return new SuccessorsIteratorEmpty();
    }

    public static SuccessorsIterator chain(Iterator<SuccessorsIterator> iterator) {
        return new ChainedSuccessorsIterator(iterator);
    }

    private static class SuccessorsIteratorFromOfInt
    extends SuccessorsIterator {
        private PrimitiveIterator.OfInt it;
        private boolean distinct;

        public SuccessorsIteratorFromOfInt(PrimitiveIterator.OfInt ofInt, boolean bl) {
            this.it = ofInt;
            this.distinct = bl;
        }

        @Override
        public boolean successorsAreDistinct() {
            return this.distinct;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public int nextInt() {
            return this.it.nextInt();
        }
    }

    private static class SuccessorsIteratorFromIterator
    extends SuccessorsIterator {
        private Iterator<Integer> it;
        private boolean distinct;

        public SuccessorsIteratorFromIterator(Iterator<Integer> iterator, boolean bl) {
            this.it = iterator;
            this.distinct = bl;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Integer next() {
            return this.it.next();
        }

        @Override
        public int nextInt() {
            return this.it.next();
        }

        @Override
        public boolean successorsAreDistinct() {
            return this.distinct;
        }
    }

    private static class SuccessorsIteratorEmpty
    extends SuccessorsIterator {
        private SuccessorsIteratorEmpty() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean successorsAreDistinct() {
            return true;
        }
    }

    private static class ChainedSuccessorsIterator
    extends SuccessorsIterator {
        private Iterator<SuccessorsIterator> iterators;
        private SuccessorsIterator current;
        private boolean distinct;

        public ChainedSuccessorsIterator(Iterator<SuccessorsIterator> iterator) {
            this.iterators = iterator;
            this.current = iterator.hasNext() ? iterator.next() : null;
            this.distinct = this.current != null && !iterator.hasNext() ? this.current.successorsAreDistinct() : false;
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                return false;
            }
            if (this.current.hasNext()) {
                return true;
            }
            while (this.iterators.hasNext()) {
                this.current = this.iterators.next();
                if (!this.current.hasNext()) continue;
                return true;
            }
            this.current = null;
            return false;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.nextInt();
        }

        @Override
        public boolean successorsAreDistinct() {
            return this.distinct;
        }
    }
}

