/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.Model;
import explicit.NondetModel;
import explicit.PredecessorRelation;
import explicit.StateValues;
import explicit.SuccessorsIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;

public class SubNondetModel<Value>
implements NondetModel<Value> {
    private NondetModel<Value> model = null;
    private BitSet states = null;
    private Map<Integer, BitSet> actions = null;
    private BitSet initialStates = null;
    private List<State> statesList = null;
    private Map<Integer, Integer> stateLookupTable = new HashMap<Integer, Integer>();
    private Map<Integer, Map<Integer, Integer>> actionLookupTable = new HashMap<Integer, Map<Integer, Integer>>();
    private Map<Integer, Integer> inverseStateLookupTable = new HashMap<Integer, Integer>();
    protected PredecessorRelation predecessorRelation;
    private int numTransitions = 0;
    private int maxNumChoices = 0;
    private int numChoices = 0;

    public SubNondetModel(NondetModel<Value> nondetModel, BitSet bitSet, Map<Integer, BitSet> map, BitSet bitSet2) {
        this.model = nondetModel;
        this.states = bitSet;
        this.actions = map;
        this.initialStates = bitSet2;
        this.generateStatistics();
        this.generateLookupTable(bitSet, map);
    }

    @Override
    public ModelType getModelType() {
        return this.model.getModelType();
    }

    @Override
    public int getNumStates() {
        return this.states.cardinality();
    }

    @Override
    public int getNumInitialStates() {
        return this.initialStates.cardinality();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = this.initialStates.nextSetBit(0);
        while (n >= 0) {
            arrayList.add(this.translateState(n));
            n = this.initialStates.nextSetBit(n + 1);
        }
        return arrayList;
    }

    @Override
    public int getFirstInitialState() {
        return this.translateState(this.initialStates.nextSetBit(0));
    }

    @Override
    public boolean isInitialState(int n) {
        return this.initialStates.get(this.translateState(n));
    }

    @Override
    public int getNumDeadlockStates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Integer> getDeadlockStates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StateValues getDeadlockStatesList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFirstDeadlockState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDeadlockState(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<State> getStatesList() {
        if (this.statesList == null) {
            this.statesList = this.generateSubStateList(this.states);
        }
        return this.statesList;
    }

    private List<State> generateSubStateList(BitSet bitSet) {
        ArrayList<State> arrayList = new ArrayList<State>();
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.model.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            arrayList.add(this.model.getStatesList().get(n));
        }
        return arrayList;
    }

    @Override
    public VarList getVarList() {
        return this.model.getVarList();
    }

    @Override
    public Values getConstantValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getLabels() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getLabelStates(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasLabel(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismExplicitTra(PrismLog prismLog, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportToPrismLanguage(String string, int n) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportStates(int n, VarList varList, PrismLog prismLog) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String infoStringTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumChoices(int n) {
        n = this.translateState(n);
        return this.actions.get(n).cardinality();
    }

    @Override
    public int getMaxNumChoices() {
        return this.maxNumChoices;
    }

    @Override
    public int getNumChoices() {
        return this.numChoices;
    }

    @Override
    public Object getAction(int n, int n2) {
        int n3 = this.translateState(n);
        int n4 = this.translateAction(n, n2);
        return this.model.getAction(n3, n4);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        int n3 = this.translateState(n);
        int n4 = this.translateAction(n, n2);
        return this.model.getNumTransitions(n3, n4);
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        int n3 = this.translateState(n);
        int n4 = this.translateAction(n, n2);
        final SuccessorsIterator successorsIterator = this.model.getSuccessors(n3, n4);
        return new SuccessorsIterator(){

            @Override
            public boolean successorsAreDistinct() {
                return successorsIterator.successorsAreDistinct();
            }

            @Override
            public boolean hasNext() {
                return successorsIterator.hasNext();
            }

            @Override
            public int nextInt() {
                return SubNondetModel.this.inverseTranslateState(successorsIterator.next());
            }
        };
    }

    private BitSet translateSet(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            bitSet2.set(this.translateState(n));
            n = bitSet.nextSetBit(n + 1);
        }
        return bitSet2;
    }

    private void generateStatistics() {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(this.states, this.model.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            this.numTransitions += this.getTransitions(n);
            this.numChoices += this.actions.get(n).cardinality();
            this.maxNumChoices = Math.max(this.maxNumChoices, this.model.getNumChoices(n));
        }
    }

    private int getTransitions(int n) {
        int n2 = 0;
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(this.actions.get(n), this.model.getNumChoices(n)).iterator();
        while (ofInt.hasNext()) {
            int n3 = (Integer)ofInt.next();
            n2 += this.model.getNumTransitions(n, n3);
        }
        return n2;
    }

    @Override
    public Model<Value> constructInducedModel(MDStrategy<Value> mDStrategy) {
        throw new RuntimeException("Not implemented");
    }

    private void generateLookupTable(BitSet bitSet, Map<Integer, BitSet> map) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.model.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            this.inverseStateLookupTable.put(n, this.stateLookupTable.size());
            this.stateLookupTable.put(this.stateLookupTable.size(), n);
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            FunctionalPrimitiveIterator.OfInt ofInt2 = new IterableStateSet(map.get(n), this.model.getNumChoices(n)).iterator();
            while (ofInt2.hasNext()) {
                int n2 = (Integer)ofInt2.next();
                hashMap.put(hashMap.size(), n2);
            }
            this.actionLookupTable.put(this.actionLookupTable.size(), hashMap);
        }
    }

    public int translateState(int n) {
        return this.stateLookupTable.get(n);
    }

    private int inverseTranslateState(int n) {
        return this.inverseStateLookupTable.get(n);
    }

    public int translateAction(int n, int n2) {
        return this.actionLookupTable.get(n).get(n2);
    }

    @Override
    public boolean hasStoredPredecessorRelation() {
        return this.predecessorRelation != null;
    }

    @Override
    public PredecessorRelation getPredecessorRelation(PrismComponent prismComponent, boolean bl) {
        if (this.predecessorRelation != null) {
            return this.predecessorRelation;
        }
        PredecessorRelation predecessorRelation = PredecessorRelation.forModel(prismComponent, this);
        if (bl) {
            this.predecessorRelation = predecessorRelation;
        }
        return predecessorRelation;
    }

    @Override
    public void clearPredecessorRelation() {
        this.predecessorRelation = null;
    }
}

