/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.MDP;
import explicit.graphviz.Decorator;
import explicit.graphviz.StateOwnerDecorator;
import explicit.rewards.STPGRewards;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;

public interface STPG<Value>
extends MDP<Value> {
    @Override
    default public ModelType getModelType() {
        return ModelType.STPG;
    }

    @Override
    default public void exportToDotFile(PrismLog prismLog, Iterable<Decorator> iterable, int n) {
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (iterable != null) {
            for (Decorator decorator : iterable) {
                arrayList.add(decorator);
            }
        }
        arrayList.add(new StateOwnerDecorator(this::getPlayer));
        MDP.super.exportToDotFile(prismLog, arrayList, n);
    }

    @Override
    default public void exportToPrismLanguage(String string, int n) throws PrismException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public String infoString() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + n + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions";
        object = (String)object + ", " + this.getNumChoices() + " choices";
        object = (String)object + ", dist max/avg = " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)n);
        return object;
    }

    @Override
    default public String infoStringTable() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + "States:      " + n + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        object = (String)object + "Choices:     " + this.getNumChoices() + "\n";
        object = (String)object + "Max/avg:     " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)n) + "\n";
        return object;
    }

    public int getPlayer(int var1);

    public void prob0step(BitSet var1, BitSet var2, boolean var3, boolean var4, BitSet var5);

    public void prob1step(BitSet var1, BitSet var2, BitSet var3, boolean var4, boolean var5, BitSet var6);

    public void mvMultMinMax(double[] var1, boolean var2, boolean var3, double[] var4, BitSet var5, boolean var6, int[] var7);

    public double mvMultMinMaxSingle(int var1, double[] var2, boolean var3, boolean var4);

    public List<Integer> mvMultMinMaxSingleChoices(int var1, double[] var2, boolean var3, boolean var4, double var5);

    public double mvMultGSMinMax(double[] var1, boolean var2, boolean var3, BitSet var4, boolean var5, boolean var6, int[] var7);

    public double mvMultJacMinMaxSingle(int var1, double[] var2, boolean var3, boolean var4, int[] var5);

    public void mvMultRewMinMax(double[] var1, STPGRewards<Double> var2, boolean var3, boolean var4, double[] var5, BitSet var6, boolean var7, int[] var8);

    public double mvMultRewMinMaxSingle(int var1, double[] var2, STPGRewards<Double> var3, boolean var4, boolean var5, int[] var6);

    public List<Integer> mvMultRewMinMaxSingleChoices(int var1, double[] var2, STPGRewards<Double> var3, boolean var4, boolean var5, double var6);

    public void mvMultRewMinMax(double[] var1, STPGRewards<Double> var2, boolean var3, boolean var4, double[] var5, BitSet var6, boolean var7, int[] var8, double var9);

    @Override
    public boolean allSuccessorsInSet(int var1, int var2, BitSet var3);
}

