/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CSG;
import explicit.CSGModelChecker;
import explicit.CTMC;
import explicit.CTMCModelChecker;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.IDTMC;
import explicit.IDTMCModelChecker;
import explicit.IMDP;
import explicit.IMDPModelChecker;
import explicit.LTLModelChecker;
import explicit.MDP;
import explicit.MDPModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.NonProbModelChecker;
import explicit.NondetModel;
import explicit.POMDP;
import explicit.POMDPModelChecker;
import explicit.SMG;
import explicit.SMGModelChecker;
import explicit.STPG;
import explicit.STPGModelChecker;
import explicit.StateValues;
import explicit.SuccessorsIterator;
import explicit.rewards.CSGRewards;
import explicit.rewards.ConstructRewards;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;
import explicit.rewards.SMGRewards;
import explicit.rewards.STPGRewards;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import parser.BooleanUtils;
import parser.ast.ASTElement;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionMultiNash;
import parser.ast.ExpressionMultiNashProb;
import parser.ast.ExpressionMultiNashReward;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionQuant;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypePathBool;
import parser.type.TypePathDouble;
import prism.AccuracyFactory;
import prism.Evaluator;
import prism.IntegerBound;
import prism.ModelType;
import prism.OpRelOpBound;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;

public class ProbModelChecker
extends NonProbModelChecker {
    protected LinEqMethod linEqMethod = LinEqMethod.GAUSS_SEIDEL;
    protected MDPSolnMethod mdpSolnMethod = MDPSolnMethod.GAUSS_SEIDEL;
    protected STPGSolnMethod stpgSolnMethod = STPGSolnMethod.GAUSS_SEIDEL;
    protected IMDPSolnMethod imdpSolnMethod = IMDPSolnMethod.GAUSS_SEIDEL;
    protected TermCrit termCrit = TermCrit.RELATIVE;
    protected double termCritParam = 1.0E-8;
    protected int maxIters = 100000;
    protected int gridResolution = 10;
    protected boolean precomp = true;
    protected boolean prob0 = true;
    protected boolean prob1 = true;
    protected boolean silentPrecomputations = false;
    protected boolean preRel = true;
    protected ValIterDir valIterDir = ValIterDir.BELOW;
    protected SolnMethod solnMethod = SolnMethod.VALUE_ITERATION;
    protected boolean errorOnNonConverge = true;
    protected boolean useDiscounting = false;
    protected double discountFactor = 1.0;
    public static final int UPDATE_DELAY = 5000;

    public ProbModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        if (this.settings != null) {
            String string = this.settings.getString("prism.linEqMethod");
            if (string.equals("Power")) {
                this.setLinEqMethod(LinEqMethod.POWER);
            } else if (string.equals("Jacobi")) {
                this.setLinEqMethod(LinEqMethod.JACOBI);
            } else if (string.equals("Gauss-Seidel")) {
                this.setLinEqMethod(LinEqMethod.GAUSS_SEIDEL);
            } else if (string.equals("Backwards Gauss-Seidel")) {
                this.setLinEqMethod(LinEqMethod.BACKWARDS_GAUSS_SEIDEL);
            } else if (string.equals("JOR")) {
                this.setLinEqMethod(LinEqMethod.JOR);
            } else if (string.equals("SOR")) {
                this.setLinEqMethod(LinEqMethod.SOR);
            } else if (string.equals("Backwards SOR")) {
                this.setLinEqMethod(LinEqMethod.BACKWARDS_SOR);
            } else {
                throw new PrismNotSupportedException("Explicit engine does not support linear equation solution method \"" + string + "\"");
            }
            string = this.settings.getString("prism.mdpSolnMethod");
            if (string.equals("Value iteration")) {
                this.setMDPSolnMethod(MDPSolnMethod.VALUE_ITERATION);
            } else if (string.equals("Gauss-Seidel")) {
                this.setMDPSolnMethod(MDPSolnMethod.GAUSS_SEIDEL);
            } else if (string.equals("Policy iteration")) {
                this.setMDPSolnMethod(MDPSolnMethod.POLICY_ITERATION);
            } else if (string.equals("Modified policy iteration")) {
                this.setMDPSolnMethod(MDPSolnMethod.MODIFIED_POLICY_ITERATION);
            } else if (string.equals("Linear programming")) {
                this.setMDPSolnMethod(MDPSolnMethod.LINEAR_PROGRAMMING);
            } else {
                throw new PrismNotSupportedException("Explicit engine does not support MDP solution method \"" + string + "\"");
            }
            string = this.settings.getString("prism.stpgSolnMethod");
            if (string.equals("Value iteration")) {
                this.setSTPGSolnMethod(STPGSolnMethod.VALUE_ITERATION);
            } else if (string.equals("Gauss-Seidel")) {
                this.setSTPGSolnMethod(STPGSolnMethod.GAUSS_SEIDEL);
            } else {
                throw new PrismNotSupportedException("Explicit engine does not support STPG solution method \"" + string + "\"");
            }
            string = this.settings.getString("prism.imdpSolnMethod");
            if (string.equals("Value iteration")) {
                this.setIMDPSolnMethod(IMDPSolnMethod.VALUE_ITERATION);
            } else if (string.equals("Gauss-Seidel")) {
                this.setIMDPSolnMethod(IMDPSolnMethod.GAUSS_SEIDEL);
            } else {
                throw new PrismNotSupportedException("Explicit engine does not support IMDP solution method \"" + string + "\"");
            }
            string = this.settings.getString("prism.termCrit");
            if (string.equals("Absolute")) {
                this.setTermCrit(TermCrit.ABSOLUTE);
            } else if (string.equals("Relative")) {
                this.setTermCrit(TermCrit.RELATIVE);
            } else {
                throw new PrismNotSupportedException("Unknown termination criterion \"" + string + "\"");
            }
            this.setTermCritParam(this.settings.getDouble("prism.termCritParam"));
            this.setMaxIters(this.settings.getInteger("prism.maxIters"));
            this.setGridResolution(this.settings.getInteger("prism.gridResolution"));
            this.setPrecomp(this.settings.getBoolean("prism.precomputation"));
            this.setProb0(this.settings.getBoolean("prism.prob0"));
            this.setProb1(this.settings.getBoolean("prism.prob1"));
            this.setPreRel(this.settings.getBoolean("prism.preRel"));
            if (this.settings.getBoolean("prism.fairness")) {
                throw new PrismNotSupportedException("The explicit engine does not support model checking MDPs under fairness");
            }
        }
    }

    public void inheritSettings(ProbModelChecker probModelChecker) {
        super.inheritSettings(probModelChecker);
        this.setLinEqMethod(probModelChecker.getLinEqMethod());
        this.setMDPSolnMethod(probModelChecker.getMDPSolnMethod());
        this.setSTPGSolnMethod(probModelChecker.getSTPGSolnMethod());
        this.setIMDPSolnMethod(probModelChecker.getIMDPSolnMethod());
        this.setTermCrit(probModelChecker.getTermCrit());
        this.setTermCritParam(probModelChecker.getTermCritParam());
        this.setMaxIters(probModelChecker.getMaxIters());
        this.setGridResolution(probModelChecker.getGridResolution());
        this.setPrecomp(probModelChecker.getPrecomp());
        this.setProb0(probModelChecker.getProb0());
        this.setProb1(probModelChecker.getProb1());
        this.setValIterDir(probModelChecker.getValIterDir());
        this.setSolnMethod(probModelChecker.getSolnMethod());
        this.setErrorOnNonConverge(probModelChecker.geterrorOnNonConverge());
    }

    @Override
    public void printSettings() {
        super.printSettings();
        this.mainLog.print("linEqMethod = " + this.linEqMethod + " ");
        this.mainLog.print("mdpSolnMethod = " + this.mdpSolnMethod + " ");
        this.mainLog.print("stpgSolnMethod = " + this.stpgSolnMethod + " ");
        this.mainLog.print("imdpSolnMethod = " + this.imdpSolnMethod + " ");
        this.mainLog.print("termCrit = " + this.termCrit + " ");
        this.mainLog.print("termCritParam = " + this.termCritParam + " ");
        this.mainLog.print("maxIters = " + this.maxIters + " ");
        this.mainLog.print("gridResolution = " + this.gridResolution + " ");
        this.mainLog.print("precomp = " + this.precomp + " ");
        this.mainLog.print("prob0 = " + this.prob0 + " ");
        this.mainLog.print("prob1 = " + this.prob1 + " ");
        this.mainLog.print("valIterDir = " + this.valIterDir + " ");
        this.mainLog.print("solnMethod = " + this.solnMethod + " ");
        this.mainLog.print("errorOnNonConverge = " + this.errorOnNonConverge + " ");
    }

    @Override
    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public boolean setSilentPrecomputations(boolean bl) {
        boolean bl2 = this.silentPrecomputations;
        this.silentPrecomputations = bl;
        return bl2;
    }

    public void setLinEqMethod(LinEqMethod linEqMethod) {
        this.linEqMethod = linEqMethod;
    }

    public void setMDPSolnMethod(MDPSolnMethod mDPSolnMethod) {
        this.mdpSolnMethod = mDPSolnMethod;
    }

    public void setSTPGSolnMethod(STPGSolnMethod sTPGSolnMethod) {
        this.stpgSolnMethod = sTPGSolnMethod;
    }

    public void setIMDPSolnMethod(IMDPSolnMethod iMDPSolnMethod) {
        this.imdpSolnMethod = iMDPSolnMethod;
    }

    public void setTermCrit(TermCrit termCrit) {
        this.termCrit = termCrit;
    }

    public void setTermCritParam(double d) {
        this.termCritParam = d;
    }

    public void setMaxIters(int n) {
        this.maxIters = n;
    }

    public void setGridResolution(int n) {
        this.gridResolution = n;
    }

    public void setPrecomp(boolean bl) {
        this.precomp = bl;
    }

    public void setProb0(boolean bl) {
        this.prob0 = bl;
    }

    public void setProb1(boolean bl) {
        this.prob1 = bl;
    }

    public void setPreRel(boolean bl) {
        this.preRel = bl;
    }

    public void setValIterDir(ValIterDir valIterDir) {
        this.valIterDir = valIterDir;
    }

    public void setSolnMethod(SolnMethod solnMethod) {
        this.solnMethod = solnMethod;
    }

    public void setErrorOnNonConverge(boolean bl) {
        this.errorOnNonConverge = bl;
    }

    @Override
    public int getVerbosity() {
        return this.verbosity;
    }

    public LinEqMethod getLinEqMethod() {
        return this.linEqMethod;
    }

    public MDPSolnMethod getMDPSolnMethod() {
        return this.mdpSolnMethod;
    }

    public STPGSolnMethod getSTPGSolnMethod() {
        return this.stpgSolnMethod;
    }

    public IMDPSolnMethod getIMDPSolnMethod() {
        return this.imdpSolnMethod;
    }

    public TermCrit getTermCrit() {
        return this.termCrit;
    }

    public double getTermCritParam() {
        return this.termCritParam;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public int getGridResolution() {
        return this.gridResolution;
    }

    public boolean getPrecomp() {
        return this.precomp;
    }

    public boolean getProb0() {
        return this.prob0;
    }

    public boolean getProb1() {
        return this.prob1;
    }

    public boolean getPreRel() {
        return this.preRel;
    }

    public ValIterDir getValIterDir() {
        return this.valIterDir;
    }

    public SolnMethod getSolnMethod() {
        return this.solnMethod;
    }

    public boolean geterrorOnNonConverge() {
        return this.errorOnNonConverge;
    }

    @Override
    public StateValues checkExpression(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionStrategy ? this.checkExpressionStrategy(model, (ExpressionStrategy)expression, bitSet) : (expression instanceof ExpressionProb ? this.checkExpressionProb(model, (ExpressionProb)expression, bitSet) : (expression instanceof ExpressionReward ? this.checkExpressionReward(model, (ExpressionReward)expression, bitSet) : (expression instanceof ExpressionSS ? this.checkExpressionSteadyState(model, (ExpressionSS)expression) : (expression instanceof ExpressionFunc ? this.checkExpressionFunc(model, (ExpressionFunc)expression, bitSet) : super.checkExpression(model, expression, bitSet)))));
        return stateValues;
    }

    protected StateValues checkExpressionStrategy(Model<?> model, ExpressionStrategy expressionStrategy, BitSet bitSet) throws PrismException {
        List<Expression> list;
        boolean bl;
        if (!expressionStrategy.isThereExists()) {
            throw new PrismNotSupportedException("The " + expressionStrategy.getOperatorString() + " operator is not yet supported");
        }
        if (!(this instanceof MDPModelChecker || this instanceof SMGModelChecker || this instanceof CSGModelChecker)) {
            throw new PrismNotSupportedException("The " + expressionStrategy.getOperatorString() + " operator is only supported for MDPs and SMGs currently");
        }
        boolean bl2 = bl = !expressionStrategy.isThereExists();
        if (expressionStrategy.getNumCoalitions() > 1 && model.getModelType() != ModelType.CSG) {
            throw new PrismNotSupportedException("The " + expressionStrategy.getOperatorString() + " operator can only contain one coalition");
        }
        Coalition coalition = expressionStrategy.getCoalition();
        if (coalition != null && !model.getModelType().multiplePlayers()) {
            if (coalition.isEmpty()) {
                bl = !bl;
            }
            coalition = null;
        }
        if ((list = expressionStrategy.getOperands()).size() > 1) {
            throw new PrismException("Cannot currently check strategy operators wth lists of expressions");
        }
        Expression expression = list.get(0);
        if (expression instanceof ExpressionProb) {
            return this.checkExpressionProb(model, (ExpressionProb)expression, bl, coalition, bitSet);
        }
        if (expression instanceof ExpressionReward) {
            if (((ExpressionReward)expression).getDiscount() != null) {
                this.useDiscounting = true;
                this.discountFactor = ((Expression)((ExpressionReward)expression).getDiscount()).evaluateDouble();
            }
            return this.checkExpressionReward(model, (ExpressionReward)expression, bl, coalition, bitSet);
        }
        if (expression instanceof ExpressionMultiNash) {
            return this.checkExpressionMultiNash(model, (ExpressionMultiNash)expression, expressionStrategy.getCoalitions(), expressionStrategy.getEquilibriumType(), expressionStrategy.getEquilibriumCriterion());
        }
        return this.checkExpressionMultiObjective(model, expressionStrategy, bl, coalition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected StateValues checkExpressionMultiNash(Model<?> model, ExpressionMultiNash expressionMultiNash, List<Coalition> list, ExpressionStrategy.EquilibriumType equilibriumType, ExpressionStrategy.EquilibriumCriterion equilibriumCriterion) throws PrismException {
        Object object;
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        List<ExpressionQuant> list2 = expressionMultiNash.getOperands();
        ArrayList<CSGRewards<Double>> arrayList = new ArrayList<CSGRewards<Double>>();
        Object[] objectArray = new BitSet[list.size()];
        Object[] objectArray2 = new BitSet[list.size()];
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        int[] nArray = new int[list.size()];
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = expressionMultiNash.getRelOp().isMin();
        int n = 1;
        if (equilibriumType == ExpressionStrategy.EquilibriumType.NASH) {
            n = 1;
        } else if (equilibriumType == ExpressionStrategy.EquilibriumType.CORRELATED) {
            n = 2;
        }
        int n2 = 3;
        if (equilibriumCriterion == ExpressionStrategy.EquilibriumCriterion.SOCIAL) {
            n2 = 3;
        } else if (equilibriumCriterion == ExpressionStrategy.EquilibriumCriterion.FAIR) {
            n2 = 4;
        }
        Arrays.fill(objectArray, null);
        Arrays.fill(objectArray2, null);
        Arrays.fill(nArray, -1);
        OpRelOpBound opRelOpBound = expressionMultiNash.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(model.getModelType());
        if (list.size() != list2.size()) {
            throw new PrismException("The number of coalitions and objectives must be equal");
        }
        for (int i = 0; i < list2.size() - 1; ++i) {
            bl = bl && list2.get(i).getClass() == list2.get(i + 1).getClass();
        }
        if (!bl) {
            throw new PrismException("Mixing P and R operators is not yet supported");
        }
        ArrayList<ExpressionTemporal> arrayList2 = new ArrayList<ExpressionTemporal>();
        block10: for (int i = 0; i < list2.size(); ++i) {
            IntegerBound integerBound;
            Expression expression = list2.get(i);
            if (expression instanceof ExpressionMultiNashProb) {
                expression = ((ExpressionMultiNashProb)expression).getExpression();
                if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionTemporal) {
                    object = (ExpressionTemporal)expression;
                    arrayList2.add(i, (ExpressionTemporal)object);
                    switch (((ExpressionTemporal)object).getOperator()) {
                        case 1: {
                            bitSet.set(i);
                            nArray[i] = 1;
                            break;
                        }
                        case 2: {
                            if (((ExpressionTemporal)object).hasBounds()) {
                                bitSet.set(i);
                                integerBound = IntegerBound.fromExpressionTemporal((ExpressionTemporal)expression, this.constantValues, true);
                                if (!integerBound.hasUpperBound()) throw new PrismException("Only upper bounds are allowed");
                                nArray[i] = integerBound.getHighestInteger();
                            } else {
                                bitSet2.set(i);
                            }
                            if (((ExpressionTemporal)expression).getOperand1().equals(ExpressionLiteral.True())) break;
                            objectArray[i] = this.checkExpression(model, ((ExpressionTemporal)expression).getOperand1(), null).getBitSet();
                            break;
                        }
                        default: {
                            throw new PrismNotSupportedException("The reward operator " + ((ExpressionTemporal)object).getOperatorSymbol() + " is not yet supported for equilibria-based properties");
                        }
                    }
                }
                objectArray2[i] = this.checkExpression(model, ((ExpressionTemporal)expression).getOperand2(), null).getBitSet();
                continue;
            }
            if (!(expression instanceof ExpressionMultiNashReward)) continue;
            int n3 = ExpressionReward.getRewardStructIndexByIndexObject(((ExpressionMultiNashReward)expression).getRewardStructIndex(), this.rewardGen, this.constantValues);
            expression = ((ExpressionMultiNashReward)expression).getExpression();
            arrayList.add(i, (CSGRewards)this.constructRewards(model, n3));
            bl2 = true;
            object = (ExpressionTemporal)expression;
            arrayList2.add(i, (ExpressionTemporal)object);
            switch (((ExpressionTemporal)object).getOperator()) {
                case 3: {
                    objectArray2[i] = this.checkExpression(model, ((ExpressionTemporal)object).getOperand2(), null).getBitSet();
                    bitSet2.set(i);
                    continue block10;
                }
                case 12: {
                    bitSet.set(i);
                    nArray[i] = ((ExpressionTemporal)object).getUpperBound().evaluateInt(this.constantValues);
                    continue block10;
                }
                case 11: {
                    if (!((ExpressionTemporal)object).hasBounds()) throw new PrismNotSupportedException("Total rewards " + ((ExpressionTemporal)object).getOperatorSymbol() + " is not yet supported for equilibria-based properties");
                    bitSet.set(i);
                    integerBound = IntegerBound.fromExpressionTemporal((ExpressionTemporal)expression, this.constantValues, true);
                    if (!integerBound.hasUpperBound()) throw new PrismException("Only upper bounds are allowed");
                    nArray[i] = integerBound.getHighestInteger();
                    continue block10;
                }
                default: {
                    throw new PrismNotSupportedException("The reward operator " + ((ExpressionTemporal)object).getOperatorSymbol() + " is not yet supported for equilibria-based properties");
                }
            }
        }
        if (!bl2) {
            arrayList = null;
        }
        if (list.size() == 1) {
            throw new PrismNotSupportedException("Equilibria-based properties require at least two coalitions");
        }
        if (list.size() == 2) {
            modelCheckerResult = bitSet2.cardinality() == list2.size() ? (bl2 ? ((CSGModelChecker)this).computeRewReachEquilibria((CSG)model, list, arrayList, (BitSet[])objectArray2, n, n2, bl3) : ((CSGModelChecker)this).computeProbReachEquilibria((CSG)model, list, (BitSet[])objectArray2, (BitSet[])objectArray, n, n2, bl3)) : (bitSet.cardinality() == list2.size() ? (bl2 ? ((CSGModelChecker)this).computeRewBoundedEquilibria((CSG)model, list, arrayList, arrayList2, nArray, n, n2, bl3) : ((CSGModelChecker)this).computeProbBoundedEquilibria((CSG)model, list, arrayList2, (BitSet[])objectArray2, (BitSet[])objectArray, nArray, n, n2, bl3)) : ((CSGModelChecker)this).computeMixedEquilibria((CSG)model, list, arrayList, arrayList2, bitSet, (BitSet[])objectArray2, (BitSet[])objectArray, nArray, n, n2, bl3));
        } else if (list.size() > 2) {
            throw new PrismNotSupportedException("Equilibria-based properties with more than two coalitions are not yet supported");
        }
        this.result.setStrategy(modelCheckerResult.strat);
        object = StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
        if (this.getVerbosity() > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            ((StateValues)object).print(this.mainLog);
        }
        if (opRelOpBound.isNumeric()) return object;
        ((StateValues)object).applyPredicate(arg_0 -> ProbModelChecker.lambda$checkExpressionMultiNash$0(opRelOpBound, (StateValues)object, arg_0));
        return object;
    }

    protected StateValues checkExpressionProb(Model<?> model, ExpressionProb expressionProb, BitSet bitSet) throws PrismException {
        return this.checkExpressionProb(model, expressionProb, true, null, bitSet);
    }

    protected StateValues checkExpressionProb(Model<?> model, ExpressionProb expressionProb, boolean bl, Coalition coalition, BitSet bitSet) throws PrismException {
        Object object;
        Object object2;
        if (expressionProb.getExpression() instanceof ExpressionReward && ((ASTElement)(object2 = ((ExpressionReward)expressionProb.getExpression()).getExpression())).getType() instanceof TypePathDouble) {
            object = (ExpressionTemporal)object2;
            if (model.getModelType() == ModelType.SMG) {
                switch (((ExpressionTemporal)object).getOperator()) {
                    case 14: {
                        return ((SMGModelChecker)this).checkExpressionMultiObjective(model, BooleanUtils.convertToCNFLists(expressionProb), coalition);
                    }
                    case 11: {
                        if (((ExpressionTemporal)object).hasBounds()) break;
                        return ((SMGModelChecker)this).checkExpressionMultiObjective(model, BooleanUtils.convertToCNFLists(expressionProb), coalition);
                    }
                }
            }
        }
        object2 = expressionProb.getRelopBoundInfo(this.constantValues);
        object = ((OpRelOpBound)object2).getMinMax(model.getModelType(), bl, coalition);
        StateValues stateValues = this.checkProbPathFormula(model, expressionProb.getExpression(), (MinMax)object, bitSet);
        if (this.getVerbosity() > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (!((OpRelOpBound)object2).isNumeric()) {
            stateValues.applyPredicate(arg_0 -> ProbModelChecker.lambda$checkExpressionProb$1((OpRelOpBound)object2, stateValues, arg_0));
        }
        return stateValues;
    }

    protected StateValues checkProbPathFormula(Model<?> model, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        if (expression instanceof ExpressionReward && "path".equals(((ExpressionReward)expression).getModifier())) {
            return this.checkProbBoundedRewardFormula(model, (ExpressionReward)expression, minMax, bitSet);
        }
        boolean bl = expression.isSimplePathFormula();
        if (bl && this.settings.getBoolean("prism.pathViaAutomata") && LTLModelChecker.isSupportedLTLFormula(model.getModelType(), expression)) {
            bl = false;
        }
        if (bl) {
            return this.checkProbPathFormulaSimple(model, expression, minMax, bitSet);
        }
        if (Expression.isCoSafeLTLSyntactic(expression, true)) {
            return this.checkProbPathFormulaCosafeLTL(model, expression, false, minMax, bitSet);
        }
        return this.checkProbPathFormulaLTL(model, expression, false, minMax, bitSet);
    }

    protected StateValues checkProbPathFormulaSimple(Model<?> model, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        boolean bl = false;
        StateValues stateValues = null;
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionUnaryOp && ((ExpressionUnaryOp)expression).getOperator() == 1) {
            bl = true;
            minMax = minMax.negate();
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkProbNext(model, expressionTemporal, minMax, bitSet);
            } else if (expressionTemporal.getOperator() == 2) {
                stateValues = expressionTemporal.hasBounds() ? this.checkProbBoundedUntil(model, expressionTemporal, minMax, bitSet) : this.checkProbUntil(model, expressionTemporal, minMax, bitSet);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in P operator");
        }
        if (bl) {
            stateValues.applyFunction(TypeDouble.getInstance(), object -> 1.0 - (Double)object);
        }
        return stateValues;
    }

    protected StateValues checkProbNext(Model<?> model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeNextProbs((CTMC)model, bitSet2);
                break;
            }
            case CSG: {
                modelCheckerResult = ((CSGModelChecker)this).computeNextProbs((CSG)model, bitSet2, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                break;
            }
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeNextProbs((DTMC)model, bitSet2);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeNextProbs((MDP)model, bitSet2, minMax.isMin());
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeNextProbs((STPG)model, bitSet2, minMax.isMin1(), minMax.isMin2());
                break;
            }
            case SMG: {
                modelCheckerResult = ((SMGModelChecker)this).computeNextProbs((SMG)model, bitSet2, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                break;
            }
            case IDTMC: {
                modelCheckerResult = ((IDTMCModelChecker)this).computeNextProbs((IDTMC)model, bitSet2, minMax);
                break;
            }
            case IMDP: {
                modelCheckerResult = ((IMDPModelChecker)this).computeNextProbs((IMDP)model, bitSet2, minMax);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + model.getModelType() + "s");
            }
        }
        this.result.setStrategy(modelCheckerResult.strat);
        return StateValues.createFromDoubleArrayResult(modelCheckerResult, model);
    }

    protected StateValues checkProbBoundedUntil(Model<?> model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        IntegerBound integerBound = IntegerBound.fromExpressionTemporal(expressionTemporal, this.constantValues, true);
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand1(), null).getBitSet();
        BitSet bitSet3 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        Integer n = integerBound.hasLowerBound() ? integerBound.getLowestInteger() : Integer.valueOf(0);
        Integer n2 = null;
        if (integerBound.hasUpperBound()) {
            n2 = integerBound.getHighestInteger() - n;
        }
        StateValues stateValues = null;
        if (n2 == null) {
            object = null;
            switch (model.getModelType()) {
                case DTMC: {
                    object = ((DTMCModelChecker)this).computeUntilProbs((DTMC)model, bitSet2, bitSet3);
                    break;
                }
                case MDP: {
                    object = ((MDPModelChecker)this).computeUntilProbs((MDP)model, bitSet2, bitSet3, minMax.isMin());
                    break;
                }
                case STPG: {
                    object = ((STPGModelChecker)this).computeUntilProbs((STPG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2(), minMax.getBound());
                    break;
                }
                case SMG: {
                    object = ((SMGModelChecker)this).computeUntilProbs((SMG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    break;
                }
                case CSG: {
                    object = ((CSGModelChecker)this).computeUntilProbs((CSG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    break;
                }
                case IDTMC: {
                    object = ((IDTMCModelChecker)this).computeUntilProbs((IDTMC)model, bitSet2, bitSet3, minMax);
                    break;
                }
                case IMDP: {
                    object = ((IMDPModelChecker)this).computeUntilProbs((IMDP)model, bitSet2, bitSet3, minMax);
                    break;
                }
                default: {
                    throw new PrismException("Cannot model check " + expressionTemporal + " for " + model.getModelType() + "s");
                }
            }
            this.result.setStrategy(object.strat);
            stateValues = StateValues.createFromDoubleArrayResult((ModelCheckerResult)object, model);
        } else if (n2 == 0) {
            stateValues = StateValues.createFromBitSetAsDoubles(bitSet3, model);
        } else {
            object = null;
            switch (model.getModelType()) {
                case DTMC: {
                    object = ((DTMCModelChecker)this).computeBoundedUntilProbs((DTMC)model, bitSet2, bitSet3, n2);
                    break;
                }
                case MDP: {
                    object = ((MDPModelChecker)this).computeBoundedUntilProbs((MDP)model, bitSet2, bitSet3, n2, minMax.isMin());
                    break;
                }
                case STPG: {
                    object = ((STPGModelChecker)this).computeBoundedUntilProbs((STPG)model, bitSet2, bitSet3, n2, minMax.isMin1(), minMax.isMin2());
                    break;
                }
                case SMG: {
                    object = ((SMGModelChecker)this).computeBoundedUntilProbs((SMG)model, bitSet2, bitSet3, n2, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    break;
                }
                case CSG: {
                    object = ((CSGModelChecker)this).computeBoundedUntilProbs((CSG)model, bitSet2, bitSet3, n2, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    break;
                }
                case IDTMC: {
                    object = ((IDTMCModelChecker)this).computeBoundedUntilProbs((IDTMC)model, bitSet2, bitSet3, n2, minMax);
                    break;
                }
                case IMDP: {
                    object = ((IMDPModelChecker)this).computeBoundedUntilProbs((IMDP)model, bitSet2, bitSet3, n2, minMax);
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + model.getModelType() + "s");
                }
            }
            this.result.setStrategy(object.strat);
            stateValues = StateValues.createFromDoubleArrayResult((ModelCheckerResult)object, model);
        }
        if (n > 0) {
            object = stateValues.getDoubleArray();
            block24: for (int i = 0; i < n; ++i) {
                switch (model.getModelType()) {
                    case DTMC: {
                        object = ((DTMCModelChecker)this).computeRestrictedNext((DTMC)model, bitSet2, (double[])object);
                        continue block24;
                    }
                    case MDP: {
                        object = ((MDPModelChecker)this).computeRestrictedNext((MDP)model, bitSet2, (double[])object, minMax.isMin());
                        continue block24;
                    }
                    case STPG: {
                        throw new PrismNotSupportedException("Lower bounds not yet supported for STPGModelChecker");
                    }
                    case SMG: {
                        throw new PrismException("Lower bounds not yet supported for SMGs");
                    }
                    default: {
                        throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + model.getModelType() + "s");
                    }
                }
            }
            stateValues = StateValues.createFromDoubleArray(object, model);
            stateValues.setAccuracy(AccuracyFactory.boundedNumericalIterations());
        }
        return stateValues;
    }

    protected StateValues checkProbUntil(Model<?> model, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand1(), null).getBitSet();
        BitSet bitSet3 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeUntilProbs((CTMC)model, bitSet2, bitSet3);
                break;
            }
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeUntilProbs((DTMC)model, bitSet2, bitSet3);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeUntilProbs((MDP)model, bitSet2, bitSet3, minMax.isMin());
                break;
            }
            case POMDP: {
                modelCheckerResult = ((POMDPModelChecker)this).computeReachProbs((POMDP)model, bitSet2, bitSet3, minMax.isMin(), bitSet);
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeUntilProbs((STPG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2(), minMax.getBound());
                break;
            }
            case SMG: {
                modelCheckerResult = ((SMGModelChecker)this).computeUntilProbs((SMG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                break;
            }
            case CSG: {
                modelCheckerResult = ((CSGModelChecker)this).computeUntilProbs((CSG)model, bitSet2, bitSet3, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                break;
            }
            case IDTMC: {
                modelCheckerResult = ((IDTMCModelChecker)this).computeUntilProbs((IDTMC)model, bitSet2, bitSet3, minMax);
                break;
            }
            case IMDP: {
                modelCheckerResult = ((IMDPModelChecker)this).computeUntilProbs((IMDP)model, bitSet2, bitSet3, minMax);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Cannot model check " + expressionTemporal + " for " + model.getModelType() + "s");
            }
        }
        this.result.setStrategy(modelCheckerResult.strat);
        return StateValues.createFromDoubleArrayResult(modelCheckerResult, model);
    }

    protected StateValues checkProbPathFormulaLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        throw new PrismNotSupportedException("Computation not implemented yet");
    }

    protected StateValues checkProbPathFormulaCosafeLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        return this.checkProbPathFormulaLTL(model, expression, bl, minMax, bitSet);
    }

    protected StateValues checkProbBoundedRewardFormula(Model model, ExpressionReward expressionReward, MinMax minMax, BitSet bitSet) throws PrismException {
        throw new PrismNotSupportedException("Reward-bounded path formulas not yet supported");
    }

    protected StateValues checkExpressionReward(Model<?> model, ExpressionReward expressionReward, BitSet bitSet) throws PrismException {
        return this.checkExpressionReward(model, expressionReward, true, null, bitSet);
    }

    protected StateValues checkExpressionReward(Model<?> model, ExpressionReward expressionReward, boolean bl, Coalition coalition, BitSet bitSet) throws PrismException {
        Object object;
        Expression expression = expressionReward.getExpression();
        if (expression.getType() instanceof TypePathDouble) {
            object = (ExpressionTemporal)expression;
            if (model.getModelType() == ModelType.SMG) {
                switch (((ExpressionTemporal)object).getOperator()) {
                    case 14: {
                        return ((SMGModelChecker)this).checkExpressionMultiObjective(model, BooleanUtils.convertToCNFLists(expressionReward), coalition);
                    }
                    case 11: {
                        if (((ExpressionTemporal)object).hasBounds()) break;
                        return ((SMGModelChecker)this).checkExpressionMultiObjective(model, BooleanUtils.convertToCNFLists(expressionReward), coalition);
                    }
                }
            }
        }
        if (expressionReward.getRewardStructIndexDiv() != null) {
            throw new PrismException("Ratio rewards not supported with the selected engine and module type.");
        }
        object = expressionReward.getRelopBoundInfo(this.constantValues);
        MinMax minMax = ((OpRelOpBound)object).getMinMax(model.getModelType(), bl, coalition);
        int n = expressionReward.getRewardStructIndexByIndexObject(this.rewardGen, this.constantValues);
        this.mainLog.println("Building reward structure...");
        Rewards<?> rewards = this.constructRewards(model, n);
        StateValues stateValues = this.checkRewardFormula(model, rewards, expressionReward.getExpression(), minMax, bitSet);
        if (this.getVerbosity() > 5) {
            this.mainLog.print("\nRewards (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (!((OpRelOpBound)object).isNumeric()) {
            stateValues.applyPredicate(arg_0 -> ProbModelChecker.lambda$checkExpressionReward$3((OpRelOpBound)object, stateValues, arg_0));
        }
        return stateValues;
    }

    protected <Value> Rewards<Value> constructRewards(Model<Value> model, int n) throws PrismException {
        return this.constructRewards(model, n, model.getModelType() == ModelType.CSG);
    }

    protected <Value> Rewards<Value> constructRewards(Model<Value> model, int n, boolean bl) throws PrismException {
        ConstructRewards constructRewards = new ConstructRewards(this);
        if (bl) {
            constructRewards.allowNegativeRewards();
        }
        return constructRewards.buildRewardStructure(model, this.rewardGen, n);
    }

    protected StateValues checkRewardFormula(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        if (expression.getType() instanceof TypePathDouble) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            switch (expressionTemporal.getOperator()) {
                case 15: 
                case 16: {
                    stateValues = this.checkRewardReach(model, rewards, expressionTemporal, minMax, bitSet);
                    break;
                }
                case 12: {
                    stateValues = this.checkRewardInstantaneous(model, rewards, expressionTemporal, minMax, bitSet);
                    break;
                }
                case 11: {
                    if (expressionTemporal.hasBounds()) {
                        stateValues = this.checkRewardCumulative(model, rewards, expressionTemporal, minMax);
                        break;
                    }
                    stateValues = this.checkRewardTotal(model, rewards, expressionTemporal, minMax);
                    break;
                }
                case 14: {
                    stateValues = this.checkRewardSteady(model, rewards);
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator");
                }
            }
        } else if (expression.getType() instanceof TypePathBool || expression.getType() instanceof TypeBool) {
            stateValues = this.checkRewardPathFormula(model, rewards, expression, minMax, bitSet);
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised operator in R operator");
        }
        return stateValues;
    }

    protected StateValues checkRewardInstantaneous(Model<?> model, Rewards<?> rewards, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        int n = -1;
        double d = -1.0;
        if (model.getModelType().continuousTime()) {
            d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
        } else {
            n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
        }
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeInstantaneousRewards((DTMC)model, (MCRewards)rewards, n, bitSet);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeInstantaneousRewards((CTMC)model, (MCRewards)rewards, d);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeInstantaneousRewards((MDP)model, (MDPRewards)rewards, n, minMax.isMin());
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeInstantaneousRewards((STPG)model, (STPGRewards)rewards, n, minMax.isMin1(), minMax.isMin2());
                break;
            }
            case SMG: {
                modelCheckerResult = ((SMGModelChecker)this).computeInstantaneousRewards((SMG)model, (SMGRewards)rewards, n, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                break;
            }
            case CSG: {
                modelCheckerResult = ((CSGModelChecker)this).computeInstantaneousRewards((CSG)model, (CSGRewards)rewards, minMax.coalition, n, minMax.isMin1(), minMax.isMin2());
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + model.getModelType() + "s");
            }
        }
        this.result.setStrategy(modelCheckerResult.strat);
        return StateValues.createFromDoubleArrayResult(modelCheckerResult, model);
    }

    protected StateValues checkRewardCumulative(Model<?> model, Rewards<?> rewards, ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        int n = -1;
        double d = -1.0;
        if (expressionTemporal.getUpperBound() == null) {
            throw new PrismNotSupportedException("This is not a cumulative reward operator");
        }
        if (model.getModelType().continuousTime()) {
            d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
            if (d < 0.0) {
                throw new PrismException("Invalid time bound " + d + " in cumulative reward formula");
            }
        } else {
            n = expressionTemporal.getUpperBound().evaluateInt(this.constantValues);
            if (n < 0) {
                throw new PrismException("Invalid time bound " + n + " in cumulative reward formula");
            }
        }
        if (n == 0 || d == 0.0) {
            StateValues stateValues = StateValues.createFromSingleValue(TypeDouble.getInstance(), 0.0, model);
            stateValues.setAccuracy(AccuracyFactory.doublesFromQualitative());
            return stateValues;
        }
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeCumulativeRewards((DTMC)model, (MCRewards)rewards, n);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeCumulativeRewards((CTMC)model, (MCRewards)rewards, d);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeCumulativeRewards((MDP)model, (MDPRewards)rewards, n, minMax.isMin());
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeCumulativeRewards((STPG)model, (STPGRewards)rewards, n, minMax.isMin1(), minMax.isMin2());
                break;
            }
            case SMG: {
                modelCheckerResult = ((SMGModelChecker)this).computeCumulativeRewards((SMG)model, (SMGRewards)rewards, n, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                break;
            }
            case CSG: {
                modelCheckerResult = ((CSGModelChecker)this).computeCumulativeRewards((CSG)model, (CSGRewards)rewards, minMax.getCoalition(), n, minMax.isMin1(), minMax.isMin2(), false);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + model.getModelType() + "s");
            }
        }
        this.result.setStrategy(modelCheckerResult.strat);
        return StateValues.createFromDoubleArrayResult(modelCheckerResult, model);
    }

    protected StateValues checkRewardTotal(Model<?> model, Rewards<?> rewards, ExpressionTemporal expressionTemporal, MinMax minMax) throws PrismException {
        if (expressionTemporal.getUpperBound() != null) {
            throw new PrismException("This is not a total reward operator");
        }
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeTotalRewards((DTMC)model, (MCRewards)rewards);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeTotalRewards((CTMC)model, (MCRewards)rewards);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeTotalRewards((MDP)model, (MDPRewards)rewards, minMax.isMin());
                break;
            }
            case CSG: {
                modelCheckerResult = ((CSGModelChecker)this).computeTotalRewards((CSG)model, (CSGRewards)rewards, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + model.getModelType() + "s");
            }
        }
        return StateValues.createFromDoubleArrayResult(modelCheckerResult, model);
    }

    protected StateValues checkRewardSteady(Model<?> model, Rewards<?> rewards) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeSteadyStateRewards((DTMC)model, (MCRewards)rewards);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeSteadyStateRewards((CTMC)model, (MCRewards)rewards);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the steady-state reward operator for " + model.getModelType() + "s");
            }
        }
        this.result.setStrategy(modelCheckerResult.strat);
        return StateValues.createFromDoubleArrayResult(modelCheckerResult, model);
    }

    protected StateValues checkRewardPathFormula(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        if (Expression.isReach(expression)) {
            return this.checkRewardReach(model, rewards, (ExpressionTemporal)expression, minMax, bitSet);
        }
        if (Expression.isCoSafeLTLSyntactic(expression, true)) {
            return this.checkRewardCoSafeLTL(model, rewards, expression, minMax, bitSet);
        }
        throw new PrismException("R operator contains a path formula that is not syntactically co-safe: " + expression);
    }

    protected StateValues checkRewardReach(Model<?> model, Rewards<?> rewards, ExpressionTemporal expressionTemporal, MinMax minMax, BitSet bitSet) throws PrismException {
        if (expressionTemporal.getOperator() != 3 && model.getModelType() != ModelType.STPG && model.getModelType() != ModelType.SMG && model.getModelType() != ModelType.CSG) {
            throw new PrismException("The " + expressionTemporal.getOperatorSymbol() + " reward operator only works for game models");
        }
        if (expressionTemporal.hasBounds()) {
            throw new PrismNotSupportedException("R operator cannot contain a bounded F operator: " + expressionTemporal);
        }
        BitSet bitSet2 = this.checkExpression(model, expressionTemporal.getOperand2(), null).getBitSet();
        ModelCheckerResult modelCheckerResult = null;
        switch (model.getModelType()) {
            case DTMC: {
                modelCheckerResult = ((DTMCModelChecker)this).computeReachRewards((DTMC)model, (MCRewards)rewards, bitSet2);
                break;
            }
            case CTMC: {
                modelCheckerResult = ((CTMCModelChecker)this).computeReachRewards((CTMC)model, (MCRewards)rewards, bitSet2);
                break;
            }
            case MDP: {
                modelCheckerResult = ((MDPModelChecker)this).computeReachRewards((MDP)model, (MDPRewards)rewards, bitSet2, minMax.isMin());
                break;
            }
            case POMDP: {
                modelCheckerResult = ((POMDPModelChecker)this).computeReachRewards((POMDP)model, (MDPRewards)rewards, bitSet2, minMax.isMin(), bitSet);
                break;
            }
            case STPG: {
                modelCheckerResult = ((STPGModelChecker)this).computeReachRewards((STPG)model, (STPGRewards)rewards, bitSet2, minMax.isMin1(), minMax.isMin2());
                break;
            }
            case SMG: {
                switch (expressionTemporal.getOperator()) {
                    case 3: {
                        modelCheckerResult = ((SMGModelChecker)this).computeReachRewards((SMG)model, (SMGRewards)rewards, bitSet2, 0, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                        break;
                    }
                    case 15: {
                        modelCheckerResult = ((SMGModelChecker)this).computeReachRewards((SMG)model, (SMGRewards)rewards, bitSet2, 1, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                        break;
                    }
                    case 16: {
                        modelCheckerResult = ((SMGModelChecker)this).computeReachRewards((SMG)model, (SMGRewards)rewards, bitSet2, 2, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    }
                }
                break;
            }
            case CSG: {
                switch (expressionTemporal.getOperator()) {
                    case 3: {
                        modelCheckerResult = ((CSGModelChecker)this).computeReachRewards((CSG)model, (CSGRewards)rewards, bitSet2, 0, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                        break;
                    }
                    case 15: {
                        modelCheckerResult = ((CSGModelChecker)this).computeReachRewards((CSG)model, (CSGRewards)rewards, bitSet2, 1, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
                    }
                }
                break;
            }
            case IDTMC: {
                modelCheckerResult = ((IDTMCModelChecker)this).computeReachRewards((IDTMC)model, (MCRewards)rewards, bitSet2, minMax);
                break;
            }
            case IMDP: {
                modelCheckerResult = ((IMDPModelChecker)this).computeReachRewards((IMDP)model, (MDPRewards)rewards, bitSet2, minMax);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet handle the " + expressionTemporal.getOperatorSymbol() + " reward operator for " + model.getModelType() + "s");
            }
        }
        this.result.setStrategy(modelCheckerResult.strat);
        return StateValues.createFromDoubleArrayResult(modelCheckerResult, model);
    }

    protected StateValues checkRewardCoSafeLTL(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        throw new PrismException("Computation not implemented yet");
    }

    protected StateValues checkExpressionSteadyState(Model<?> model, ExpressionSS expressionSS) throws PrismException {
        OpRelOpBound opRelOpBound = expressionSS.getRelopBoundInfo(this.constantValues);
        MinMax minMax = opRelOpBound.getMinMax(model.getModelType(), true, null);
        StateValues stateValues = this.checkSteadyStateFormula(model, expressionSS.getExpression(), minMax);
        if (this.getVerbosity() > 5) {
            this.mainLog.print("\nProbabilities (non-zero only) for all states:\n");
            stateValues.print(this.mainLog);
        }
        if (!opRelOpBound.isNumeric()) {
            stateValues.applyPredicate(object -> opRelOpBound.apply((Double)object, stateValues.getAccuracy()));
        }
        return stateValues;
    }

    protected StateValues checkSteadyStateFormula(Model<?> model, Expression expression, MinMax minMax) throws PrismException {
        BitSet bitSet = this.checkExpression(model, expression, null).getBitSet();
        switch (model.getModelType()) {
            case DTMC: {
                return ((DTMCModelChecker)this).computeSteadyStateFormula((DTMC)model, bitSet);
            }
            case CTMC: {
                return ((CTMCModelChecker)this).computeSteadyStateFormula((CTMC)model, bitSet);
            }
        }
        throw new PrismNotSupportedException("Explicit engine does not yet handle the S operator for " + model.getModelType() + "s");
    }

    protected StateValues checkExpressionMultiObjective(Model<?> model, ExpressionStrategy expressionStrategy, boolean bl, Coalition coalition) throws PrismException {
        expressionStrategy = (ExpressionStrategy)expressionStrategy.deepCopy();
        Expression expression = expressionStrategy.getOperand(0);
        while (Expression.isParenth(expression)) {
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        if (expression.getType() instanceof TypeBool) {
            if (bl) {
                expression = Expression.Not(expression);
            }
            List<List<Expression>> list = BooleanUtils.convertToCNFLists(expression);
            for (List<Expression> list2 : list) {
                for (Expression expression2 : list2) {
                    if (Expression.isNot(expression2)) {
                        expression2 = ((ExpressionUnaryOp)expression2).getOperand();
                    }
                    if (expression2 instanceof ExpressionQuant) continue;
                    throw new PrismException("Expression " + expression2.getClass() + " is not allowed in a multi-objective query");
                }
            }
            for (List<Expression> list2 : list) {
                for (int i = 0; i < list2.size(); ++i) {
                    Expression expression2;
                    expression2 = list2.get(i);
                    if (!Expression.isNot(expression2)) continue;
                    ExpressionQuant expressionQuant = (ExpressionQuant)((ExpressionUnaryOp)expression2).getOperand();
                    expressionQuant.setRelOp(expressionQuant.getRelOp().negate());
                    list2.set(i, expressionQuant);
                }
            }
            this.mainLog.println("\nReducing multi-objective query to CNF: " + BooleanUtils.convertCNFListsToExpression(list));
            return this.checkExpressionMultiObjective(model, list, coalition);
        }
        if (expression.getType() instanceof TypeDouble) {
            throw new PrismException("Multi-objective model checking not supported for: " + expression);
        }
        throw new PrismException("Multi-objective model checking not supported for: " + expression);
    }

    public StateValues checkExpressionMultiObjective(Model<?> model, List<List<Expression>> list, Coalition coalition) throws PrismException {
        throw new PrismException("Not implemented");
    }

    protected StateValues checkExpressionMulti(Model<?> model, Expression expression, boolean bl, Coalition coalition) throws PrismException {
        if (bl) {
            throw new PrismException("Nor support for forall in multi-objective queries yet");
        }
        if (!(expression instanceof ExpressionFunc)) {
            throw new PrismException("Unsupported format for multi-objective query");
        }
        switch (((ExpressionFunc)expression).getNameCode()) {
            case 8: {
                throw new PrismException("Properties with \"multi\" no longer supported.");
            }
        }
        throw new PrismException("Unsupported format for multi-objective query");
    }

    @Override
    protected StateValues checkExpressionFunc(Model<?> model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        switch (expressionFunc.getNameCode()) {
            case 8: {
                throw new PrismNotSupportedException("Properties with \"multi\" not supported.");
            }
        }
        return super.checkExpressionFunc(model, expressionFunc, bitSet);
    }

    protected BitSet findTerminalStates(Model<?> model) {
        int n = model.getStatesList().size();
        BitSet bitSet = new BitSet(n);
        BitSet bitSet2 = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            bitSet2.clear();
            bitSet2.set(i);
            if (!model.allSuccessorsInSet(i, bitSet2)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public StateValues readDistributionFromFile(File file, Model<?> model) throws PrismException {
        StateValues stateValues = null;
        if (file != null) {
            this.mainLog.println("\nImporting probability distribution from file \"" + file + "\"...");
            stateValues = StateValues.createFromFile(TypeDouble.getInstance(), file, model);
        }
        return stateValues;
    }

    public StateValues buildInitialDistribution(Model<?> model) throws PrismException {
        int n3 = model.getNumInitialStates();
        if (n3 == 1) {
            int n4 = model.getFirstInitialState();
            return StateValues.create(TypeDouble.getInstance(), n2 -> n2 == n4 ? 1.0 : 0.0, model);
        }
        double d = 1.0 / (double)n3;
        return StateValues.create(TypeDouble.getInstance(), n -> model.isInitialState(n) ? d : 0.0, model);
    }

    public <Value> void exportStateRewardsToFile(Model<Value> model, int n, int n2, PrismLog prismLog) throws PrismException {
        this.exportStateRewardsToFile(model, n, n2, prismLog, false, 16);
    }

    public <Value> void exportStateRewardsToFile(Model<Value> model, int n, int n2, PrismLog prismLog, boolean bl, int n3) throws PrismException {
        if (n2 != 1) {
            throw new PrismNotSupportedException("Exporting state rewards in the requested format is currently not supported by the explicit engine");
        }
        Rewards<Value> rewards = this.constructRewards(model, n);
        switch (model.getModelType()) {
            case CTMC: 
            case DTMC: 
            case IDTMC: {
                this.exportMCStateRewardsToFile(model, (MCRewards)rewards, n, n2, prismLog, bl, n3);
                break;
            }
            case CSG: 
            case MDP: 
            case STPG: 
            case SMG: 
            case IMDP: 
            case POMDP: {
                this.exportMDPStateRewardsToFile(model, (MDPRewards)rewards, n, n2, prismLog, bl, n3);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet export state rewards for " + model.getModelType() + "s");
            }
        }
    }

    protected <Value> void exportMCStateRewardsToFile(Model<Value> model, MCRewards<Value> mCRewards, int n, int n2, PrismLog prismLog, boolean bl, int n3) throws PrismException {
        Value Value2;
        int n4;
        int n5 = model.getNumStates();
        int n6 = 0;
        Evaluator<Value> evaluator = mCRewards.getEvaluator();
        for (n4 = 0; n4 < n5; ++n4) {
            Value2 = mCRewards.getStateReward(n4);
            if (evaluator.isZero(Value2)) continue;
            ++n6;
        }
        this.printStateRewardsHeader(n, prismLog, bl);
        prismLog.println(n5 + " " + n6);
        for (n4 = 0; n4 < n5; ++n4) {
            Value2 = mCRewards.getStateReward(n4);
            if (evaluator.isZero(Value2)) continue;
            prismLog.println(n4 + " " + evaluator.toStringExport(Value2, n3));
        }
    }

    public <Value> void exportMDPStateRewardsToFile(Model<Value> model, MDPRewards<Value> mDPRewards, int n, int n2, PrismLog prismLog, boolean bl, int n3) throws PrismException {
        Value Value2;
        int n4;
        int n5 = model.getNumStates();
        int n6 = 0;
        Evaluator<Value> evaluator = mDPRewards.getEvaluator();
        for (n4 = 0; n4 < n5; ++n4) {
            Value2 = mDPRewards.getStateReward(n4);
            if (evaluator.isZero(Value2)) continue;
            ++n6;
        }
        this.printStateRewardsHeader(n, prismLog, bl);
        prismLog.println(n5 + " " + n6);
        for (n4 = 0; n4 < n5; ++n4) {
            Value2 = mDPRewards.getStateReward(n4);
            if (evaluator.isZero(Value2)) continue;
            prismLog.println(n4 + " " + evaluator.toStringExport(Value2, n3));
        }
    }

    protected void printStateRewardsHeader(int n, PrismLog prismLog, boolean bl) {
        if (bl) {
            return;
        }
        String string = this.rewardGen.getRewardStructName(n);
        prismLog.print("# Reward structure");
        if (!"".equals(string)) {
            prismLog.print(" \"" + string + "\"");
        }
        prismLog.println("\n# State rewards");
    }

    public <Value> void exportTransRewardsToFile(Model<Value> model, int n, int n2, PrismLog prismLog, boolean bl, int n3) throws PrismException {
        if (n2 != 1) {
            throw new PrismNotSupportedException("Exporting state rewards in the requested format is currently not supported by the explicit engine");
        }
        Rewards<Value> rewards = this.constructRewards(model, n);
        switch (model.getModelType()) {
            case CSG: 
            case MDP: 
            case STPG: 
            case SMG: 
            case IMDP: 
            case POMDP: {
                this.exportMDPTransRewardsToFile((NondetModel)model, (MDPRewards)rewards, n, n2, prismLog, bl, n3);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Explicit engine does not yet export transition rewards for " + model.getModelType() + "s");
            }
        }
    }

    public <Value> void exportMDPTransRewardsToFile(NondetModel<Value> nondetModel, MDPRewards<Value> mDPRewards, int n, int n2, PrismLog prismLog, boolean bl, int n3) throws PrismException {
        Value Value2;
        int n4;
        int n5;
        int n6;
        int n7 = nondetModel.getNumStates();
        int n8 = nondetModel.getNumChoices();
        int n9 = 0;
        Evaluator<Value> evaluator = mDPRewards.getEvaluator();
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = nondetModel.getNumChoices();
            for (n4 = 0; n4 < n5; ++n4) {
                Value2 = mDPRewards.getTransitionReward(n6, n4);
                if (evaluator.isZero(Value2)) continue;
                n9 += nondetModel.getNumTransitions(n6, n4);
            }
        }
        this.printTransRewardsHeader(n, prismLog, bl);
        prismLog.println(n7 + " " + n8 + " " + n9);
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = nondetModel.getNumChoices();
            for (n4 = 0; n4 < n5; ++n4) {
                Value2 = mDPRewards.getTransitionReward(n6, n4);
                if (evaluator.isZero(Value2)) continue;
                int n10 = nondetModel.getNumTransitions(n6, n4);
                SuccessorsIterator successorsIterator = nondetModel.getSuccessors(n6, n4);
                while (successorsIterator.hasNext()) {
                    int n11 = successorsIterator.nextInt();
                    prismLog.println(n6 + " " + n4 + " " + n11 + " " + evaluator.toStringExport(Value2, n3));
                }
            }
        }
    }

    protected void printTransRewardsHeader(int n, PrismLog prismLog, boolean bl) {
        if (bl) {
            return;
        }
        String string = this.rewardGen.getRewardStructName(n);
        prismLog.print("# Reward structure");
        if (!"".equals(string)) {
            prismLog.print(" \"" + string + "\"");
        }
        prismLog.println("\n# Transition rewards");
    }

    private static /* synthetic */ boolean lambda$checkExpressionReward$3(OpRelOpBound opRelOpBound, StateValues stateValues, Object object) throws PrismException {
        return opRelOpBound.apply((Double)object, stateValues.getAccuracy());
    }

    private static /* synthetic */ boolean lambda$checkExpressionProb$1(OpRelOpBound opRelOpBound, StateValues stateValues, Object object) throws PrismException {
        return opRelOpBound.apply((Double)object, stateValues.getAccuracy());
    }

    private static /* synthetic */ boolean lambda$checkExpressionMultiNash$0(OpRelOpBound opRelOpBound, StateValues stateValues, Object object) throws PrismException {
        return opRelOpBound.apply((Double)object, stateValues.getAccuracy());
    }

    public static enum LinEqMethod {
        POWER,
        JACOBI,
        GAUSS_SEIDEL,
        BACKWARDS_GAUSS_SEIDEL,
        JOR,
        SOR,
        BACKWARDS_SOR;


        public String fullName() {
            switch (this) {
                case POWER: {
                    return "Power method";
                }
                case JACOBI: {
                    return "Jacobi";
                }
                case GAUSS_SEIDEL: {
                    return "Gauss-Seidel";
                }
                case BACKWARDS_GAUSS_SEIDEL: {
                    return "Backwards Gauss-Seidel";
                }
                case JOR: {
                    return "JOR";
                }
                case SOR: {
                    return "SOR";
                }
                case BACKWARDS_SOR: {
                    return "Backwards SOR";
                }
            }
            return this.toString();
        }
    }

    public static enum MDPSolnMethod {
        VALUE_ITERATION,
        GAUSS_SEIDEL,
        POLICY_ITERATION,
        MODIFIED_POLICY_ITERATION,
        LINEAR_PROGRAMMING;


        public String fullName() {
            switch (this) {
                case VALUE_ITERATION: {
                    return "Value iteration";
                }
                case GAUSS_SEIDEL: {
                    return "Gauss-Seidel";
                }
                case POLICY_ITERATION: {
                    return "Policy iteration";
                }
                case MODIFIED_POLICY_ITERATION: {
                    return "Modified policy iteration";
                }
                case LINEAR_PROGRAMMING: {
                    return "Linear programming";
                }
            }
            return this.toString();
        }
    }

    public static enum STPGSolnMethod {
        VALUE_ITERATION,
        GAUSS_SEIDEL;


        public String fullName() {
            switch (this) {
                case VALUE_ITERATION: {
                    return "Value iteration";
                }
                case GAUSS_SEIDEL: {
                    return "Gauss-Seidel";
                }
            }
            return this.toString();
        }
    }

    public static enum IMDPSolnMethod {
        VALUE_ITERATION,
        GAUSS_SEIDEL;


        public String fullName() {
            switch (this) {
                case VALUE_ITERATION: {
                    return "Value iteration";
                }
                case GAUSS_SEIDEL: {
                    return "Gauss-Seidel";
                }
            }
            return this.toString();
        }
    }

    public static enum TermCrit {
        ABSOLUTE,
        RELATIVE;

    }

    public static enum ValIterDir {
        BELOW,
        ABOVE;

    }

    public static enum SolnMethod {
        VALUE_ITERATION,
        GAUSS_SEIDEL,
        POLICY_ITERATION,
        MODIFIED_POLICY_ITERATION,
        LINEAR_PROGRAMMING;

    }
}

