/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import java.util.List;
import parser.State;
import prism.ModelInfo;
import prism.PrismException;
import prism.PrismLog;

public interface PartiallyObservableModel<Value>
extends Model<Value> {
    public List<State> getObservationsList();

    public List<State> getUnobservationsList();

    default public int getNumObservations() {
        return this.getObservationsList().size();
    }

    default public int getNumUnobservations() {
        return this.getUnobservationsList().size();
    }

    public int getObservation(int var1);

    default public State getObservationAsState(int n) {
        int n2 = this.getObservation(n);
        List<State> list = this.getObservationsList();
        if (list != null && list.size() > n2) {
            return list.get(n2);
        }
        return null;
    }

    public int getUnobservation(int var1);

    default public State getUnobservationAsState(int n) {
        int n2 = this.getUnobservation(n);
        List<State> list = this.getUnobservationsList();
        if (list != null && list.size() > n2) {
            return list.get(n2);
        }
        return null;
    }

    default public double getObservationProb(int n, int n2) {
        return this.getObservation(n) == n2 ? 1.0 : 0.0;
    }

    public int getNumChoicesForObservation(int var1);

    default public void exportObservations(int n, ModelInfo modelInfo, PrismLog prismLog) throws PrismException {
        int n2;
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("(");
        int n3 = modelInfo.getNumObservables();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.print(modelInfo.getObservableName(n2));
            if (n2 >= n3 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        if (n == 2) {
            prismLog.println("obs=[");
        }
        n2 = this.getNumObservations();
        List<State> list = this.getObservationsList();
        for (int i = 0; i < n2; ++i) {
            if (n != 2) {
                prismLog.println(i + ":" + list.get(i).toString());
                continue;
            }
            prismLog.println(list.get(i).toStringNoParentheses());
        }
        if (n == 2) {
            prismLog.println("];");
        }
    }
}

