/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Belief;
import explicit.MDP;
import explicit.PartiallyObservableModel;
import explicit.rewards.MDPRewards;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import prism.ModelType;
import prism.PrismLog;
import prism.PrismUtils;

public interface POMDP<Value>
extends MDP<Value>,
PartiallyObservableModel<Value> {
    @Override
    default public ModelType getModelType() {
        return ModelType.POMDP;
    }

    @Override
    default public void exportToPrismExplicitTra(PrismLog prismLog, int n) {
        int n2 = this.getNumStates();
        prismLog.print(n2 + " " + this.getNumChoices() + " " + this.getNumTransitions() + " " + this.getNumObservations() + "\n");
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                Iterator iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    treeMap.put((Integer)entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    prismLog.print(i + " " + j + " " + entry.getKey() + " " + this.getEvaluator().toStringExport(entry.getValue(), n) + " " + this.getObservation((Integer)entry.getKey()));
                    Object object = this.getAction(i, j);
                    prismLog.print((String)(object == null ? "\n" : " " + object + "\n"));
                }
                treeMap.clear();
            }
        }
    }

    @Override
    default public String infoString() {
        Object object = "";
        object = (String)object + this.getNumStates() + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions";
        object = (String)object + ", " + this.getNumChoices() + " choices";
        object = (String)object + ", dist max/avg = " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)this.getNumStates());
        object = (String)object + ", " + this.getNumObservations() + " observables";
        object = (String)object + ", " + this.getNumUnobservations() + " unobservables";
        return object;
    }

    @Override
    default public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.getNumStates() + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Obs/unobs:   " + this.getNumObservations() + "/" + this.getNumUnobservations() + "\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        object = (String)object + "Choices:     " + this.getNumChoices() + "\n";
        object = (String)object + "Max/avg:     " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)this.getNumStates()) + "\n";
        return object;
    }

    public Object getActionForObservation(int var1, int var2);

    default public int getChoiceByActionForObservation(int n, Object object) {
        int n2 = this.getNumChoicesForObservation(n);
        for (int i = 0; i < n2; ++i) {
            Object object2 = this.getActionForObservation(n, i);
            if (!(object2 == null ? object == null : object2.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public Belief getInitialBelief();

    public double[] getInitialBeliefInDist();

    public Belief getBeliefAfterChoice(Belief var1, int var2);

    public double[] getBeliefInDistAfterChoice(double[] var1, int var2);

    public Belief getBeliefAfterChoiceAndObservation(Belief var1, int var2, int var3);

    public double[] getBeliefInDistAfterChoiceAndObservation(double[] var1, int var2, int var3);

    public double getObservationProbAfterChoice(Belief var1, int var2, int var3);

    public double getObservationProbAfterChoice(double[] var1, int var2, int var3);

    public HashMap<Integer, Double> computeObservationProbsAfterAction(double[] var1, int var2);

    public double getRewardAfterChoice(Belief var1, int var2, MDPRewards<Double> var3);

    public double getRewardAfterChoice(double[] var1, int var2, MDPRewards<Double> var3);
}

