/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.SuccessorsIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntPredicate;
import prism.PrismLog;
import strat.MDStrategy;

public interface NondetModel<Value>
extends Model<Value> {
    public int getNumChoices(int var1);

    default public int getMaxNumChoices() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n = Math.max(n, this.getNumChoices(i));
        }
        return n;
    }

    default public int getNumChoices() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumChoices(i);
        }
        return n;
    }

    public Object getAction(int var1, int var2);

    default public List<Object> getAvailableActions(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.getAction(n, i));
        }
        return arrayList;
    }

    default public int getChoiceByAction(int n, Object object) {
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            Object object2 = this.getAction(n, i);
            if (!(object2 == null ? object == null : object2.equals(object))) continue;
            return i;
        }
        return -1;
    }

    default public boolean areAllChoiceActionsUnique() {
        int n = this.getNumStates();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getNumChoices(i);
            if (n2 <= 1) continue;
            hashSet.clear();
            for (int j = 0; j < n2; ++j) {
                if (hashSet.add(this.getAction(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public int getNumTransitions(int var1, int var2);

    @Override
    default public int getNumTransitions(int n) {
        int n2 = 0;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            n2 += this.getNumTransitions(n, i);
        }
        return n2;
    }

    default public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.allSuccessorsMatch(n, n2, bitSet::get);
    }

    default public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.someSuccessorsMatch(n, n2, bitSet::get);
    }

    default public boolean successorsSafeAndCanReach(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        return this.successorsSafeAndCanReach(n, n2, bitSet::get, bitSet2::get);
    }

    default public boolean allSuccessorsMatch(int n, int n2, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (intPredicate.test(n3)) continue;
            return false;
        }
        return true;
    }

    default public boolean someSuccessorsMatch(int n, int n2, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (!intPredicate.test(n3)) continue;
            return true;
        }
        return false;
    }

    default public boolean successorsSafeAndCanReach(int n, int n2, IntPredicate intPredicate, IntPredicate intPredicate2) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        boolean bl = false;
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (!intPredicate.test(n3)) {
                return false;
            }
            if (bl) continue;
            bl = intPredicate2.test(n3);
        }
        return bl;
    }

    default public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        return successorsIterator.distinct();
    }

    public SuccessorsIterator getSuccessors(int var1, int var2);

    @Override
    default public SuccessorsIterator getSuccessors(final int n) {
        return SuccessorsIterator.chain(new Iterator<SuccessorsIterator>(){
            private int choice = 0;
            private int choices = NondetModel.this.getNumChoices(n);

            @Override
            public boolean hasNext() {
                return this.choice < this.choices;
            }

            @Override
            public SuccessorsIterator next() {
                return NondetModel.this.getSuccessors(n, this.choice++);
            }
        });
    }

    public Model<Value> constructInducedModel(MDStrategy<Value> var1);

    default public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray) {
        this.exportToDotFileWithStrat(prismLog, bitSet, nArray, 16);
    }

    public void exportToDotFileWithStrat(PrismLog var1, BitSet var2, int[] var3, int var4);
}

