/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.PredecessorRelation;
import explicit.StateValues;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.Evaluator;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLog;

public abstract class ModelExplicit<Value>
implements Model<Value> {
    protected Evaluator<Value> eval = Evaluator.forDouble();
    protected int numStates;
    protected List<Integer> initialStates;
    protected TreeSet<Integer> deadlocks;
    protected List<State> statesList;
    protected Values constantValues;
    protected VarList varList;
    protected Map<String, BitSet> labels = new TreeMap<String, BitSet>();
    protected PredecessorRelation predecessorRelation = null;

    public void setEvaluator(Evaluator<Value> evaluator) {
        this.eval = evaluator;
    }

    public void copyFrom(Model<Value> model) {
        this.setEvaluator(model.getEvaluator());
        this.numStates = model.getNumStates();
        for (int n : model.getInitialStates()) {
            this.addInitialState(n);
        }
        for (int n : model.getDeadlockStates()) {
            this.addDeadlockState(n);
        }
        this.statesList = model.getStatesList();
        this.constantValues = model.getConstantValues();
        this.labels = model.getLabelToStatesMap();
        this.varList = model.getVarList();
    }

    public void copyFrom(Model<Value> model, int[] nArray) {
        this.setEvaluator(model.getEvaluator());
        this.numStates = model.getNumStates();
        for (int n : model.getInitialStates()) {
            this.addInitialState(nArray[n]);
        }
        for (int n : model.getDeadlockStates()) {
            this.addDeadlockState(nArray[n]);
        }
        this.statesList = null;
        this.constantValues = model.getConstantValues();
        this.labels.clear();
        this.varList = model.getVarList();
    }

    public void initialise(int n) {
        this.numStates = n;
        this.initialStates = new ArrayList<Integer>();
        this.deadlocks = new TreeSet();
        this.statesList = new ArrayList<State>(n);
        this.constantValues = null;
        this.varList = null;
        this.labels = new TreeMap<String, BitSet>();
    }

    public void addInitialState(int n) {
        this.initialStates.add(n);
    }

    public void clearInitialStates() {
        this.initialStates.clear();
    }

    public void addDeadlockState(int n) {
        this.deadlocks.add(n);
    }

    public abstract void buildFromPrismExplicit(String var1) throws PrismException;

    public void setStatesList(List<State> list) {
        this.statesList = list;
    }

    public void setConstantValues(Values values) {
        this.constantValues = values;
    }

    public void setVarList(VarList varList) {
        this.varList = varList;
    }

    public void addLabel(String string, BitSet bitSet) {
        this.labels.put(string, bitSet);
    }

    public String addUniqueLabel(String string, BitSet bitSet, Set<String> set) {
        int n = 0;
        Object object = string;
        while (true) {
            boolean bl;
            boolean bl2 = bl = !this.hasLabel((String)object);
            if (set != null) {
                bl &= !set.contains(object);
            }
            if (bl) break;
            object = string + "_" + n;
            if (n == Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Integer overflow trying to add unique label");
            }
            ++n;
        }
        this.addLabel((String)object, bitSet);
        return object;
    }

    @Override
    public Evaluator<Value> getEvaluator() {
        return this.eval;
    }

    @Override
    public int getNumStates() {
        return this.numStates;
    }

    @Override
    public int getNumInitialStates() {
        return this.initialStates.size();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.initialStates;
    }

    @Override
    public int getFirstInitialState() {
        return this.initialStates.isEmpty() ? -1 : this.initialStates.get(0);
    }

    @Override
    public boolean isInitialState(int n) {
        return this.initialStates.contains(n);
    }

    @Override
    public int getNumDeadlockStates() {
        return this.deadlocks.size();
    }

    @Override
    public Iterable<Integer> getDeadlockStates() {
        return this.deadlocks;
    }

    @Override
    public StateValues getDeadlockStatesList() {
        BitSet bitSet = new BitSet();
        for (int n : this.deadlocks) {
            bitSet.set(n);
        }
        return StateValues.createFromBitSet(bitSet, this);
    }

    @Override
    public int getFirstDeadlockState() {
        return this.deadlocks.isEmpty() ? -1 : this.deadlocks.first();
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.deadlocks.contains(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.statesList;
    }

    @Override
    public Values getConstantValues() {
        return this.constantValues;
    }

    @Override
    public VarList getVarList() {
        return this.varList;
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.labels.get(string);
    }

    @Override
    public boolean hasLabel(String string) {
        return this.labels.containsKey(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.labels.keySet();
    }

    @Override
    public Map<String, BitSet> getLabelToStatesMap() {
        return this.labels;
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
        this.checkForDeadlocks(null);
    }

    @Override
    public abstract void checkForDeadlocks(BitSet var1) throws PrismException;

    @Override
    public void exportStates(int n, VarList varList, PrismLog prismLog) throws PrismException {
        int n2;
        if (this.statesList == null) {
            return;
        }
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("(");
        int n3 = varList.getNumVars();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.print(varList.getName(n2));
            if (n2 >= n3 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        if (n == 2) {
            prismLog.println("states=[");
        }
        n2 = this.statesList.size();
        for (int i = 0; i < n2; ++i) {
            if (n != 2) {
                prismLog.println(i + ":" + this.statesList.get(i).toString());
                continue;
            }
            prismLog.println(this.statesList.get(i).toStringNoParentheses());
        }
        if (n == 2) {
            prismLog.println("];");
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ModelExplicit)) {
            return false;
        }
        ModelExplicit modelExplicit = (ModelExplicit)object;
        if (this.numStates != modelExplicit.numStates) {
            return false;
        }
        return this.initialStates.equals(modelExplicit.initialStates);
    }

    @Override
    public boolean hasStoredPredecessorRelation() {
        return this.predecessorRelation != null;
    }

    @Override
    public PredecessorRelation getPredecessorRelation(PrismComponent prismComponent, boolean bl) {
        if (this.predecessorRelation != null) {
            return this.predecessorRelation;
        }
        PredecessorRelation predecessorRelation = PredecessorRelation.forModel(prismComponent, this);
        if (bl) {
            this.predecessorRelation = predecessorRelation;
        }
        return predecessorRelation;
    }

    @Override
    public void clearPredecessorRelation() {
        this.predecessorRelation = null;
    }
}

