/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IteratorTools;
import explicit.PartiallyObservableModel;
import explicit.PredecessorRelation;
import explicit.StateValues;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.graphviz.MarkStateSetDecorator;
import explicit.graphviz.ShowStatesDecorator;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.IntPredicate;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public interface Model<Value> {
    public ModelType getModelType();

    public int getNumStates();

    public int getNumInitialStates();

    public Iterable<Integer> getInitialStates();

    public int getFirstInitialState();

    public boolean isInitialState(int var1);

    public int getNumDeadlockStates();

    public Iterable<Integer> getDeadlockStates();

    public StateValues getDeadlockStatesList();

    public int getFirstDeadlockState();

    public boolean isDeadlockState(int var1);

    public List<State> getStatesList();

    public VarList getVarList();

    public Values getConstantValues();

    public BitSet getLabelStates(String var1);

    public Set<String> getLabels();

    public boolean hasLabel(String var1);

    default public Map<String, BitSet> getLabelToStatesMap() {
        TreeMap<String, BitSet> treeMap = new TreeMap<String, BitSet>();
        for (String string : this.getLabels()) {
            treeMap.put(string, this.getLabelStates(string));
        }
        return treeMap;
    }

    default public int getNumTransitions() {
        int n = this.getNumStates();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getNumTransitions(i);
        }
        return n2;
    }

    default public int getNumTransitions(int n) {
        return Math.toIntExact(IteratorTools.count(this.getSuccessorsIterator(n)));
    }

    default public long getNumTransitions(PrimitiveIterator.OfInt ofInt) {
        long l = 0L;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            l += (long)this.getNumTransitions(n);
        }
        return l;
    }

    default public Iterator<Integer> getSuccessorsIterator(int n) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        return successorsIterator.distinct();
    }

    public SuccessorsIterator getSuccessors(int var1);

    default public boolean isSuccessor(int n, int n2) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    default public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        return this.allSuccessorsMatch(n, bitSet::get);
    }

    default public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        return this.someSuccessorsMatch(n, bitSet::get);
    }

    default public boolean allSuccessorsMatch(int n, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (intPredicate.test(n2)) continue;
            return false;
        }
        return true;
    }

    default public boolean someSuccessorsMatch(int n, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (!intPredicate.test(n2)) continue;
            return true;
        }
        return false;
    }

    public void findDeadlocks(boolean var1) throws PrismException;

    public void checkForDeadlocks() throws PrismException;

    public void checkForDeadlocks(BitSet var1) throws PrismException;

    default public void exportToPrismExplicit(String string) throws PrismException {
        this.exportToPrismExplicit(string, 16);
    }

    default public void exportToPrismExplicit(String string, int n) throws PrismException {
        this.exportToPrismExplicitTra(string + ".tra", n);
    }

    default public void exportToPrismExplicitTra(String string) throws PrismException {
        this.exportToPrismExplicitTra(string, 16);
    }

    default public void exportToPrismExplicitTra(String string, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToPrismExplicitTra(prismFileLog, n);
        }
    }

    default public void exportToPrismExplicitTra(File file) throws PrismException {
        this.exportToPrismExplicitTra(file, 16);
    }

    default public void exportToPrismExplicitTra(File file, int n) throws PrismException {
        this.exportToPrismExplicitTra(file.getPath(), n);
    }

    default public void exportToPrismExplicitTra(PrismLog prismLog) {
        this.exportToPrismExplicitTra(prismLog, 16);
    }

    public void exportToPrismExplicitTra(PrismLog var1, int var2);

    default public void exportToDotFile(String string) throws PrismException {
        this.exportToDotFile(string, 16);
    }

    default public void exportToDotFile(String string, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, n);
        }
    }

    default public void exportToDotFile(String string, BitSet bitSet) throws PrismException {
        this.exportToDotFile(string, bitSet, 16);
    }

    default public void exportToDotFile(String string, BitSet bitSet, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, bitSet, n);
        }
    }

    default public void exportToDotFile(String string, Iterable<Decorator> iterable) throws PrismException {
        this.exportToDotFile(string, iterable, 16);
    }

    default public void exportToDotFile(String string, Iterable<Decorator> iterable, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, iterable, n);
        }
    }

    default public void exportToDotFile(PrismLog prismLog) {
        this.exportToDotFile(prismLog, 16);
    }

    default public void exportToDotFile(PrismLog prismLog, int n) {
        this.exportToDotFile(prismLog, (Iterable<Decorator>)null, n);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet) {
        this.exportToDotFile(prismLog, bitSet, 16);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet, int n) {
        if (bitSet == null) {
            this.exportToDotFile(prismLog, n);
        }
        this.exportToDotFile(prismLog, Collections.singleton(new MarkStateSetDecorator(bitSet)), n);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet, boolean bl) {
        this.exportToDotFile(prismLog, bitSet, bl, 16);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet, boolean bl, int n) {
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (bl) {
            if (this.getModelType().partiallyObservable()) {
                arrayList.add(new ShowStatesDecorator(this.getStatesList(), ((PartiallyObservableModel)this)::getObservationAsState));
            } else {
                arrayList.add(new ShowStatesDecorator(this.getStatesList()));
            }
        }
        if (bitSet != null) {
            arrayList.add(new MarkStateSetDecorator(bitSet));
        }
        this.exportToDotFile(prismLog, arrayList, n);
    }

    default public void exportToDotFile(PrismLog prismLog, Iterable<Decorator> iterable) {
        this.exportToDotFile(prismLog, iterable, 16);
    }

    default public void exportToDotFile(PrismLog prismLog, Iterable<Decorator> iterable, int n) {
        Decoration decoration = new Decoration();
        decoration.attributes().put("shape", "box");
        prismLog.print("digraph " + this.getModelType() + " {\nnode " + decoration.toString() + ";\n");
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            Decoration decoration2 = new Decoration(decoration);
            decoration2.setLabel(Integer.toString(i));
            if (iterable != null) {
                for (Decorator decorator : iterable) {
                    decoration2 = decorator.decorateState(i, decoration2);
                }
            }
            String string = decoration2.toString();
            prismLog.println(i + " " + (String)string + ";");
            this.exportTransitionsToDotFile(i, prismLog, iterable, n);
        }
        prismLog.print("}\n");
    }

    default public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
        this.exportTransitionsToDotFile(n, prismLog, iterable, 16);
    }

    default public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable, int n2) {
        throw new UnsupportedOperationException();
    }

    default public void exportToPrismLanguage(String string) throws PrismException {
        this.exportToPrismLanguage(string, 16);
    }

    public void exportToPrismLanguage(String var1, int var2) throws PrismException;

    public void exportStates(int var1, VarList var2, PrismLog var3) throws PrismException;

    public String infoString();

    public String infoStringTable();

    public boolean hasStoredPredecessorRelation();

    public PredecessorRelation getPredecessorRelation(PrismComponent var1, boolean var2);

    public void clearPredecessorRelation();

    default public Evaluator<Value> getEvaluator() {
        return Evaluator.forDouble();
    }
}

