/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.ChoiceActionsSimple;
import explicit.Distribution;
import explicit.MDP;
import explicit.MDPExplicit;
import explicit.MDPSimple;
import explicit.SuccessorsIterator;
import explicit.Utils;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import prism.PrismException;
import prism.PrismUtils;

public class MDPSparse
extends MDPExplicit<Double> {
    protected double[] nonZeros;
    protected int[] cols;
    protected int[] choiceStarts;
    protected int[] rowStarts;
    protected Object[] actions;
    protected int numDistrs;
    protected int numTransitions;
    protected int maxNumDistrs;

    public MDPSparse(MDP<Double> mDP) {
        this(mDP, false);
    }

    public MDPSparse(MDP<Double> mDP, boolean bl) {
        this.initialise(mDP.getNumStates());
        this.setStatesList(mDP.getStatesList());
        this.setConstantValues(mDP.getConstantValues());
        for (String string : mDP.getLabels()) {
            this.addLabel(string, mDP.getLabelStates(string));
        }
        this.numDistrs = mDP.getNumChoices();
        this.numTransitions = mDP.getNumTransitions();
        this.maxNumDistrs = mDP.getMaxNumChoices();
        this.nonZeros = new double[this.numTransitions];
        this.cols = new int[this.numTransitions];
        this.choiceStarts = new int[this.numDistrs + 1];
        this.rowStarts = new int[this.numStates + 1];
        this.actions = MDPSparse.hasActionLabels(mDP) ? new Object[this.numDistrs] : null;
        TreeMap treeMap = bl ? new TreeMap() : null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.numStates; ++i) {
            int n3;
            int n4;
            if (mDP.isInitialState(i)) {
                this.addInitialState(i);
            }
            if (mDP.isDeadlockState(i)) {
                this.deadlocks.add(i);
            }
            this.rowStarts[i] = n;
            if (this.actions != null) {
                n4 = mDP.getNumChoices(i);
                for (n3 = 0; n3 < n4; ++n3) {
                    this.actions[n + n3] = mDP.getAction(i, n3);
                }
            }
            n4 = mDP.getNumChoices(i);
            for (n3 = 0; n3 < n4; ++n3) {
                this.choiceStarts[n] = n2;
                Iterator<Map.Entry<Integer, Double>> iterator = mDP.getTransitionsIterator(i, n3);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    if (bl) {
                        treeMap.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    this.cols[n2] = entry.getKey();
                    this.nonZeros[n2] = entry.getValue();
                    ++n2;
                }
                if (bl) {
                    for (Map.Entry<Integer, Double> entry : treeMap.entrySet()) {
                        this.cols[n2] = entry.getKey();
                        this.nonZeros[n2] = entry.getValue();
                        ++n2;
                    }
                    treeMap.clear();
                }
                ++n;
            }
        }
        this.choiceStarts[this.numDistrs] = this.numTransitions;
        this.rowStarts[this.numStates] = this.numDistrs;
    }

    private static boolean hasActionLabels(MDP<?> mDP) {
        int n = mDP.getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = mDP.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                if (mDP.getAction(i, j) == null) continue;
                return true;
            }
        }
        return false;
    }

    public MDPSparse(MDPSimple<Double> mDPSimple) {
        this(mDPSimple, false);
    }

    public MDPSparse(MDPSimple<Double> mDPSimple, boolean bl) {
        TreeMap<Integer, Double> treeMap = null;
        this.initialise(mDPSimple.getNumStates());
        this.copyFrom(mDPSimple);
        this.numDistrs = mDPSimple.getNumChoices();
        this.numTransitions = mDPSimple.getNumTransitions();
        this.maxNumDistrs = mDPSimple.getMaxNumChoices();
        if (bl) {
            treeMap = new TreeMap<Integer, Double>();
        }
        this.nonZeros = new double[this.numTransitions];
        this.cols = new int[this.numTransitions];
        this.choiceStarts = new int[this.numDistrs + 1];
        this.rowStarts = new int[this.numStates + 1];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.numStates; ++i) {
            this.rowStarts[i] = n2;
            for (Distribution distribution : mDPSimple.trans.get(i)) {
                this.choiceStarts[n2] = n;
                for (Map.Entry entry : distribution) {
                    if (bl) {
                        treeMap.put((Integer)entry.getKey(), (Double)entry.getValue());
                        continue;
                    }
                    this.cols[n] = (Integer)entry.getKey();
                    this.nonZeros[n] = (Double)entry.getValue();
                    ++n;
                }
                if (bl) {
                    for (Map.Entry entry : treeMap.entrySet()) {
                        this.cols[n] = (Integer)entry.getKey();
                        this.nonZeros[n] = (Double)entry.getValue();
                        ++n;
                    }
                    treeMap.clear();
                }
                ++n2;
            }
        }
        this.choiceStarts[this.numDistrs] = this.numTransitions;
        this.rowStarts[this.numStates] = this.numDistrs;
        this.actions = mDPSimple.actions.convertToSparseStorage(this);
    }

    public MDPSparse(MDPSimple<Double> mDPSimple, boolean bl, int[] nArray) {
        int n;
        TreeMap<Integer, Double> treeMap = null;
        this.initialise(mDPSimple.getNumStates());
        this.copyFrom(mDPSimple, nArray);
        this.numDistrs = mDPSimple.getNumChoices();
        this.numTransitions = mDPSimple.getNumTransitions();
        this.maxNumDistrs = mDPSimple.getMaxNumChoices();
        int[] nArray2 = new int[this.numStates];
        for (n = 0; n < this.numStates; ++n) {
            nArray2[nArray[n]] = n;
        }
        if (bl) {
            treeMap = new TreeMap<Integer, Double>();
        }
        this.nonZeros = new double[this.numTransitions];
        this.cols = new int[this.numTransitions];
        this.choiceStarts = new int[this.numDistrs + 1];
        this.rowStarts = new int[this.numStates + 1];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.numStates; ++n) {
            this.rowStarts[n] = n3;
            for (Distribution distribution : mDPSimple.trans.get(nArray2[n])) {
                this.choiceStarts[n3] = n2;
                for (Map.Entry entry : distribution) {
                    if (bl) {
                        treeMap.put(nArray[(Integer)entry.getKey()], (Double)entry.getValue());
                        continue;
                    }
                    this.cols[n2] = nArray[(Integer)entry.getKey()];
                    this.nonZeros[n2] = (Double)entry.getValue();
                    ++n2;
                }
                if (bl) {
                    for (Map.Entry entry : treeMap.entrySet()) {
                        this.cols[n2] = (Integer)entry.getKey();
                        this.nonZeros[n2] = (Double)entry.getValue();
                        ++n2;
                    }
                    treeMap.clear();
                }
                ++n3;
            }
        }
        this.choiceStarts[this.numDistrs] = this.numTransitions;
        this.rowStarts[this.numStates] = this.numDistrs;
        this.actions = new ChoiceActionsSimple(mDPSimple.actions, nArray).convertToSparseStorage(this);
    }

    public MDPSparse(MDP<Double> mDP, List<Integer> list, List<List<Integer>> list2) {
        int n;
        int n2;
        int n32;
        this.initialise(list.size());
        for (int n32 : mDP.getInitialStates()) {
            this.addInitialState(n32);
        }
        for (int n32 : mDP.getDeadlockStates()) {
            this.addDeadlockState(n32);
        }
        this.statesList = new ArrayList();
        for (int n32 : list) {
            this.statesList.add(mDP.getStatesList().get(n32));
        }
        this.numDistrs = 0;
        this.numTransitions = 0;
        this.maxNumDistrs = 0;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n32 = list.get(n2);
            int n4 = list2.get(n32).size();
            this.numDistrs += n4;
            if (n4 > this.maxNumDistrs) {
                this.maxNumDistrs = n4;
            }
            for (int n5 : list2.get(n32)) {
                this.numTransitions += mDP.getNumTransitions(n32, n5);
            }
        }
        this.nonZeros = new double[this.numTransitions];
        this.cols = new int[this.numTransitions];
        this.choiceStarts = new int[this.numDistrs + 1];
        this.rowStarts = new int[this.numStates + 1];
        this.actions = new Object[this.numDistrs];
        n2 = 0;
        n32 = 0;
        int[] nArray = new int[mDP.getNumStates()];
        for (n = 0; n < list.size(); ++n) {
            nArray[list.get((int)n).intValue()] = n;
        }
        for (n = 0; n < list.size(); ++n) {
            int n5;
            n5 = list.get(n);
            this.rowStarts[n] = n2;
            for (int n6 : list2.get(n5)) {
                this.choiceStarts[n2] = n32;
                this.actions[n2] = mDP.getAction(n5, n6);
                ++n2;
                Iterator<Map.Entry<Integer, Double>> iterator = mDP.getTransitionsIterator(n5, n6);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    this.cols[n32] = nArray[entry.getKey()];
                    this.nonZeros[n32] = entry.getValue();
                    ++n32;
                }
            }
        }
        this.choiceStarts[this.numDistrs] = this.numTransitions;
        this.rowStarts[this.numStates] = this.numDistrs;
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.maxNumDistrs = 0;
        this.numTransitions = 0;
        this.numDistrs = 0;
        this.actions = null;
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        int n = 0;
        try {
            int n2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            String string2 = bufferedReader.readLine();
            n = 1;
            if (string2 == null) {
                bufferedReader.close();
                throw new PrismException("Missing first line of .tra file");
            }
            String[] stringArray = string2.split(" ");
            int n3 = Integer.parseInt(stringArray[0]);
            this.initialise(n3);
            this.initialStates.add(0);
            this.numDistrs = Integer.parseInt(stringArray[1]);
            this.numTransitions = Integer.parseInt(stringArray[2]);
            int n4 = -1;
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            string2 = bufferedReader.readLine();
            ++n;
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    stringArray = string2.split(" ");
                    n2 = Integer.parseInt(stringArray[0]);
                    int n8 = Integer.parseInt(stringArray[1]);
                    int n9 = Integer.parseInt(stringArray[2]);
                    double d = Double.parseDouble(stringArray[3]);
                    if (n2 != n4) {
                        this.rowStarts[n2] = n6;
                    }
                    if (n2 != n4 || n8 != n5) {
                        this.choiceStarts[n6] = n7;
                        ++n6;
                    }
                    this.cols[n7] = n9;
                    this.nonZeros[n7] = d;
                    n4 = n2;
                    n5 = n8;
                    ++n7;
                }
                string2 = bufferedReader.readLine();
                ++n;
            }
            this.choiceStarts[this.numDistrs] = this.numTransitions;
            this.rowStarts[this.numStates] = this.numDistrs;
            this.maxNumDistrs = 0;
            for (n2 = 0; n2 < this.numStates; ++n2) {
                this.maxNumDistrs = Math.max(this.maxNumDistrs, this.getNumChoices(n2));
            }
            bufferedReader.close();
            if (n6 != this.numDistrs) {
                throw new PrismException("Choice count is wrong in tra file (" + n6 + "!=" + this.numTransitions + ")");
            }
            if (n7 != this.numTransitions) {
                throw new PrismException("Transition count is wrong in tra file (" + n6 + "!=" + this.numTransitions + ")");
            }
        }
        catch (IOException iOException) {
            System.exit(1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Problem in .tra file (line " + n + ") for " + this.getModelType());
        }
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public int getNumTransitions(int n) {
        return this.choiceStarts[this.rowStarts[n + 1]] - this.choiceStarts[this.rowStarts[n]];
    }

    private SuccessorsIterator colsIterator(final int n, final int n2, final boolean bl) {
        return new SuccessorsIterator(){
            int cur;
            {
                this.cur = n;
            }

            @Override
            public boolean successorsAreDistinct() {
                return bl;
            }

            @Override
            public boolean hasNext() {
                return this.cur < n2;
            }

            @Override
            public int nextInt() {
                return MDPSparse.this.cols[this.cur++];
            }
        };
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        int n2 = this.choiceStarts[this.rowStarts[n]];
        int n3 = this.choiceStarts[this.rowStarts[n + 1]];
        boolean bl = n2 == n3 || n2 + 1 == n3;
        return this.colsIterator(n2, n3, bl);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (this.getNumChoices(i) != 0) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            throw new PrismException("Can't fix deadlocks in an MDPSparse since it cannot be modified after construction");
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (this.getNumChoices(i) != 0 || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("MDP has a deadlock in state " + i);
        }
    }

    @Override
    public int getNumChoices(int n) {
        return this.rowStarts[n + 1] - this.rowStarts[n];
    }

    @Override
    public int getMaxNumChoices() {
        return this.maxNumDistrs;
    }

    @Override
    public int getNumChoices() {
        return this.numDistrs;
    }

    @Override
    public Object getAction(int n, int n2) {
        return n2 < 0 || this.actions == null ? null : this.actions[this.rowStarts[n] + n2];
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        int n3 = this.choiceStarts[this.rowStarts[n] + n2];
        int n4 = this.choiceStarts[this.rowStarts[n] + n2 + 1];
        return this.colsIterator(n3, n4, true);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return this.choiceStarts[this.rowStarts[n] + n2 + 1] - this.choiceStarts[this.rowStarts[n] + n2];
    }

    @Override
    public void forEachTransition(int n, int n2, MDP.TransitionConsumer<Double> transitionConsumer) {
        int n3 = this.choiceStarts[this.rowStarts[n] + n2 + 1];
        for (int i = this.choiceStarts[this.rowStarts[n] + n2]; i < n3; ++i) {
            transitionConsumer.accept(n, this.cols[i], this.nonZeros[i]);
        }
    }

    @Override
    public void forEachDoubleTransition(int n, int n2, MDP.DoubleTransitionConsumer doubleTransitionConsumer) {
        int n3 = this.choiceStarts[this.rowStarts[n] + n2 + 1];
        for (int i = this.choiceStarts[this.rowStarts[n] + n2]; i < n3; ++i) {
            doubleTransitionConsumer.accept(n, this.cols[i], this.nonZeros[i]);
        }
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(final int n, final int n2) {
        return new Iterator<Map.Entry<Integer, Double>>(){
            final int start;
            int col;
            final int end;
            {
                this.col = this.start = MDPSparse.this.choiceStarts[MDPSparse.this.rowStarts[n] + n2];
                this.end = MDPSparse.this.choiceStarts[MDPSparse.this.rowStarts[n] + n2 + 1];
            }

            @Override
            public boolean hasNext() {
                return this.col < this.end;
            }

            @Override
            public Map.Entry<Integer, Double> next() {
                assert (this.col < this.end);
                int n3 = this.col++;
                return new AbstractMap.SimpleImmutableEntry<Integer, Double>(MDPSparse.this.cols[n3], MDPSparse.this.nonZeros[n3]);
            }
        };
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, BitSet bitSet3) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            boolean bl2 = bl;
            int n2 = this.rowStarts[n];
            int n3 = this.rowStarts[n + 1];
            for (int i = n2; i < n3; ++i) {
                boolean bl3 = false;
                int n4 = this.choiceStarts[i];
                int n5 = this.choiceStarts[i + 1];
                for (int j = n4; j < n5; ++j) {
                    if (!bitSet2.get(this.cols[j])) continue;
                    bl3 = true;
                    break;
                }
                if (bl) {
                    if (bl3) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            bitSet3.set(n, bl2);
        }
    }

    @Override
    public void prob1Astep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            boolean bl = true;
            int n2 = this.rowStarts[n];
            int n3 = this.rowStarts[n + 1];
            for (int i = n2; i < n3; ++i) {
                boolean bl2 = false;
                boolean bl3 = true;
                int n4 = this.choiceStarts[i];
                int n5 = this.choiceStarts[i + 1];
                for (int j = n4; j < n5; ++j) {
                    if (!bitSet2.get(this.cols[j])) {
                        bl3 = false;
                        break;
                    }
                    if (!bitSet3.get(this.cols[j])) continue;
                    bl2 = true;
                }
                if (bl2 && bl3) continue;
                bl = false;
                break;
            }
            bitSet4.set(n, bl);
        }
    }

    @Override
    public void prob1Estep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, int[] nArray) {
        int n = -1;
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates).iterator();
        while (ofInt.hasNext()) {
            int n2 = (Integer)ofInt.next();
            boolean bl = false;
            int n3 = this.rowStarts[n2];
            int n4 = this.rowStarts[n2 + 1];
            for (int i = n3; i < n4; ++i) {
                boolean bl2 = false;
                boolean bl3 = true;
                int n5 = this.choiceStarts[i];
                int n6 = this.choiceStarts[i + 1];
                for (int j = n5; j < n6; ++j) {
                    if (!bitSet2.get(this.cols[j])) {
                        bl3 = false;
                        break;
                    }
                    if (!bitSet3.get(this.cols[j])) continue;
                    bl2 = true;
                }
                if (!bl2 || !bl3) continue;
                bl = true;
                if (nArray == null) break;
                n = i - n3;
                break;
            }
            if (nArray != null & bl & !bitSet4.get(n2)) {
                nArray[n2] = n;
            }
            bitSet4.set(n2, bl);
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.numStates).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            boolean bl2 = bl;
            int n2 = this.rowStarts[n];
            int n3 = this.rowStarts[n + 1];
            for (int i = n2; i < n3; ++i) {
                boolean bl3 = false;
                boolean bl4 = true;
                int n4 = this.choiceStarts[i];
                int n5 = this.choiceStarts[i + 1];
                for (int j = n4; j < n5; ++j) {
                    if (bitSet3.get(this.cols[j])) {
                        bl3 = true;
                    }
                    if (bitSet2.get(this.cols[j])) continue;
                    bl4 = false;
                }
                if (bl) {
                    if (bl3 && bl4) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3 || !bl4) continue;
                bl2 = true;
                break;
            }
            bitSet4.set(n, bl2);
        }
    }

    @Override
    public boolean prob1stepSingle(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        int n3 = this.rowStarts[n] + n2;
        boolean bl = false;
        boolean bl2 = true;
        int n4 = this.choiceStarts[n3];
        int n5 = this.choiceStarts[n3 + 1];
        for (int i = n4; i < n5; ++i) {
            if (bitSet2.get(this.cols[i])) {
                bl = true;
            }
            if (bitSet.get(this.cols[i])) continue;
            bl2 = false;
        }
        return bl && bl2;
    }

    @Override
    public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.rowStarts[n];
        int n4 = this.rowStarts[n + 1];
        for (int i = n3; i < n4; ++i) {
            double d2 = 0.0;
            int n5 = this.choiceStarts[i];
            int n6 = this.choiceStarts[i + 1];
            for (int j = n5; j < n6; ++j) {
                d2 += this.nonZeros[j] * dArray[this.cols[j]];
            }
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i - n3;
                }
            }
            bl2 = false;
        }
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.rowStarts[n];
        int n3 = this.rowStarts[n + 1];
        for (int i = n2; i < n3; ++i) {
            double d2 = 0.0;
            int n4 = this.choiceStarts[i];
            int n5 = this.choiceStarts[i + 1];
            for (int j = n4; j < n5; ++j) {
                d2 += this.nonZeros[j] * dArray[this.cols[j]];
            }
            if (!PrismUtils.doublesAreEqual(d, d2)) continue;
            arrayList.add(i - n2);
        }
        return arrayList;
    }

    @Override
    public double mvMultSingle(int n, int n2, double[] dArray) {
        int n3 = this.rowStarts[n] + n2;
        double d = 0.0;
        int n4 = this.choiceStarts[n3];
        int n5 = this.choiceStarts[n3 + 1];
        for (int i = n4; i < n5; ++i) {
            d += this.nonZeros[i] * dArray[this.cols[i]];
        }
        return d;
    }

    @Override
    public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.rowStarts[n];
        int n4 = this.rowStarts[n + 1];
        for (int i = n3; i < n4; ++i) {
            double d2 = 1.0;
            double d3 = 0.0;
            int n5 = this.choiceStarts[i];
            int n6 = this.choiceStarts[i + 1];
            for (int j = n5; j < n6; ++j) {
                if (this.cols[j] != n) {
                    d3 += this.nonZeros[j] * dArray[this.cols[j]];
                    continue;
                }
                d2 -= this.nonZeros[j];
            }
            if (d2 > 0.0) {
                d3 /= d2;
            }
            if (bl2 || bl && d3 < d || !bl && d3 > d) {
                d = d3;
                if (nArray != null) {
                    n2 = i - n3;
                }
            }
            bl2 = false;
        }
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, int n2, double[] dArray) {
        int n3 = this.rowStarts[n] + n2;
        double d = 1.0;
        double d2 = 0.0;
        int n4 = this.choiceStarts[n3];
        int n5 = this.choiceStarts[n3 + 1];
        for (int i = n4; i < n5; ++i) {
            if (this.cols[i] != n) {
                d2 += this.nonZeros[i] * dArray[this.cols[i]];
                continue;
            }
            d -= this.nonZeros[i];
        }
        if (d > 0.0) {
            d2 /= d;
        }
        return d2;
    }

    @Override
    public double mvMultRewMinMaxSingle(int n, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.rowStarts[n];
        int n4 = this.rowStarts[n + 1];
        for (int i = n3; i < n4; ++i) {
            double d2 = mDPRewards.getTransitionReward(n, i - n3);
            int n5 = this.choiceStarts[i];
            int n6 = this.choiceStarts[i + 1];
            for (int j = n5; j < n6; ++j) {
                d2 += this.nonZeros[j] * dArray[this.cols[j]];
            }
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i - n3;
                }
            }
            bl2 = false;
        }
        d += mDPRewards.getStateReward(n).doubleValue();
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public double mvMultRewSingle(int n, int n2, double[] dArray, MCRewards<Double> mCRewards) {
        int n3 = this.rowStarts[n] + n2;
        double d = 0.0;
        int n4 = this.choiceStarts[n3];
        int n5 = this.choiceStarts[n3 + 1];
        for (int i = n4; i < n5; ++i) {
            d += this.nonZeros[i] * dArray[this.cols[i]];
        }
        return d += mCRewards.getStateReward(n).doubleValue();
    }

    @Override
    public double mvMultRewJacMinMaxSingle(int n, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.rowStarts[n];
        int n4 = this.rowStarts[n + 1];
        for (int i = n3; i < n4; ++i) {
            double d2 = 1.0;
            boolean bl3 = true;
            double d3 = mDPRewards.getStateReward(n);
            d3 += mDPRewards.getTransitionReward(n, i - n3).doubleValue();
            int n5 = this.choiceStarts[i];
            int n6 = this.choiceStarts[i + 1];
            for (int j = n5; j < n6; ++j) {
                if (this.cols[j] != n) {
                    bl3 = false;
                    d3 += this.nonZeros[j] * dArray[this.cols[j]];
                    continue;
                }
                d2 -= this.nonZeros[j];
            }
            if (bl3) {
                d3 = d3 != 0.0 ? (d3 > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : 0.0;
            } else if (d2 > 0.0) {
                d3 /= d2;
            }
            if (bl2 || bl && d3 < d || !bl && d3 > d) {
                d = d3;
                if (nArray != null) {
                    n2 = i - n3;
                }
            }
            bl2 = false;
        }
        if (nArray != null & !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    @Override
    public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.rowStarts[n];
        int n3 = this.rowStarts[n + 1];
        for (int i = n2; i < n3; ++i) {
            double d2 = mDPRewards.getTransitionReward(n, i - n2);
            int n4 = this.choiceStarts[i];
            int n5 = this.choiceStarts[i + 1];
            for (int j = n4; j < n5; ++j) {
                d2 += this.nonZeros[j] * dArray[this.cols[j]];
            }
            if (!PrismUtils.doublesAreEqual(d, d2 += mDPRewards.getStateReward(n).doubleValue())) continue;
            arrayList.add(i - n2);
        }
        return arrayList;
    }

    @Override
    public void mvMultRight(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        for (int n : nArray) {
            int n2 = nArray2[n];
            int n3 = this.rowStarts[n] + n2;
            int n4 = this.choiceStarts[n3];
            int n5 = this.choiceStarts[n3 + 1];
            for (n2 = n4; n2 < n5; ++n2) {
                int n6 = this.cols[n2];
                dArray2[n6] = dArray2[n6] + this.nonZeros[n2] * dArray[n];
            }
        }
    }

    public String toString() {
        Object object = "";
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": [";
            int n = this.rowStarts[i];
            int n2 = this.rowStarts[i + 1];
            for (int j = n; j < n2; ++j) {
                Object object2;
                if (j > n) {
                    object = (String)object + ",";
                }
                if ((object2 = this.getAction(i, j - n)) != null) {
                    object = (String)object + object2 + ":";
                }
                object = (String)object + "{";
                int n3 = this.choiceStarts[j];
                int n4 = this.choiceStarts[j + 1];
                for (int k = n3; k < n4; ++k) {
                    if (k > n3) {
                        object = (String)object + ", ";
                    }
                    object = (String)object + this.cols[k] + ":" + this.nonZeros[k];
                }
                object = (String)object + "}";
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]";
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof MDPSparse)) {
            return false;
        }
        MDPSparse mDPSparse = (MDPSparse)object;
        if (this.numStates != mDPSparse.numStates) {
            return false;
        }
        if (!this.initialStates.equals(mDPSparse.initialStates)) {
            return false;
        }
        if (!Utils.doubleArraysAreEqual(this.nonZeros, mDPSparse.nonZeros)) {
            return false;
        }
        if (!Utils.intArraysAreEqual(this.cols, mDPSparse.cols)) {
            return false;
        }
        if (!Utils.intArraysAreEqual(this.choiceStarts, mDPSparse.choiceStarts)) {
            return false;
        }
        return Utils.intArraysAreEqual(this.rowStarts, mDPSparse.rowStarts);
    }
}

