/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.IteratorTools;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.NondetModel;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;

public interface MDP<Value>
extends NondetModel<Value> {
    @Override
    default public ModelType getModelType() {
        return ModelType.MDP;
    }

    @Override
    default public void exportToPrismExplicitTra(PrismLog prismLog, int n) {
        int n2 = this.getNumStates();
        prismLog.print(n2 + " " + this.getNumChoices() + " " + this.getNumTransitions() + "\n");
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Value> entry = iterator.next();
                    treeMap.put((Integer)entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    prismLog.print(i + " " + j + " " + entry.getKey() + " " + this.getEvaluator().toStringExport(entry.getValue(), n));
                    Object object = this.getAction(i, j);
                    prismLog.print((String)(object == null ? "\n" : " " + object + "\n"));
                }
                treeMap.clear();
            }
        }
    }

    @Override
    default public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable, int n2) {
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            Object object = this.getAction(n, i);
            String string = "n" + n + "_" + i;
            prismLog.print(n + " -> " + string + " ");
            Decoration decoration = new Decoration();
            decoration.attributes().put("arrowhead", "none");
            decoration.setLabel(i + (String)(object != null ? ":" + object : ""));
            if (iterable != null) {
                for (Decorator decorator : iterable) {
                    decoration = decorator.decorateTransition(n, i, decoration);
                }
            }
            prismLog.println(" " + decoration.toString() + ";");
            prismLog.print(string + " [ shape=point,width=0.1,height=0.1,label=\"\" ];\n");
            Iterator<Object> iterator = this.getTransitionsIterator(n, i);
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                prismLog.print(string + " -> " + entry.getKey() + " ");
                decoration = new Decoration();
                decoration.setLabel(this.getEvaluator().toStringExport(entry.getValue(), n2));
                if (iterable != null) {
                    for (Decorator decorator : iterable) {
                        decoration = decorator.decorateProbability(n, (Integer)entry.getKey(), i, entry.getValue(), decoration);
                    }
                }
                prismLog.println(" " + decoration.toString() + ";");
            }
        }
    }

    @Override
    default public void exportToPrismLanguage(String string, int n) throws PrismException {
        try (FileWriter fileWriter = new FileWriter(string);){
            fileWriter.write(this.getModelType().keyword() + "\n");
            int n2 = this.getNumStates();
            fileWriter.write("module M\nx : [0.." + (n2 - 1) + "];\n");
            TreeMap<Integer, Value> treeMap = new TreeMap<Integer, Value>();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.getNumChoices(i);
                for (int j = 0; j < n3; ++j) {
                    Object object = this.getTransitionsIterator(i, j);
                    while (object.hasNext()) {
                        Map.Entry<Integer, Value> entry = object.next();
                        treeMap.put(entry.getKey(), entry.getValue());
                    }
                    object = this.getAction(i, j);
                    fileWriter.write((String)(object != null ? "[" + object + "]" : "[]"));
                    fileWriter.write("x=" + i + "->");
                    boolean bl = true;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        if (bl) {
                            bl = false;
                        } else {
                            fileWriter.write("+");
                        }
                        fileWriter.write(this.getEvaluator().toStringPrism(entry.getValue(), n) + ":(x'=" + entry.getKey() + ")");
                    }
                    fileWriter.write(";\n");
                    treeMap.clear();
                }
            }
            fileWriter.write("endmodule\n");
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + this.getModelType() + " to file \"" + string + "\"" + iOException);
        }
    }

    @Override
    default public String infoString() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + n + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions";
        object = (String)object + ", " + this.getNumChoices() + " choices";
        object = (String)object + ", dist max/avg = " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)n);
        return object;
    }

    @Override
    default public String infoStringTable() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + "States:      " + n + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        object = (String)object + "Choices:     " + this.getNumChoices() + "\n";
        object = (String)object + "Max/avg:     " + this.getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)this.getNumChoices() / (double)n) + "\n";
        return object;
    }

    @Override
    default public int getNumTransitions(int n, int n2) {
        return Math.toIntExact(IteratorTools.count(this.getTransitionsIterator(n, n2)));
    }

    @Override
    default public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray, int n) {
        int n2 = this.getNumStates();
        prismLog.print("digraph " + this.getModelType() + " {\nnode [shape=box];\n");
        for (int i = 0; i < n2; ++i) {
            if (bitSet != null && bitSet.get(i)) {
                prismLog.print(i + " [style=filled  fillcolor=\"#cccccc\"]\n");
            }
            int n3 = this.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                String string = nArray[i] == j ? ",color=\"#ff0000\",fontcolor=\"#ff0000\"" : "";
                Object object = this.getAction(i, j);
                String string2 = "n" + i + "_" + j;
                prismLog.print(i + " -> " + string2 + " [ arrowhead=none,label=\"" + j);
                if (object != null) {
                    prismLog.print(":" + object);
                }
                prismLog.print("\"" + string + " ];\n");
                prismLog.print(string2 + " [ shape=point,height=0.1,label=\"\"" + string + " ];\n");
                Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Value> entry = iterator.next();
                    prismLog.print(string2 + " -> " + entry.getKey() + " [ label=\"" + this.getEvaluator().toStringExport(entry.getValue(), n) + "\"" + string + " ];\n");
                }
            }
        }
        prismLog.print("}\n");
    }

    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int var1, int var2);

    default public void forEachTransition(int n, int n2, TransitionConsumer<Value> transitionConsumer) {
        Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(n, n2);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Value> entry = iterator.next();
            transitionConsumer.accept(n, entry.getKey(), entry.getValue());
        }
    }

    default public Value sumOverTransitions(int n, int n2, final TransitionToValueFunction<Value> transitionToValueFunction) {
        class Sum {
            Value sum;

            Sum() {
                this.sum = MDP.this.getEvaluator().zero();
            }

            void accept(int n, int n2, Value Value2) {
                this.sum = MDP.this.getEvaluator().add(this.sum, transitionToValueFunction.apply(n, n2, Value2));
            }
        }
        Sum sum = new Sum();
        this.forEachTransition(n, n2, sum::accept);
        return sum.sum;
    }

    default public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, BitSet bitSet3) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            boolean bl2 = bl;
            int n2 = this.getNumChoices(n);
            for (int i = 0; i < n2; ++i) {
                boolean bl3 = this.someSuccessorsInSet(n, i, bitSet2);
                if (bl) {
                    if (bl3) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            bitSet3.set(n, bl2);
        }
    }

    default public void prob1Astep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            boolean bl = true;
            int n2 = this.getNumChoices(n);
            for (int i = 0; i < n2; ++i) {
                if (this.successorsSafeAndCanReach(n, i, bitSet2, bitSet3)) continue;
                bl = false;
                break;
            }
            bitSet4.set(n, bl);
        }
    }

    default public void prob1Estep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, int[] nArray) {
        int n = -1;
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n2 = ofInt.nextInt();
            boolean bl = false;
            int n3 = this.getNumChoices(n2);
            for (int i = 0; i < n3; ++i) {
                if (!this.successorsSafeAndCanReach(n2, i, bitSet2, bitSet3)) continue;
                bl = true;
                if (nArray == null) break;
                n = i;
                break;
            }
            if (nArray != null & bl & !bitSet4.get(n2)) {
                nArray[n2] = n;
            }
            bitSet4.set(n2, bl);
        }
    }

    default public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            boolean bl2 = bl;
            int n2 = this.getNumChoices(n);
            for (int i = 0; i < n2; ++i) {
                boolean bl3 = this.successorsSafeAndCanReach(n, i, bitSet2, bitSet3);
                if (bl) {
                    if (bl3) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            bitSet4.set(n, bl2);
        }
    }

    default public boolean prob1stepSingle(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        return this.successorsSafeAndCanReach(n, n2, bitSet, bitSet2);
    }

    default public void forEachDoubleTransition(int n, int n2, DoubleTransitionConsumer doubleTransitionConsumer) {
        Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(n, n2);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Value> entry = iterator.next();
            doubleTransitionConsumer.accept(n, entry.getKey(), this.getEvaluator().toDouble(entry.getValue()));
        }
    }

    default public double sumOverDoubleTransitions(int n, int n2, final DoubleTransitionToDoubleFunction doubleTransitionToDoubleFunction) {
        class Sum {
            double sum = 0.0;

            Sum() {
            }

            void accept(int n, int n2, double d) {
                this.sum += doubleTransitionToDoubleFunction.apply(n, n2, d);
            }
        }
        Sum sum = new Sum();
        this.forEachDoubleTransition(n, n2, sum::accept);
        return sum.sum;
    }

    default public void mvMultMinMax(double[] dArray, boolean bl, double[] dArray2, BitSet bitSet, boolean bl2, int[] nArray) {
        this.mvMultMinMax(dArray, bl, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator(), nArray);
    }

    default public void mvMultMinMax(double[] dArray, boolean bl, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl, nArray);
        }
    }

    default public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultSingle(n, i, dArray);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            double d2 = this.mvMultSingle(n, i, dArray);
            if (!PrismUtils.doublesAreEqual(d, d2)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    default public double mvMultSingle(int n3, int n4, double[] dArray) {
        return this.sumOverDoubleTransitions(n3, n4, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultGSMinMax(double[] dArray, boolean bl, BitSet bitSet, boolean bl2, boolean bl3, int[] nArray) {
        return this.mvMultGSMinMax(dArray, bl, new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator(), bl3, nArray);
    }

    default public double mvMultGSMinMax(double[] dArray, boolean bl, PrimitiveIterator.OfInt ofInt, boolean bl2, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultJacMinMaxSingle(n, dArray, bl, nArray);
            double d3 = bl2 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultGSMinMaxIntervalIter(double[] dArray, boolean bl, PrimitiveIterator.OfInt ofInt, int[] nArray, boolean bl2, boolean bl3) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultJacMinMaxSingle(n, dArray, bl, nArray);
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
                dArray[n] = d;
                continue;
            }
            dArray[n] = d;
        }
    }

    default public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultJacSingle(n, i, dArray);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultJacSingle(int n, int n2, final double[] dArray) {
        class Jacobi {
            double diag = 1.0;
            double d = 0.0;

            Jacobi() {
            }

            void accept(int n, int n2, double d) {
                if (n2 != n) {
                    this.d += d * dArray[n2];
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachDoubleTransition(n, n2, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public void mvMultRewMinMax(double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, double[] dArray2, BitSet bitSet, boolean bl2, int[] nArray) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
        }
    }

    default public void mvMultRewMinMax(double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
        }
    }

    default public double mvMultRewMinMaxSingle(int n, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultRewSingle(n, i, dArray, mDPRewards);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultRewSingle(int n3, int n4, double[] dArray, MDPRewards<Double> mDPRewards) {
        double d2 = mDPRewards.getStateReward(n3);
        d2 += mDPRewards.getTransitionReward(n3, n4).doubleValue();
        return d2 += this.sumOverDoubleTransitions(n3, n4, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultRewSingle(int n3, int n4, double[] dArray, MCRewards<Double> mCRewards) {
        double d2 = mCRewards.getStateReward(n3);
        return d2 += this.sumOverDoubleTransitions(n3, n4, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultRewGSMinMax(double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, BitSet bitSet, boolean bl2, boolean bl3, int[] nArray) {
        return this.mvMultRewGSMinMax(dArray, mDPRewards, bl, new IterableStateSet(bitSet, this.getNumStates(), bl2).iterator(), bl3, nArray);
    }

    default public double mvMultRewGSMinMax(double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, PrimitiveIterator.OfInt ofInt, boolean bl2, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultRewJacMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
            double d3 = bl2 ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultRewGSMinMaxIntervalIter(double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, PrimitiveIterator.OfInt ofInt, int[] nArray, boolean bl2, boolean bl3) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultRewJacMinMaxSingle(n, dArray, mDPRewards, bl, nArray);
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
                dArray[n] = d;
                continue;
            }
            dArray[n] = d;
        }
    }

    default public double mvMultRewJacMinMaxSingle(int n, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl2 = true;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultRewJacSingle(n, i, dArray, mDPRewards);
            if (bl2 || bl && d2 < d || !bl && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl2 = false;
        }
        if (nArray != null && !bl2) {
            if (bl) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultRewJacSingle(final int n, final int n2, final double[] dArray, final MDPRewards<Double> mDPRewards) {
        class Jacobi {
            double diag = 1.0;
            double d = (Double)mDPRewards.getStateReward(n) + (Double)mDPRewards.getTransitionReward(n, n2);
            boolean onlySelfLoops = true;

            Jacobi() {
            }

            void accept(int n3, int n22, double d) {
                if (n22 != n3) {
                    this.d += d * dArray[n22];
                    this.onlySelfLoops = false;
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachDoubleTransition(n, n2, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (jacobi.onlySelfLoops) {
            d = d != 0.0 ? (d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : 0.0;
        } else if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, double d) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            double d2 = this.mvMultRewSingle(n, i, dArray, mDPRewards);
            if (!PrismUtils.doublesAreEqual(d, d2)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    default public void mvMultRight(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        for (int n3 : nArray) {
            this.forEachDoubleTransition(n3, nArray2[n3], (n, n2, d) -> {
                int n3 = n2;
                dArray[n3] = dArray2[n3] + d * dArray[n];
            });
        }
    }

    @FunctionalInterface
    public static interface TransitionConsumer<Value> {
        public void accept(int var1, int var2, Value var3);
    }

    @FunctionalInterface
    public static interface TransitionToValueFunction<Value> {
        public Value apply(int var1, int var2, Value var3);
    }

    @FunctionalInterface
    public static interface DoubleTransitionConsumer {
        public void accept(int var1, int var2, double var3);
    }

    @FunctionalInterface
    public static interface DoubleTransitionToDoubleFunction {
        public double apply(int var1, int var2, double var3);
    }
}

