/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.ChoiceActionsSimple;
import explicit.LTS;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.NondetModelSimple;
import explicit.SuccessorsIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import prism.PrismException;
import strat.MDStrategy;

public class LTSSimple<Value>
extends ModelExplicit<Value>
implements LTS<Value>,
NondetModelSimple<Value> {
    protected List<List<Integer>> trans;
    protected ChoiceActionsSimple actions;
    protected int numTransitions;

    public LTSSimple() {
        this.initialise(0);
    }

    public LTSSimple(int n) {
        this.initialise(n);
    }

    public LTSSimple(LTSSimple<Value> lTSSimple) {
        this(lTSSimple.getNumStates());
        this.copyFrom(lTSSimple);
        for (int i = 0; i < this.numStates; ++i) {
            List<Integer> list = this.trans.get(i);
            for (int n : lTSSimple.trans.get(i)) {
                list.add(n);
            }
        }
        this.actions = new ChoiceActionsSimple(lTSSimple.actions);
        this.numTransitions = lTSSimple.numTransitions;
    }

    public LTSSimple(LTSSimple<Value> lTSSimple, int[] nArray) {
        this(lTSSimple.getNumStates());
        this.copyFrom(lTSSimple, nArray);
        for (int i = 0; i < this.numStates; ++i) {
            List<Integer> list = this.trans.get(nArray[i]);
            for (int n : lTSSimple.trans.get(i)) {
                list.add(nArray[n]);
            }
        }
        this.actions = new ChoiceActionsSimple(lTSSimple.actions, nArray);
        this.numTransitions = lTSSimple.numTransitions;
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.trans = new ArrayList<List<Integer>>();
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
        }
        this.actions = new ChoiceActionsSimple();
        this.numTransitions = 0;
    }

    @Override
    public void clearState(int n) {
        List<Integer> list = this.trans.get(n);
        this.numTransitions -= list.size();
        list.clear();
        this.actions.clearState(n);
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
            ++this.numStates;
        }
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new UnsupportedOperationException();
    }

    public void addTransition(int n, int n2) {
        this.trans.get(n).add(n2);
        ++this.numTransitions;
    }

    public void addActionLabelledTransition(int n, int n2, Object object) {
        this.trans.get(n).add(n2);
        this.actions.setAction(n, this.trans.get(n).size() - 1, object);
        ++this.numTransitions;
    }

    public void setAction(int n, int n2, Object object) {
        this.actions.setAction(n, n2, object);
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public int getNumTransitions(int n) {
        return this.getNumChoices(n);
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            this.addTransition(i, i);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("Model has a deadlock in state " + i);
        }
    }

    @Override
    public int getNumChoices(int n) {
        return this.trans.get(n).size();
    }

    @Override
    public int getNumChoices() {
        return this.numTransitions;
    }

    @Override
    public Object getAction(int n, int n2) {
        return this.actions.getAction(n, n2);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        if (n2 < this.getNumChoices(n)) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return bitSet.get(this.trans.get(n).get(n2));
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return bitSet.get(this.trans.get(n).get(n2));
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        return SuccessorsIterator.fromSingleton(this.trans.get(n).get(n2));
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        return SuccessorsIterator.from(this.trans.get(n).iterator(), false);
    }

    @Override
    public Model<Value> constructInducedModel(MDStrategy<Value> mDStrategy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSuccessor(int n, int n2) {
        return this.trans.get(n).get(n2);
    }
}

