/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableBitSet;
import common.IterableStateSet;
import explicit.LTS;
import explicit.LTSSimple;
import explicit.Model;
import explicit.Product;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2ba.MyBitSet;
import jltl2dstar.NBA;
import jltl2dstar.NBA_State;
import prism.PrismLog;

public class LTSNBAProduct
extends Product<Model<?>> {
    private ArrayList<ProductState> productStates;
    private BitSet acceptingStates;
    private int nbaSize;

    private LTSNBAProduct(LTS<?> lTS, Model<?> model, ArrayList<ProductState> arrayList, BitSet bitSet, int n) {
        super(lTS, model);
        this.productStates = arrayList;
        this.acceptingStates = bitSet;
        this.nbaSize = n;
    }

    @Override
    public int getModelState(int n) {
        return this.productStates.get(n).modelState;
    }

    @Override
    public int getAutomatonState(int n) {
        return this.productStates.get(n).automatonState;
    }

    @Override
    public int getAutomatonSize() {
        return this.nbaSize;
    }

    public void printStateMapping(PrismLog prismLog) {
        for (int i = 0; i < this.productStates.size(); ++i) {
            prismLog.println(i + ": " + this.productStates.get(i) + (this.acceptingStates.get(i) ? " !" : ""));
        }
    }

    public BitSet getAcceptingStates() {
        return this.acceptingStates;
    }

    public static LTSNBAProduct doProduct(Model<?> model, NBA nBA, BitSet bitSet, Vector<BitSet> vector) {
        ProductState productState;
        int n;
        ArrayList<ProductState> arrayList = new ArrayList<ProductState>();
        HashMap<ProductState, Integer> hashMap = new HashMap<ProductState, Integer>();
        LTSSimple lTSSimple = new LTSSimple();
        BitSet bitSet2 = new BitSet();
        Stack<Integer> stack = new Stack<Integer>();
        BitSet bitSet3 = new BitSet();
        NBA_State nBA_State = nBA.getStartState();
        if (nBA_State == null) {
            nBA_State = nBA.newState();
            nBA.setStartState(nBA_State);
        }
        Object object = new IterableStateSet(bitSet, model.getNumStates()).iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            productState = new ProductState(n, nBA_State.getName());
            arrayList.add(productState);
            int n2 = lTSSimple.addState();
            lTSSimple.addInitialState(n2);
            assert (n2 == arrayList.size() - 1);
            hashMap.put(productState, n2);
            stack.push(n2);
            if (!nBA_State.isFinal()) continue;
            bitSet2.set(n2);
        }
        object = nBA.getAPSet();
        while (!stack.isEmpty()) {
            n = (Integer)stack.pop();
            if (bitSet3.get(n)) continue;
            productState = arrayList.get(n);
            APElement aPElement = new APElement(((APSet)object).size());
            for (int i = 0; i < ((APSet)object).size(); ++i) {
                aPElement.set(i, vector.get(Integer.parseInt(((APSet)object).getAP(i).substring(1))).get(productState.getModelState()));
            }
            NBA_State nBA_State2 = nBA.get(productState.getAutomatonState());
            MyBitSet myBitSet = nBA_State2.getEdge(aPElement);
            Iterator<Integer> iterator = model.getSuccessorsIterator(productState.getModelState());
            while (iterator.hasNext()) {
                Integer n3 = iterator.next();
                for (Integer n4 : IterableBitSet.getSetBits(myBitSet)) {
                    ProductState productState2 = new ProductState(n3, n4);
                    Integer n5 = (Integer)hashMap.get(productState2);
                    if (n5 == null) {
                        arrayList.add(productState2);
                        n5 = lTSSimple.addState();
                        assert (n5 == arrayList.size() - 1);
                        hashMap.put(productState2, n5);
                        stack.push(n5);
                        boolean bl = nBA.get(n4).isFinal();
                        if (bl) {
                            bitSet2.set(n5);
                        }
                    }
                    lTSSimple.addTransition(n, n5);
                }
                bitSet3.set(n);
            }
        }
        return new LTSNBAProduct(lTSSimple, model, arrayList, bitSet2, nBA.size());
    }

    private static class ProductState {
        private int modelState;
        private int automatonState;

        public ProductState(int n, int n2) {
            this.modelState = n;
            this.automatonState = n2;
        }

        public int getModelState() {
            return this.modelState;
        }

        public int getAutomatonState() {
            return this.automatonState;
        }

        public String toString() {
            return "(" + this.getModelState() + "," + this.getAutomatonState() + ")";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.automatonState;
            n = 31 * n + this.modelState;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ProductState)) {
                return false;
            }
            ProductState productState = (ProductState)object;
            if (this.automatonState != productState.automatonState) {
                return false;
            }
            return this.modelState == productState.modelState;
        }
    }
}

