/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceBuchi;
import acceptance.AcceptanceGenRabin;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import automata.DA;
import automata.LTL2DA;
import automata.LTL2WDBA;
import common.IterableStateSet;
import common.StopWatch;
import explicit.CSG;
import explicit.CSGSimple;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.ECComputer;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.ModelSimple;
import explicit.NondetModel;
import explicit.POMDP;
import explicit.POMDPSimple;
import explicit.ProbModelChecker;
import explicit.Product;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import explicit.SMG;
import explicit.SMGSimple;
import explicit.STPG;
import explicit.STPGSimple;
import explicit.StateModelChecker;
import explicit.StateValues;
import java.awt.Point;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import jltl2ba.SimpleLTL;
import parser.State;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import parser.type.TypePathBool;
import prism.ModelType;
import prism.PlayerInfoOwner;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class LTLModelChecker
extends PrismComponent {
    public LTLModelChecker(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public static boolean isSupportedLTLFormula(ModelType modelType, Expression expression) throws PrismLangException {
        if (!expression.isPathFormula(true)) {
            return false;
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (modelType.continuousTime()) {
                return false;
            }
            if (!expression.isSimplePathFormula()) {
                return false;
            }
        }
        return true;
    }

    public Expression checkMaximalStateFormulas(StateModelChecker stateModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector) throws PrismException {
        if (expression.getType() instanceof TypeBool) {
            StateValues stateValues = stateModelChecker.checkExpression(model, expression, null);
            BitSet bitSet = stateValues.getBitSet();
            if (bitSet.isEmpty()) {
                return Expression.False();
            }
            if (bitSet.cardinality() == model.getNumStates()) {
                return Expression.True();
            }
            int n = vector.indexOf(bitSet);
            if (n != -1) {
                stateValues.clear();
                return new ExpressionLabel("L" + n);
            }
            BitSet bitSet2 = new BitSet(model.getNumStates());
            bitSet2.set(0, model.getNumStates());
            bitSet2.andNot(bitSet);
            n = vector.indexOf(bitSet2);
            if (n != -1) {
                stateValues.clear();
                return Expression.Not(new ExpressionLabel("L" + n));
            }
            vector.add(bitSet);
            return new ExpressionLabel("L" + (vector.size() - 1));
        }
        if (expression.getType() instanceof TypePathBool) {
            if (expression instanceof ExpressionBinaryOp) {
                ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
                expressionBinaryOp.setOperand1(this.checkMaximalStateFormulas(stateModelChecker, model, expressionBinaryOp.getOperand1(), vector));
                expressionBinaryOp.setOperand2(this.checkMaximalStateFormulas(stateModelChecker, model, expressionBinaryOp.getOperand2(), vector));
            } else if (expression instanceof ExpressionUnaryOp) {
                ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
                expressionUnaryOp.setOperand(this.checkMaximalStateFormulas(stateModelChecker, model, expressionUnaryOp.getOperand(), vector));
            } else if (expression instanceof ExpressionTemporal) {
                ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
                if (expressionTemporal.getOperand1() != null) {
                    expressionTemporal.setOperand1(this.checkMaximalStateFormulas(stateModelChecker, model, expressionTemporal.getOperand1(), vector));
                }
                if (expressionTemporal.getOperand2() != null) {
                    expressionTemporal.setOperand2(this.checkMaximalStateFormulas(stateModelChecker, model, expressionTemporal.getOperand2(), vector));
                }
            }
        }
        return expression;
    }

    public DA<BitSet, ? extends AcceptanceOmega> constructDAForLTLFormula(ProbModelChecker probModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (Expression.containsRewardBoundedPathFormula(expression)) {
            throw new PrismException("Automaton construction for reward-bounded path formulas not supported");
        }
        if (Expression.containsTemporalTimeBounds(expression)) {
            if (model.getModelType().continuousTime()) {
                throw new PrismException("Automaton construction for time-bounded operators not supported for " + model.getModelType() + ".");
            }
            if (!expression.isSimplePathFormula()) {
                throw new PrismNotSupportedException("Time-bounded operators not supported in LTL: " + expression);
            }
        }
        Expression expression2 = this.checkMaximalStateFormulas(probModelChecker, model, expression.deepCopy(), vector);
        this.mainLog.println("\nBuilding deterministic automaton (for " + expression2 + ")...");
        long l = System.currentTimeMillis();
        LTL2DA lTL2DA = new LTL2DA(this);
        DA<BitSet, ? extends AcceptanceOmega> dA = lTL2DA.convertLTLFormulaToDA(expression2, probModelChecker.getConstantValues(), acceptanceTypeArray);
        this.mainLog.println(dA.getAutomataType() + " has " + dA.size() + " states, " + dA.getAcceptance().getSizeStatistics() + ".");
        dA.checkForCanonicalAPs(vector.size());
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Time for " + dA.getAutomataType() + " translation: " + (double)l / 1000.0 + " seconds.");
        if (this.settings.getExportPropAut()) {
            this.mainLog.println("Exporting " + dA.getAutomataType() + " to file \"" + this.settings.getExportPropAutFilename() + "\"...");
            PrintStream printStream = PrismUtils.newPrintStream(this.settings.getExportPropAutFilename());
            dA.print(printStream, this.settings.getExportPropAutType());
            printStream.close();
        }
        return dA;
    }

    public DA<BitSet, AcceptanceReach> constructDFAForCosafetyProbLTL(StateModelChecker stateModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector) throws PrismException {
        Expression expression2 = this.checkMaximalStateFormulas(stateModelChecker, model, expression.deepCopy(), vector);
        SimpleLTL simpleLTL = expression2.convertForJltl2ba();
        simpleLTL = simpleLTL.toBasicOperators();
        simpleLTL = simpleLTL.pushNegation();
        LTL2WDBA lTL2WDBA = new LTL2WDBA(this);
        this.mainLog.println("\nBuilding deterministic finite automaton via LTL2WDBA construction (for " + simpleLTL + ")...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("constructing DFA");
        DA<BitSet, AcceptanceReach> dA = lTL2WDBA.cosafeltl2dfa(simpleLTL);
        stopWatch.stop("DFA has " + dA.size() + " states");
        return dA;
    }

    public DA<BitSet, AcceptanceReach> constructDFAForCosafetyRewardLTL(StateModelChecker stateModelChecker, Model<?> model, Expression expression, Vector<BitSet> vector) throws PrismException {
        Object object;
        Object object2;
        Expression expression2 = this.checkMaximalStateFormulas(stateModelChecker, model, expression.deepCopy(), vector);
        SimpleLTL simpleLTL = expression2.convertForJltl2ba();
        simpleLTL = simpleLTL.toBasicOperators();
        if ((simpleLTL = simpleLTL.pushNegation()).hasNextStep()) {
            object2 = "L" + vector.size();
            object = new BitSet();
            ((BitSet)object).set(0, model.getNumStates(), true);
            vector.add((BitSet)object);
            simpleLTL = simpleLTL.extendNextStepWithAP((String)object2);
        }
        object2 = new LTL2WDBA(this);
        this.mainLog.println("\nBuilding deterministic finite automaton via LTL2WDBA construction (for " + simpleLTL + ")...");
        object = new StopWatch(this.getLog());
        ((StopWatch)object).start("constructing DFA");
        DA<BitSet, AcceptanceReach> dA = ((LTL2WDBA)object2).cosafeltl2dfa(simpleLTL);
        ((StopWatch)object).stop("DFA has " + dA.size() + " states");
        return dA;
    }

    public <Value> LTLProduct<DTMC<Value>> constructProductMC(ProbModelChecker probModelChecker, DTMC<Value> dTMC, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, dTMC, expression, bitSet, acceptanceTypeArray);
    }

    public <Value> LTLProduct<MDP<Value>> constructProductMDP(ProbModelChecker probModelChecker, MDP<Value> mDP, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, mDP, expression, bitSet, acceptanceTypeArray);
    }

    public <Value> LTLProduct<STPG<Value>> constructProductSTPG(ProbModelChecker probModelChecker, STPG<Value> sTPG, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, sTPG, expression, bitSet, acceptanceTypeArray);
    }

    public <Value> LTLProduct<SMG<Value>> constructProductSMG(ProbModelChecker probModelChecker, SMG<Value> sMG, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, sMG, expression, bitSet, acceptanceTypeArray);
    }

    public <Value> LTLProduct<CSG<Value>> constructProductCSG(ProbModelChecker probModelChecker, CSG<Value> cSG, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        return this.constructDAProductForLTLFormula(probModelChecker, cSG, expression, bitSet, acceptanceTypeArray);
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructDAProductForLTLFormula(ProbModelChecker probModelChecker, M m, Expression expression, BitSet bitSet, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, ? extends AcceptanceOmega> dA = this.constructDAForLTLFormula(probModelChecker, m, expression, vector, acceptanceTypeArray);
        this.mainLog.println("Constructing " + m.getModelType() + "-" + dA.getAutomataType() + " product...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        LTLProduct<M> lTLProduct = this.constructProductModel(dA, m, vector, bitSet);
        stopWatch.stop("product has " + lTLProduct.getProductModel().infoString());
        return lTLProduct;
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructDFAProductForCosafetyProbLTL(ProbModelChecker probModelChecker, M m, Expression expression, BitSet bitSet) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, AcceptanceReach> dA = this.constructDFAForCosafetyProbLTL(probModelChecker, m, expression, vector);
        this.mainLog.println("Constructing " + m.getModelType() + "-" + dA.getAutomataType() + " product...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        LTLProduct<M> lTLProduct = this.constructProductModel(dA, m, vector, bitSet);
        stopWatch.stop("product has " + lTLProduct.getProductModel().infoString());
        return lTLProduct;
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructDFAProductForCosafetyReward(ProbModelChecker probModelChecker, M m, Expression expression, BitSet bitSet) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        DA<BitSet, AcceptanceReach> dA = this.constructDFAForCosafetyRewardLTL(probModelChecker, m, expression, vector);
        this.mainLog.println("Constructing " + m.getModelType() + "-" + dA.getAutomataType() + " product...");
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("product construction");
        LTLProduct<M> lTLProduct = this.constructProductModel(dA, m, vector, bitSet);
        stopWatch.stop("product has " + lTLProduct.getProductModel().infoString());
        return lTLProduct;
    }

    public <Value, M extends Model<Value>> LTLProduct<M> constructProductModel(DA<BitSet, ? extends AcceptanceOmega> dA, M m, Vector<BitSet> vector, BitSet bitSet) throws PrismException {
        ModelExplicit modelExplicit;
        Object object;
        VarList varList = null;
        if (m.getVarList() != null) {
            object = m.getVarList();
            modelExplicit = "_da";
            while (((VarList)object).getIndex((String)((Object)modelExplicit)) != -1) {
                modelExplicit = "_" + (String)((Object)modelExplicit);
            }
            varList = (VarList)((VarList)object).clone();
            Declaration declaration = new Declaration((String)((Object)modelExplicit), new DeclarationInt(Expression.Int(0), Expression.Int(Math.max(dA.size() - 1, 1))));
            varList.addVar(0, declaration, 1, m.getConstantValues());
        }
        object = m.getModelType();
        modelExplicit = null;
        switch (2.$SwitchMap$prism$ModelType[((Enum)object).ordinal()]) {
            case 1: {
                modelExplicit = new DTMCSimple();
                break;
            }
            case 2: {
                modelExplicit = new MDPSimple();
                break;
            }
            case 3: {
                modelExplicit = new POMDPSimple();
                break;
            }
            case 4: {
                modelExplicit = new IDTMCSimple();
                break;
            }
            case 5: {
                modelExplicit = new IMDPSimple();
                break;
            }
            case 6: {
                modelExplicit = new STPGSimple();
                break;
            }
            case 7: {
                modelExplicit = new SMGSimple();
                break;
            }
            case 8: {
                modelExplicit = new CSGSimple();
                break;
            }
            default: {
                throw new PrismNotSupportedException("Model construction not supported for " + (ModelType)((Object)object) + "s");
            }
        }
        if (m instanceof PlayerInfoOwner) {
            if (object == ModelType.STPG) {
                ((STPGSimple)modelExplicit).copyPlayerInfo((PlayerInfoOwner)((Object)m));
            }
            if (object == ModelType.SMG) {
                ((SMGSimple)modelExplicit).copyPlayerInfo((PlayerInfoOwner)((Object)m));
            }
            if (object == ModelType.CSG) {
                ((CSGSimple)modelExplicit).copyPlayerInfo((PlayerInfoOwner)((Object)m));
            }
        }
        if (object == ModelType.CSG) {
            ((CSGSimple)modelExplicit).setActions(((CSG)m).getActions());
            ((CSGSimple)modelExplicit).setIndexes(((CSG)m).getIndexes());
            ((CSGSimple)modelExplicit).setIdles(((CSG)m).getIdles());
        }
        ((ModelExplicit)modelExplicit).setEvaluator(m.getEvaluator());
        ((ModelExplicit)modelExplicit).setVarList(varList);
        switch (2.$SwitchMap$prism$ModelType[((Enum)object).ordinal()]) {
            case 4: {
                return this.doConstructProductModel(ModelType.DTMC, (ModelSimple<?>)((Object)modelExplicit), dA, m, vector, bitSet);
            }
            case 5: {
                return this.doConstructProductModel(ModelType.MDP, (ModelSimple<?>)((Object)modelExplicit), dA, m, vector, bitSet);
            }
        }
        return this.doConstructProductModel((ModelType)((Object)object), (ModelSimple<?>)((Object)modelExplicit), dA, m, vector, bitSet);
    }

    /*
     * WARNING - void declaration
     */
    protected <Value, M extends Model<Value>> LTLProduct<M> doConstructProductModel(ModelType modelType, ModelSimple<?> modelSimple, DA<BitSet, ? extends AcceptanceOmega> dA, M m, Vector<BitSet> vector, BitSet bitSet) throws PrismException {
        Object object;
        int n;
        int n2 = dA.size();
        int n3 = dA.getAPList().size();
        int n4 = m.getNumStates();
        int n5 = Math.multiplyExact(n4, n2);
        BitSet bitSet2 = new BitSet(n3);
        ArrayList<State> arrayList = null;
        ArrayList<State> arrayList2 = null;
        try {
            n5 = Math.multiplyExact(n4, n2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismException("Size of product state space of model and automaton is too large for explicit engine");
        }
        LinkedList<Point> linkedList = new LinkedList<Point>();
        int[] nArray = new int[n5];
        Arrays.fill(nArray, -1);
        if (m.getStatesList() != null) {
            arrayList = new ArrayList<State>();
            arrayList2 = new ArrayList<State>(dA.size());
            for (int i = 0; i < dA.size(); ++i) {
                arrayList2.add(new State(1).setValue(0, i));
            }
        }
        Object object2 = new IterableStateSet(bitSet, m.getNumStates()).iterator();
        while (object2.hasNext()) {
            int n6 = (Integer)object2.next();
            for (n = 0; n < n3; ++n) {
                bitSet2.set(n, vector.get(Integer.parseInt(dA.getAPList().get(n).substring(1))).get(n6));
            }
            n = dA.getEdgeDestByLabel(dA.getStartState(), bitSet2);
            if (n < 0) {
                throw new PrismException("The deterministic automaton is not complete (state " + dA.getStartState() + ")");
            }
            linkedList.add(new Point(n6, n));
            switch (modelType) {
                case STPG: {
                    ((STPGSimple)modelSimple).addState(((STPG)m).getPlayer(n6));
                    break;
                }
                case SMG: {
                    ((SMGSimple)modelSimple).addState(((SMG)m).getPlayer(n6));
                    break;
                }
                default: {
                    modelSimple.addState();
                }
            }
            modelSimple.addInitialState(modelSimple.getNumStates() - 1);
            nArray[n6 * n2 + n] = modelSimple.getNumStates() - 1;
            if (arrayList == null) continue;
            arrayList.add(new State((State)arrayList2.get(n), m.getStatesList().get(n6)));
        }
        object2 = new BitSet(n5);
        while (!linkedList.isEmpty()) {
            Point point = (Point)linkedList.pop();
            int n7 = point.x;
            int n8 = point.y;
            ((BitSet)object2).set(n7 * n2 + n8);
            n = m instanceof NondetModel ? ((NondetModel)m).getNumChoices(n7) : 1;
            block33: for (int i = 0; i < n; ++i) {
                void var24_38;
                switch (modelType) {
                    case DTMC: {
                        Iterator iterator = ((DTMC)m).getTransitionsIterator(n7);
                        break;
                    }
                    case MDP: {
                        Iterator iterator = ((MDP)m).getTransitionsIterator(n7, i);
                        break;
                    }
                    case POMDP: {
                        Iterator iterator = ((POMDP)m).getTransitionsIterator(n7, i);
                        break;
                    }
                    case STPG: {
                        Iterator iterator = ((STPG)m).getTransitionsIterator(n7, i);
                        break;
                    }
                    case SMG: {
                        Iterator iterator = ((SMG)m).getTransitionsIterator(n7, i);
                        break;
                    }
                    case CSG: {
                        Iterator iterator = ((CSG)m).getTransitionsIterator(n7, i);
                        break;
                    }
                    default: {
                        throw new PrismNotSupportedException("Product construction not implemented for " + modelType + "s");
                    }
                }
                object = null;
                if (modelType.nondeterministic()) {
                    object = new Distribution<Value>(m.getEvaluator());
                }
                block34: while (var24_38.hasNext()) {
                    Map.Entry entry = (Map.Entry)var24_38.next();
                    int n9 = (Integer)entry.getKey();
                    Object v = entry.getValue();
                    for (int j = 0; j < n3; ++j) {
                        bitSet2.set(j, vector.get(Integer.parseInt(dA.getAPList().get(j).substring(1))).get(n9));
                    }
                    int n10 = dA.getEdgeDestByLabel(n8, bitSet2);
                    if (n10 < 0) {
                        throw new PrismException("The deterministic automaton is not complete (state " + n8 + ")");
                    }
                    if (!((BitSet)object2).get(n9 * n2 + n10) && nArray[n9 * n2 + n10] == -1) {
                        linkedList.add(new Point(n9, n10));
                        switch (modelType) {
                            case STPG: {
                                ((STPGSimple)modelSimple).addState(((STPG)m).getPlayer(n9));
                                break;
                            }
                            case SMG: {
                                ((SMGSimple)modelSimple).addState(((SMG)m).getPlayer(n9));
                                break;
                            }
                            default: {
                                modelSimple.addState();
                            }
                        }
                        nArray[n9 * n2 + n10] = modelSimple.getNumStates() - 1;
                        if (arrayList != null) {
                            arrayList.add(new State((State)arrayList2.get(n10), m.getStatesList().get(n9)));
                        }
                    }
                    switch (modelType) {
                        case DTMC: {
                            ((DTMCSimple)modelSimple).setProbability(nArray[n7 * n2 + n8], nArray[n9 * n2 + n10], v);
                            continue block34;
                        }
                        case MDP: 
                        case POMDP: 
                        case STPG: 
                        case SMG: 
                        case CSG: {
                            ((Distribution)object).set(nArray[n9 * n2 + n10], v);
                            continue block34;
                        }
                    }
                    throw new PrismNotSupportedException("Product construction not implemented for " + modelType + "s");
                }
                switch (modelType) {
                    case MDP: {
                        ((MDPSimple)modelSimple).addActionLabelledChoice(nArray[n7 * n2 + n8], object, ((MDP)m).getAction(n7, i));
                        continue block33;
                    }
                    case POMDP: {
                        ((POMDPSimple)modelSimple).addActionLabelledChoice(nArray[n7 * n2 + n8], object, ((POMDP)m).getAction(n7, i));
                        continue block33;
                    }
                    case STPG: {
                        ((STPGSimple)modelSimple).addActionLabelledChoice(nArray[n7 * n2 + n8], object, ((STPG)m).getAction(n7, i));
                        continue block33;
                    }
                    case SMG: {
                        ((SMGSimple)modelSimple).addActionLabelledChoice(nArray[n7 * n2 + n8], object, ((SMG)m).getAction(n7, i));
                        continue block33;
                    }
                    case CSG: {
                        int n6 = ((CSGSimple)modelSimple).addActionLabelledChoice(nArray[n7 * n2 + n8], object, ((CSG)m).getAction(n7, i));
                        ((CSGSimple)modelSimple).setIndexes(nArray[n7 * n2 + n8], n6, ((CSG)m).getIndexes(n7, i));
                        continue block33;
                    }
                }
            }
            if (modelType != ModelType.POMDP) continue;
            State state = ((POMDP)m).getObservationAsState(n7);
            State state2 = ((POMDP)m).getUnobservationAsState(n7);
            ((POMDPSimple)modelSimple).setObservation(nArray[n7 * n2 + n8], state, state2, null);
        }
        int[] nArray2 = new int[modelSimple.getNumStates()];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == -1) continue;
            nArray2[nArray[n]] = n;
        }
        modelSimple.findDeadlocks(false);
        if (arrayList != null) {
            modelSimple.setStatesList(arrayList);
        }
        LTLProduct lTLProduct = new LTLProduct(this, modelSimple, m, null, n2, nArray2);
        lTLProduct.setAcceptance(this.liftAcceptance(lTLProduct, dA.getAcceptance()));
        for (String string : m.getLabels()) {
            object = lTLProduct.liftFromModel(m.getLabelStates(string));
            modelSimple.addLabel(string, (BitSet)object);
        }
        return lTLProduct;
    }

    public BitSet findAcceptingBSCCs(Model<?> model, AcceptanceOmega acceptanceOmega) throws PrismException {
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, model, sCCConsumerStore);
        sCCComputer.computeSCCs();
        List<BitSet> list = sCCConsumerStore.getBSCCs();
        BitSet bitSet = new BitSet();
        for (BitSet bitSet2 : list) {
            if (!acceptanceOmega.isBSCCAccepting(bitSet2)) continue;
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public BitSet findAcceptingECStates(NondetModel<?> nondetModel, AcceptanceOmega acceptanceOmega) throws PrismException {
        if (acceptanceOmega instanceof AcceptanceBuchi) {
            return this.findAcceptingECStatesForBuchi(nondetModel, (AcceptanceBuchi)acceptanceOmega);
        }
        if (acceptanceOmega instanceof AcceptanceRabin) {
            return this.findAcceptingECStatesForRabin(nondetModel, (AcceptanceRabin)acceptanceOmega);
        }
        if (acceptanceOmega instanceof AcceptanceStreett) {
            return this.findAcceptingECStatesForStreett(nondetModel, (AcceptanceStreett)acceptanceOmega);
        }
        if (acceptanceOmega instanceof AcceptanceGenRabin) {
            return this.findAcceptingECStatesForGeneralizedRabin(nondetModel, (AcceptanceGenRabin)acceptanceOmega);
        }
        throw new PrismNotSupportedException("Computing end components for acceptance type '" + acceptanceOmega.getType() + "' currently not supported (explicit engine).");
    }

    public BitSet findAcceptingECStatesForBuchi(NondetModel<?> nondetModel, AcceptanceBuchi acceptanceBuchi) throws PrismException {
        BitSet bitSet = new BitSet();
        if (acceptanceBuchi.getAcceptingStates().isEmpty()) {
            return bitSet;
        }
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates();
        List<BitSet> list = eCComputer.getMECStates();
        for (BitSet bitSet2 : list) {
            if (!bitSet2.intersects(acceptanceBuchi.getAcceptingStates())) continue;
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public BitSet findAcceptingECStatesForRabin(NondetModel<?> nondetModel, AcceptanceRabin acceptanceRabin) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = nondetModel.getNumStates();
        for (int i = 0; i < acceptanceRabin.size(); ++i) {
            BitSet bitSet2 = ((AcceptanceRabin.RabinPair)acceptanceRabin.get(i)).getL();
            BitSet bitSet3 = new BitSet();
            for (int j = 0; j < n; ++j) {
                if (bitSet2.get(j)) continue;
                bitSet3.set(j);
            }
            if (bitSet3.cardinality() == 0) continue;
            ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates(bitSet3, ((AcceptanceRabin.RabinPair)acceptanceRabin.get(i)).getK());
            List<BitSet> list = eCComputer.getMECStates();
            for (BitSet bitSet4 : list) {
                bitSet.or(bitSet4);
            }
        }
        return bitSet;
    }

    public BitSet findAcceptingECStatesForStreett(NondetModel<?> nondetModel, AcceptanceStreett acceptanceStreett) throws PrismException {
        Object object;
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        bitSet2.set(0, acceptanceStreett.size());
        class ECandPairs {
            BitSet MEC;
            BitSet activePairs;

            ECandPairs() {
            }
        }
        Stack<ECandPairs> stack = new Stack<ECandPairs>();
        ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
        eCComputer.computeMECStates();
        for (BitSet bitSet3 : eCComputer.getMECStates()) {
            object = new ECandPairs();
            ((ECandPairs)object).MEC = bitSet3;
            ((ECandPairs)object).activePairs = bitSet2;
            stack.push((ECandPairs)object);
        }
        while (!stack.empty()) {
            BitSet bitSet3;
            ECandPairs eCandPairs = (ECandPairs)stack.pop();
            bitSet3 = (BitSet)eCandPairs.activePairs.clone();
            object = null;
            boolean bl = true;
            int n = eCandPairs.activePairs.nextSetBit(0);
            while (n != -1) {
                if (!((AcceptanceStreett.StreettPair)acceptanceStreett.get(n)).isBSCCAccepting(eCandPairs.MEC)) {
                    if (object == null) {
                        object = (BitSet)eCandPairs.MEC.clone();
                    }
                    ((BitSet)object).andNot(((AcceptanceStreett.StreettPair)acceptanceStreett.get(n)).getR());
                    bitSet3.clear(n);
                    bl = false;
                }
                n = eCandPairs.activePairs.nextSetBit(n + 1);
            }
            if (bl) {
                bitSet.or(eCandPairs.MEC);
                continue;
            }
            if (((BitSet)object).isEmpty()) continue;
            eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates((BitSet)object);
            for (BitSet bitSet4 : eCComputer.getMECStates()) {
                ECandPairs eCandPairs2 = new ECandPairs();
                eCandPairs2.MEC = bitSet4;
                eCandPairs2.activePairs = bitSet3;
                stack.push(eCandPairs2);
            }
        }
        return bitSet;
    }

    public BitSet findAcceptingECStatesForGeneralizedRabin(NondetModel<?> nondetModel, AcceptanceGenRabin acceptanceGenRabin) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = nondetModel.getNumStates();
        for (int i = 0; i < acceptanceGenRabin.size(); ++i) {
            BitSet bitSet2 = ((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getL();
            BitSet bitSet3 = new BitSet();
            for (int j = 0; j < n; ++j) {
                if (bitSet2.get(j)) continue;
                bitSet3.set(j);
            }
            if (bitSet3.cardinality() == 0) continue;
            ECComputer eCComputer = ECComputer.createECComputer(this, nondetModel);
            eCComputer.computeMECStates(bitSet3);
            List<BitSet> list = eCComputer.getMECStates();
            int n2 = ((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getNumK();
            for (BitSet bitSet4 : list) {
                boolean bl = true;
                for (int j = 0; j < n2; ++j) {
                    if (bitSet4.intersects(((AcceptanceGenRabin.GenRabinPair)acceptanceGenRabin.get(i)).getK(j))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                bitSet.or(bitSet4);
            }
        }
        return bitSet;
    }

    private AcceptanceOmega liftAcceptance(final LTLProduct<?> lTLProduct, AcceptanceOmega acceptanceOmega) {
        AcceptanceOmega acceptanceOmega2 = acceptanceOmega.clone();
        acceptanceOmega2.lift(new AcceptanceOmega.LiftBitSet(){

            @Override
            public BitSet lift(BitSet bitSet) {
                return lTLProduct.liftFromAutomaton(bitSet);
            }
        });
        return acceptanceOmega2;
    }

    public static class LTLProduct<M extends Model<?>>
    extends Product<M> {
        private int daSize;
        private int[] invMap;
        private AcceptanceOmega acceptance;
        final /* synthetic */ LTLModelChecker this$0;

        public LTLProduct(M m, M m2, AcceptanceOmega acceptanceOmega, int n, int[] nArray) {
            this.this$0 = var1_1;
            super(m, m2);
            this.daSize = n;
            this.invMap = nArray;
            this.acceptance = acceptanceOmega;
        }

        @Override
        public int getModelState(int n) {
            return this.invMap[n] / this.daSize;
        }

        @Override
        public int getAutomatonState(int n) {
            return this.invMap[n] % this.daSize;
        }

        @Override
        public int getAutomatonSize() {
            return this.daSize;
        }

        public AcceptanceOmega getAcceptance() {
            return this.acceptance;
        }

        public void setAcceptance(AcceptanceOmega acceptanceOmega) {
            this.acceptance = acceptanceOmega;
        }
    }
}

