/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import explicit.Distribution;
import explicit.DoubleIntervalDistribution;
import java.util.Iterator;
import java.util.Map;
import prism.Evaluator;

public class IntervalUtils {
    public static DoubleIntervalDistribution extractDoubleIntervalDistribution(Distribution<Interval<Double>> distribution) {
        return IntervalUtils.extractDoubleIntervalDistribution(distribution.iterator(), distribution.size());
    }

    public static DoubleIntervalDistribution extractDoubleIntervalDistribution(Iterator<Map.Entry<Integer, Interval<Double>>> iterator, int n) {
        DoubleIntervalDistribution doubleIntervalDistribution = new DoubleIntervalDistribution(n);
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry<Integer, Interval<Double>> entry = iterator.next();
            doubleIntervalDistribution.lower[n2] = entry.getValue().getLower();
            doubleIntervalDistribution.upper[n2] = entry.getValue().getUpper();
            doubleIntervalDistribution.index[n2] = entry.getKey();
            ++n2;
        }
        return doubleIntervalDistribution;
    }

    public static <Value> void delimit(Distribution<Interval<Value>> distribution, Evaluator<Value> evaluator) {
        Evaluator<Interval<Interval<Value>>> evaluator2 = distribution.getEvaluator();
        Interval<Value> interval = evaluator2.subtract(evaluator2.one(), distribution.sum());
        Value Value2 = interval.getLower();
        Value Value3 = interval.getUpper();
        for (Map.Entry entry : distribution) {
            Object Value4;
            Interval interval2 = (Interval)entry.getValue();
            Object Value5 = interval2.getLower();
            Object Value6 = interval2.getUpper();
            Object Value7 = evaluator.add(Value3, Value6);
            if (evaluator.gt(Value7, Value5)) {
                interval2.setLower(Value7);
            }
            if (!evaluator.gt(Value6, Value4 = evaluator.add(Value2, Value5))) continue;
            interval2.setUpper(Value4);
        }
    }

    public Distribution<Interval<Double>> delimitDoubles(Distribution<Interval<Double>> distribution) {
        DoubleIntervalDistribution doubleIntervalDistribution = IntervalUtils.extractDoubleIntervalDistribution(distribution);
        if (IntervalUtils.delimitDoubles(doubleIntervalDistribution)) {
            Distribution<Interval<Double>> distribution2 = new Distribution<Interval<Double>>(distribution.getEvaluator());
            for (int i = 0; i < doubleIntervalDistribution.size; ++i) {
                distribution2.add(doubleIntervalDistribution.index[i], new Interval<Double>(doubleIntervalDistribution.lower[i], doubleIntervalDistribution.upper[i]));
            }
            return distribution2;
        }
        return distribution;
    }

    public static boolean delimitDoubles(DoubleIntervalDistribution doubleIntervalDistribution) {
        boolean bl = false;
        for (int i = 0; i < doubleIntervalDistribution.size; ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < doubleIntervalDistribution.size; ++n) {
                if (n == i) continue;
                d += doubleIntervalDistribution.upper[i];
            }
            if (doubleIntervalDistribution.lower[i] < 1.0 - d) {
                doubleIntervalDistribution.lower[i] = 1.0 - d;
                bl |= true;
            }
            d = 0.0;
            for (n = 0; n < doubleIntervalDistribution.size; ++n) {
                if (n == i) continue;
                d += doubleIntervalDistribution.lower[i];
            }
            if (!(doubleIntervalDistribution.upper[i] > 1.0 - d)) continue;
            doubleIntervalDistribution.upper[i] = 1.0 - d;
            bl |= true;
        }
        return bl;
    }
}

