/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.text.DecimalFormat;

public class Interval {
    private static DecimalFormat df = new DecimalFormat("0.000");
    public double lhs = 0.0;
    public double rhs = 1.0;

    public Interval(double d, double d2) {
        this.lhs = d;
        this.rhs = d2;
    }

    public boolean achievableFrom(Interval interval) {
        return this.lhs <= interval.lhs && this.rhs >= interval.rhs;
    }

    public boolean achievableFrom(Interval interval, Interval interval2) {
        double d = (this.lhs - interval2.lhs) / (interval.lhs - interval2.lhs);
        if (d >= 0.0 && d <= 1.0 && this.rhs >= d * interval.rhs + (1.0 - d) * interval2.rhs) {
            return true;
        }
        double d2 = (this.rhs - interval2.rhs) / (interval.rhs - interval2.rhs);
        return d2 >= 0.0 && d2 <= 1.0 && this.lhs <= d2 * interval.lhs + (1.0 - d2) * interval2.lhs;
    }

    public boolean convexAchievableFrom(Interval interval, Interval interval2) {
        double d = (this.lhs - interval2.lhs) / (interval.lhs - interval2.lhs);
        if (d >= 0.0 && d <= 1.0 && this.rhs >= d * interval.rhs + (1.0 - d) * interval2.rhs) {
            return true;
        }
        double d2 = (this.rhs - interval2.rhs) / (interval.rhs - interval2.rhs);
        return d2 >= 0.0 && d2 <= 1.0 && this.lhs <= d2 * interval.lhs + (1.0 - d2) * interval2.lhs;
    }

    public static Interval getUnion(Interval interval, Interval interval2) {
        return new Interval(Math.min(interval.lhs, interval2.lhs), Math.max(interval.rhs, interval2.rhs));
    }

    public String toString() {
        return "(" + df.format(this.lhs) + "," + df.format(this.rhs) + ")";
    }

    public boolean equals(Object object) {
        return object instanceof Interval && ((Interval)object).lhs == this.lhs && ((Interval)object).rhs == this.rhs;
    }

    public int hashCode() {
        return (int)(1000000.0 * (this.lhs + this.rhs + this.lhs * this.rhs));
    }

    public static void main(String[] stringArray) {
        Interval interval = new Interval(0.25, 0.5);
        Interval interval2 = new Interval(0.0, 0.0);
        Interval interval3 = new Interval(0.4, 1.0);
        Interval interval4 = new Interval(0.3, 0.4);
        System.out.println(interval.achievableFrom(interval4));
        System.out.println(interval.achievableFrom(interval4, interval2));
    }
}

