/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.NondetModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import prism.PrismComponent;

public class IncomingChoiceRelation {
    List<ArrayList<Choice>> pre;

    public IncomingChoiceRelation(NondetModel<?> nondetModel) {
        this.pre = new ArrayList<ArrayList<Choice>>(nondetModel.getNumStates());
        for (int i = 0; i < nondetModel.getNumStates(); ++i) {
            this.pre.add(i, new ArrayList());
        }
        this.compute(nondetModel);
    }

    private void compute(NondetModel<?> nondetModel) {
        int n = nondetModel.getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = nondetModel.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                Choice choice = new Choice(i, j);
                Iterator<Integer> iterator = nondetModel.getSuccessorsIterator(i, j);
                while (iterator.hasNext()) {
                    int n3 = iterator.next();
                    this.pre.get(n3).add(choice);
                }
            }
        }
    }

    public Iterable<Choice> getIncomingChoices(int n) {
        return this.pre.get(n);
    }

    public Iterator<Choice> getIncomingChoicesIterator(int n) {
        return this.getIncomingChoices(n).iterator();
    }

    public static IncomingChoiceRelation forModel(PrismComponent prismComponent, NondetModel<?> nondetModel) {
        long l = System.currentTimeMillis();
        prismComponent.getLog().print("Calculating incoming choices relation for " + nondetModel.getModelType().fullName() + "...  ");
        prismComponent.getLog().flush();
        IncomingChoiceRelation incomingChoiceRelation = new IncomingChoiceRelation(nondetModel);
        l = System.currentTimeMillis() - l;
        prismComponent.getLog().println("done (" + (double)l / 1000.0 + " seconds)");
        return incomingChoiceRelation;
    }

    public static final class Choice {
        private int state;
        private int choice;

        public Choice(int n, int n2) {
            this.state = n;
            this.choice = n2;
        }

        public int getState() {
            return this.state;
        }

        public int getChoice() {
            return this.choice;
        }

        public String toString() {
            return "(" + this.state + "," + this.choice + ")";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.choice;
            n = 31 * n + this.state;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Choice choice = (Choice)object;
            if (this.choice != choice.choice) {
                return false;
            }
            return this.state == choice.state;
        }
    }
}

