/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import common.IterableStateSet;
import explicit.DoubleIntervalDistribution;
import explicit.IDTMC;
import explicit.IntervalUtils;
import explicit.MDP;
import explicit.MinMax;
import explicit.rewards.MDPRewards;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import parser.State;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismException;

public interface IMDP<Value>
extends MDP<Interval<Value>> {
    @Override
    default public ModelType getModelType() {
        return ModelType.IMDP;
    }

    default public void checkLowerBoundsArePositive() throws PrismException {
        Evaluator<Interval> evaluator = this.getEvaluator();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                Iterator iterator = this.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (evaluator.gt((Interval)entry.getValue(), (Interval)evaluator.zero())) continue;
                    List<State> list = this.getStatesList();
                    String string = list == null ? "" + i : list.get(i).toString();
                    throw new PrismException("Transition probability has lower bound of 0 in state " + string);
                }
            }
        }
    }

    default public void mvMultUnc(double[] dArray, MinMax minMax, double[] dArray2, BitSet bitSet, boolean bl, int[] nArray) {
        this.mvMultUnc(dArray, minMax, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator(), nArray);
    }

    default public void mvMultUnc(double[] dArray, MinMax minMax, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultUncSingle(n, dArray, minMax, nArray);
        }
    }

    default public double mvMultUncSingle(int n, double[] dArray, MinMax minMax, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl = true;
        boolean bl2 = minMax.isMin();
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultUncSingle(n, i, dArray, minMax);
            if (bl || bl2 && d2 < d || !bl2 && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl = false;
        }
        if (nArray != null && !bl) {
            if (bl2) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultUncSingle(int n, int n2, double[] dArray, MinMax minMax) {
        DoubleIntervalDistribution doubleIntervalDistribution = IntervalUtils.extractDoubleIntervalDistribution(this.getTransitionsIterator(n, n2), this.getNumTransitions(n, n2));
        return IDTMC.mvMultUncSingle(doubleIntervalDistribution, dArray, minMax);
    }

    default public void mvMultRewUnc(double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, double[] dArray2, BitSet bitSet, boolean bl, int[] nArray) {
        this.mvMultRewUnc(dArray, mDPRewards, minMax, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator(), nArray);
    }

    default public void mvMultRewUnc(double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, double[] dArray2, PrimitiveIterator.OfInt ofInt, int[] nArray) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewUncSingle(n, dArray, mDPRewards, minMax, nArray);
        }
    }

    default public double mvMultRewUncSingle(int n, double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, int[] nArray) {
        int n2 = -1;
        double d = 0.0;
        boolean bl = true;
        boolean bl2 = minMax.isMin();
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            double d2 = this.mvMultRewUncSingle(n, i, dArray, mDPRewards, minMax);
            if (bl || bl2 && d2 < d || !bl2 && d2 > d) {
                d = d2;
                if (nArray != null) {
                    n2 = i;
                }
            }
            bl = false;
        }
        if (nArray != null && !bl) {
            if (bl2) {
                nArray[n] = n2;
            } else if (nArray[n] == -1 || d > dArray[n]) {
                nArray[n] = n2;
            }
        }
        return d;
    }

    default public double mvMultRewUncSingle(int n, int n2, double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax) {
        double d = mDPRewards.getStateReward(n);
        d += mDPRewards.getTransitionReward(n, n2).doubleValue();
        return d += this.mvMultUncSingle(n, n2, dArray, minMax);
    }

    default public double mvMultUncGS(double[] dArray, MinMax minMax, PrimitiveIterator.OfInt ofInt, boolean bl, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultUncSingle(n, dArray, minMax, nArray);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public double mvMultRewUncGS(double[] dArray, MDPRewards<Double> mDPRewards, MinMax minMax, PrimitiveIterator.OfInt ofInt, boolean bl, int[] nArray) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultRewUncSingle(n, dArray, mDPRewards, minMax, nArray);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }
}

