/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import common.IterableStateSet;
import explicit.DTMC;
import explicit.DoubleIntervalDistribution;
import explicit.IntervalUtils;
import explicit.MinMax;
import explicit.rewards.MCRewards;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import parser.State;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismException;

public interface IDTMC<Value>
extends DTMC<Interval<Value>> {
    @Override
    default public ModelType getModelType() {
        return ModelType.IDTMC;
    }

    default public void checkLowerBoundsArePositive() throws PrismException {
        Evaluator<Interval> evaluator = this.getEvaluator();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Iterator iterator = this.getTransitionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (evaluator.gt((Interval)entry.getValue(), (Interval)evaluator.zero())) continue;
                List<State> list = this.getStatesList();
                String string = list == null ? "" + i : list.get(i).toString();
                throw new PrismException("Transition probability has lower bound of 0 in state " + string);
            }
        }
    }

    default public void mvMultUnc(double[] dArray, MinMax minMax, double[] dArray2, BitSet bitSet, boolean bl) {
        this.mvMultUnc(dArray, minMax, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator());
    }

    default public void mvMultUnc(double[] dArray, MinMax minMax, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultUncSingle(n, dArray, minMax);
        }
    }

    default public double mvMultUncSingle(int n, double[] dArray, MinMax minMax) {
        DoubleIntervalDistribution doubleIntervalDistribution = IntervalUtils.extractDoubleIntervalDistribution(this.getTransitionsIterator(n), this.getNumTransitions(n));
        return IDTMC.mvMultUncSingle(doubleIntervalDistribution, dArray, minMax);
    }

    default public void mvMultRewUnc(double[] dArray, MCRewards<Double> mCRewards, MinMax minMax, double[] dArray2, BitSet bitSet, boolean bl) {
        this.mvMultRewUnc(dArray, mCRewards, minMax, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator());
    }

    default public void mvMultRewUnc(double[] dArray, MCRewards<Double> mCRewards, MinMax minMax, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewUncSingle(n, dArray, mCRewards, minMax);
        }
    }

    default public double mvMultRewUncSingle(int n, double[] dArray, MCRewards<Double> mCRewards, MinMax minMax) {
        double d = mCRewards.getStateReward(n);
        return d += this.mvMultUncSingle(n, dArray, minMax);
    }

    default public double mvMultUncGS(double[] dArray, MinMax minMax, PrimitiveIterator.OfInt ofInt, boolean bl) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultUncSingle(n, dArray, minMax);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public double mvMultRewUncGS(double[] dArray, MCRewards<Double> mCRewards, MinMax minMax, PrimitiveIterator.OfInt ofInt, boolean bl) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultRewUncSingle(n, dArray, mCRewards, minMax);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    public static double mvMultUncSingle(DoubleIntervalDistribution doubleIntervalDistribution, double[] dArray, MinMax minMax) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < doubleIntervalDistribution.size; ++i) {
            arrayList.add(i);
        }
        if (minMax.isMaxUnc()) {
            Collections.sort(arrayList, (n, n2) -> -Double.compare(dArray[doubleIntervalDistribution.index[n]], dArray[doubleIntervalDistribution.index[n2]]));
        } else {
            Collections.sort(arrayList, (n, n2) -> Double.compare(dArray[doubleIntervalDistribution.index[n]], dArray[doubleIntervalDistribution.index[n2]]));
        }
        double d = 0.0;
        double d2 = 1.0;
        for (n3 = 0; n3 < doubleIntervalDistribution.size; ++n3) {
            d += dArray[doubleIntervalDistribution.index[n3]] * doubleIntervalDistribution.lower[n3];
            d2 -= doubleIntervalDistribution.lower[n3];
        }
        for (n3 = 0; n3 < doubleIntervalDistribution.size; ++n3) {
            int n4 = (Integer)arrayList.get(n3);
            double d3 = doubleIntervalDistribution.upper[n4] - doubleIntervalDistribution.lower[n4];
            if (d3 < d2) {
                d += d3 * dArray[doubleIntervalDistribution.index[n4]];
                d2 -= d3;
                continue;
            }
            d += d2 * dArray[doubleIntervalDistribution.index[n4]];
            break;
        }
        return d;
    }
}

