/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.CTMCSimple;
import explicit.DTMCSimple;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.StateModelChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import parser.State;
import prism.ModelInfo;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class ExplicitFiles2Model
extends PrismComponent {
    private boolean fixdl;

    public ExplicitFiles2Model(PrismComponent prismComponent) {
        super(prismComponent);
        if (this.settings != null) {
            this.setFixDeadlocks(this.settings.getBoolean("prism.fixDeadlocks"));
        }
    }

    public boolean getFixDeadlocks() {
        return this.fixdl;
    }

    public void setFixDeadlocks(boolean bl) {
        this.fixdl = bl;
    }

    public Model<?> build(File file, File file2, File file3, ModelInfo modelInfo, int n) throws PrismException {
        Object object;
        Object object2;
        ModelExplicit modelExplicit = null;
        switch (modelInfo.getModelType()) {
            case DTMC: {
                object2 = new DTMCSimple();
                ((DTMCSimple)object2).buildFromPrismExplicit(file2.getAbsolutePath());
                modelExplicit = object2;
                break;
            }
            case CTMC: {
                CTMCSimple cTMCSimple = new CTMCSimple();
                cTMCSimple.buildFromPrismExplicit(file2.getAbsolutePath());
                modelExplicit = cTMCSimple;
                break;
            }
            case MDP: {
                object = new MDPSimple();
                ((MDPSimple)object).buildFromPrismExplicit(file2.getAbsolutePath());
                modelExplicit = object;
                break;
            }
            case IDTMC: {
                IDTMCSimple iDTMCSimple = new IDTMCSimple();
                iDTMCSimple.buildFromPrismExplicit(file2.getAbsolutePath());
                modelExplicit = iDTMCSimple;
                break;
            }
            case IMDP: {
                IMDPSimple iMDPSimple = new IMDPSimple();
                iMDPSimple.buildFromPrismExplicit(file2.getAbsolutePath());
                modelExplicit = iMDPSimple;
                break;
            }
            case CTMDP: 
            case LTS: 
            case PTA: 
            case SMG: 
            case STPG: {
                throw new PrismNotSupportedException("Currently, importing " + modelInfo.getModelType() + " is not supported");
            }
        }
        if (modelExplicit == null) {
            throw new PrismException("Could not import " + modelInfo.getModelType());
        }
        if (modelExplicit.getNumStates() == 0) {
            throw new PrismNotSupportedException("Imported model has no states, not supported");
        }
        if (file3 != null) {
            this.loadLabels(modelExplicit, file3);
        } else {
            modelExplicit.addInitialState(0);
        }
        if (!modelExplicit.getInitialStates().iterator().hasNext()) {
            throw new PrismException("Imported model has no initial states");
        }
        modelExplicit.findDeadlocks(this.fixdl);
        if (file != null) {
            this.loadStates(modelExplicit, file, modelInfo);
        } else {
            object2 = new ArrayList(modelExplicit.getNumStates());
            for (int i = 0; i < modelExplicit.getNumStates(); ++i) {
                object = new State(1);
                ((State)object).setValue(0, i);
                object2.add(object);
            }
            modelExplicit.setStatesList((List<State>)object2);
        }
        return modelExplicit;
    }

    private void loadLabels(ModelExplicit<?> modelExplicit, File file) throws PrismException {
        Map<String, BitSet> map = StateModelChecker.loadLabelsFile(file.getAbsolutePath());
        for (Map.Entry<String, BitSet> entry : map.entrySet()) {
            if (entry.getKey().equals("init")) {
                FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(entry.getValue(), modelExplicit.getNumStates()).iterator();
                while (ofInt.hasNext()) {
                    int n = (Integer)ofInt.next();
                    modelExplicit.addInitialState(n);
                }
                continue;
            }
            if (entry.getKey().equals("deadlock")) continue;
            modelExplicit.addLabel(entry.getKey(), entry.getValue());
        }
    }

    private void loadStates(ModelExplicit<?> modelExplicit, File file, ModelInfo modelInfo) throws PrismException {
        int n = modelExplicit.getNumStates();
        ArrayList<State> arrayList = new ArrayList<State>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
        int n2 = 0;
        int n3 = modelInfo.getNumVars();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            bufferedReader.readLine();
            n2 = 1;
            String string = bufferedReader.readLine();
            ++n2;
            while (string != null) {
                if ((string = string.trim()).length() > 0) {
                    String[] stringArray = string.split(":");
                    int n4 = Integer.parseInt(stringArray[0]);
                    stringArray = stringArray[1].substring(stringArray[1].indexOf(40) + 1, stringArray[1].indexOf(41)).split(",");
                    State state = new State(n3);
                    if (stringArray.length != n3) {
                        throw new PrismException("(wrong number of variable values) ");
                    }
                    for (int i = 0; i < n3; ++i) {
                        if (stringArray[i].equals("true")) {
                            state.setValue(i, true);
                            continue;
                        }
                        if (stringArray[i].equals("false")) {
                            state.setValue(i, false);
                            continue;
                        }
                        state.setValue(i, Integer.parseInt(stringArray[i]));
                    }
                    if (arrayList.get(n4) != null) {
                        throw new PrismException("(duplicated state) ");
                    }
                    arrayList.set(n4, state);
                }
                string = bufferedReader.readLine();
                ++n2;
            }
            modelExplicit.setStatesList(arrayList);
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + file + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected " + prismException.getMessage() + "at line " + n2 + " of states file \"" + file + "\"");
        }
    }
}

