/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Distribution;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import simulator.RandomNumberGenerator;

public class DistributionOver<Value, T>
implements Iterable<Map.Entry<T, Value>> {
    private Distribution<Value> distr;
    private Function<Integer, T> objects;

    public static <Value, T> DistributionOver<Value, T> create(Distribution<Value> distribution, Function<Integer, T> function) {
        DistributionOver<Value, T> distributionOver = new DistributionOver<Value, T>();
        distributionOver.distr = distribution;
        distributionOver.objects = function;
        return distributionOver;
    }

    public Value getProbability(T t) {
        for (Map.Entry entry : this.distr) {
            T t2 = this.objects.apply((Integer)entry.getKey());
            if (!Objects.equals(t2, t)) continue;
            return (Value)entry.getValue();
        }
        return this.distr.getEvaluator().zero();
    }

    @Override
    public Iterator<Map.Entry<T, Value>> iterator() {
        return new Iterator<Map.Entry<T, Value>>(){
            Iterator<Map.Entry<Integer, Value>> iter;
            {
                this.iter = DistributionOver.this.distr.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<T, Value> next() {
                Map.Entry entry = this.iter.next();
                return new AbstractMap.SimpleImmutableEntry(DistributionOver.this.objects.apply(entry.getKey()), entry.getValue());
            }
        };
    }

    public T sample() {
        int n = this.distr.sample();
        return n == -1 ? null : (T)this.objects.apply(n);
    }

    public T sample(RandomNumberGenerator randomNumberGenerator) {
        int n = this.distr.sample(randomNumberGenerator);
        return n == -1 ? null : (T)this.objects.apply(n);
    }
}

