/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.iterable.FunctionalIterable;
import common.iterable.FunctionalIterator;
import common.iterable.Reducible;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.State;
import prism.Evaluator;
import prism.PrismException;
import simulator.RandomNumberGenerator;

public class Distribution<Value>
implements FunctionalIterable<Map.Entry<Integer, Value>> {
    protected final HashMap<Integer, Value> map;
    protected final Evaluator<Value> eval;

    @Deprecated
    public Distribution() {
        this(Evaluator.forDouble());
    }

    public Distribution(Evaluator<Value> evaluator) {
        this.eval = evaluator;
        this.map = new HashMap();
    }

    public Distribution(Iterator<Map.Entry<Integer, Value>> iterator, Evaluator<Value> evaluator) {
        this(evaluator);
        iterator.forEachRemaining(entry -> this.add((Integer)entry.getKey(), entry.getValue()));
    }

    public Distribution(Distribution<Value> distribution) {
        this(distribution.getEvaluator());
        distribution.forEach((? super E entry) -> this.map.put((Integer)entry.getKey(), entry.getValue()));
    }

    public Distribution(Distribution<Value> distribution, int[] nArray) {
        this(distribution.getEvaluator());
        distribution.forEach((? super E entry) -> this.add(nArray[(Integer)entry.getKey()], entry.getValue()));
    }

    public static Distribution<Double> ofDouble() {
        return new Distribution<Double>(Evaluator.forDouble());
    }

    public static Distribution<Double> ofDouble(Iterator<Map.Entry<Integer, Double>> iterator) {
        return new Distribution<Double>(iterator, Evaluator.forDouble());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean add(int n, Value Value2) {
        if (this.eval.isZero(Value2)) {
            return true;
        }
        Object object = this.map.merge(n, Value2, this.eval::add);
        return object != Value2;
    }

    public void set(int n, Value Value2) {
        if (this.eval.isZero(Value2)) {
            this.map.remove(n);
        } else {
            this.map.put(n, Value2);
        }
    }

    public Value get(int n) {
        return this.map.getOrDefault(n, this.eval.zero());
    }

    public boolean contains(int n) {
        return this.map.containsKey(n);
    }

    public boolean isSubsetOf(BitSet bitSet) {
        return Reducible.extend(this.getSupport()).allMatch(bitSet::get);
    }

    public boolean containsOneOf(BitSet bitSet) {
        return Reducible.extend(this.getSupport()).anyMatch(bitSet::get);
    }

    public Set<Integer> getSupport() {
        return this.map.keySet();
    }

    @Override
    public FunctionalIterator<Map.Entry<Integer, Value>> iterator() {
        return Reducible.extend(this.map.entrySet().iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public int sample() {
        return this.getValueByProbabilitySum(Math.random());
    }

    public int sample(RandomNumberGenerator randomNumberGenerator) {
        return this.getValueByProbabilitySum(randomNumberGenerator.randomUnifDouble());
    }

    private int getValueByProbabilitySum(double d) {
        if (this.isEmpty()) {
            return -1;
        }
        Iterator iterator = this.iterator();
        Map.Entry entry = null;
        Value Value2 = this.eval.zero();
        while (d >= this.eval.toDouble(Value2) && iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            Value2 = this.eval.add(Value2, entry.getValue());
        }
        return (Integer)entry.getKey();
    }

    public Value sum() {
        return (Value)this.map(Map.Entry::getValue).reduce(this.eval.zero(), this.eval::add);
    }

    public Value sumAllBut(int n) {
        return (Value)this.filter((T entry) -> (Integer)entry.getKey() != n).map(Map.Entry::getValue).reduce(this.eval.zero(), this.eval::add);
    }

    public Distribution<Value> map(int[] nArray) {
        return new Distribution<Value>(this, nArray);
    }

    public Evaluator<Value> getEvaluator() {
        return this.eval;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Distribution)) {
            return false;
        }
        return this.map.equals(((Distribution)object).map);
    }

    public int hashCode() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toStringCSV() {
        Object object = "Value";
        for (Map.Entry entry : this) {
            object = (String)object + ", " + entry.getKey();
        }
        object = (String)object + "\nProbability";
        for (Map.Entry entry : this) {
            object = (String)object + ", " + entry.getValue();
        }
        object = (String)object + "\n";
        return object;
    }

    public Integer sampleFromDistribution() throws PrismException {
        double d = Math.random();
        for (Map.Entry entry : this) {
            if (!((d -= this.getEvaluator().toDouble(entry.getValue())) <= 1.0E-4)) continue;
            return (Integer)entry.getKey();
        }
        throw new PrismException("Distribution invalid.");
    }

    public Distribution(List<Distribution<Value>> list, List<State> list2, State state, Value Value2, int n, int n2) {
        this(list.get(0).getEvaluator());
        super.productDistribution(list, list2, state, Value2, n, n2, this);
    }

    private void productDistribution(List<Distribution<Value>> list, List<State> list2, State state, Value Value2, int n, int n2, Distribution<Value> distribution) {
        if (n == n2) {
            for (State state2 : list2) {
                if (state2.compareTo(state) != 0) continue;
                int n3 = list2.indexOf(state);
                distribution.add(n3, Value2);
                break;
            }
        } else if (n < list.size()) {
            if (list.get(n) == null) {
                State state3 = new State(state);
                this.productDistribution(list, list2, state3, Value2, n + 1, n2, distribution);
            } else {
                for (Map.Entry entry : list.get(n)) {
                    State state4 = new State(state);
                    state4.varValues[n] = entry.getKey();
                    this.productDistribution(list, list2, state4, this.getEvaluator().multiply(Value2, entry.getValue()), n + 1, n2, distribution);
                }
            }
        } else {
            State state5 = new State(state);
            this.productDistribution(list, list2, state5, Value2, n2, n2, distribution);
        }
    }
}

