/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMCSimple;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.StateValues;
import explicit.SuccessorsIterator;
import explicit.rewards.MCRewards;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import parser.Values;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class DTMCUniformisedSimple<Value>
extends DTMCExplicit<Value> {
    protected CTMCSimple<Value> ctmc;
    protected Value q;
    protected int numExtraTransitions;

    public DTMCUniformisedSimple(CTMCSimple<Value> cTMCSimple, Value Value2) {
        this.ctmc = cTMCSimple;
        this.numStates = cTMCSimple.getNumStates();
        this.q = Value2;
        this.numExtraTransitions = 0;
        for (int i = 0; i < this.numStates; ++i) {
            if (cTMCSimple.getTransitions(i).contains(i) || this.getEvaluator().geq(cTMCSimple.getTransitions(i).sumAllBut(i), Value2)) continue;
            ++this.numExtraTransitions;
        }
    }

    public DTMCUniformisedSimple(CTMCSimple<Value> cTMCSimple) {
        this(cTMCSimple, cTMCSimple.getDefaultUniformisationRate());
    }

    @Override
    public void buildFromPrismExplicit(String string) throws PrismException {
        throw new PrismNotSupportedException("Not supported");
    }

    @Override
    public int getNumStates() {
        return this.ctmc.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.ctmc.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.ctmc.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.ctmc.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.ctmc.isInitialState(n);
    }

    @Override
    public int getNumDeadlockStates() {
        return this.ctmc.getNumDeadlockStates();
    }

    @Override
    public Iterable<Integer> getDeadlockStates() {
        return this.ctmc.getDeadlockStates();
    }

    @Override
    public StateValues getDeadlockStatesList() {
        return this.ctmc.getDeadlockStatesList();
    }

    @Override
    public int getFirstDeadlockState() {
        return this.ctmc.getFirstDeadlockState();
    }

    @Override
    public boolean isDeadlockState(int n) {
        return this.ctmc.isDeadlockState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.ctmc.getStatesList();
    }

    @Override
    public Values getConstantValues() {
        return this.ctmc.getConstantValues();
    }

    @Override
    public int getNumTransitions() {
        return this.ctmc.getNumTransitions() + this.numExtraTransitions;
    }

    @Override
    public int getNumTransitions(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        throw new Error("Not yet supported");
    }

    public int getNumChoices(int n) {
        return 1;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
    }

    @Override
    public void checkForDeadlocks() throws PrismException {
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
    }

    @Override
    public String infoString() {
        Object object = "";
        object = (String)object + this.getNumStates() + " states (" + this.getNumInitialStates() + " initial)";
        object = (String)object + ", " + this.getNumTransitions() + " transitions (incl. " + this.numExtraTransitions + " self-loops)";
        return object;
    }

    @Override
    public String infoStringTable() {
        Object object = "";
        object = (String)object + "States:      " + this.getNumStates() + " (" + this.getNumInitialStates() + " initial)\n";
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        return object;
    }

    @Override
    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int n) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public double mvMultSingle(int n, double[] dArray) {
        double d = this.getEvaluator().toDouble(this.q);
        Distribution distribution = this.ctmc.getTransitions(n);
        double d2 = 0.0;
        double d3 = 0.0;
        for (Map.Entry entry : distribution) {
            int n2 = (Integer)entry.getKey();
            double d4 = this.getEvaluator().toDouble(entry.getValue());
            if (n2 == n) continue;
            d2 += d4;
            d3 += d4 / d * dArray[n2];
        }
        if (d2 < d) {
            d3 += (1.0 - d2 / d) * dArray[n];
        }
        return d3;
    }

    @Override
    public double mvMultJacSingle(int n, double[] dArray) {
        double d = this.getEvaluator().toDouble(this.q);
        Distribution distribution = this.ctmc.getTransitions(n);
        double d2 = 0.0;
        double d3 = 0.0;
        for (Map.Entry entry : distribution) {
            int n2 = (Integer)entry.getKey();
            double d4 = (Double)entry.getValue();
            if (n2 == n) continue;
            d2 += d4;
            d3 += d4 / d * dArray[n2];
        }
        return d3 /= d2 / d;
    }

    @Override
    public double mvMultRewSingle(int n, double[] dArray, MCRewards<Double> mCRewards) {
        throw new Error("Not yet supported");
    }

    @Override
    public void vmMult(double[] dArray, double[] dArray2) {
        double d = this.getEvaluator().toDouble(this.q);
        Arrays.fill(dArray2, 0.0);
        for (int i = 0; i < this.numStates; ++i) {
            double d2 = 0.0;
            Iterator iterator = this.ctmc.getTransitionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int n = entry.getKey();
                double d3 = this.getEvaluator().toDouble(entry.getValue()) / d;
                if (n == i) continue;
                d2 += d3;
                int n2 = n;
                dArray2[n2] = dArray2[n2] + d3 * dArray[i];
            }
            int n = i;
            dArray2[n] = dArray2[n] + (1.0 - d2) * dArray[i];
        }
    }

    public String toString() {
        Object object = "";
        object = (String)object + "ctmc: " + this.ctmc;
        object = ", q: " + this.q;
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCUniformisedSimple)) {
            return false;
        }
        DTMCUniformisedSimple dTMCUniformisedSimple = (DTMCUniformisedSimple)object;
        if (!this.ctmc.equals(dTMCUniformisedSimple.ctmc)) {
            return false;
        }
        if (this.q != dTMCUniformisedSimple.q) {
            return false;
        }
        return this.numExtraTransitions == dTMCUniformisedSimple.numExtraTransitions;
    }
}

