/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import explicit.CSGSimple;
import explicit.CTMCSimple;
import explicit.CTMDPSimple;
import explicit.DTMCSimple;
import explicit.DTMCSparse;
import explicit.Distribution;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.IndexedSet;
import explicit.LTSSimple;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.MDPSparse;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.NondetModel;
import explicit.POMDPSimple;
import explicit.SMGSimple;
import explicit.STPGSimple;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.ModulesFile;
import prism.ModelGenerator;
import prism.ModelType;
import prism.PlayerInfoOwner;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.PrismPrintStreamLog;
import prism.ProgressDisplay;
import prism.UndefinedConstants;
import simulator.ModulesFileModelGenerator;

public class ConstructModel
extends PrismComponent {
    protected boolean findDeadlocks = true;
    protected boolean fixDeadlocks = true;
    protected boolean sortStates = true;
    protected boolean buildSparse = true;
    protected boolean distinguishActions = true;
    protected boolean attachLabels = true;
    protected List<State> statesList;

    public ConstructModel(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public List<State> getStatesList() {
        return this.statesList;
    }

    public void setFixDeadlocks(boolean bl) {
        this.fixDeadlocks = bl;
    }

    public void setSortStates(boolean bl) {
        this.sortStates = bl;
    }

    public void setBuildSparse(boolean bl) {
        this.buildSparse = bl;
    }

    public void setDistinguishActions(boolean bl) {
        this.distinguishActions = bl;
    }

    public void setAttachLabels(boolean bl) {
        this.attachLabels = bl;
    }

    public List<State> computeReachableStates(ModelGenerator<?> modelGenerator) throws PrismException {
        this.constructModel(modelGenerator, true);
        return this.getStatesList();
    }

    public <Value> Model<Value> constructModel(ModelGenerator<Value> modelGenerator) throws PrismException {
        return this.constructModel(modelGenerator, false);
    }

    /*
     * WARNING - void declaration
     */
    public <Value> Model<Value> constructModel(ModelGenerator<Value> modelGenerator, boolean bl) throws PrismException {
        void var35_50;
        int n;
        ModelExplicit modelExplicit = null;
        DTMCSimple<Double> dTMCSimple = null;
        CTMCSimple<Value> cTMCSimple = null;
        MDPSimple<Double> mDPSimple = null;
        POMDPSimple<Value> pOMDPSimple = null;
        CTMDPSimple<Value> cTMDPSimple = null;
        STPGSimple<Value> sTPGSimple = null;
        CSGSimple<Value> cSGSimple = null;
        SMGSimple<Value> sMGSimple = null;
        IDTMCSimple<Interval<Interval<Interval<Interval<Value>>>>> iDTMCSimple = null;
        IMDPSimple<Interval<Interval<Interval<Interval<Value>>>>> iMDPSimple = null;
        LTSSimple lTSSimple = null;
        Distribution<Value> distribution = null;
        Distribution<Interval<Interval<Value>>> distribution2 = null;
        ArrayList<String> arrayList = null;
        ModelType modelType = modelGenerator.getModelType();
        VarList varList = modelGenerator.createVarList();
        if (modelGenerator.containsUnboundedVariables()) {
            this.mainLog.printWarning("Model contains one or more unbounded variables: model construction may not terminate");
        }
        this.mainLog.print("\nComputing reachable states...");
        this.mainLog.flush();
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.start();
        long l = System.currentTimeMillis();
        if (modelType.multiplePlayers()) {
            arrayList = new ArrayList<String>();
            for (n = 0; n < modelGenerator.getNumPlayers(); ++n) {
                String string = modelGenerator.getPlayerName(n);
                if (!"".equals(string) && arrayList.contains(string)) {
                    throw new PrismException("Duplicate player name \"" + (String)string + "\"");
                }
                arrayList.add(string);
            }
            if (modelType == ModelType.STPG && arrayList.size() != 2) {
                throw new PrismException("An STPG should define exactly 2 players");
            }
        }
        if (modelType.concurrent() && modelGenerator.getActions() == null) {
            throw new PrismException("Model generator must implement getActions() for concurrent games");
        }
        if (!bl) {
            switch (modelType) {
                case DTMC: {
                    dTMCSimple = new DTMCSimple<Double>();
                    modelExplicit = dTMCSimple;
                    break;
                }
                case CTMC: {
                    cTMCSimple = new CTMCSimple<Value>();
                    modelExplicit = cTMCSimple;
                    break;
                }
                case CSG: {
                    cSGSimple = new CSGSimple<Value>();
                    modelExplicit = cSGSimple;
                    cSGSimple.setActions(modelGenerator.getActions());
                    break;
                }
                case MDP: {
                    mDPSimple = new MDPSimple<Double>();
                    modelExplicit = mDPSimple;
                    break;
                }
                case POMDP: {
                    pOMDPSimple = new POMDPSimple<Value>();
                    modelExplicit = pOMDPSimple;
                    break;
                }
                case CTMDP: {
                    cTMDPSimple = new CTMDPSimple<Value>();
                    modelExplicit = cTMDPSimple;
                    break;
                }
                case IDTMC: {
                    iDTMCSimple = new IDTMCSimple<Interval<Interval<Interval<Interval<Value>>>>>();
                    modelExplicit = iDTMCSimple;
                    break;
                }
                case IMDP: {
                    iMDPSimple = new IMDPSimple<Interval<Interval<Interval<Interval<Value>>>>>();
                    modelExplicit = iMDPSimple;
                    break;
                }
                case LTS: {
                    lTSSimple = new LTSSimple();
                    modelExplicit = lTSSimple;
                    break;
                }
                case STPG: {
                    sTPGSimple = new STPGSimple<Value>();
                    modelExplicit = sTPGSimple;
                    break;
                }
                case SMG: {
                    sMGSimple = new SMGSimple<Value>();
                    modelExplicit = sMGSimple;
                    break;
                }
                case PTA: 
                case POPTA: {
                    throw new PrismNotSupportedException("Model construction not supported for " + modelType + "s");
                }
            }
            if (modelExplicit instanceof PlayerInfoOwner) {
                ((PlayerInfoOwner)((Object)modelExplicit)).setPlayerNames(arrayList);
            }
            if (!modelType.uncertain()) {
                ((ModelExplicit)modelExplicit).setEvaluator(modelGenerator.getEvaluator());
            } else {
                ((ModelExplicit)modelExplicit).setEvaluator(modelGenerator.getIntervalEvaluator());
            }
            ((ModelExplicit)modelExplicit).setVarList(varList);
        }
        IndexedSet<State> indexedSet = new IndexedSet<State>(true);
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State object2 : modelGenerator.getInitialStates()) {
            linkedList.add(object2);
            indexedSet.add(object2);
            if (bl) continue;
            modelExplicit.addState();
            modelExplicit.addInitialState(modelExplicit.getNumStates() - 1);
        }
        int n2 = -1;
        while (!linkedList.isEmpty()) {
            State state = (State)linkedList.removeFirst();
            ++n2;
            modelGenerator.exploreState(state);
            int n3 = modelGenerator.getNumChoices();
            if (modelType.multiplePlayers() && !modelType.concurrent()) {
                int n4 = modelGenerator.getPlayerOwningState();
                if (modelType == ModelType.STPG) {
                    sTPGSimple.setPlayer(n2, n4);
                } else if (modelType == ModelType.SMG) {
                    sMGSimple.setPlayer(n2, n4);
                }
            }
            for (n = 0; n < n3; ++n) {
                if (modelType.partiallyObservable() && ((NondetModel)((Object)modelExplicit)).getChoiceByAction(n2, modelGenerator.getChoiceAction(n)) != -1) {
                    String string = modelGenerator.getChoiceAction(n) == null ? "" : modelGenerator.getChoiceAction(n).toString();
                    String string3 = modelType + " is not allowed duplicate action";
                    string3 = string3 + " (\"" + string + "\") in state " + state.toString(modelGenerator);
                    throw new PrismException(string3);
                }
                if (!bl && modelType.nondeterministic()) {
                    if (!modelType.uncertain()) {
                        distribution = new Distribution<Value>(modelGenerator.getEvaluator());
                    } else {
                        distribution2 = new Distribution<Interval<Interval<Value>>>(modelGenerator.getIntervalEvaluator());
                    }
                }
                int n5 = modelGenerator.getNumTransitions(n);
                block40: for (int i = 0; i < n5; ++i) {
                    State state2 = modelGenerator.computeTransitionTarget(n, i);
                    if (indexedSet.add(state2)) {
                        linkedList.add(state2);
                        if (!bl) {
                            modelExplicit.addState();
                        }
                    }
                    int n6 = indexedSet.getIndexOfLastAdd();
                    if (bl) continue;
                    switch (modelType) {
                        case DTMC: {
                            dTMCSimple.addToProbability(n2, n6, (Double)modelGenerator.getTransitionProbability(n, i));
                            continue block40;
                        }
                        case CTMC: {
                            cTMCSimple.addToProbability(n2, n6, modelGenerator.getTransitionProbability(n, i));
                            continue block40;
                        }
                        case IDTMC: {
                            iDTMCSimple.addToProbability(n2, n6, modelGenerator.getTransitionProbabilityInterval(n, i));
                            continue block40;
                        }
                        case CSG: 
                        case MDP: 
                        case POMDP: 
                        case CTMDP: 
                        case STPG: 
                        case SMG: {
                            distribution.add(n6, modelGenerator.getTransitionProbability(n, i));
                            continue block40;
                        }
                        case IMDP: {
                            distribution2.add(n6, modelGenerator.getTransitionProbabilityInterval(n, i));
                            continue block40;
                        }
                        case LTS: {
                            if (this.distinguishActions) {
                                lTSSimple.addActionLabelledTransition(n2, n6, modelGenerator.getChoiceAction(n));
                                continue block40;
                            }
                            lTSSimple.addTransition(n2, n6);
                            continue block40;
                        }
                        case PTA: 
                        case POPTA: {
                            throw new PrismNotSupportedException("Model construction not supported for " + modelType + "s");
                        }
                    }
                }
                int n7 = -1;
                if (!bl) {
                    if (modelType == ModelType.MDP) {
                        if (this.distinguishActions) {
                            mDPSimple.addActionLabelledChoice(n2, distribution, modelGenerator.getChoiceAction(n));
                        } else {
                            mDPSimple.addChoice(n2, distribution);
                        }
                    } else if (modelType == ModelType.POMDP) {
                        if (this.distinguishActions) {
                            pOMDPSimple.addActionLabelledChoice(n2, distribution, modelGenerator.getChoiceAction(n));
                        } else {
                            pOMDPSimple.addChoice(n2, distribution);
                        }
                    } else if (modelType == ModelType.CTMDP) {
                        if (this.distinguishActions) {
                            cTMDPSimple.addActionLabelledChoice(n2, distribution, modelGenerator.getChoiceAction(n));
                        } else {
                            cTMDPSimple.addChoice(n2, distribution);
                        }
                    } else if (modelType == ModelType.STPG) {
                        if (this.distinguishActions) {
                            sTPGSimple.addActionLabelledChoice(n2, distribution, modelGenerator.getTransitionAction(n, 0));
                        } else {
                            sTPGSimple.addChoice(n2, distribution);
                        }
                    } else if (modelType == ModelType.CSG) {
                        cSGSimple.addActionLabelledChoice(n2, distribution, modelGenerator.getTransitionIndexes(n));
                    } else if (modelType == ModelType.SMG) {
                        if (this.distinguishActions) {
                            sMGSimple.addActionLabelledChoice(n2, distribution, modelGenerator.getTransitionAction(n, 0));
                        } else {
                            sMGSimple.addChoice(n2, distribution);
                        }
                    } else if (modelType == ModelType.IMDP) {
                        n7 = this.distinguishActions ? iMDPSimple.addActionLabelledChoice(n2, distribution2, modelGenerator.getChoiceAction(n)) : iMDPSimple.addChoice(n2, distribution2);
                    }
                }
                if (modelType == ModelType.IDTMC) {
                    iDTMCSimple.delimit(n2, modelGenerator.getEvaluator());
                    continue;
                }
                if (modelType != ModelType.IMDP) continue;
                iMDPSimple.delimit(n2, n7, modelGenerator.getEvaluator());
            }
            if (!bl && modelType == ModelType.POMDP) {
                this.setStateObservation(modelGenerator, (POMDPSimple)modelExplicit, n2, state);
            }
            progressDisplay.updateIfReady(n2 + 1);
        }
        progressDisplay.update(n2 + 1);
        progressDisplay.end(" states");
        this.mainLog.print("Reachable states exploration" + (bl ? "" : " and model construction"));
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        if (!bl && this.findDeadlocks) {
            if (modelType != ModelType.CSG) {
                modelExplicit.findDeadlocks(this.fixDeadlocks);
            } else {
                modelExplicit.findDeadlocks(false);
                if (modelExplicit.getNumDeadlockStates() > 0) {
                    for (Integer n7 : modelExplicit.getDeadlockStates()) {
                        cSGSimple.fixDeadlock(n7);
                    }
                }
            }
        }
        int[] nArray = null;
        if (this.sortStates) {
            this.mainLog.println("Sorting reachable states list...");
            nArray = indexedSet.buildSortingPermutation();
            this.statesList = indexedSet.toPermutedArrayList(nArray);
        } else {
            this.statesList = indexedSet.toArrayList();
        }
        indexedSet.clear();
        indexedSet = null;
        Object var35_35 = null;
        if (!bl) {
            void var35_49;
            boolean bl2 = modelExplicit.getEvaluator().one() instanceof Double;
            switch (modelType) {
                case DTMC: {
                    if (this.buildSparse && bl2) {
                        DTMCSparse dTMCSparse = this.sortStates ? new DTMCSparse(dTMCSimple, nArray) : new DTMCSparse(dTMCSimple);
                        break;
                    }
                    DTMCSimple<Double> dTMCSimple2 = this.sortStates ? new DTMCSimple<Double>(dTMCSimple, nArray) : dTMCSimple;
                    break;
                }
                case CTMC: {
                    CTMCSimple<Value> cTMCSimple2 = this.sortStates ? new CTMCSimple<Value>(cTMCSimple, nArray) : cTMCSimple;
                    break;
                }
                case MDP: {
                    if (this.buildSparse && bl2) {
                        MDPSparse mDPSparse = this.sortStates ? new MDPSparse(mDPSimple, true, nArray) : new MDPSparse((MDP<Double>)mDPSimple);
                        break;
                    }
                    MDPSimple<Double> mDPSimple2 = this.sortStates ? new MDPSimple<Double>(mDPSimple, nArray) : mDPSimple;
                    break;
                }
                case POMDP: {
                    POMDPSimple<Value> pOMDPSimple2 = this.sortStates ? new POMDPSimple<Value>(pOMDPSimple, nArray) : pOMDPSimple;
                    break;
                }
                case CTMDP: {
                    CTMDPSimple<Value> cTMDPSimple2 = this.sortStates ? new CTMDPSimple<Value>(cTMDPSimple, nArray) : cTMDPSimple;
                    break;
                }
                case CSG: {
                    CSGSimple<Value> cSGSimple2 = this.sortStates ? new CSGSimple<Value>(cSGSimple, nArray) : cSGSimple;
                    break;
                }
                case STPG: {
                    STPGSimple<Value> sTPGSimple2 = this.sortStates ? new STPGSimple<Value>(sTPGSimple, nArray) : sTPGSimple;
                    break;
                }
                case SMG: {
                    SMGSimple<Value> sMGSimple2 = this.sortStates ? new SMGSimple<Value>(sMGSimple, nArray) : sMGSimple;
                    break;
                }
                case IDTMC: {
                    IDTMCSimple<Interval<Interval<Interval<Interval<Value>>>>> iDTMCSimple2 = this.sortStates ? new IDTMCSimple<Interval<Interval<Interval<Interval<Value>>>>>(iDTMCSimple, nArray) : iDTMCSimple;
                    break;
                }
                case IMDP: {
                    IMDPSimple<Interval<Interval<Interval<Interval<Value>>>>> iMDPSimple2 = this.sortStates ? new IMDPSimple<Interval<Interval<Interval<Interval<Value>>>>>(iMDPSimple, nArray) : iMDPSimple;
                    break;
                }
                case LTS: {
                    LTSSimple lTSSimple2 = this.sortStates ? new LTSSimple(lTSSimple, nArray) : lTSSimple;
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Model construction not supported for " + modelType + "s");
                }
            }
            var35_49.setStatesList(this.statesList);
            var35_49.setConstantValues(new Values(modelGenerator.getConstantValues()));
        }
        if (modelType == ModelType.CSG) {
            cSGSimple.addIdleIndexes();
        }
        nArray = null;
        if (!bl && this.attachLabels) {
            this.attachLabels(modelGenerator, (ModelExplicit<Value>)var35_50);
        }
        return var35_50;
    }

    private <Value> void setStateObservation(ModelGenerator<Value> modelGenerator, POMDPSimple<Value> pOMDPSimple, int n, State state) throws PrismException {
        State state2 = modelGenerator.getObservation(state);
        int n2 = modelGenerator.getNumVars();
        int n3 = n2 - modelGenerator.getNumObservableVars();
        State state3 = new State(n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (modelGenerator.isVarObservable(i)) continue;
            state3.setValue(n4++, state.varValues[i]);
        }
        pOMDPSimple.setObservation(n, state2, state3, modelGenerator.getObservableNames());
    }

    private <Value> void attachLabels(ModelGenerator<Value> modelGenerator, ModelExplicit<Value> modelExplicit) throws PrismException {
        int n;
        List<State> list = modelExplicit.getStatesList();
        int n2 = list.size();
        int n3 = modelGenerator.getNumLabels();
        if (n3 == 0) {
            return;
        }
        BitSet[] bitSetArray = new BitSet[n3];
        for (n = 0; n < n3; ++n) {
            bitSetArray[n] = new BitSet();
        }
        for (n = 0; n < n2; ++n) {
            State state = list.get(n);
            modelGenerator.exploreState(state);
            for (int i = 0; i < n3; ++i) {
                if (!modelGenerator.isLabelTrue(i)) continue;
                bitSetArray[i].set(n);
            }
        }
        for (n = 0; n < n3; ++n) {
            modelExplicit.addLabel(modelGenerator.getLabelName(n), bitSetArray[n]);
        }
    }

    public static void main(String[] stringArray) {
        try {
            PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.out);
            Prism prism = new Prism(prismPrintStreamLog);
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            UndefinedConstants undefinedConstants = new UndefinedConstants(modulesFile, null);
            if (stringArray.length > 2) {
                undefinedConstants.defineUsingConstSwitch(stringArray[2]);
            }
            modulesFile.setSomeUndefinedConstants(undefinedConstants.getMFConstantValues());
            ConstructModel constructModel = new ConstructModel(prism);
            constructModel.setSortStates(true);
            ModulesFileModelGenerator<?> modulesFileModelGenerator = ModulesFileModelGenerator.create(modulesFile, constructModel);
            Model<?> model = constructModel.constructModel(modulesFileModelGenerator);
            model.exportToPrismExplicitTra(stringArray[1]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }
}

