/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.ModelSimple;
import explicit.NondetModel;
import explicit.POMDP;
import explicit.POMDPSimple;
import explicit.SMG;
import explicit.SMGSimple;
import explicit.STPG;
import explicit.STPGSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;
import strat.MDStrategy;
import strat.StrategyExportOptions;

public class ConstructInducedModel {
    private StrategyExportOptions.InducedModelMode mode = StrategyExportOptions.InducedModelMode.RESTRICT;
    private boolean reachOnly = true;

    public ConstructInducedModel setMode(StrategyExportOptions.InducedModelMode inducedModelMode) {
        this.mode = inducedModelMode;
        return this;
    }

    public ConstructInducedModel setReachOnly(boolean bl) {
        this.reachOnly = bl;
        return this;
    }

    public <Value> Model<Value> constructInducedModel(NondetModel<Value> nondetModel, MDStrategy<Value> mDStrategy) throws PrismException {
        ModelType modelType;
        ModelType modelType2;
        block17: {
            block16: {
                modelType2 = nondetModel.getModelType();
                modelType = null;
                if (this.mode != StrategyExportOptions.InducedModelMode.REDUCE) break block16;
                switch (modelType2) {
                    case MDP: 
                    case POMDP: 
                    case STPG: 
                    case SMG: {
                        modelType = ModelType.DTMC;
                        break block17;
                    }
                    case IMDP: {
                        modelType = ModelType.IDTMC;
                        break block17;
                    }
                    default: {
                        throw new PrismNotSupportedException("Induced model construction not supported for " + modelType2 + "s");
                    }
                }
            }
            modelType = modelType2;
        }
        ModelExplicit modelExplicit = null;
        switch (modelType) {
            case DTMC: {
                modelExplicit = new DTMCSimple();
                break;
            }
            case MDP: {
                modelExplicit = new MDPSimple();
                break;
            }
            case POMDP: {
                modelExplicit = new POMDPSimple();
                break;
            }
            case IDTMC: {
                modelExplicit = new IDTMCSimple();
                break;
            }
            case IMDP: {
                modelExplicit = new IMDPSimple();
                break;
            }
            case STPG: {
                modelExplicit = new STPGSimple();
                break;
            }
            case SMG: {
                modelExplicit = new SMGSimple();
                break;
            }
            default: {
                throw new PrismNotSupportedException("Product construction not supported for " + modelType2 + "s");
            }
        }
        ((ModelExplicit)modelExplicit).setEvaluator(nondetModel.getEvaluator());
        ((ModelExplicit)modelExplicit).setVarList(nondetModel.getVarList());
        switch (modelType2) {
            case IMDP: {
                modelType = this.mode == StrategyExportOptions.InducedModelMode.REDUCE ? ModelType.DTMC : ModelType.MDP;
                return this.doConstructInducedModel(ModelType.MDP, modelType, (ModelSimple<Value>)((Object)modelExplicit), nondetModel, mDStrategy);
            }
        }
        return this.doConstructInducedModel(modelType2, modelType, (ModelSimple<Value>)((Object)modelExplicit), nondetModel, mDStrategy);
    }

    public <Value> Model<Value> doConstructInducedModel(ModelType modelType, ModelType modelType2, ModelSimple<Value> modelSimple, NondetModel<Value> nondetModel, MDStrategy<Value> mDStrategy) throws PrismException {
        int n;
        Object object;
        List<State> list = nondetModel.getStatesList();
        if (this.reachOnly && list != null) {
            list = new ArrayList<State>();
        }
        int n2 = nondetModel.getNumStates();
        int[] nArray = new int[n2];
        if (this.reachOnly) {
            int n32;
            Arrays.fill(nArray, -1);
            BitSet bitSet = new BitSet();
            for (int n32 : nondetModel.getInitialStates()) {
                nArray[n32] = 0;
                bitSet.set(n32);
            }
            while (!bitSet.isEmpty()) {
                int n4 = bitSet.nextSetBit(0);
                while (n4 >= 0) {
                    bitSet.set(n4, false);
                    n32 = mDStrategy.getChoiceIndex(n4);
                    if (n32 < 0) {
                        n32 = 0;
                    }
                    object = nondetModel.getSuccessorsIterator(n4, n32);
                    while (object.hasNext()) {
                        int n5 = object.next();
                        if (nArray[n5] != -1) continue;
                        nArray[n5] = 0;
                        bitSet.set(n5);
                    }
                    n4 = bitSet.nextSetBit(n4 + 1);
                }
            }
            n = 0;
            for (n32 = 0; n32 < n2; ++n32) {
                if (nArray[n32] == -1) continue;
                nArray[n32] = n++;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i;
            }
        }
        block26: for (int i = 0; i < n2; ++i) {
            Iterator iterator;
            if (nArray[i] == -1) continue;
            switch (modelType2) {
                case STPG: {
                    ((STPGSimple)modelSimple).addState(((STPG)nondetModel).getPlayer(i));
                    break;
                }
                case SMG: {
                    ((SMGSimple)modelSimple).addState(((SMG)nondetModel).getPlayer(i));
                    break;
                }
                default: {
                    modelSimple.addState();
                }
            }
            if (nondetModel.isInitialState(i)) {
                modelSimple.addInitialState(nArray[i]);
            }
            if (this.reachOnly && list != null) {
                list.add(nondetModel.getStatesList().get(i));
            }
            if ((n = mDStrategy.getChoiceIndex(i)) < 0) {
                n = 0;
            }
            switch (modelType) {
                case MDP: {
                    iterator = ((MDP)nondetModel).getTransitionsIterator(i, n);
                    break;
                }
                case POMDP: {
                    iterator = ((POMDP)nondetModel).getTransitionsIterator(i, n);
                    break;
                }
                case STPG: {
                    iterator = ((STPG)nondetModel).getTransitionsIterator(i, n);
                    break;
                }
                case SMG: {
                    iterator = ((SMG)nondetModel).getTransitionsIterator(i, n);
                    break;
                }
                default: {
                    throw new PrismNotSupportedException("Induced model construction not implemented for " + modelType + "s");
                }
            }
            object = null;
            if (modelType2.nondeterministic()) {
                object = new Distribution(nondetModel.getEvaluator());
            }
            block27: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int n6 = entry.getKey();
                Object Value2 = entry.getValue();
                switch (modelType2) {
                    case DTMC: {
                        ((DTMCSimple)modelSimple).setProbability(nArray[i], nArray[n6], Value2);
                        continue block27;
                    }
                    case MDP: 
                    case POMDP: 
                    case STPG: 
                    case SMG: {
                        ((Distribution)object).set(nArray[n6], Value2);
                        continue block27;
                    }
                }
                throw new PrismNotSupportedException("Induced model construction not implemented for " + modelType + "s");
            }
            switch (modelType2) {
                case MDP: {
                    ((MDPSimple)modelSimple).addActionLabelledChoice(nArray[i], object, ((MDP)nondetModel).getAction(i, n));
                    continue block26;
                }
                case POMDP: {
                    ((POMDPSimple)modelSimple).addActionLabelledChoice(nArray[i], object, ((POMDP)nondetModel).getAction(i, n));
                    continue block26;
                }
                case STPG: {
                    ((STPGSimple)modelSimple).addActionLabelledChoice(nArray[i], object, ((STPG)nondetModel).getAction(i, n));
                    continue block26;
                }
                case SMG: {
                    ((SMGSimple)modelSimple).addActionLabelledChoice(nArray[i], object, ((SMG)nondetModel).getAction(i, n));
                    continue block26;
                }
            }
        }
        modelSimple.findDeadlocks(false);
        if (list != null) {
            modelSimple.setStatesList(list);
        }
        return modelSimple;
    }
}

