/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CSG;
import explicit.Distribution;
import explicit.MDPSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import prism.PlayerInfo;
import prism.PlayerInfoOwner;

public class CSGSimple<Value>
extends MDPSimple<Value>
implements CSG<Value> {
    protected Vector<String> actions;
    protected List<List<int[]>> transIndexes = new ArrayList<List<int[]>>();
    protected BitSet[] indexes;
    protected int[] idles;
    protected PlayerInfo playerInfo;

    public CSGSimple() {
        this.playerInfo = new PlayerInfo();
    }

    public CSGSimple(CSGSimple<Value> cSGSimple, int[] nArray) {
        super(cSGSimple, nArray);
        int n;
        for (n = 0; n < cSGSimple.getNumStates(); ++n) {
            this.transIndexes.add(n, null);
        }
        for (n = 0; n < cSGSimple.getNumStates(); ++n) {
            this.transIndexes.set(nArray[n], cSGSimple.getTransIndexes(n));
        }
        this.indexes = cSGSimple.getIndexes();
        this.playerInfo = new PlayerInfo(cSGSimple.playerInfo);
        this.actions = cSGSimple.getActions();
        this.idles = cSGSimple.getIdles();
    }

    @Override
    public void clearState(int n) {
        super.clearState(n);
        this.transIndexes.set(n, new ArrayList());
    }

    @Override
    public int addState() {
        int n = super.addState();
        this.transIndexes.add(new ArrayList());
        return n;
    }

    @Override
    public void addStates(int n) {
        super.addStates(n);
        for (int i = 0; i < n; ++i) {
            this.transIndexes.add(new ArrayList());
        }
    }

    public int addActionLabelledChoice(int n, Distribution<Value> distribution, int[] nArray) {
        int n2;
        Object object = "";
        for (n2 = 0; n2 < nArray.length; ++n2) {
            object = nArray[n2] >= 0 ? (String)object + "[" + this.actions.get(nArray[n2] - 1) + "]" : (String)object + "<" + n2 + ">";
        }
        int n3 = super.addActionLabelledChoice(n, distribution, object);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] < 0) continue;
            this.indexes[n2].set(nArray[n2]);
        }
        this.transIndexes.get(n).add(n3, nArray);
        return n3;
    }

    public void setIndexes(int n, int n2, int[] nArray) {
        this.transIndexes.get(n).add(n2, nArray);
    }

    public void setActions(List<Object> list) {
        this.actions = new Vector();
        for (Object object : list) {
            this.actions.add(object.toString());
        }
    }

    public void setActions(Vector<String> vector) {
        this.actions = new Vector<String>(vector);
    }

    public void setIndexes(BitSet[] bitSetArray) {
        this.indexes = bitSetArray;
    }

    public void setIdles(int[] nArray) {
        this.idles = nArray;
    }

    public void addIdleIndexes() {
        int n = this.actions.size() + 1;
        for (int i = 0; i < this.idles.length; ++i) {
            this.actions.add(n - 1, "<" + i + ">");
            this.idles[i] = n++;
        }
    }

    @Override
    public void setPlayerNames(List<String> list) {
        CSG.super.setPlayerNames(list);
        this.initIndexes();
    }

    public void copyPlayerInfo(PlayerInfoOwner playerInfoOwner) {
        this.playerInfo = new PlayerInfo(playerInfoOwner.getPlayerInfo());
        this.initIndexes();
    }

    protected void initIndexes() {
        int n = this.getNumPlayers();
        this.idles = new int[n];
        this.indexes = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = new BitSet();
        }
    }

    public void fixDeadlock(int n) {
        int n2 = this.getNumPlayers();
        Distribution distribution = new Distribution();
        distribution.add(n, this.getEvaluator().one());
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = -1;
        }
        this.addActionLabelledChoice(n, distribution, nArray);
    }

    @Override
    public PlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    @Override
    public Vector<String> getActions() {
        return this.actions;
    }

    @Override
    public int[] getIndexes(int n, int n2) {
        return this.transIndexes.get(n).get(n2);
    }

    @Override
    public BitSet getIndexesForPlayer(int n, int n2) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.getNumChoices(n); ++i) {
            int[] nArray = this.getIndexes(n, i);
            if (nArray[n2] > 0) {
                bitSet.set(nArray[n2]);
                continue;
            }
            bitSet.set(this.idles[n2]);
        }
        return bitSet;
    }

    @Override
    public String[] getActions(int n, int n2) {
        int[] nArray = this.getIndexes(n, n2);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = nArray[i] > 0 ? this.actions.get(nArray[i] - 1) : "<" + i + ">";
        }
        return stringArray;
    }

    @Override
    public BitSet[] getIndexes() {
        return this.indexes;
    }

    @Override
    public int[] getIdles() {
        return this.idles;
    }

    @Override
    public int getIdleForPlayer(int n) {
        return this.idles[n];
    }

    @Override
    public BitSet getConcurrentPlayers(int n) {
        BitSet bitSet = new BitSet();
        int[] nArray = this.getNumActions(n);
        int n2 = this.getNumPlayers();
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] < 2) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public List<List<int[]>> getTransIndexes() {
        return this.transIndexes;
    }

    public List<int[]> getTransIndexes(int n) {
        return this.transIndexes.get(n);
    }

    public List<String> getActionsForPlayer(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.indexes[n].nextSetBit(0);
        while (n2 >= 0) {
            arrayList.add(this.actions.get(n2));
            n2 = this.indexes[n].nextSetBit(n2 + 1);
        }
        return arrayList;
    }

    public Set<String> getActionsForPlayer(int n, int n2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.getNumChoices(n); ++i) {
            String[] stringArray = this.getActions(n, i);
            if (stringArray[n2].equals("-")) continue;
            hashSet.add(stringArray[n2]);
        }
        return hashSet;
    }

    public int[] getNumActions(int n) {
        int n2 = this.getNumPlayers();
        BitSet[] bitSetArray = new BitSet[n2];
        int[] nArray = new int[n2];
        Arrays.fill(nArray, 0);
        for (int i = 0; i < n2; ++i) {
            bitSetArray[i] = new BitSet();
            for (int j = 0; j < this.getNumChoices(n); ++j) {
                int[] nArray2 = this.transIndexes.get(n).get(j);
                if (nArray2[i] <= 0 || bitSetArray[i].get(nArray2[i])) continue;
                bitSetArray[i].set(nArray2[i]);
                int n3 = i;
                nArray[n3] = nArray[n3] + 1;
            }
        }
        return nArray;
    }

    public BitSet getActivePlayers(int n) {
        BitSet bitSet = new BitSet();
        int[] nArray = this.getNumActions(n);
        int n2 = this.getNumPlayers();
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= 0) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public void printModelInfo() {
        System.out.println(this.actions);
        for (int i = 0; i < this.getNumStates(); ++i) {
            int n;
            System.out.print("\n## state " + i + " : " + Arrays.toString(this.getNumActions(i)));
            for (n = 0; n < this.getNumPlayers(); ++n) {
                System.out.print(" : " + this.getActionsForPlayer(i, n) + " : " + this.getIndexesForPlayer(i, n));
            }
            System.out.println();
            for (n = 0; n < this.getNumChoices(i); ++n) {
                System.out.println(Arrays.toString(this.getIndexes(i, n)) + " : " + Arrays.toString(this.getActions(i, n)));
            }
        }
    }
}

