/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CSG;
import explicit.CSGCorrelated;
import explicit.CSGCorrelatedZ3;
import explicit.CSGLabeledPolytopes;
import explicit.CSGLabeledPolytopesYicesStack;
import explicit.CSGLabeledPolytopesZ3Stack;
import explicit.CSGModelChecker;
import explicit.CSGSupportEnumeration;
import explicit.CSGSupportEnumerationZ3;
import explicit.EquilibriumResult;
import explicit.MDPModelChecker;
import explicit.ModelCheckerResult;
import explicit.ProbModelChecker;
import explicit.rewards.CSGRewards;
import explicit.rewards.MDPRewards;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.Precision;
import parser.ast.Coalition;
import parser.ast.ExpressionTemporal;
import prism.Pair;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;
import strat.CSGStrategy;

public class CSGModelCheckerEquilibria
extends CSGModelChecker {
    protected MDPModelChecker mdpmc;
    private HashMap<Integer, HashMap<Integer, ArrayList<Pair<BitSet, Double>>>> assertions;
    private ArrayList<ArrayList<ArrayList<Pair<BitSet, Double>>>> products;
    private ArrayList<Integer> payoffs;
    private HashMap<Integer, HashMap<Integer, ArrayList<Pair<BitSet, Double>>>> gradient;
    private HashMap<Integer, int[]> mapActionIndex;
    private ArrayList<ArrayList<BitSet>> supports;
    private ArrayList<BitSet> psupports;
    private ArrayList<BitSet> allSupports;
    private ArrayList<ArrayList<HashMap<BitSet, Double>>> ceConstraints;
    private HashMap<BitSet, Integer> ceVarMap;
    protected BitSet[] dominated;
    protected BitSet[] dominating;
    protected BitSet players = new BitSet();
    protected CSGLabeledPolytopes smtLabeleldPolytopes;
    protected CSGSupportEnumeration smtSupportEnumeration;
    protected CSGSupportEnumeration nlpSupportEnumeration;
    protected CSGCorrelated ceSolver;
    protected String smtSolver;
    protected boolean assumptionCheck = false;
    public static final int NASH = 1;
    public static final int CORR = 2;
    public static final int SWEQ = 3;
    public static final int FAIR = 4;

    public CSGModelCheckerEquilibria(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        this.psupports = new ArrayList();
        this.supports = new ArrayList();
        this.allSupports = new ArrayList();
        this.mapActionIndex = new HashMap();
        this.products = new ArrayList();
        this.assertions = new HashMap();
        this.ceConstraints = new ArrayList();
        this.ceVarMap = new HashMap();
        this.gradient = new HashMap();
        this.payoffs = new ArrayList();
        this.mdpmc = new MDPModelChecker(prismComponent);
        this.mdpmc.setVerbosity(0);
        this.mdpmc.setSilentPrecomputations(true);
        this.assumptionCheck = false;
        switch (this.smtSolver = this.getSettings().getString("prism.smtsolver")) {
            case "Z3": {
                break;
            }
            case "Yices": {
                break;
            }
            default: {
                throw new PrismException("Unknown SMT solver \"" + this.smtSolver + "\"");
            }
        }
    }

    public String setSolver(int n) throws PrismException {
        String string = null;
        block0 : switch (n) {
            case 2: {
                this.ceSolver = new CSGCorrelatedZ3(this.maxRows * this.maxCols, this.numCoalitions);
                string = this.ceSolver.getSolverName();
                break;
            }
            default: {
                switch (this.smtSolver) {
                    case "Z3": {
                        this.smtLabeleldPolytopes = new CSGLabeledPolytopesZ3Stack(this.maxRows, this.maxCols);
                        string = this.smtLabeleldPolytopes.getSolverName();
                        break block0;
                    }
                    case "Yices": {
                        this.smtLabeleldPolytopes = new CSGLabeledPolytopesYicesStack();
                        string = this.smtLabeleldPolytopes.getSolverName();
                    }
                }
            }
        }
        return string;
    }

    public void buildCoalitions(CSG<Double> cSG, List<Coalition> list) throws PrismException {
        int n;
        if (list == null || list.isEmpty()) {
            throw new PrismException("Coalitions must not be empty");
        }
        int n2 = 0;
        this.numPlayers = cSG.getNumPlayers();
        this.numCoalitions = list.size();
        this.coalitionIndexes = new BitSet[list.size()];
        this.actionIndexes = new BitSet[list.size()];
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (n = 0; n < this.numPlayers; ++n) {
            hashMap.put(n + 1, cSG.getPlayerName(n));
        }
        for (int i = 0; i < list.size(); ++i) {
            this.coalitionIndexes[i] = new BitSet();
            this.actionIndexes[i] = new BitSet();
            for (n = 0; n < this.numPlayers; ++n) {
                if (!this.coalitionIndexes[i].get(n)) {
                    if (!list.get(i).isPlayerIndexInCoalition(n, hashMap)) continue;
                    this.coalitionIndexes[i].set(n);
                    this.actionIndexes[i].or(cSG.getIndexes()[n]);
                    this.actionIndexes[i].set(cSG.getIdleForPlayer(n));
                    continue;
                }
                throw new PrismLangException("Repeated player in coalition " + list.get(i));
            }
            n2 += this.coalitionIndexes[i].cardinality();
        }
        if (n2 != this.numPlayers) {
            throw new PrismLangException("All players must be in a coalition");
        }
        this.players.clear();
        this.players.set(0, this.numCoalitions);
    }

    public void buildAllSupports() {
        for (int i = 0; i < this.numCoalitions; ++i) {
            if (!this.dominating[i].isEmpty()) {
                this.supports.get(i).add(this.dominating[i]);
                continue;
            }
            this.buildSupportsPlayer(new BitSet(), i, 0);
        }
        for (BitSet bitSet : this.supports.get(0)) {
            BitSet bitSet2 = new BitSet();
            bitSet2.or(bitSet);
            this.buildAllSupportsAux(bitSet2, 1);
        }
    }

    public void buildAllSupportsAux(BitSet bitSet, int n) {
        for (BitSet bitSet2 : this.supports.get(n)) {
            BitSet bitSet3 = (BitSet)bitSet.clone();
            bitSet3.or(bitSet2);
            if (n == this.numCoalitions - 1) {
                if (this.allSupports.contains(bitSet3)) continue;
                this.allSupports.add(bitSet3);
                continue;
            }
            this.buildAllSupportsAux(bitSet3, n + 1);
        }
    }

    public void buildSupportsPlayer(BitSet bitSet, int n, int n2) {
        BitSet bitSet2 = (BitSet)bitSet.clone();
        if (!this.dominated[n].get((Integer)((ArrayList)this.strategies.get(n)).get(n2))) {
            bitSet2.set((Integer)((ArrayList)this.strategies.get(n)).get(n2));
        }
        BitSet bitSet3 = (BitSet)bitSet.clone();
        if (n2 == ((ArrayList)this.strategies.get(n)).size() - 1) {
            if (!bitSet3.isEmpty()) {
                this.supports.get(n).add(bitSet3);
            }
            if (!bitSet2.isEmpty()) {
                this.supports.get(n).add(bitSet2);
            }
        } else {
            this.buildSupportsPlayer(bitSet3, n, n2 + 1);
            this.buildSupportsPlayer(bitSet2, n, n2 + 1);
        }
    }

    public void findMaxAvgAct(CSG<Double> cSG) {
        int n;
        Object object = "(";
        Object object2 = "(";
        this.maxRows = 0;
        this.maxCols = 0;
        this.avgNumActions = new double[this.numCoalitions];
        Arrays.fill(this.avgNumActions, 0.0);
        this.maxNumActions = new int[this.numCoalitions];
        Arrays.fill(this.maxNumActions, 0);
        for (int i = 0; i < cSG.getNumStates(); ++i) {
            n = 0;
            while (n < this.numCoalitions) {
                int n2 = 1;
                int n3 = this.coalitionIndexes[n].nextSetBit(0);
                while (n3 >= 0) {
                    n2 *= cSG.getIndexesForPlayer(i, n3).cardinality();
                    n3 = this.coalitionIndexes[n].nextSetBit(n3 + 1);
                }
                this.maxNumActions[n] = this.maxNumActions[n] < n2 ? n2 : this.maxNumActions[n];
                int n4 = n++;
                this.avgNumActions[n4] = this.avgNumActions[n4] + (double)n2;
            }
        }
        for (n = 0; n < this.numCoalitions; ++n) {
            int n5 = n;
            this.avgNumActions[n5] = this.avgNumActions[n5] / (double)cSG.getNumStates();
            object = (String)object + (n < this.numCoalitions - 1 ? this.maxNumActions[n] + "," : this.maxNumActions[n] + ")");
            object2 = (String)object2 + (n < this.numCoalitions - 1 ? PrismUtils.formatDouble2dp(this.avgNumActions[n]) + "," : PrismUtils.formatDouble2dp(this.avgNumActions[n]) + ")");
        }
        this.mainLog.println("Max/avg (actions): " + (String)object + "/" + (String)object2);
    }

    public BitSet findDominated(int n) throws PrismException {
        BitSet bitSet = new BitSet();
        if (this.assertions.get(n).keySet().size() == 1) {
            return bitSet;
        }
        block0: for (int n2 : this.assertions.get(n).keySet()) {
            for (int n3 : this.assertions.get(n).keySet()) {
                if (n2 == n3) continue;
                boolean bl = true;
                for (int i = 0; i < this.assertions.get(n).get(n2).size(); ++i) {
                    Pair<BitSet, Double> pair = this.assertions.get(n).get(n2).get(i);
                    Pair<BitSet, Double> pair2 = this.assertions.get(n).get(n3).get(i);
                    if (!((BitSet)pair.first).equals(pair2.first)) {
                        throw new PrismException("Error when comparing indexes");
                    }
                    bl = bl && Double.compare((Double)pair.second, (Double)pair2.second) < 0;
                }
                if (!bl) continue;
                bitSet.set((Integer)((ArrayList)this.strategies.get(n)).get(n2));
                continue block0;
            }
        }
        return bitSet;
    }

    public BitSet findDominating(int n) throws PrismException {
        BitSet bitSet = new BitSet();
        if (this.assertions.get(n).keySet().size() == 1) {
            return bitSet;
        }
        for (int n2 : this.assertions.get(n).keySet()) {
            boolean bl = true;
            for (int n3 : this.assertions.get(n).keySet()) {
                if (n2 == n3) continue;
                for (int i = 0; i < this.assertions.get(n).get(n2).size(); ++i) {
                    Pair<BitSet, Double> pair = this.assertions.get(n).get(n2).get(i);
                    Pair<BitSet, Double> pair2 = this.assertions.get(n).get(n3).get(i);
                    if (!((BitSet)pair.first).equals(pair2.first)) {
                        throw new PrismException("Error when comparing indexes");
                    }
                    bl = bl && Double.compare((Double)pair.second, (Double)pair2.second) > 0;
                }
            }
            if (!bl) continue;
            bitSet.set((Integer)((ArrayList)this.strategies.get(n)).get(n2));
        }
        return bitSet;
    }

    public int[] findMaxIndexes(double[][] dArray) {
        int[] nArray = new int[]{0, 0};
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (Double.compare(dArray[i][j], d) <= 0) continue;
                d = dArray[i][j];
                nArray[0] = i;
                nArray[1] = j;
            }
        }
        return nArray;
    }

    public boolean checkAllZeroEntries() {
        boolean bl = true;
        for (BitSet bitSet : this.utilities.keySet()) {
            for (int i = 0; i < this.numCoalitions; ++i) {
                boolean bl2 = bl = bl && Double.compare((Double)((ArrayList)this.utilities.get(bitSet)).get(i), 0.0) == 0;
                if (!bl) break;
            }
            if (bl) continue;
            break;
        }
        return bl;
    }

    public double[][] findSWNEOnePlayer(List<Map<Integer, BitSet>> list, List<List<Map<BitSet, Double>>> list2, List<Map<BitSet, Double>> list3, BitSet bitSet) {
        BitSet bitSet2 = null;
        double[][] dArray = new double[1][this.numCoalitions];
        int n = bitSet.nextSetBit(0);
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        for (BitSet bitSet3 : this.utilities.keySet()) {
            int n2;
            d2 = 0.0;
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                d2 += ((Double)((ArrayList)this.utilities.get(bitSet3)).get(n2)).doubleValue();
            }
            if (Double.compare((Double)((ArrayList)this.utilities.get(bitSet3)).get(n), d) > 0) {
                bitSet2 = bitSet3;
                d3 = 0.0;
                d = (Double)((ArrayList)this.utilities.get(bitSet3)).get(n);
                for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                    dArray[0][n2] = (Double)((ArrayList)this.utilities.get(bitSet3)).get(n2);
                    d3 += ((Double)((ArrayList)this.utilities.get(bitSet3)).get(n2)).doubleValue();
                }
                continue;
            }
            if (Double.compare((Double)((ArrayList)this.utilities.get(bitSet3)).get(n), d) != 0 || Double.compare(d2, d3) <= 0) continue;
            bitSet2 = bitSet3;
            d3 = 0.0;
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                dArray[0][n2] = (Double)((ArrayList)this.utilities.get(bitSet3)).get(n2);
                d3 += ((Double)((ArrayList)this.utilities.get(bitSet3)).get(n2)).doubleValue();
            }
        }
        if (this.genStrat) {
            list3 = new ArrayList<Map<BitSet, Double>>();
            this.extractStrategyFromSupport(list, list3, bitSet2);
            list2.add(list3);
        }
        return dArray;
    }

    public double[][] findSWNEUniqueSupport(List<Map<Integer, BitSet>> list, List<List<Map<BitSet, Double>>> list2, List<Map<BitSet, Double>> list3) {
        double[][] dArray = new double[1][this.numCoalitions];
        for (BitSet bitSet : this.allSupports) {
            for (int i = 0; i < this.numCoalitions; ++i) {
                dArray[0][i] = (Double)((ArrayList)this.utilities.get(bitSet)).get(i);
            }
            if (!this.genStrat) continue;
            list3 = new ArrayList<Map<BitSet, Double>>();
            this.extractStrategyFromSupport(list, list3, bitSet);
            list2.add(list3);
        }
        return dArray;
    }

    public void extractStrategyFromSupport(List<Map<Integer, BitSet>> list, List<Map<BitSet, Double>> list2, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.numCoalitions; ++i) {
            bitSet2.clear();
            for (int j = 0; j < ((ArrayList)this.strategies.get(i)).size(); ++j) {
                bitSet2.set((Integer)((ArrayList)this.strategies.get(i)).get(j));
            }
            bitSet2.and(bitSet);
            int n = bitSet2.nextSetBit(0);
            list2.add(i, new HashMap());
            list2.get(i).put(list.get(i).get(((ArrayList)this.strategies.get(i)).indexOf(n)), 1.0);
        }
    }

    public ArrayList<Map<BitSet, Double>> extractStrategyFromEquilibrium(EquilibriumResult equilibriumResult, List<Map<Integer, BitSet>> list) {
        ArrayList<Map<BitSet, Double>> arrayList = new ArrayList<Map<BitSet, Double>>();
        for (int i = 0; i < this.numCoalitions; ++i) {
            arrayList.add(i, new HashMap());
            for (int n : equilibriumResult.getStrategy().get(i).getSupport()) {
                arrayList.get(i).put(list.get(i).get(n), equilibriumResult.getStrategy().get(i).get(n));
            }
        }
        return arrayList;
    }

    public void buildStepGame(CSG<Double> cSG, List<CSGRewards<Double>> list, List<Map<Integer, BitSet>> list2, double[][] dArray, int n, boolean bl) throws PrismException {
        int n2;
        HashMap<BitSet, Integer> hashMap = new HashMap<BitSet, Integer>();
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        int[] nArray = new int[this.numPlayers];
        this.ceVarMap.clear();
        this.actions.clear();
        this.psupports.clear();
        this.strategies.clear();
        this.utilities.clear();
        this.varIndex = 0;
        Arrays.fill(nArray, -1);
        for (n2 = 0; n2 < this.numCoalitions; ++n2) {
            this.actions.add(n2, new ArrayList());
            this.psupports.add(n2, new BitSet());
            this.strategies.add(n2, new ArrayList());
        }
        for (int i = 0; i < cSG.getNumChoices(n); ++i) {
            double d;
            BitSet bitSet3 = new BitSet();
            int[] nArray2 = cSG.getIndexes(n, i);
            bitSet.clear();
            for (int j = 0; j < this.numPlayers; ++j) {
                if (nArray2[j] != -1) {
                    bitSet.set(nArray2[j]);
                    continue;
                }
                bitSet.set(cSG.getIdleForPlayer(j));
            }
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                d = 0.0;
                bitSet2.clear();
                bitSet2.or(this.actionIndexes[n2]);
                bitSet2.and(bitSet);
                if (bitSet2.cardinality() != this.coalitionIndexes[n2].cardinality()) {
                    throw new PrismException("Error in coalition");
                }
                if (!hashMap.keySet().contains(bitSet2)) {
                    Object object = "";
                    ((ArrayList)this.strategies.get(n2)).add(this.varIndex);
                    this.psupports.get(n2).set(this.varIndex);
                    if (list2 != null) {
                        list2.get(n2).put(((ArrayList)this.strategies.get(n2)).size() - 1, (BitSet)bitSet2.clone());
                    }
                    int n3 = bitSet2.nextSetBit(0);
                    while (n3 >= 0) {
                        object = (String)object + "[" + cSG.getActions().get(n3 - 1) + "]";
                        n3 = bitSet2.nextSetBit(n3 + 1);
                    }
                    ((ArrayList)this.actions.get(n2)).add(object);
                    bitSet3.set(this.varIndex);
                    hashMap.put((BitSet)bitSet2.clone(), this.varIndex);
                    ++this.varIndex;
                    continue;
                }
                bitSet3.set((Integer)hashMap.get(bitSet2));
            }
            this.utilities.put(bitSet3, new ArrayList());
            this.ceVarMap.put(bitSet3, this.utilities.keySet().size() - 1);
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                d = 0.0;
                for (int n4 : cSG.getChoice(n, i).getSupport()) {
                    if (!Double.isNaN(dArray[n2][n4])) {
                        d += cSG.getChoice(n, i).get(n4) * dArray[n2][n4];
                        continue;
                    }
                    this.mainLog.println("val[c][d]: " + dArray[n2][n4]);
                    this.mainLog.println("\n## state " + n);
                    this.mainLog.println("-- strategies " + this.strategies);
                    this.mainLog.println("-- actions " + this.actions);
                    this.mainLog.println("-- utilities " + this.utilities);
                    throw new PrismException("Error in building game for state " + n);
                }
                if (list != null && list.get(n2) != null) {
                    d += ((Double)list.get(n2).getTransitionReward(n, i)).doubleValue();
                }
                d = Precision.round((double)d, (int)12, (int)6);
                ((ArrayList)this.utilities.get(bitSet3)).add(n2, bl ? -1.0 * d : d);
            }
        }
    }

    public ArrayList<ArrayList<ArrayList<Double>>> buildBimatrixGame(CSG<Double> cSG, CSGRewards<Double> cSGRewards, CSGRewards<Double> cSGRewards2, List<Map<Integer, BitSet>> list, List<ArrayList<Integer>> list2, double[][] dArray, int n, boolean bl) throws PrismException {
        int n2;
        ArrayList<ArrayList<ArrayList<Double>>> arrayList = new ArrayList<ArrayList<ArrayList<Double>>>();
        ArrayList<CSGRewards<Double>> arrayList2 = null;
        BitSet bitSet = new BitSet();
        if (this.numCoalitions > 2) {
            throw new PrismLangException("Multiplayer game not supported by this method");
        }
        if (cSGRewards != null || cSGRewards2 != null) {
            arrayList2 = new ArrayList<CSGRewards<Double>>();
            arrayList2.add(0, cSGRewards);
            arrayList2.add(1, cSGRewards2);
        }
        this.buildStepGame(cSG, arrayList2, list, dArray, n, bl);
        this.clear();
        this.computeAssertions();
        for (n2 = 0; n2 < this.numCoalitions; ++n2) {
            this.dominated[n2] = this.findDominated(n2);
            this.dominating[n2] = this.findDominating(n2);
        }
        this.buildAllSupports();
        for (n2 = 0; n2 < 2; ++n2) {
            arrayList.add(n2, new ArrayList());
            int n3 = 0;
            for (int i = 0; i < ((ArrayList)this.strategies.get(0)).size(); ++i) {
                if (this.dominated[0].get((Integer)((ArrayList)this.strategies.get(0)).get(i))) continue;
                arrayList.get(n2).add(n3, new ArrayList());
                bitSet.clear();
                bitSet.set((Integer)((ArrayList)this.strategies.get(0)).get(i));
                int n4 = 0;
                for (int j = 0; j < ((ArrayList)this.strategies.get(1)).size(); ++j) {
                    if (this.dominated[1].get((Integer)((ArrayList)this.strategies.get(1)).get(j))) continue;
                    bitSet.set((Integer)((ArrayList)this.strategies.get(1)).get(j));
                    if (!this.utilities.containsKey(bitSet)) {
                        throw new PrismException("Error in building bimatrix game");
                    }
                    arrayList.get(n2).get(n3).add(n4, (Double)((ArrayList)this.utilities.get(bitSet)).get(n2));
                    bitSet.clear((Integer)((ArrayList)this.strategies.get(1)).get(j));
                    if (n2 == 0 && n3 == 0) {
                        list2.get(1).add(n4, j);
                    }
                    ++n4;
                }
                if (n2 == 0) {
                    list2.get(0).add(n3, i);
                }
                ++n3;
            }
        }
        return arrayList;
    }

    public void clear() {
        int n;
        this.supports.clear();
        this.allSupports.clear();
        this.products.clear();
        this.assertions.clear();
        this.ceConstraints.clear();
        this.gradient.clear();
        this.payoffs.clear();
        this.mapActionIndex.clear();
        for (n = 0; n < this.numCoalitions; ++n) {
            this.supports.add(n, new ArrayList());
            this.products.add(n, new ArrayList());
            this.assertions.put(n, new HashMap());
            this.ceConstraints.add(n, new ArrayList());
            this.gradient.put(n, new HashMap());
            for (int i = 0; i < ((ArrayList)this.strategies.get(n)).size(); ++i) {
                this.products.get(n).add(i, new ArrayList());
                this.mapActionIndex.put((Integer)((ArrayList)this.strategies.get(n)).get(i), new int[]{n, i});
            }
        }
        for (n = 0; n < this.numCoalitions; ++n) {
            this.payoffs.add(n, this.varIndex);
            ++this.varIndex;
        }
    }

    public void computeAssertions() throws PrismException {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.numCoalitions; ++i) {
            BitSet bitSet2 = (BitSet)this.players.clone();
            bitSet2.clear(i);
            for (int j = 0; j < ((ArrayList)this.strategies.get(i)).size(); ++j) {
                bitSet.clear();
                bitSet.set((Integer)((ArrayList)this.strategies.get(i)).get(j));
                this.assertions.get(i).put(j, this.prodAction(bitSet, bitSet2, j, i));
            }
        }
    }

    public ArrayList<Pair<BitSet, Double>> prodAction(BitSet bitSet, BitSet bitSet2, int n, int n2) throws PrismException {
        this.prodAction(new Pair<BitSet, Double>(new BitSet(), 0.0), bitSet, bitSet2, n, n2);
        ArrayList<Pair<BitSet, Double>> arrayList = new ArrayList<Pair<BitSet, Double>>();
        for (int i = 0; i < this.products.get(n2).get(n).size(); ++i) {
            arrayList.add(this.products.get(n2).get(n).get(i));
        }
        this.products.get(n2).get(n).clear();
        return arrayList;
    }

    public void prodAction(Pair<BitSet, Double> pair, BitSet bitSet, BitSet bitSet2, int n, int n2) throws PrismException {
        BitSet bitSet3 = (BitSet)bitSet2.clone();
        if (this.products.get(n2) == null) {
            this.products.add(n2, new ArrayList());
        } else if (this.products.get(n2).get(n) == null) {
            this.products.get(n2).add(n, new ArrayList());
        }
        int n3 = bitSet2.nextSetBit(0);
        while (n3 < bitSet2.size() && n3 != -1) {
            bitSet3.clear(n3);
            for (int i = 0; i < ((ArrayList)this.actions.get(n3)).size(); ++i) {
                BitSet bitSet4 = new BitSet();
                bitSet4.or(bitSet);
                bitSet4.set((Integer)((ArrayList)this.strategies.get(n3)).get(i));
                Pair<BitSet, Double> pair2 = new Pair<BitSet, Double>(new BitSet(), 0.0);
                ((BitSet)pair2.first).or((BitSet)pair.first);
                ((BitSet)pair2.first).set((Integer)((ArrayList)this.strategies.get(n3)).get(i));
                this.prodAction(pair2, bitSet4, bitSet3, n, n2);
                if (bitSet2.cardinality() != 1 || bitSet4.cardinality() != this.numCoalitions) continue;
                ((BitSet)pair2.first).or((BitSet)pair.first);
                ((BitSet)pair2.first).set((Integer)((ArrayList)this.strategies.get(n3)).get(i));
                pair2.second = ((ArrayList)this.utilities.get(bitSet4)).get(n2);
                this.products.get(n2).get(n).add(pair2);
                if (this.gradient.get(n2).get(n) == null) {
                    this.gradient.get(n2).put(n, new ArrayList());
                }
                if ((Double)pair2.second != 0.0) {
                    this.gradient.get(n2).get(n).add(pair2);
                }
                BitSet bitSet5 = new BitSet();
                int n4 = ((BitSet)pair2.first).nextSetBit(0);
                while (n4 >= 0) {
                    bitSet5.or((BitSet)pair2.first);
                    bitSet5.set((Integer)((ArrayList)this.strategies.get(n2)).get(n));
                    bitSet5.clear(n4);
                    if (this.gradient.get(this.mapActionIndex.get(n4)[0]).get(this.mapActionIndex.get(n4)[1]) == null) {
                        this.gradient.get(this.mapActionIndex.get(n4)[0]).put(this.mapActionIndex.get(n4)[1], new ArrayList());
                    }
                    if ((Double)pair2.second != 0.0) {
                        this.gradient.get(this.mapActionIndex.get(n4)[0]).get(this.mapActionIndex.get(n4)[1]).add(new Pair<BitSet, Double>((BitSet)bitSet5.clone(), (Double)pair2.second));
                    }
                    bitSet5.clear();
                    n4 = ((BitSet)pair2.first).nextSetBit(n4 + 1);
                }
            }
            n3 = bitSet2.nextSetBit(n3 + 1);
        }
    }

    public double[][] computeBoundedReachProbs(CSG<Double> cSG, BitSet bitSet, int n) {
        int n2;
        double[][] dArray = new double[n][cSG.getNumStates()];
        double[] dArray2 = new double[cSG.getNumStates()];
        double[] dArray3 = new double[cSG.getNumStates()];
        for (n2 = 0; n2 < cSG.getNumStates(); ++n2) {
            dArray2[n2] = bitSet.get(n2) ? 1.0 : 0.0;
            dArray3[n2] = dArray2[n2];
        }
        for (int i = 0; i < n; ++i) {
            for (n2 = 0; n2 < cSG.getNumStates(); ++n2) {
                double d = 0.0;
                for (int j = 0; j < cSG.getNumChoices(n2); ++j) {
                    double d2 = 0.0;
                    Iterator iterator = cSG.getTransitionsIterator(n2, j);
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        d2 += (Double)entry.getValue() * dArray3[entry.getKey()];
                    }
                    d = d2 > d ? d2 : d;
                }
                if (bitSet.get(n2)) continue;
                dArray2[n2] = d;
            }
            dArray3 = Arrays.copyOf(dArray2, dArray2.length);
            dArray[i] = dArray2;
        }
        return dArray;
    }

    public ModelCheckerResult computeBoundedEquilibria(CSG<Double> cSG, List<Coalition> list, List<CSGRewards<Double>> list2, List<ExpressionTemporal> list3, BitSet[] bitSetArray, BitSet[] bitSetArray2, int[] nArray, int n, int n2, boolean bl) throws PrismException {
        int n3;
        int n4;
        if (this.genStrat) {
            throw new PrismException("Strategy synthesis for bounded properties is not supported yet.");
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        ArrayList<CSGRewards<Double>> arrayList = null;
        BitSet[] bitSetArray3 = new BitSet[list.size()];
        BitSet[] bitSetArray4 = new BitSet[3];
        BitSet bitSet = new BitSet();
        double[][] dArray = new double[list.size()][cSG.getNumStates()];
        double[][] dArray2 = new double[list.size()][cSG.getNumStates()];
        double[][] dArray3 = new double[list.size()][cSG.getNumStates()];
        double[] dArray4 = new double[cSG.getNumStates()];
        boolean bl2 = list2 != null;
        this.buildCoalitions(cSG, list);
        this.findMaxRowsCols(cSG);
        this.mainLog.println("Starting bounded equilibria computation (solver=" + this.setSolver(n) + ")...");
        this.dominated = new BitSet[this.numCoalitions];
        this.dominating = new BitSet[this.numCoalitions];
        if (list3.get(0).getOperator() == 1 || list3.get(1).getOperator() == 1) {
            int n5;
            for (int i = 0; i < 2; ++i) {
                if (list3.get(i).getOperator() == 1) {
                    for (n5 = 0; n5 < cSG.getNumStates(); ++n5) {
                        dArray[i][n5] = bitSetArray[i].get(n5) ? 1.0 : 0.0;
                    }
                    continue;
                }
                dArray[i] = this.mdpmc.computeBoundedUntilProbs(cSG, (BitSet)bitSetArray2[i], (BitSet)bitSetArray[i], (int)(nArray[i] - 1), (boolean)bl).soln;
            }
            for (n5 = 0; n5 < cSG.getNumStates(); ++n5) {
                double[] dArray5 = this.stepEquilibriaTwoPlayer(cSG, null, null, null, dArray, n5, n, n2, bl2, bl);
                dArray2[0][n5] = dArray5[1];
                dArray2[1][n5] = dArray5[2];
                dArray4[n5] = dArray5[1] + dArray5[2];
            }
            this.mainLog.println("\nCoalition results (initial state): (" + dArray2[0][cSG.getFirstInitialState()] + "," + dArray2[1][cSG.getFirstInitialState()] + ")");
            modelCheckerResult.soln = dArray4;
            modelCheckerResult.numIters = 1;
            return modelCheckerResult;
        }
        if (!bl2) {
            for (n4 = 0; n4 < 2; ++n4) {
                bitSetArray4[n4] = new BitSet();
                if (bitSetArray2[n4] == null) {
                    bitSetArray4[n4].set(0, cSG.getNumStates());
                    continue;
                }
                bitSetArray4[n4].or(bitSetArray2[n4]);
            }
        }
        if (bitSetArray == null) {
            bitSetArray = new BitSet[list.size()];
            for (n4 = 0; n4 < list.size(); ++n4) {
                bitSetArray[n4] = new BitSet();
            }
        }
        for (n4 = 0; n4 < list.size(); ++n4) {
            bitSetArray3[n4] = new BitSet();
            bitSetArray3[n4].or(bitSetArray[n4]);
            for (int i = 0; i < list.size(); ++i) {
                if (n4 == i) continue;
                bitSetArray3[n4].andNot(bitSetArray[i]);
            }
        }
        int n6 = Math.abs(nArray[0] - nArray[1]);
        int n7 = nArray[0] > nArray[1] ? n6 : 0;
        int n8 = n3 = nArray[1] > nArray[0] ? n6 : 0;
        if (!bl2) {
            bitSetArray4[2] = new BitSet();
            bitSetArray4[2].or(bitSetArray4[0]);
            bitSetArray4[2].and(bitSetArray4[1]);
            bitSet.clear();
            bitSet.or(bitSetArray4[0]);
            bitSetArray4[0].andNot(bitSetArray4[1]);
            bitSetArray4[1].andNot(bitSet);
            bitSet.clear();
        } else {
            arrayList = new ArrayList<CSGRewards<Double>>();
        }
        long l = System.currentTimeMillis();
        if (bl2) {
            if (nArray[0] > nArray[1]) {
                dArray3[0] = list3.get(0).getOperator() == 11 ? this.mdpmc.computeCumulativeRewards(cSG, (MDPRewards<Double>)((MDPRewards)list2.get((int)0)), (int)n7, (boolean)bl).soln : this.mdpmc.computeInstantaneousRewards(cSG, (MDPRewards<Double>)((MDPRewards)list2.get((int)0)), (int)n7, (boolean)bl).soln;
            }
            if (nArray[1] > nArray[0]) {
                dArray3[1] = list3.get(1).getOperator() == 11 ? this.mdpmc.computeCumulativeRewards(cSG, (MDPRewards<Double>)((MDPRewards)list2.get((int)1)), (int)n3, (boolean)bl).soln : this.mdpmc.computeInstantaneousRewards(cSG, (MDPRewards<Double>)((MDPRewards)list2.get((int)1)), (int)n3, (boolean)bl).soln;
            }
        }
        l = System.currentTimeMillis() - l;
        while (true) {
            int n9;
            long l2 = System.currentTimeMillis();
            if (!bl2) {
                if (n7 > 0) {
                    dArray3[0] = bitSetArray2[0] == null ? this.mdpmc.computeBoundedReachProbs(cSG, (BitSet)bitSetArray[0], (int)n7, (boolean)bl).soln : this.mdpmc.computeBoundedUntilProbs(cSG, (BitSet)bitSetArray2[0], (BitSet)bitSetArray[0], (int)n7, (boolean)bl).soln;
                }
                if (n3 > 0) {
                    dArray3[1] = bitSetArray2[1] == null ? this.mdpmc.computeBoundedReachProbs(cSG, (BitSet)bitSetArray[1], (int)n3, (boolean)bl).soln : this.mdpmc.computeBoundedUntilProbs(cSG, (BitSet)bitSetArray2[1], (BitSet)bitSetArray[1], (int)n3, (boolean)bl).soln;
                }
            }
            l += System.currentTimeMillis() - l2;
            if (Math.min(n7, n3) > 0) {
                for (n9 = 0; n9 < cSG.getNumStates(); ++n9) {
                    double[] dArray6;
                    if (bl2) {
                        arrayList.clear();
                        for (n4 = 0; n4 < 2; ++n4) {
                            arrayList.add(n4, list2.get(n4));
                            if (list3.get(n4).getOperator() == 11) continue;
                            arrayList.set(n4, null);
                        }
                        dArray6 = this.stepEquilibriaTwoPlayer(cSG, arrayList, null, null, dArray, n9, n, n2, bl2, bl);
                        dArray2[0][n9] = dArray6[1];
                        dArray2[1][n9] = dArray6[2];
                        continue;
                    }
                    if (bitSetArray[0].get(n9) && bitSetArray[1].get(n9)) {
                        dArray2[0][n9] = 1.0;
                        dArray2[1][n9] = 1.0;
                        continue;
                    }
                    if (bitSetArray3[0].get(n9)) {
                        dArray2[0][n9] = 1.0;
                        dArray2[1][n9] = dArray3[1][n9];
                        continue;
                    }
                    if (bitSetArray3[1].get(n9)) {
                        dArray2[0][n9] = dArray3[0][n9];
                        dArray2[1][n9] = 1.0;
                        continue;
                    }
                    if (bitSetArray4[0].get(n9)) {
                        dArray2[0][n9] = dArray3[0][n9];
                        dArray2[1][n9] = 0.0;
                        continue;
                    }
                    if (bitSetArray4[1].get(n9)) {
                        dArray2[0][n9] = 0.0;
                        dArray2[1][n9] = dArray3[1][n9];
                        continue;
                    }
                    if (!bitSetArray4[2].get(n9)) {
                        dArray2[0][n9] = 0.0;
                        dArray2[1][n9] = 0.0;
                        continue;
                    }
                    dArray6 = this.stepEquilibriaTwoPlayer(cSG, null, null, null, dArray, n9, n, n2, bl2, bl);
                    dArray2[0][n9] = dArray6[1];
                    dArray2[1][n9] = dArray6[2];
                }
                for (n9 = 0; n9 < cSG.getNumStates(); ++n9) {
                    dArray[0][n9] = dArray2[0][n9];
                    dArray[1][n9] = dArray2[1][n9];
                    dArray4[n9] = dArray[0][n9] + dArray[1][n9];
                }
            } else {
                for (n9 = 0; n9 < cSG.getNumStates(); ++n9) {
                    if (bl2) {
                        if (n7 == 0 && n3 == 0) {
                            dArray[0][n9] = list3.get(0).getOperator() == 11 ? 0.0 : (Double)list2.get(0).getStateReward(n9);
                            dArray[1][n9] = list3.get(1).getOperator() == 11 ? 0.0 : (Double)list2.get(1).getStateReward(n9);
                            continue;
                        }
                        if (n7 == 0) {
                            dArray[0][n9] = list3.get(0).getOperator() == 11 ? 0.0 : (Double)list2.get(0).getStateReward(n9);
                            dArray[1][n9] = dArray3[1][n9];
                            continue;
                        }
                        dArray[0][n9] = dArray3[0][n9];
                        dArray[1][n9] = list3.get(1).getOperator() == 11 ? 0.0 : (Double)list2.get(1).getStateReward(n9);
                        continue;
                    }
                    if (n7 == 0 && n3 == 0) {
                        dArray[0][n9] = bitSetArray[0].get(n9) ? 1.0 : 0.0;
                        dArray[1][n9] = bitSetArray[1].get(n9) ? 1.0 : 0.0;
                        continue;
                    }
                    if (n7 == 0) {
                        dArray[0][n9] = bitSetArray[0].get(n9) ? 1.0 : 0.0;
                        dArray[1][n9] = bitSetArray[1].get(n9) ? 1.0 : dArray3[1][n9];
                        continue;
                    }
                    dArray[0][n9] = bitSetArray[0].get(n9) ? 1.0 : dArray3[0][n9];
                    dArray[1][n9] = bitSetArray[1].get(n9) ? 1.0 : 0.0;
                }
            }
            if (n6 == Math.max(nArray[0], nArray[1])) break;
            ++n6;
            n7 = Math.min(n7 + 1, nArray[0]);
            n3 = Math.min(n3 + 1, nArray[1]);
        }
        this.mainLog.println("\nPrecomputation took " + (double)l / 1000.0 + " seconds.");
        this.mainLog.println("Coalition results (initial state): (" + dArray[0][cSG.getFirstInitialState()] + "," + dArray[1][cSG.getFirstInitialState()] + ")");
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.numIters = n6;
        return modelCheckerResult;
    }

    /*
     * Unable to fully structure code
     */
    public ModelCheckerResult computeMultiBoundedEquilibria(CSG<Double> var1_1, List<Coalition> var2_2, List<CSGRewards<Double>> var3_3, List<ExpressionTemporal> var4_4, BitSet[] var5_5, BitSet[] var6_6, int[] var7_7, int var8_8, int var9_9, boolean var10_10) throws PrismException {
        this.mainLog.println("\n# Running bounded multi-player equilibria...\n");
        if (this.genStrat) {
            throw new PrismException("Strategy synthesis for bounded properties is not yet supported");
        }
        var11_11 = new ModelCheckerResult();
        var12_12 = null;
        var26_13 = -1;
        var13_14 = new double[var2_2.size()][var1_1.getNumStates()];
        var14_15 = new double[var2_2.size()][var1_1.getNumStates()];
        var15_16 = new double[var2_2.size()][var1_1.getNumStates()];
        var17_17 = new double[var1_1.getNumStates()];
        var22_18 = var3_3 != null;
        this.buildCoalitions(var1_1, var2_2);
        this.dominated = new BitSet[this.numCoalitions];
        this.dominating = new BitSet[this.numCoalitions];
        this.findMaxAvgAct(var1_1);
        if (var22_18) {
            var26_13 = var4_4.get(0).getOperator();
            for (var27_19 = 1; var27_19 < var4_4.size(); ++var27_19) {
                if (var26_13 == var4_4.get(var27_19).getOperator()) continue;
                throw new PrismException("Properties with mixed operators are not yet supported");
            }
            if (var26_13 == 11) {
                for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                    for (var25_21 = 0; var25_21 < var1_1.getNumStates(); ++var25_21) {
                        var13_14[var23_20][var25_21] = 0.0;
                    }
                }
            } else {
                for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                    for (var25_21 = 0; var25_21 < var1_1.getNumStates(); ++var25_21) {
                        var13_14[var23_20][var25_21] = var10_10 != false ? -1.0 * (Double)var3_3.get(var23_20).getStateReward(var25_21) : (Double)var3_3.get(var23_20).getStateReward(var25_21);
                    }
                }
            }
        } else {
            for (var25_21 = 0; var25_21 < var1_1.getNumStates(); ++var25_21) {
                for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                    if (!var5_5[var23_20].get(var25_21)) continue;
                    var13_14[var23_20][var25_21] = 1.0;
                }
            }
        }
        for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
            Arrays.fill(var15_16[var23_20], 0.0);
            Arrays.fill(var14_15[var23_20], 0.0);
        }
        switch (var8_8) {
            default: 
        }
        this.smtSupportEnumeration = new CSGSupportEnumerationZ3(this.maxNumActions, this.numCoalitions);
        this.smtSupportEnumeration.setIndexes(this.strategies);
        this.smtSupportEnumeration.setNumPlayers(this.numCoalitions);
        this.smtSupportEnumeration.init();
        var21_22 = true;
        var24_23 = 0;
        var19_24 = System.currentTimeMillis();
        while (true) {
            for (var25_21 = 0; var25_21 < var1_1.getNumStates(); ++var25_21) {
                var18_26 = null;
                switch (var8_8) {
                    case 2: {
                        if (!var22_18) break;
                        if (var26_13 == 11) {
                            var18_26 = this.stepCorrelatedEquilibria(var1_1, var3_3, var12_12, null, var13_14, var25_21, var10_10, var9_9);
                            break;
                        }
                        var18_26 = this.stepCorrelatedEquilibria(var1_1, null, var12_12, null, var13_14, var25_21, var10_10, var9_9);
                        break;
                    }
                    default: {
                        if (var22_18) {
                            if (var26_13 == 11) {
                                var16_25 = this.stepEquilibria(var1_1, var3_3, var12_12, null, var13_14, var25_21, var10_10);
                                this.addStateRewards(var16_25, var3_3, var25_21, var10_10);
                            } else {
                                var16_25 = this.stepEquilibria(var1_1, null, var12_12, null, var13_14, var25_21, var10_10);
                            }
                        } else {
                            var16_25 = this.stepEquilibria(var1_1, null, var12_12, null, var13_14, var25_21, var10_10);
                        }
                        var18_26 = this.swne(var16_25, null, var10_10);
                    }
                }
                for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                    var14_15[var23_20][var25_21] = var18_26[var23_20 + 1];
                }
            }
            for (var25_21 = 0; var25_21 < var1_1.getNumStates(); ++var25_21) {
                for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                    var13_14[var23_20][var25_21] = var14_15[var23_20][var25_21];
                }
                var17_17[var25_21] = 0.0;
                for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                    v0 = var25_21;
                    var17_17[v0] = var17_17[v0] + var13_14[var23_20][var25_21];
                }
            }
            for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                var21_22 &= PrismUtils.doublesAreClose(var13_14[var23_20], var15_16[var23_20], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            }
            if (var21_22 || ++var24_23 == var7_7[0]) break;
            if (!var21_22 && var24_23 == this.maxIters) {
                throw new PrismException("Could not converge after " + var24_23 + " iterations");
            }
            var21_22 = true;
            var23_20 = 0;
            while (true) {
                if (var23_20 >= this.numCoalitions) ** continue;
                var15_16[var23_20] = Arrays.copyOf(var13_14[var23_20], var13_14[var23_20].length);
                ++var23_20;
            }
            break;
        }
        var19_24 = System.currentTimeMillis() - var19_24;
        this.mainLog.println();
        for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
            this.mainLog.println("Result for coalition " + var2_2.get(var23_20) + ": " + var13_14[var23_20][var1_1.getFirstInitialState()] + " (value in the intial state).");
        }
        var17_17 = new double[var1_1.getNumStates()];
        for (var25_21 = 0; var25_21 < var1_1.getNumStates(); ++var25_21) {
            var17_17[var25_21] = 0.0;
            for (var23_20 = 0; var23_20 < this.numCoalitions; ++var23_20) {
                v1 = var25_21;
                var17_17[v1] = var17_17[v1] + var13_14[var23_20][var25_21];
            }
        }
        var11_11.soln = var17_17;
        var11_11.numIters = var24_23;
        var11_11.timeTaken = (double)var19_24 / 1000.0;
        return var11_11;
    }

    public boolean checkEquilibriumChange(double[][] dArray, double[] dArray2, int n) {
        boolean bl = true;
        for (int i = 0; i < this.numCoalitions; ++i) {
            boolean bl2 = bl = bl && Double.compare(dArray[i][n], dArray2[i + 1]) == 0;
            if (bl) continue;
            return true;
        }
        return false;
    }

    public void buildSubGames(Set<BitSet> set, BitSet bitSet, int n) {
        BitSet bitSet2 = new BitSet();
        bitSet2.set(n);
        set.add((BitSet)bitSet2.clone());
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            BitSet bitSet3 = new BitSet();
            bitSet3.or(bitSet2);
            bitSet3.set(n2);
            set.add(bitSet3);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
    }

    public void buildSubGames(Map<Integer, Set<BitSet>> map, BitSet bitSet, int n) {
        BitSet bitSet2 = new BitSet();
        bitSet2.set(n);
        map.get(bitSet2.cardinality()).add((BitSet)bitSet2.clone());
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            BitSet bitSet3 = new BitSet();
            bitSet3.or(bitSet2);
            bitSet3.set(n2);
            map.get(bitSet3.cardinality()).add(bitSet3);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
    }

    public ModelCheckerResult computeReachEquilibria(CSG<Double> cSG, List<Coalition> list, List<CSGRewards<Double>> list2, BitSet[] bitSetArray, BitSet[] bitSetArray2, int n, int n2, boolean bl) throws PrismException {
        int n3;
        long l;
        int n4;
        int n5;
        ModelCheckerResult[] modelCheckerResultArray = new ModelCheckerResult[list.size()];
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        ArrayList<List<List<Map<BitSet, Double>>>> arrayList = null;
        ArrayList<List<Map<BitSet, Double>>> arrayList2 = null;
        ArrayList<Map<Integer, BitSet>> arrayList3 = null;
        BitSet[] bitSetArray3 = new BitSet[bitSetArray.length];
        BitSet[] bitSetArray4 = new BitSet[3];
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        double[][] dArray = new double[list.size()][cSG.getNumStates()];
        double[][] dArray2 = new double[list.size()][cSG.getNumStates()];
        double[][] dArray3 = new double[list.size()][cSG.getNumStates()];
        double[] dArray4 = new double[cSG.getNumStates()];
        if (this.genStrat) {
            this.mdpmc.setGenStrat(true);
            arrayList3 = new ArrayList<Map<Integer, BitSet>>();
            arrayList2 = new ArrayList<List<Map<BitSet, Double>>>();
            arrayList = new ArrayList<List<List<Map<BitSet, Double>>>>();
            for (n5 = 0; n5 < list.size(); ++n5) {
                arrayList3.add(n5, new HashMap());
                arrayList.add(n5, new ArrayList());
                ((List)arrayList.get(n5)).add(0, new ArrayList());
                for (n4 = 0; n4 < cSG.getNumStates(); ++n4) {
                    ((List)((List)arrayList.get(n5)).get(0)).add(n4, null);
                }
            }
        }
        boolean bl2 = list2 != null;
        for (n5 = 0; n5 < bitSetArray.length; ++n5) {
            bitSetArray3[n5] = new BitSet();
            bitSetArray3[n5].or(bitSetArray[n5]);
            for (n4 = 0; n4 < bitSetArray.length; ++n4) {
                if (n5 == n4) continue;
                bitSetArray3[n5].andNot(bitSetArray[n4]);
            }
            bitSet.or(bitSetArray[n5]);
        }
        if (!bl2) {
            for (n5 = 0; n5 < 2; ++n5) {
                bitSetArray4[n5] = new BitSet();
                if (bitSetArray2[n5] == null) {
                    bitSetArray4[n5].set(0, cSG.getNumStates());
                    continue;
                }
                bitSetArray4[n5].or(bitSetArray2[n5]);
            }
            bitSetArray4[2] = new BitSet();
            bitSetArray4[2].or(bitSetArray4[0]);
            bitSetArray4[2].and(bitSetArray4[1]);
            bitSet2.clear();
            bitSet2.or(bitSetArray4[0]);
            bitSetArray4[0].andNot(bitSetArray4[1]);
            bitSetArray4[1].andNot(bitSet2);
            bitSet.or(bitSetArray4[0]);
            bitSet.or(bitSetArray4[1]);
            bitSet2.clear();
            bitSet2.set(0, cSG.getNumStates());
            bitSet2.andNot(bitSetArray4[2]);
            bitSet.or(bitSet2);
        }
        this.buildCoalitions(cSG, list);
        this.dominated = new BitSet[this.numCoalitions];
        this.dominating = new BitSet[this.numCoalitions];
        this.mainLog.println();
        this.findMaxRowsCols(cSG);
        this.mainLog.println("Starting equilibria computation (solver=" + this.setSolver(n) + ")...");
        this.mainLog.println("Checking whether all objctives are reachable...");
        if (this.assumptionCheck) {
            for (n5 = 0; n5 < bitSetArray.length; ++n5) {
                bitSet2.clear();
                if (!bl2 && bitSetArray2[n5] != null) {
                    bitSet2.or(bitSetArray2[n5]);
                    bitSet2.flip(0, cSG.getNumStates());
                    bitSet2.andNot(bitSetArray[n5]);
                }
                bitSet2.or(this.mdpmc.prob0(cSG, null, bitSetArray[n5], false, null));
                bitSet2.or(bitSetArray[n5]);
                if (this.mdpmc.prob1(cSG, null, bitSet2, true, null).cardinality() == cSG.getNumStates()) continue;
                throw new PrismException("At least one of the objectives is not reachable with probability 1 from all states");
            }
        }
        int n6 = 0;
        if (bl2) {
            l = System.currentTimeMillis();
            for (n5 = 0; n5 < bitSetArray.length; ++n5) {
                modelCheckerResultArray[n5] = this.mdpmc.computeReachRewards(cSG, (MDPRewards<Double>)list2.get(n5), bitSetArray[n5], bl);
                dArray2[n5] = modelCheckerResultArray[n5].soln;
            }
            l = System.currentTimeMillis() - l;
            for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                if (bitSetArray[0].get(n3) && bitSetArray[1].get(n3)) {
                    dArray[0][n3] = 0.0;
                    dArray[1][n3] = 0.0;
                    continue;
                }
                if (bitSetArray3[0].get(n3)) {
                    dArray[0][n3] = 0.0;
                    dArray[1][n3] = dArray2[1][n3];
                    continue;
                }
                if (!bitSetArray3[1].get(n3)) continue;
                dArray[0][n3] = dArray2[0][n3];
                dArray[1][n3] = 0.0;
            }
        } else {
            l = System.currentTimeMillis();
            for (n5 = 0; n5 < bitSetArray.length; ++n5) {
                modelCheckerResultArray[n5] = bitSetArray2[n5] != null ? this.mdpmc.computeUntilProbs(cSG, bitSetArray2[n5], bitSetArray[n5], bl) : this.mdpmc.computeReachProbs(cSG, bitSetArray[n5], bl);
                dArray2[n5] = modelCheckerResultArray[n5].soln;
            }
            l = System.currentTimeMillis() - l;
            for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                if (bitSetArray[0].get(n3) && bitSetArray[1].get(n3)) {
                    dArray[0][n3] = 1.0;
                    dArray[1][n3] = 1.0;
                    continue;
                }
                if (bitSetArray3[0].get(n3)) {
                    dArray[0][n3] = 1.0;
                    dArray[1][n3] = dArray2[1][n3];
                    continue;
                }
                if (bitSetArray3[1].get(n3)) {
                    dArray[0][n3] = dArray2[0][n3];
                    dArray[1][n3] = 1.0;
                    continue;
                }
                if (bitSetArray4[0].get(n3)) {
                    dArray[0][n3] = dArray2[0][n3];
                    dArray[1][n3] = 0.0;
                    continue;
                }
                if (bitSetArray4[1].get(n3)) {
                    dArray[0][n3] = 0.0;
                    dArray[1][n3] = dArray2[1][n3];
                    continue;
                }
                if (bitSetArray4[2].get(n3)) continue;
                dArray[0][n3] = 0.0;
                dArray[1][n3] = 0.0;
            }
        }
        this.mainLog.println();
        boolean bl3 = true;
        this.dominated = new BitSet[this.numCoalitions];
        this.dominating = new BitSet[this.numCoalitions];
        while (true) {
            block17: for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                int n7;
                if (bitSet.get(n3)) continue;
                if (this.genStrat) {
                    arrayList2 = new ArrayList();
                    arrayList3.clear();
                    for (n7 = 0; n7 < 2; ++n7) {
                        arrayList3.add(n7, new HashMap());
                    }
                }
                double[] dArray5 = this.stepEquilibriaTwoPlayer(cSG, list2, arrayList3, arrayList2, dArray, n3, n, n2, bl2, bl);
                dArray2[0][n3] = dArray5[1];
                dArray2[1][n3] = dArray5[2];
                if (!this.genStrat) continue;
                switch (n) {
                    case 2: {
                        if (((List)((List)arrayList.get(0)).get(0)).get(n3) == null) {
                            ((List)((List)arrayList.get(0)).get(0)).set(n3, (Map)((List)arrayList2.get(0)).get(0));
                            continue block17;
                        }
                        if (((Map)((List)((List)arrayList.get(0)).get(0)).get(n3)).equals(((List)arrayList2.get(0)).get(0)) || !this.checkEquilibriumChange(dArray, dArray5, n3)) continue block17;
                        ((List)((List)arrayList.get(0)).get(0)).set(n3, (Map)((List)arrayList2.get(0)).get(0));
                        continue block17;
                    }
                    default: {
                        for (n7 = 0; n7 < list.size(); ++n7) {
                            if (((List)((List)arrayList.get(n7)).get(0)).get(n3) == null) {
                                ((List)((List)arrayList.get(n7)).get(0)).set(n3, (Map)((List)arrayList2.get(0)).get(n7));
                                continue;
                            }
                            if (((Map)((List)((List)arrayList.get(0)).get(0)).get(n3)).equals(((List)arrayList2.get(0)).get(n7)) || !this.checkEquilibriumChange(dArray, dArray5, n3)) continue;
                            ((List)((List)arrayList.get(n7)).get(0)).set(n3, (Map)((List)arrayList2.get(0)).get(n7));
                        }
                    }
                }
            }
            for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                if (!bitSet.get(n3)) {
                    dArray[0][n3] = dArray2[0][n3];
                    dArray[1][n3] = dArray2[1][n3];
                }
                dArray4[n3] = dArray[0][n3] + dArray[1][n3];
            }
            bl3 &= PrismUtils.doublesAreClose(dArray[0], dArray3[0], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            if (bl3 &= PrismUtils.doublesAreClose(dArray[1], dArray3[1], this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE)) break;
            if (!bl3 && n6 == this.maxIters) {
                throw new PrismException("Could not converge after " + n6 + " iterations");
            }
            bl3 = true;
            dArray3[0] = Arrays.copyOf(dArray[0], dArray[0].length);
            dArray3[1] = Arrays.copyOf(dArray[1], dArray[1].length);
            ++n6;
        }
        this.mainLog.println("\nValue iteration converged after " + n6 + " iterations.");
        this.mainLog.println("\nPrecomputation took " + (double)l / 1000.0 + " seconds.");
        this.mainLog.println("Coalition results (initial state): (" + dArray[0][cSG.getFirstInitialState()] + "," + dArray[1][cSG.getFirstInitialState()] + ")");
        modelCheckerResult.soln = dArray4;
        if (this.genStrat) {
            switch (n) {
                case 2: {
                    if (bl2) {
                        modelCheckerResult.strat = new CSGStrategy(cSG, arrayList, modelCheckerResultArray, bitSetArray, CSGStrategy.CSGStrategyType.EQUILIBRIA_CE_R);
                        break;
                    }
                    modelCheckerResult.strat = new CSGStrategy(cSG, arrayList, modelCheckerResultArray, bitSetArray, CSGStrategy.CSGStrategyType.EQUILIBRIA_CE_P);
                    break;
                }
                default: {
                    modelCheckerResult.strat = bl2 ? new CSGStrategy(cSG, arrayList, modelCheckerResultArray, bitSetArray, CSGStrategy.CSGStrategyType.EQUILIBRIA_R) : new CSGStrategy(cSG, arrayList, modelCheckerResultArray, bitSetArray, CSGStrategy.CSGStrategyType.EQUILIBRIA_P);
                }
            }
        }
        modelCheckerResult.numIters = n6;
        return modelCheckerResult;
    }

    public double[] fair(double[][] dArray, List<List<Map<BitSet, Double>>> list, boolean bl) {
        int n;
        int n2;
        List<Map<BitSet, Double>> list3 = null;
        BitSet bitSet = new BitSet();
        double[] dArray2 = new double[this.numCoalitions + 1];
        double[][] dArray3 = new double[dArray.length][2];
        for (n2 = 0; n2 < this.numCoalitions; ++n2) {
            dArray2[0] = dArray2[0] + dArray[0][n2];
            dArray2[n2 + 1] = dArray[0][n2];
        }
        dArray3[0][0] = Arrays.stream(dArray[0]).max().getAsDouble();
        dArray3[0][1] = Arrays.stream(dArray[0]).min().getAsDouble();
        double d = dArray3[0][0] - dArray3[0][1];
        bitSet.set(0);
        if (list != null) {
            list3 = list.get(0);
        }
        for (n = 1; n < dArray.length; ++n) {
            dArray3[n][0] = Arrays.stream(dArray[n]).max().getAsDouble();
            dArray3[n][1] = Arrays.stream(dArray[n]).min().getAsDouble();
            if (Double.compare(dArray3[n][0] - dArray3[n][1], d) < 0) {
                d = dArray3[n][0] - dArray3[n][1];
                bitSet.clear();
                bitSet.set(n);
                continue;
            }
            if (Double.compare(dArray3[n][0] - dArray3[n][1], d) != 0) continue;
            bitSet.set(n);
        }
        if (bitSet.cardinality() == 1) {
            n = bitSet.nextSetBit(0);
            dArray2[0] = 0.0;
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                dArray2[0] = dArray2[0] + dArray[n][n2];
                dArray2[n2 + 1] = dArray[n][n2];
            }
            if (list != null) {
                list3 = list.get(n);
            }
            List<Map<BitSet, Double>> list4 = list3;
            if (list != null) {
                list.removeIf(list2 -> !list2.equals(list4));
            }
            if (bl) {
                for (n = 0; n < dArray2.length; ++n) {
                    dArray2[n] = -1.0 * dArray2[n];
                }
            }
            return dArray2;
        }
        double[][] dArray4 = new double[bitSet.cardinality()][this.numCoalitions];
        int n3 = 0;
        n = bitSet.nextSetBit(0);
        while (n >= 0) {
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                dArray4[n3][n2] = dArray[n][n2];
                if (list == null) continue;
                Collections.swap(list, n, n3);
            }
            ++n3;
            n = bitSet.nextSetBit(n + 1);
        }
        return this.swne(dArray4, list, bl);
    }

    public double[] swne(double[][] dArray, List<List<Map<BitSet, Double>>> list, boolean bl) {
        double d;
        int n;
        int n2;
        List<Map<BitSet, Double>> list3 = null;
        BitSet bitSet = new BitSet();
        double[] dArray2 = new double[this.numCoalitions + 1];
        dArray2[0] = 0.0;
        for (n2 = 0; n2 < this.numCoalitions; ++n2) {
            dArray2[0] = dArray2[0] + dArray[0][n2];
            dArray2[n2 + 1] = dArray[0][n2];
        }
        bitSet.set(0);
        if (list != null) {
            list3 = list.get(0);
        }
        for (n = 1; n < dArray.length; ++n) {
            d = 0.0;
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                d += dArray[n][n2];
            }
            if (Double.compare(d, dArray2[0]) > 0) {
                dArray2[0] = 0.0;
                for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                    dArray2[0] = dArray2[0] + dArray[n][n2];
                    dArray2[n2 + 1] = dArray[n][n2];
                }
                bitSet.clear();
                bitSet.set(n);
                if (list == null) continue;
                list3 = list.get(n);
                continue;
            }
            if (Double.compare(d, dArray2[0]) != 0) continue;
            bitSet.set(n);
        }
        if (bitSet.cardinality() != 1) {
            n = this.findMaxEqIndexes(bitSet, dArray, dArray2);
            d = 0.0;
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                d += dArray[n][n2];
                dArray2[n2 + 1] = dArray[n][n2];
            }
            dArray2[0] = d;
            if (list != null) {
                list3 = list.get(n);
            }
        }
        List<Map<BitSet, Double>> list4 = list3;
        if (list != null) {
            list.removeIf(list2 -> !list2.equals(list4));
        }
        if (bl) {
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = -1.0 * dArray2[i];
            }
        }
        return dArray2;
    }

    public int findMaxEqIndexes(BitSet bitSet, double[][] dArray, double[] dArray2) {
        int n;
        BitSet bitSet2 = new BitSet();
        BitSet[] bitSetArray = new BitSet[this.numCoalitions];
        for (n = 0; n < this.numCoalitions; ++n) {
            bitSetArray[n] = new BitSet();
            double d = dArray2[n + 1];
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (Double.compare(dArray[n2][n], d) > 0) {
                    bitSetArray[n].clear();
                    bitSetArray[n].set(n2);
                    d = dArray[n2][n];
                } else if (Double.compare(dArray[n2][n], d) == 0) {
                    bitSetArray[n].set(n2);
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        if (bitSetArray[0].cardinality() == 1) {
            int n3 = bitSetArray[0].nextSetBit(0);
            return n3;
        }
        bitSet2.or(bitSetArray[0]);
        for (n = 1; n < this.numCoalitions; ++n) {
            bitSet2.and(bitSetArray[n]);
            if (bitSet2.cardinality() != 1) continue;
            int n4 = bitSet2.nextSetBit(0);
            return n4;
        }
        int n5 = bitSetArray[0].nextSetBit(0);
        return n5;
    }

    public void addStateRewards(double[][] dArray, CSGRewards<Double> cSGRewards, CSGRewards<Double> cSGRewards2, int n, boolean bl) {
        for (int i = 0; i < dArray.length; ++i) {
            if (cSGRewards != null) {
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] + (bl ? -1.0 * (Double)cSGRewards.getStateReward(n) : (Double)cSGRewards.getStateReward(n));
            }
            if (cSGRewards2 == null) continue;
            double[] dArray3 = dArray[i];
            dArray3[1] = dArray3[1] + (bl ? -1.0 * (Double)cSGRewards2.getStateReward(n) : (Double)cSGRewards2.getStateReward(n));
        }
    }

    public void addStateRewards(double[][] dArray, List<CSGRewards<Double>> list, int n, boolean bl) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < this.numCoalitions; ++j) {
                if (list.get(j) == null) continue;
                double[] dArray2 = dArray[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + (bl ? -1.0 * (Double)list.get(j).getStateReward(n) : (Double)list.get(j).getStateReward(n));
            }
        }
    }

    public void addStateRewards(double[] dArray, List<CSGRewards<Double>> list, int n, boolean bl) {
        for (int i = 0; i < this.numCoalitions; ++i) {
            if (list.get(i) == null) continue;
            int n2 = i + 1;
            dArray[n2] = dArray[n2] + (bl ? -1.0 * (Double)list.get(i).getStateReward(n) : (Double)list.get(i).getStateReward(n));
        }
    }

    public double[] stepCorrelatedEquilibria(CSG<Double> cSG, List<CSGRewards<Double>> list, List<Map<Integer, BitSet>> list2, List<List<Map<BitSet, Double>>> list3, double[][] dArray, int n, boolean bl, int n2) throws PrismException {
        int n3;
        int n4;
        ArrayList arrayList = null;
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        double[] dArray2 = new double[this.numCoalitions + 1];
        this.buildStepGame(cSG, list, list2, dArray, n, bl);
        this.clear();
        this.computeAssertions();
        for (n4 = 0; n4 < this.numCoalitions; ++n4) {
            for (int i = 0; i < ((ArrayList)this.strategies.get(n4)).size(); ++i) {
                this.ceConstraints.get(n4).add(i, new HashMap());
                for (Pair object : this.assertions.get(n4).get(i)) {
                    BitSet bitSet3 = new BitSet();
                    bitSet3.or((BitSet)object.getKey());
                    this.ceConstraints.get(n4).get(i).put(bitSet3, (Double)object.second);
                }
            }
        }
        if (this.genStrat) {
            arrayList = new ArrayList();
            arrayList.add(new HashMap());
            bitSet2 = new BitSet();
        }
        if (this.utilities.size() == 1) {
            for (BitSet bitSet3 : this.utilities.keySet()) {
                for (n4 = 0; n4 < this.numCoalitions; ++n4) {
                    dArray2[0] = dArray2[0] + (Double)((ArrayList)this.utilities.get(bitSet3)).get(n4);
                    dArray2[n4 + 1] = (Double)((ArrayList)this.utilities.get(bitSet3)).get(n4);
                }
                if (!this.genStrat) continue;
                bitSet = new BitSet();
                for (n4 = 0; n4 < this.numCoalitions; ++n4) {
                    bitSet2.clear();
                    bitSet2.or(this.psupports.get(n4));
                    bitSet2.and(bitSet3);
                    n3 = bitSet2.nextSetBit(0);
                    bitSet.or(list2.get(n4).get(((ArrayList)this.strategies.get(n4)).indexOf(n3)));
                }
                ((Map)arrayList.get(0)).put(bitSet, 1.0);
            }
            if (this.genStrat) {
                list3.add(0, arrayList);
            }
        } else {
            EquilibriumResult equilibriumResult = this.ceSolver.computeEquilibrium(this.utilities, this.ceConstraints, this.strategies, this.ceVarMap, n2);
            if (equilibriumResult.getStatus() == CSGResultStatus.SAT) {
                dArray2[0] = 0.0;
                for (Double d : equilibriumResult.getPayoffVector()) {
                    dArray2[0] = dArray2[0] + d;
                }
                Arrays.fill(dArray2, 0.0);
                for (n4 = 0; n4 < this.numCoalitions; ++n4) {
                    dArray2[n4 + 1] = equilibriumResult.getPayoffVector().get(n4);
                }
                for (BitSet bitSet4 : this.ceVarMap.keySet()) {
                    if (!this.genStrat) continue;
                    bitSet = new BitSet();
                    for (n4 = 0; n4 < this.numCoalitions; ++n4) {
                        bitSet2.clear();
                        bitSet2.or(this.psupports.get(n4));
                        bitSet2.and(bitSet4);
                        n3 = bitSet2.nextSetBit(0);
                        bitSet.or(list2.get(n4).get(((ArrayList)this.strategies.get(n4)).indexOf(n3)));
                    }
                    if (Double.compare(equilibriumResult.getStrategy().get(0).get(this.ceVarMap.get(bitSet4)), 0.0) <= 0) continue;
                    ((Map)arrayList.get(0)).put(bitSet, equilibriumResult.getStrategy().get(0).get(this.ceVarMap.get(bitSet4)));
                }
                if (this.genStrat) {
                    list3.add(0, arrayList);
                }
            } else {
                throw new PrismException(this.ceSolver.getSolverName() + " could not find an optimal solution for state " + n);
            }
        }
        if (list != null) {
            this.addStateRewards(dArray2, list, n, bl);
        }
        if (bl) {
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                dArray2[n3] = -1.0 * dArray2[n3];
            }
        }
        return dArray2;
    }

    public double[][] stepEquilibria(CSG<Double> cSG, List<CSGRewards<Double>> list, List<Map<Integer, BitSet>> list2, List<List<Map<BitSet, Double>>> list3, double[][] dArray, int n, boolean bl) throws PrismException {
        int n2;
        ArrayList<ArrayList<Double>> arrayList = new ArrayList<ArrayList<Double>>();
        ArrayList<Map<BitSet, Double>> arrayList2 = null;
        this.buildStepGame(cSG, list, list2, dArray, n, bl);
        BitSet bitSet = cSG.getConcurrentPlayers(n);
        long l = System.currentTimeMillis();
        if (bitSet.cardinality() == 1) {
            return this.findSWNEOnePlayer(list2, list3, arrayList2, bitSet);
        }
        this.clear();
        this.computeAssertions();
        for (n2 = 0; n2 < this.numCoalitions; ++n2) {
            this.dominated[n2] = this.findDominated(n2);
            this.dominating[n2] = this.findDominating(n2);
        }
        this.buildAllSupports();
        if (this.checkAllZeroEntries()) {
            double[][] dArray2 = new double[1][this.numCoalitions];
            Arrays.fill(dArray2[0], 0.0);
            if (this.genStrat) {
                arrayList2 = new ArrayList<Map<BitSet, Double>>();
                this.extractStrategyFromSupport(list2, arrayList2, (BitSet)this.utilities.keySet().toArray()[0]);
                list3.add(arrayList2);
            }
            return dArray2;
        }
        if (this.utilities.size() == 1) {
            return this.findSWNEUniqueSupport(list2, list3, arrayList2);
        }
        this.smtSupportEnumeration.translateAssertions(this.assertions, this.mapActionIndex);
        if (this.allSupports.size() == 1) {
            return this.findSWNEUniqueSupport(list2, list3, arrayList2);
        }
        HashSet<BitSet> hashSet = new HashSet<BitSet>();
        HashSet<BitSet> hashSet2 = new HashSet<BitSet>();
        HashSet<BitSet> hashSet3 = new HashSet<BitSet>();
        for (BitSet bitSet2 : this.allSupports) {
            if (bitSet2.cardinality() < this.numCoalitions) {
                this.mainLog.println("Support: " + bitSet2);
                for (int i = 0; i < this.numCoalitions; ++i) {
                    this.mainLog.println("Player " + i);
                    this.mainLog.println("Dominating: " + this.dominating[i]);
                    this.mainLog.println("Dominated: " + this.dominated[i]);
                    this.mainLog.println("Action indexes: " + this.actionIndexes[i]);
                    this.mainLog.println("Strategies:" + this.strategies.get(i));
                    this.mainLog.println("Supports:" + this.supports.get(i));
                }
                throw new PrismException("Problem with support");
            }
            EquilibriumResult equilibriumResult = this.smtSupportEnumeration.computeEquilibria(bitSet2, this.mapActionIndex);
            if (equilibriumResult.getStatus() == CSGResultStatus.SAT) {
                hashSet3.add(bitSet2);
                arrayList.add(equilibriumResult.getPayoffVector());
                if (!this.genStrat) continue;
                list3.add(this.extractStrategyFromEquilibrium(equilibriumResult, list2));
                continue;
            }
            if (equilibriumResult.getStatus() == CSGResultStatus.UNKNOWN) {
                hashSet.add(bitSet2);
                continue;
            }
            if (equilibriumResult.getStatus() != CSGResultStatus.UNSAT) continue;
            hashSet2.add(bitSet2);
        }
        if (hashSet3.size() != 0) {
            // empty if block
        }
        if (hashSet.size() != 0) {
            // empty if block
        }
        double[][] dArray3 = new double[arrayList.size()][this.numCoalitions];
        for (int i = 0; i < arrayList.size(); ++i) {
            for (n2 = 0; n2 < this.numCoalitions; ++n2) {
                dArray3[i][n2] = (Double)((ArrayList)arrayList.get(i)).get(n2);
            }
        }
        return dArray3;
    }

    public double[] stepEquilibriaTwoPlayer(CSG<Double> cSG, List<CSGRewards<Double>> list, List<Map<Integer, BitSet>> list2, List<List<Map<BitSet, Double>>> list3, double[][] dArray, int n, int n2, int n3, boolean bl, boolean bl2) throws PrismException {
        double[] dArray2;
        block0 : switch (n2) {
            case 2: {
                if (bl) {
                    dArray2 = this.stepCorrelatedEquilibria(cSG, list, list2, list3, dArray, n, bl2, n3);
                    break;
                }
                dArray2 = this.stepCorrelatedEquilibria(cSG, null, list2, list3, dArray, n, bl2, n3);
                break;
            }
            default: {
                double[][] dArray3 = bl ? this.stepNashEquilibria(cSG, list.get(0), list.get(1), list2, list3, dArray, n, bl2) : this.stepNashEquilibria(cSG, null, null, list2, list3, dArray, n, bl2);
                switch (n3) {
                    case 4: {
                        dArray2 = this.fair(dArray3, list3, bl2);
                        break block0;
                    }
                }
                dArray2 = this.swne(dArray3, list3, bl2);
            }
        }
        return dArray2;
    }

    public double[][] stepNashEquilibria(CSG<Double> cSG, CSGRewards<Double> cSGRewards, CSGRewards<Double> cSGRewards2, List<Map<Integer, BitSet>> list, List<List<Map<BitSet, Double>>> list2, double[][] dArray, int n, boolean bl) throws PrismException {
        double[][] dArray2;
        int n2;
        HashMap<BitSet, Double> hashMap = null;
        HashMap<BitSet, Double> hashMap2 = null;
        list = new ArrayList<Map<Integer, BitSet>>();
        ArrayList<ArrayList<Integer>> arrayList = new ArrayList<ArrayList<Integer>>();
        for (n2 = 0; n2 < 2; ++n2) {
            list.add(n2, new HashMap());
            arrayList.add(n2, new ArrayList());
        }
        ArrayList<ArrayList<ArrayList<Double>>> arrayList2 = this.buildBimatrixGame(cSG, cSGRewards, cSGRewards2, list, arrayList, dArray, n, bl);
        int n3 = arrayList2.get(0).size();
        int n4 = arrayList2.get(0).get(0).size();
        double[][] dArray3 = new double[n3][n4];
        double[][] dArray4 = new double[n3][n4];
        if (n3 > 1 && n4 > 1) {
            int n5;
            boolean bl2 = true;
            boolean bl3 = true;
            double d = arrayList2.get(0).get(0).get(0);
            double d2 = arrayList2.get(1).get(0).get(0);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n5 = 0; n5 < n4; ++n5) {
                    double d3 = arrayList2.get(0).get(n2).get(n5);
                    double d4 = arrayList2.get(1).get(n2).get(n5);
                    bl2 = bl2 && Double.compare(d, d3) == 0;
                    bl3 = bl3 && Double.compare(d2, d4) == 0;
                    dArray3[n2][n5] = d3;
                    dArray4[n2][n5] = d4;
                }
            }
            if (!bl2 || !bl3) {
                if (bl2 || bl3) {
                    int n6;
                    int n7;
                    dArray2 = new double[1][2];
                    if (bl2) {
                        int[] nArray = this.findMaxIndexes(dArray4);
                        n7 = nArray[0];
                        n6 = nArray[1];
                    } else {
                        int[] nArray = this.findMaxIndexes(dArray3);
                        n7 = nArray[0];
                        n6 = nArray[1];
                    }
                    dArray2[0][0] = dArray3[n7][n6];
                    dArray2[0][1] = dArray4[n7][n6];
                    if (this.genStrat) {
                        ArrayList arrayList3 = new ArrayList();
                        arrayList3.add(0, new HashMap());
                        ((Map)arrayList3.get(0)).put(list.get(0).get(arrayList.get(0).get(n7)), 1.0);
                        arrayList3.add(1, new HashMap());
                        ((Map)arrayList3.get(1)).put(list.get(1).get(arrayList.get(1).get(n6)), 1.0);
                        list2.add(0, arrayList3);
                    }
                    this.addStateRewards(dArray2, cSGRewards, cSGRewards2, n, bl);
                } else {
                    this.smtLabeleldPolytopes.update(n3, n4, dArray3, dArray4);
                    this.smtLabeleldPolytopes.computeEquilibria();
                    this.smtLabeleldPolytopes.compPayoffs();
                    dArray2 = new double[this.smtLabeleldPolytopes.getNeq()][2];
                    for (n2 = 0; n2 < this.smtLabeleldPolytopes.getNeq(); ++n2) {
                        dArray2[n2][0] = this.smtLabeleldPolytopes.getP1p()[n2];
                        dArray2[n2][1] = this.smtLabeleldPolytopes.getP2p()[n2];
                        if (!this.genStrat) continue;
                        ArrayList arrayList4 = new ArrayList();
                        for (n5 = 0; n5 < 2; ++n5) {
                            arrayList4.add(n5, new HashMap());
                            for (int n8 : this.smtLabeleldPolytopes.getStrat().get(n2).get(n5).getSupport()) {
                                ((Map)arrayList4.get(n5)).put(list.get(n5).get(arrayList.get(n5).get(n8)), this.smtLabeleldPolytopes.getStrat().get(n2).get(n5).get(n8));
                            }
                        }
                        list2.add(n2, arrayList4);
                    }
                    this.addStateRewards(dArray2, cSGRewards, cSGRewards2, n, bl);
                }
            } else {
                dArray2 = new double[1][2];
                dArray2[0][0] = d;
                dArray2[0][1] = d2;
                if (this.genStrat) {
                    ArrayList arrayList5 = new ArrayList();
                    arrayList5.add(0, new HashMap());
                    ((Map)arrayList5.get(0)).put(list.get(0).get(arrayList.get(0).get(0)), 1.0);
                    arrayList5.add(1, new HashMap());
                    ((Map)arrayList5.get(1)).put(list.get(1).get(arrayList.get(0).get(0)), 1.0);
                    list2.add(0, arrayList5);
                }
                this.addStateRewards(dArray2, cSGRewards, cSGRewards2, n, bl);
            }
        } else {
            dArray2 = new double[1][2];
            if (this.genStrat) {
                hashMap = new HashMap<BitSet, Double>();
                hashMap2 = new HashMap<BitSet, Double>();
            }
            double d = Double.NEGATIVE_INFINITY;
            double d5 = Double.NEGATIVE_INFINITY;
            double d6 = Double.NEGATIVE_INFINITY;
            if (n3 > 1 && n4 == 1) {
                for (int i = 0; i < n3; ++i) {
                    double d7 = arrayList2.get(0).get(i).get(0);
                    double d8 = arrayList2.get(1).get(i).get(0);
                    double d9 = d7 + d8;
                    if (Double.compare(d7, d) <= 0 && (Double.compare(d7, d) != 0 || Double.compare(d9, d6) <= 0)) continue;
                    if (this.genStrat) {
                        hashMap.clear();
                        hashMap.put(list.get(0).get(arrayList.get(0).get(i)), 1.0);
                    }
                    d5 = d8;
                    d = d7;
                    d6 = d + d5;
                }
                if (this.genStrat) {
                    hashMap2.put(list.get(1).get(arrayList.get(1).get(0)), 1.0);
                }
            } else if (n3 == 1 && n4 > 1) {
                for (int i = 0; i < n4; ++i) {
                    double d10 = arrayList2.get(0).get(0).get(i);
                    double d11 = arrayList2.get(1).get(0).get(i);
                    double d12 = d10 + d11;
                    if (Double.compare(d11, d5) <= 0 && (Double.compare(d11, d5) != 0 || Double.compare(d12, d6) <= 0)) continue;
                    if (this.genStrat) {
                        hashMap2.clear();
                        hashMap2.put(list.get(1).get(arrayList.get(1).get(i)), 1.0);
                    }
                    d5 = d11;
                    d = d10;
                    d6 = d + d5;
                }
                if (this.genStrat) {
                    hashMap.put(list.get(0).get(arrayList.get(0).get(0)), 1.0);
                }
            } else if (n3 == 1 && n4 == 1) {
                d = arrayList2.get(0).get(0).get(0);
                d5 = arrayList2.get(1).get(0).get(0);
                if (this.genStrat) {
                    hashMap.put(list.get(0).get(arrayList.get(0).get(0)), 1.0);
                    hashMap2.put(list.get(1).get(arrayList.get(1).get(0)), 1.0);
                }
            } else {
                throw new PrismException("Error with matrix rank");
            }
            if (this.genStrat) {
                ArrayList<HashMap<BitSet, Double>> arrayList6 = new ArrayList<HashMap<BitSet, Double>>();
                arrayList6.add(0, hashMap);
                arrayList6.add(1, hashMap2);
                list2.add(0, arrayList6);
            }
            dArray2[0][0] = d;
            dArray2[0][1] = d5;
            this.addStateRewards(dArray2, cSGRewards, cSGRewards2, n, bl);
        }
        return dArray2;
    }

    public static enum CSGResultStatus {
        SAT,
        UNKNOWN,
        UNSAT;

    }
}

