/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import com.microsoft.z3.AlgebraicNum;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.Model;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import com.microsoft.z3.Version;
import explicit.CSGLabeledPolytopes;
import explicit.Distribution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import prism.PrismException;

public class CSGLabeledPolytopesZ3Stack
implements CSGLabeledPolytopes {
    private String solverName = "Z3";
    private RealExpr[] payvars;
    private ArithExpr[] payoffs;
    private RealExpr[] vars;
    private RealExpr[] p1vars;
    private RealExpr[] p2vars;
    private IntExpr zero;
    private IntExpr one;
    private BoolExpr ytrue;
    private BoolExpr yfalse;
    private BoolExpr[] xlabels;
    private BoolExpr[] ylabels;
    private ArithExpr[] xexps;
    private ArithExpr[] yexps;
    private ArithExpr curr;
    private BoolExpr eq;
    private int nrows = 0;
    private int ncols = 0;
    private BoolExpr[] tmpc;
    private BoolExpr[] tmpr;
    private Model model;
    private Expr xctr;
    private Expr yctr;
    private BoolExpr c1;
    private BoolExpr c2;
    private int neq = 0;
    private double[] p1p;
    private double[] p2p;
    private double[][] a;
    private double[][] b;
    private String[] lvp1;
    private String[] lvp2;
    private Context ctx;
    private Solver s;
    private HashMap<String, ArrayList<Double>> eqs;
    private ArrayList<ArrayList<Distribution<Double>>> strat;

    public CSGLabeledPolytopesZ3Stack(int n, int n2) throws PrismException {
        int n3;
        this.initSolver();
        this.s = this.ctx.mkSolver();
        this.eqs = new HashMap();
        this.zero = this.ctx.mkInt(0);
        this.one = this.ctx.mkInt(1);
        this.vars = new RealExpr[n + n2];
        this.lvp1 = new String[n];
        this.lvp2 = new String[n2];
        this.tmpc = new BoolExpr[n2 - 1];
        this.tmpr = new BoolExpr[n - 1];
        this.xlabels = new BoolExpr[n + n2];
        this.ylabels = new BoolExpr[n + n2];
        this.yexps = new ArithExpr[n];
        this.xexps = new ArithExpr[n2];
        this.xctr = this.zero;
        this.yctr = this.zero;
        this.ytrue = this.ctx.mkTrue();
        this.yfalse = this.ctx.mkFalse();
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            this.vars[n3] = this.ctx.mkRealConst("x" + n3);
            this.lvp1[n3] = "x_" + n3;
        }
        while (n4 < n2) {
            this.vars[n3] = this.ctx.mkRealConst("y" + n4);
            this.lvp2[n4] = "y_" + n4;
            ++n3;
            ++n4;
        }
        for (RealExpr realExpr : this.vars) {
            this.s.add(new Expr[]{this.ctx.mkLe((Expr)realExpr, (Expr)this.one)});
            this.s.add(new Expr[]{this.ctx.mkGe((Expr)realExpr, (Expr)this.zero)});
        }
    }

    private void initSolver() throws PrismException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("model", "true");
        hashMap.put("auto_config", "true");
        try {
            this.ctx = new Context(hashMap);
            this.solverName = Version.getFullVersion();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new PrismException("Could not initialise Z3: " + unsatisfiedLinkError.getMessage());
        }
    }

    @Override
    public void update(int n, int n2, double[][] dArray, double[][] dArray2) {
        this.nrows = n;
        this.ncols = n2;
        this.a = dArray;
        this.b = dArray2;
    }

    private void xLabels() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrows + this.ncols; ++i) {
            int n3;
            if (i < this.nrows) {
                this.xlabels[i] = this.ctx.mkEq((Expr)this.vars[i], (Expr)this.zero);
                continue;
            }
            for (n3 = 0; n3 < this.ncols; ++n3) {
                if (n2 == n3) continue;
                this.tmpc[n] = this.ctx.mkGe((Expr)this.xexps[n2], (Expr)this.xexps[n3]);
                ++n;
            }
            this.xlabels[i] = this.tmpc[0];
            if (this.ncols - 1 > 1) {
                for (n3 = 1; n3 < this.ncols - 1; ++n3) {
                    this.xlabels[i] = this.ctx.mkAnd(new Expr[]{this.xlabels[i], this.tmpc[n3]});
                }
            }
            ++n2;
            n = 0;
        }
    }

    private void yLabels() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrows + this.ncols; ++i) {
            if (i < this.nrows) {
                int n3;
                for (n3 = 0; n3 < this.nrows; ++n3) {
                    if (n2 == n3) continue;
                    this.tmpr[n] = this.ctx.mkGe((Expr)this.yexps[n2], (Expr)this.yexps[n3]);
                    ++n;
                }
                this.ylabels[i] = this.tmpr[0];
                if (this.nrows - 1 > 1) {
                    for (n3 = 1; n3 < this.nrows - 1; ++n3) {
                        this.ylabels[i] = this.ctx.mkAnd(new Expr[]{this.ylabels[i], this.tmpr[n3]});
                    }
                }
                ++n2;
                n = 0;
                continue;
            }
            this.ylabels[i] = this.ctx.mkEq((Expr)this.vars[i], (Expr)this.zero);
        }
    }

    private void vMult() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.curr = this.zero;
            for (n = 0; n < this.ncols; ++n) {
                try {
                    this.curr = this.ctx.mkAdd(new Expr[]{this.curr, this.ctx.mkMul(new Expr[]{this.vars[this.nrows + n], this.ctx.mkReal(String.valueOf(this.a[n2][n]))})});
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(this.a[n2][n]);
                    System.out.println(String.valueOf(this.a[n2][n]));
                    exception.printStackTrace();
                }
            }
            this.yexps[n2] = this.curr;
        }
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.curr = this.zero;
            for (n = 0; n < this.nrows; ++n) {
                try {
                    this.curr = this.ctx.mkAdd(new Expr[]{this.curr, this.ctx.mkMul(new Expr[]{this.vars[n], this.ctx.mkReal(String.valueOf(this.b[n][n2]))})});
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(this.a[n][n2]);
                    System.out.println(String.valueOf(this.a[n][n2]));
                    exception.printStackTrace();
                }
            }
            this.xexps[n2] = this.curr;
        }
    }

    @Override
    public void computeEquilibria() {
        int n;
        int n2;
        this.vMult();
        this.xLabels();
        this.yLabels();
        this.s.push();
        this.eq = this.ytrue;
        this.xctr = this.zero;
        this.yctr = this.zero;
        for (n2 = 0; n2 < this.nrows + this.ncols; ++n2) {
            this.eq = this.ctx.mkAnd(new Expr[]{this.eq, this.ctx.mkOr(new Expr[]{this.xlabels[n2], this.ylabels[n2]})});
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.xctr = this.ctx.mkAdd(new Expr[]{(ArithExpr)this.xctr, this.vars[n2]});
        }
        this.xctr = this.ctx.mkEq(this.xctr, (Expr)this.one);
        for (n = n2; n < this.nrows + this.ncols; ++n) {
            this.yctr = this.ctx.mkAdd(new Expr[]{(ArithExpr)this.yctr, this.vars[n]});
        }
        this.yctr = this.ctx.mkEq(this.yctr, (Expr)this.one);
        this.s.add(new Expr[]{(BoolExpr)this.xctr});
        this.s.add(new Expr[]{(BoolExpr)this.yctr});
        this.s.add(new Expr[]{this.eq});
        this.strat = new ArrayList();
        this.eqs.clear();
        n = 0;
        while (Status.SATISFIABLE == this.s.check()) {
            this.model = this.s.getModel();
            this.c1 = this.ytrue;
            this.c2 = this.ytrue;
            ArrayList arrayList = new ArrayList();
            Distribution<Double> distribution = new Distribution<Double>();
            Distribution<Double> distribution2 = new Distribution<Double>();
            for (n2 = 0; n2 < this.nrows + this.ncols; ++n2) {
                double d = this.getDoubleValue(this.model, (Expr)this.vars[n2]);
                if (d > 0.0) {
                    if (n2 < this.nrows) {
                        distribution.add(n2, d);
                    } else {
                        distribution2.add(n2 - this.nrows, d);
                    }
                }
                if (n == 0) {
                    if (n2 < this.nrows) {
                        this.eqs.put(this.lvp1[n2], new ArrayList());
                        this.eqs.get(this.lvp1[n2]).add(d);
                        continue;
                    }
                    this.eqs.put(this.lvp2[n2 - this.nrows], new ArrayList());
                    this.eqs.get(this.lvp2[n2 - this.nrows]).add(d);
                    continue;
                }
                if (n2 < this.nrows) {
                    this.eqs.get(this.lvp1[n2]).add(d);
                    continue;
                }
                this.eqs.get(this.lvp2[n2 - this.nrows]).add(d);
            }
            for (n2 = 0; n2 < this.nrows + this.ncols; ++n2) {
                if (n2 < this.nrows) {
                    if (Double.compare(this.eqs.get(this.lvp1[n2]).get(n), 0.0) != 0) {
                        this.c1 = this.ctx.mkAnd(new Expr[]{this.c1, this.ctx.mkNot((Expr)this.ctx.mkEq((Expr)this.vars[n2], (Expr)this.zero))});
                        continue;
                    }
                    this.c1 = this.ctx.mkAnd(new Expr[]{this.c1, this.ctx.mkEq((Expr)this.vars[n2], (Expr)this.zero)});
                    continue;
                }
                this.c2 = Double.compare(this.eqs.get(this.lvp2[n2 - this.nrows]).get(n), 0.0) != 0 ? this.ctx.mkAnd(new Expr[]{this.c2, this.ctx.mkNot((Expr)this.ctx.mkEq((Expr)this.vars[n2], (Expr)this.zero))}) : this.ctx.mkAnd(new Expr[]{this.c2, this.ctx.mkEq((Expr)this.vars[n2], (Expr)this.zero)});
            }
            arrayList.add(0, distribution);
            arrayList.add(1, distribution2);
            this.strat.add(n, arrayList);
            ++n;
            this.s.add(new Expr[]{this.ctx.mkOr(new Expr[]{this.ctx.mkNot((Expr)this.c1), this.ctx.mkNot((Expr)this.c2)})});
        }
        this.s.pop();
        this.neq = n;
    }

    @Override
    public void compPayoffs() {
        this.p1p = new double[this.neq];
        this.p2p = new double[this.neq];
        Arrays.fill(this.p1p, 0.0);
        Arrays.fill(this.p2p, 0.0);
        for (int i = 0; i < this.neq; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                for (int k = 0; k < this.ncols; ++k) {
                    int n = i;
                    this.p1p[n] = this.p1p[n] + this.eqs.get(this.lvp1[j]).get(i) * this.eqs.get(this.lvp2[k]).get(i) * this.a[j][k];
                    int n2 = i;
                    this.p2p[n2] = this.p2p[n2] + this.eqs.get(this.lvp1[j]).get(i) * this.eqs.get(this.lvp2[k]).get(i) * this.b[j][k];
                }
            }
        }
    }

    public double getDoubleValue(Model model, Expr expr) {
        if (model.getConstInterp(expr) instanceof RatNum) {
            RatNum ratNum = (RatNum)model.getConstInterp(expr);
            return ratNum.getBigIntNumerator().doubleValue() / ratNum.getBigIntDenominator().doubleValue();
        }
        if (model.getConstInterp(expr) instanceof AlgebraicNum) {
            AlgebraicNum algebraicNum = (AlgebraicNum)model.getConstInterp(expr);
            RatNum ratNum = algebraicNum.toUpper(12);
            return ratNum.getBigIntNumerator().doubleValue() / ratNum.getBigIntDenominator().doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public String getSolverName() {
        return this.solverName;
    }

    @Override
    public ArrayList<ArrayList<Distribution<Double>>> getStrat() {
        return this.strat;
    }

    @Override
    public double[] getP1p() {
        return this.p1p;
    }

    @Override
    public double[] getP2p() {
        return this.p2p;
    }

    @Override
    public int getNeq() {
        return this.neq;
    }

    public void clear() {
    }
}

