/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import com.sri.yices.Config;
import com.sri.yices.Context;
import com.sri.yices.Model;
import com.sri.yices.Status;
import com.sri.yices.Terms;
import com.sri.yices.Yices;
import explicit.CSGLabeledPolytopes;
import explicit.Distribution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import prism.PrismException;

public class CSGLabeledPolytopesYicesStack
implements CSGLabeledPolytopes {
    private String solverName = "Yices";
    private Context ctx;
    private int realType;
    private int boolType;
    private int zero;
    private int one;
    private int ytrue;
    private int yfalse;
    private int eq;
    private int curr;
    private int[] xlabels;
    private int[] ylabels;
    private int[] vars;
    private int[] xexps;
    private int[] yexps;
    private int[] tmpc;
    private int[] tmpr;
    private Model model;
    private int xctr;
    private int yctr;
    private int c1;
    private int c2;
    private String[] lvp1;
    private String[] lvp2;
    private double[][] a;
    private double[][] b;
    private double[] p1p;
    private double[] p2p;
    private int neq;
    private int nrows;
    private int ncols;
    private HashMap<String, ArrayList<Double>> eqs;
    private ArrayList<ArrayList<Distribution<Double>>> strat;
    protected String eqPolicy;

    public CSGLabeledPolytopesYicesStack() throws PrismException {
        this.initSolver();
    }

    public CSGLabeledPolytopesYicesStack(int n, int n2) throws PrismException {
        int n3;
        this.initSolver();
        this.eqs = new HashMap();
        this.realType = Yices.realType();
        this.boolType = Yices.boolType();
        this.zero = Terms.intConst((long)0L);
        this.one = Terms.intConst((long)1L);
        this.vars = new int[n + n2];
        this.lvp1 = new String[n];
        this.lvp2 = new String[n2];
        this.tmpc = new int[n2 - 1];
        this.tmpr = new int[n - 1];
        this.xlabels = new int[n + n2];
        this.ylabels = new int[n + n2];
        this.yexps = new int[n];
        this.xexps = new int[n2];
        this.xctr = this.zero;
        this.yctr = this.zero;
        this.ytrue = Yices.mkTrue();
        this.yfalse = Yices.mkFalse();
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            this.vars[n3] = Terms.newUninterpretedTerm((int)this.realType);
            this.lvp1[n3] = "x_" + n3;
        }
        while (n4 < n2) {
            this.vars[n3] = Terms.newUninterpretedTerm((int)this.realType);
            this.lvp2[n4] = "y_" + n4;
            ++n3;
            ++n4;
        }
        for (int n5 : this.vars) {
            this.ctx.assertFormula(Terms.arithLeq((int)n5, (int)this.one));
            this.ctx.assertFormula(Terms.arithGeq((int)n5, (int)this.zero));
        }
    }

    public void clear() throws PrismException {
        int n;
        this.initSolver();
        this.eqs = new HashMap();
        this.realType = Yices.realType();
        this.boolType = Yices.boolType();
        this.zero = Terms.intConst((long)0L);
        this.one = Terms.intConst((long)1L);
        this.vars = new int[this.nrows + this.ncols];
        this.lvp1 = new String[this.nrows];
        this.lvp2 = new String[this.ncols];
        this.tmpc = new int[this.ncols - 1];
        this.tmpr = new int[this.nrows - 1];
        this.xlabels = new int[this.nrows + this.ncols];
        this.ylabels = new int[this.nrows + this.ncols];
        this.yexps = new int[this.nrows];
        this.xexps = new int[this.ncols];
        this.xctr = this.zero;
        this.yctr = this.zero;
        this.ytrue = Yices.mkTrue();
        this.yfalse = Yices.mkFalse();
        int n2 = 0;
        for (n = 0; n < this.nrows; ++n) {
            this.vars[n] = Terms.newUninterpretedTerm((int)this.realType);
            this.lvp1[n] = "x_" + n;
        }
        while (n2 < this.ncols) {
            this.vars[n] = Terms.newUninterpretedTerm((int)this.realType);
            this.lvp2[n2] = "y_" + n2;
            ++n;
            ++n2;
        }
        for (int n3 : this.vars) {
            this.ctx.assertFormula(Terms.arithLeq((int)n3, (int)this.one));
            this.ctx.assertFormula(Terms.arithGeq((int)n3, (int)this.zero));
        }
    }

    private void initSolver() throws PrismException {
        try {
            Config config = new Config("QF_LRA");
            config.set("mode", "push-pop");
            this.ctx = new Context(config);
            config.close();
            this.solverName = "Yices " + Yices.version();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new PrismException("Could not initialise Yices: " + unsatisfiedLinkError.getMessage());
        }
    }

    @Override
    public String getSolverName() {
        return this.solverName;
    }

    @Override
    public void update(int n, int n2, double[][] dArray, double[][] dArray2) {
        this.nrows = n;
        this.ncols = n2;
        this.a = dArray;
        this.b = dArray2;
    }

    private void xLabels() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrows + this.ncols; ++i) {
            int n3;
            if (i < this.nrows) {
                this.xlabels[i] = Terms.arithEq((int)this.vars[i], (int)this.zero);
                continue;
            }
            for (n3 = 0; n3 < this.ncols; ++n3) {
                if (n2 == n3) continue;
                this.tmpc[n] = Terms.arithGeq((int)this.xexps[n2], (int)this.xexps[n3]);
                ++n;
            }
            this.xlabels[i] = this.tmpc[0];
            if (this.ncols - 1 > 1) {
                for (n3 = 1; n3 < this.ncols - 1; ++n3) {
                    this.xlabels[i] = Terms.and((int[])new int[]{this.xlabels[i], this.tmpc[n3]});
                }
            }
            ++n2;
            n = 0;
        }
    }

    private void yLabels() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nrows + this.ncols; ++i) {
            if (i < this.nrows) {
                int n3;
                for (n3 = 0; n3 < this.nrows; ++n3) {
                    if (n2 == n3) continue;
                    this.tmpr[n] = Terms.arithGeq((int)this.yexps[n2], (int)this.yexps[n3]);
                    ++n;
                }
                this.ylabels[i] = this.tmpr[0];
                if (this.nrows - 1 > 1) {
                    for (n3 = 1; n3 < this.nrows - 1; ++n3) {
                        this.ylabels[i] = Terms.and((int[])new int[]{this.ylabels[i], this.tmpr[n3]});
                    }
                }
                ++n2;
                n = 0;
                continue;
            }
            this.ylabels[i] = Terms.arithEq((int)this.vars[i], (int)this.zero);
        }
    }

    private void vMult() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.curr = this.zero;
            for (n = 0; n < this.ncols; ++n) {
                try {
                    this.curr = Terms.add((int)this.curr, (int)Terms.mul((int)this.vars[this.nrows + n], (int)Terms.parseFloat((String)String.valueOf(this.a[n2][n]))));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.yexps[n2] = this.curr;
        }
        for (n2 = 0; n2 < this.ncols; ++n2) {
            this.curr = this.zero;
            for (n = 0; n < this.nrows; ++n) {
                try {
                    this.curr = Terms.add((int)this.curr, (int)Terms.mul((int)this.vars[n], (int)Terms.parseFloat((String)String.valueOf(this.b[n][n2]))));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.xexps[n2] = this.curr;
        }
    }

    @Override
    public void computeEquilibria() throws PrismException {
        int n;
        int n2;
        this.clear();
        this.vMult();
        this.xLabels();
        this.yLabels();
        this.eq = this.ytrue;
        this.xctr = this.zero;
        this.yctr = this.zero;
        for (n2 = 0; n2 < this.nrows + this.ncols; ++n2) {
            this.eq = Terms.and((int[])new int[]{this.eq, Terms.or((int[])new int[]{this.xlabels[n2], this.ylabels[n2]})});
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            this.xctr = Terms.add((int)this.xctr, (int)this.vars[n2]);
        }
        this.xctr = Terms.arithEq((int)this.xctr, (int)this.one);
        for (n = n2; n < this.nrows + this.ncols; ++n) {
            this.yctr = Terms.add((int)this.yctr, (int)this.vars[n]);
        }
        this.yctr = Terms.arithEq((int)this.yctr, (int)this.one);
        this.ctx.assertFormula(this.xctr);
        this.ctx.assertFormula(this.yctr);
        this.ctx.assertFormula(this.eq);
        this.strat = new ArrayList();
        this.eqs.clear();
        n = 0;
        while (this.ctx.check() == Status.SAT) {
            this.model = this.ctx.getModel();
            this.c1 = this.ytrue;
            this.c2 = this.ytrue;
            ArrayList arrayList = new ArrayList();
            Distribution<Double> distribution = new Distribution<Double>();
            Distribution<Double> distribution2 = new Distribution<Double>();
            for (n2 = 0; n2 < this.nrows + this.ncols; ++n2) {
                double d = this.model.doubleValue(this.vars[n2]);
                if (d > 0.0) {
                    if (n2 < this.nrows) {
                        distribution.add(n2, d);
                    } else {
                        distribution2.add(n2 - this.nrows, d);
                    }
                }
                if (n == 0) {
                    if (n2 < this.nrows) {
                        this.eqs.put(this.lvp1[n2], new ArrayList());
                        this.eqs.get(this.lvp1[n2]).add(d);
                        continue;
                    }
                    this.eqs.put(this.lvp2[n2 - this.nrows], new ArrayList());
                    this.eqs.get(this.lvp2[n2 - this.nrows]).add(d);
                    continue;
                }
                if (n2 < this.nrows) {
                    this.eqs.get(this.lvp1[n2]).add(d);
                    continue;
                }
                this.eqs.get(this.lvp2[n2 - this.nrows]).add(d);
            }
            if (this.eqPolicy == "first_found") {
                arrayList.add(0, distribution);
                arrayList.add(1, distribution2);
                this.strat.add(n, arrayList);
                ++n;
                break;
            }
            for (n2 = 0; n2 < this.nrows + this.ncols; ++n2) {
                if (n2 < this.nrows) {
                    if (Double.compare(this.eqs.get(this.lvp1[n2]).get(n), 0.0) != 0) {
                        this.c1 = Terms.and((int[])new int[]{this.c1, Terms.not((int)Terms.arithEq((int)this.vars[n2], (int)this.zero))});
                        continue;
                    }
                    this.c1 = Terms.and((int[])new int[]{this.c1, Terms.arithEq((int)this.vars[n2], (int)this.zero)});
                    continue;
                }
                this.c2 = Double.compare(this.eqs.get(this.lvp2[n2 - this.nrows]).get(n), 0.0) != 0 ? Terms.and((int[])new int[]{this.c2, Terms.not((int)Terms.arithEq((int)this.vars[n2], (int)this.zero))}) : Terms.and((int[])new int[]{this.c2, Terms.arithEq((int)this.vars[n2], (int)this.zero)});
            }
            arrayList.add(0, distribution);
            arrayList.add(1, distribution2);
            this.strat.add(n, arrayList);
            ++n;
            this.ctx.assertFormula(Terms.or((int[])new int[]{Terms.not((int)this.c1), Terms.not((int)this.c2)}));
        }
        this.model.close();
        this.neq = n;
        Yices.reset();
        this.compPayoffs();
    }

    @Override
    public void compPayoffs() {
        this.p1p = new double[this.neq];
        this.p2p = new double[this.neq];
        Arrays.fill(this.p1p, 0.0);
        Arrays.fill(this.p2p, 0.0);
        for (int i = 0; i < this.neq; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                for (int k = 0; k < this.ncols; ++k) {
                    int n = i;
                    this.p1p[n] = this.p1p[n] + this.eqs.get(this.lvp1[j]).get(i) * this.eqs.get(this.lvp2[k]).get(i) * this.a[j][k];
                    int n2 = i;
                    this.p2p[n2] = this.p2p[n2] + this.eqs.get(this.lvp1[j]).get(i) * this.eqs.get(this.lvp2[k]).get(i) * this.b[j][k];
                }
            }
        }
    }

    @Override
    public ArrayList<ArrayList<Distribution<Double>>> getStrat() {
        return this.strat;
    }

    @Override
    public double[] getP1p() {
        return this.p1p;
    }

    @Override
    public double[] getP2p() {
        return this.p2p;
    }

    @Override
    public int getNeq() {
        return this.neq;
    }

    public void setPolicy(String string) {
        this.eqPolicy = string;
    }
}

