/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.functions.DoubleLongToDoubleFunction;
import common.functions.IntDoubleToIntFunction;
import common.functions.IntLongToIntFunction;
import common.functions.LongDoubleToLongFunction;
import common.functions.ObjDoubleFunction;
import common.functions.ObjIntFunction;
import common.functions.ObjLongFunction;
import common.iterable.Distinct;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.Reducible;
import java.util.BitSet;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public interface PrimitiveReducible<E, E_CAT, E_CONS>
extends Reducible<E, E_CAT> {
    public void forEach(E_CONS var1);

    public static interface OfLong<E_CAT>
    extends PrimitiveReducible<Long, E_CAT, LongConsumer> {
        default public OfLong<E_CAT> dedupe() {
            LongPredicate longPredicate = new LongPredicate(){
                boolean start = true;
                long previous = 0L;

                @Override
                public boolean test(long l) {
                    if (this.start) {
                        this.start = false;
                    } else if (this.previous == l) {
                        return false;
                    }
                    this.previous = l;
                    return true;
                }
            };
            return this.filter(longPredicate);
        }

        default public OfLong<E_CAT> distinct() {
            return this.filter(new Distinct.OfLong());
        }

        public OfLong<E_CAT> filter(LongPredicate var1);

        public <T> Reducible<T, ?> map(LongFunction<? extends T> var1);

        public OfDouble<?> mapToDouble(LongToDoubleFunction var1);

        public OfInt<?> mapToInt(LongToIntFunction var1);

        public OfLong<?> mapToLong(LongUnaryOperator var1);

        default public OfLong<E_CAT> consume() {
            this.forEach(l -> {});
            return this;
        }

        default public boolean allMatch(LongPredicate longPredicate) {
            return !this.anyMatch(longPredicate.negate());
        }

        default public boolean anyMatch(LongPredicate longPredicate) {
            return !this.filter(longPredicate).isEmpty();
        }

        default public boolean noneMatch(LongPredicate longPredicate) {
            return !this.anyMatch(longPredicate);
        }

        @Override
        default public long[] collect(long[] lArray) {
            return this.collect(lArray, 0);
        }

        default public long[] collect(long[] lArray, int n) {
            this.collectAndCount(lArray, n);
            return lArray;
        }

        default public int collectAndCount(long[] lArray) {
            return this.collectAndCount(lArray, 0);
        }

        default public int collectAndCount(long[] lArray, int n2) {
            Objects.requireNonNull(lArray);
            int n3 = this.reduce(n2, (int n, long l) -> {
                lArray[n] = l;
                return n + 1;
            });
            return n3 - n2;
        }

        default public FunctionalPrimitiveIterable.OfLong collectDistinct() {
            Distinct.OfLong ofLong = new Distinct.OfLong();
            this.filter(ofLong).consume();
            return ofLong.getSeen();
        }

        @Override
        default public boolean contains(Object object) {
            if (object instanceof Long) {
                return this.contains((Long)object);
            }
            return false;
        }

        default public boolean contains(long l) {
            return this.anyMatch((long l2) -> l2 == l);
        }

        @Override
        default public long count() {
            return this.reduce(0L, (long l, long l2) -> l + 1L);
        }

        default public long count(LongPredicate longPredicate) {
            return this.filter(longPredicate).count();
        }

        public long detect(LongPredicate var1);

        default public OptionalLong max() {
            return this.reduce(Math::max);
        }

        default public OptionalLong min() {
            return this.reduce(Math::min);
        }

        public OptionalLong reduce(LongBinaryOperator var1);

        public <T> T reduce(T var1, ObjLongFunction<T, T> var2);

        public double reduce(double var1, DoubleLongToDoubleFunction var3);

        public int reduce(int var1, IntLongToIntFunction var2);

        public long reduce(long var1, LongBinaryOperator var3);

        default public long sum() {
            return this.reduce(0L, Long::sum);
        }
    }

    public static interface OfInt<E_CAT>
    extends PrimitiveReducible<Integer, E_CAT, IntConsumer> {
        default public OfInt<E_CAT> dedupe() {
            IntPredicate intPredicate = new IntPredicate(){
                boolean start = true;
                int previous = 0;

                @Override
                public boolean test(int n) {
                    if (this.start) {
                        this.start = false;
                    } else if (this.previous == n) {
                        return false;
                    }
                    this.previous = n;
                    return true;
                }
            };
            return this.filter(intPredicate);
        }

        default public OfInt<E_CAT> distinct() {
            return this.filter(new Distinct.OfInt());
        }

        public OfInt<E_CAT> filter(IntPredicate var1);

        public <T> Reducible<T, ?> map(IntFunction<? extends T> var1);

        public OfDouble<?> mapToDouble(IntToDoubleFunction var1);

        public OfInt<?> mapToInt(IntUnaryOperator var1);

        public OfLong<?> mapToLong(IntToLongFunction var1);

        default public OfInt<E_CAT> consume() {
            this.forEach(n -> {});
            return this;
        }

        default public boolean allMatch(IntPredicate intPredicate) {
            return !this.anyMatch(intPredicate.negate());
        }

        default public boolean anyMatch(IntPredicate intPredicate) {
            return !this.filter(intPredicate).isEmpty();
        }

        default public boolean noneMatch(IntPredicate intPredicate) {
            return !this.anyMatch(intPredicate);
        }

        @Override
        default public int[] collect(int[] nArray) {
            return this.collect(nArray, 0);
        }

        default public int[] collect(int[] nArray, int n) {
            this.collectAndCount(nArray, n);
            return nArray;
        }

        @Override
        default public BitSet collect(BitSet bitSet) {
            this.forEach(bitSet::set);
            return bitSet;
        }

        default public int collectAndCount(int[] nArray) {
            return this.collectAndCount(nArray, 0);
        }

        default public int collectAndCount(int[] nArray, int n3) {
            Objects.requireNonNull(nArray);
            int n4 = this.reduce(n3, (int n, int n2) -> {
                nArray[n] = n2;
                return n + 1;
            });
            return n4 - n3;
        }

        default public int collectAndCount(BitSet bitSet) {
            Objects.requireNonNull(bitSet);
            return this.reduce(0, (int n, int n2) -> {
                bitSet.set(n2);
                return n + 1;
            });
        }

        default public FunctionalPrimitiveIterable.OfInt collectDistinct() {
            Distinct.OfInt ofInt = new Distinct.OfInt();
            this.filter(ofInt).consume();
            return ofInt.getSeen();
        }

        @Override
        default public boolean contains(Object object) {
            if (object instanceof Integer) {
                return this.contains((Integer)object);
            }
            return false;
        }

        default public boolean contains(int n) {
            return this.anyMatch((int n2) -> n2 == n);
        }

        @Override
        default public long count() {
            return this.reduce(0L, (long l, long l2) -> l + 1L);
        }

        default public long count(IntPredicate intPredicate) {
            return this.filter(intPredicate).count();
        }

        public int detect(IntPredicate var1);

        default public OptionalInt max() {
            return this.reduce(Math::max);
        }

        default public OptionalInt min() {
            return this.reduce(Math::min);
        }

        public OptionalDouble reduce(DoubleBinaryOperator var1);

        public OptionalInt reduce(IntBinaryOperator var1);

        public OptionalLong reduce(LongBinaryOperator var1);

        public <T> T reduce(T var1, ObjIntFunction<T, T> var2);

        public double reduce(double var1, DoubleBinaryOperator var3);

        public int reduce(int var1, IntBinaryOperator var2);

        public long reduce(long var1, LongBinaryOperator var3);

        default public long sum() {
            return this.reduce(0L, Long::sum);
        }
    }

    public static interface OfDouble<E_CAT>
    extends PrimitiveReducible<Double, E_CAT, DoubleConsumer> {
        default public OfDouble<E_CAT> dedupe() {
            DoublePredicate doublePredicate = new DoublePredicate(){
                boolean start = true;
                double previous = 0.0;

                @Override
                public boolean test(double d) {
                    if (this.start) {
                        this.start = false;
                    } else {
                        if (this.previous == d) {
                            return false;
                        }
                        if (Double.isNaN(this.previous) && Double.isNaN(d)) {
                            return false;
                        }
                    }
                    this.previous = d;
                    return true;
                }
            };
            return this.filter(doublePredicate);
        }

        default public OfDouble<E_CAT> distinct() {
            return this.filter(new Distinct.OfDouble());
        }

        public OfDouble<E_CAT> filter(DoublePredicate var1);

        public <T> Reducible<T, ?> map(DoubleFunction<? extends T> var1);

        public OfDouble<?> mapToDouble(DoubleUnaryOperator var1);

        public OfInt<?> mapToInt(DoubleToIntFunction var1);

        public OfLong<?> mapToLong(DoubleToLongFunction var1);

        default public OfDouble<E_CAT> consume() {
            this.forEach(d -> {});
            return this;
        }

        default public boolean allMatch(DoublePredicate doublePredicate) {
            return !this.anyMatch(doublePredicate.negate());
        }

        default public boolean anyMatch(DoublePredicate doublePredicate) {
            return !this.filter(doublePredicate).isEmpty();
        }

        default public boolean noneMatch(DoublePredicate doublePredicate) {
            return !this.anyMatch(doublePredicate);
        }

        @Override
        default public double[] collect(double[] dArray) {
            return this.collect(dArray, 0);
        }

        default public double[] collect(double[] dArray, int n) {
            this.collectAndCount(dArray, n);
            return dArray;
        }

        default public int collectAndCount(double[] dArray) {
            return this.collectAndCount(dArray, 0);
        }

        default public int collectAndCount(double[] dArray, int n2) {
            Objects.requireNonNull(dArray);
            int n3 = this.reduce(n2, (int n, double d) -> {
                dArray[n] = d;
                return n + 1;
            });
            return n3 - n2;
        }

        default public FunctionalPrimitiveIterable.OfDouble collectDistinct() {
            Distinct.OfDouble ofDouble = new Distinct.OfDouble();
            this.filter(ofDouble).consume();
            return ofDouble.getSeen();
        }

        @Override
        default public boolean contains(Object object) {
            if (object instanceof Double) {
                return this.contains((Double)object);
            }
            return false;
        }

        default public boolean contains(double d3) {
            return this.anyMatch(Double.isNaN(d3) ? d -> Double.isNaN(d) : d2 -> d2 == d3);
        }

        @Override
        default public long count() {
            return this.reduce(0L, (long l, double d) -> l + 1L);
        }

        default public long count(DoublePredicate doublePredicate) {
            return this.filter(doublePredicate).count();
        }

        public double detect(DoublePredicate var1);

        default public OptionalDouble max() {
            return this.reduce(Math::max);
        }

        default public OptionalDouble min() {
            return this.reduce(Math::min);
        }

        public OptionalDouble reduce(DoubleBinaryOperator var1);

        public <T> T reduce(T var1, ObjDoubleFunction<T, T> var2);

        public double reduce(double var1, DoubleBinaryOperator var3);

        public int reduce(int var1, IntDoubleToIntFunction var2);

        public long reduce(long var1, LongDoubleToLongFunction var3);

        default public double sum() {
            return this.reduce(0.0, Double::sum);
        }
    }
}

