/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.EmptyIterator;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.Reducible;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class MappingIterator<S, E, I extends Iterator<S>>
implements FunctionalIterator<E> {
    protected I iterator;

    public MappingIterator(I i) {
        Objects.requireNonNull(i);
        this.iterator = i;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        this.release();
        return false;
    }

    @Override
    public long count() {
        return Reducible.extend(this.iterator).count();
    }

    public static class LongToLong
    extends MappingIterator<Long, Long, PrimitiveIterator.OfLong>
    implements FunctionalPrimitiveIterator.OfLong {
        protected final LongUnaryOperator function;

        public LongToLong(PrimitiveIterator.OfLong ofLong, LongUnaryOperator longUnaryOperator) {
            super(ofLong);
            Objects.requireNonNull(longUnaryOperator);
            this.function = longUnaryOperator;
        }

        @Override
        public long nextLong() {
            this.requireNext();
            return this.function.applyAsLong(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofLong();
        }
    }

    public static class LongToInt
    extends MappingIterator<Long, Integer, PrimitiveIterator.OfLong>
    implements FunctionalPrimitiveIterator.OfInt {
        protected final LongToIntFunction function;

        public LongToInt(PrimitiveIterator.OfLong ofLong, LongToIntFunction longToIntFunction) {
            super(ofLong);
            Objects.requireNonNull(longToIntFunction);
            this.function = longToIntFunction;
        }

        @Override
        public int nextInt() {
            this.requireNext();
            return this.function.applyAsInt(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofLong();
        }
    }

    public static class LongToDouble
    extends MappingIterator<Long, Double, PrimitiveIterator.OfLong>
    implements FunctionalPrimitiveIterator.OfDouble {
        protected final LongToDoubleFunction function;

        public LongToDouble(PrimitiveIterator.OfLong ofLong, LongToDoubleFunction longToDoubleFunction) {
            super(ofLong);
            Objects.requireNonNull(longToDoubleFunction);
            this.function = longToDoubleFunction;
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            return this.function.applyAsDouble(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofLong();
        }
    }

    public static class LongToObj<E>
    extends MappingIterator<Long, E, PrimitiveIterator.OfLong> {
        protected final LongFunction<? extends E> function;

        public LongToObj(PrimitiveIterator.OfLong ofLong, LongFunction<? extends E> longFunction) {
            super(ofLong);
            Objects.requireNonNull(longFunction);
            this.function = longFunction;
        }

        @Override
        public E next() {
            this.requireNext();
            return this.function.apply(((PrimitiveIterator.OfLong)this.iterator).nextLong());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofLong();
        }
    }

    public static class IntToLong
    extends MappingIterator<Integer, Long, PrimitiveIterator.OfInt>
    implements FunctionalPrimitiveIterator.OfLong {
        protected final IntToLongFunction function;

        public IntToLong(PrimitiveIterator.OfInt ofInt, IntToLongFunction intToLongFunction) {
            super(ofInt);
            Objects.requireNonNull(intToLongFunction);
            this.function = intToLongFunction;
        }

        @Override
        public long nextLong() {
            this.requireNext();
            return this.function.applyAsLong(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofInt();
        }
    }

    public static class IntToInt
    extends MappingIterator<Integer, Integer, PrimitiveIterator.OfInt>
    implements FunctionalPrimitiveIterator.OfInt {
        protected final IntUnaryOperator function;

        public IntToInt(PrimitiveIterator.OfInt ofInt, IntUnaryOperator intUnaryOperator) {
            super(ofInt);
            Objects.requireNonNull(intUnaryOperator);
            this.function = intUnaryOperator;
        }

        @Override
        public int nextInt() {
            this.requireNext();
            return this.function.applyAsInt(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofInt();
        }
    }

    public static class IntToDouble
    extends MappingIterator<Integer, Double, PrimitiveIterator.OfInt>
    implements FunctionalPrimitiveIterator.OfDouble {
        protected final IntToDoubleFunction function;

        public IntToDouble(PrimitiveIterator.OfInt ofInt, IntToDoubleFunction intToDoubleFunction) {
            super(ofInt);
            Objects.requireNonNull(intToDoubleFunction);
            this.function = intToDoubleFunction;
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            return this.function.applyAsDouble(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofInt();
        }
    }

    public static class IntToObj<E>
    extends MappingIterator<Integer, E, PrimitiveIterator.OfInt> {
        protected final IntFunction<? extends E> function;

        public IntToObj(PrimitiveIterator.OfInt ofInt, IntFunction<? extends E> intFunction) {
            super(ofInt);
            Objects.requireNonNull(intFunction);
            this.function = intFunction;
        }

        @Override
        public E next() {
            this.requireNext();
            return this.function.apply(((PrimitiveIterator.OfInt)this.iterator).nextInt());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofInt();
        }
    }

    public static class DoubleToLong
    extends MappingIterator<Double, Long, PrimitiveIterator.OfDouble>
    implements FunctionalPrimitiveIterator.OfLong {
        protected final DoubleToLongFunction function;

        public DoubleToLong(PrimitiveIterator.OfDouble ofDouble, DoubleToLongFunction doubleToLongFunction) {
            super(ofDouble);
            Objects.requireNonNull(doubleToLongFunction);
            this.function = doubleToLongFunction;
        }

        @Override
        public long nextLong() {
            this.requireNext();
            return this.function.applyAsLong(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofDouble();
        }
    }

    public static class DoubleToInt
    extends MappingIterator<Double, Integer, PrimitiveIterator.OfDouble>
    implements FunctionalPrimitiveIterator.OfInt {
        protected final DoubleToIntFunction function;

        public DoubleToInt(PrimitiveIterator.OfDouble ofDouble, DoubleToIntFunction doubleToIntFunction) {
            super(ofDouble);
            Objects.requireNonNull(doubleToIntFunction);
            this.function = doubleToIntFunction;
        }

        @Override
        public int nextInt() {
            this.requireNext();
            return this.function.applyAsInt(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofDouble();
        }
    }

    public static class DoubleToDouble
    extends MappingIterator<Double, Double, PrimitiveIterator.OfDouble>
    implements FunctionalPrimitiveIterator.OfDouble {
        protected final DoubleUnaryOperator function;

        public DoubleToDouble(PrimitiveIterator.OfDouble ofDouble, DoubleUnaryOperator doubleUnaryOperator) {
            super(ofDouble);
            Objects.requireNonNull(doubleUnaryOperator);
            this.function = doubleUnaryOperator;
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            return this.function.applyAsDouble(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofDouble();
        }
    }

    public static class DoubleToObj<E>
    extends MappingIterator<Double, E, PrimitiveIterator.OfDouble> {
        protected final DoubleFunction<? extends E> function;

        public DoubleToObj(PrimitiveIterator.OfDouble ofDouble, DoubleFunction<? extends E> doubleFunction) {
            super(ofDouble);
            Objects.requireNonNull(doubleFunction);
            this.function = doubleFunction;
        }

        @Override
        public E next() {
            this.requireNext();
            return this.function.apply(((PrimitiveIterator.OfDouble)this.iterator).nextDouble());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.ofDouble();
        }
    }

    public static class ObjToLong<S>
    extends MappingIterator<S, Long, Iterator<S>>
    implements FunctionalPrimitiveIterator.OfLong {
        protected final ToLongFunction<? super S> function;

        public ObjToLong(Iterator<S> iterator, ToLongFunction<? super S> toLongFunction) {
            super(iterator);
            Objects.requireNonNull(toLongFunction);
            this.function = toLongFunction;
        }

        @Override
        public long nextLong() {
            this.requireNext();
            return this.function.applyAsLong(this.iterator.next());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.of();
        }
    }

    public static class ObjToInt<S>
    extends MappingIterator<S, Integer, Iterator<S>>
    implements FunctionalPrimitiveIterator.OfInt {
        protected final ToIntFunction<? super S> function;

        public ObjToInt(Iterator<S> iterator, ToIntFunction<? super S> toIntFunction) {
            super(iterator);
            Objects.requireNonNull(toIntFunction);
            this.function = toIntFunction;
        }

        @Override
        public int nextInt() {
            this.requireNext();
            return this.function.applyAsInt(this.iterator.next());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.of();
        }
    }

    public static class ObjToDouble<S>
    extends MappingIterator<S, Double, Iterator<S>>
    implements FunctionalPrimitiveIterator.OfDouble {
        protected final ToDoubleFunction<? super S> function;

        public ObjToDouble(Iterator<S> iterator, ToDoubleFunction<? super S> toDoubleFunction) {
            super(iterator);
            Objects.requireNonNull(toDoubleFunction);
            this.function = toDoubleFunction;
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            return this.function.applyAsDouble(this.iterator.next());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.of();
        }
    }

    public static class ObjToObj<S, E>
    extends MappingIterator<S, E, Iterator<S>> {
        protected final Function<? super S, ? extends E> function;

        public ObjToObj(Iterator<S> iterator, Function<? super S, ? extends E> function) {
            super(iterator);
            Objects.requireNonNull(function);
            this.function = function;
        }

        @Override
        public E next() {
            this.requireNext();
            return this.function.apply(this.iterator.next());
        }

        @Override
        public void release() {
            this.iterator = EmptyIterator.of();
        }
    }
}

