/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalIterable;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.MappingIterator;
import common.iterable.PrimitiveIterable;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class MappingIterable<S, E, I extends Iterable<S>>
implements FunctionalIterable<E> {
    protected final I iterable;

    public MappingIterable(I i) {
        Objects.requireNonNull(i);
        this.iterable = i;
    }

    public static class LongToLong
    extends MappingIterable<Long, Long, PrimitiveIterable.OfLong>
    implements FunctionalPrimitiveIterable.OfLong {
        protected final LongUnaryOperator function;

        public LongToLong(PrimitiveIterable.OfLong ofLong, LongUnaryOperator longUnaryOperator) {
            super(ofLong);
            Objects.requireNonNull(longUnaryOperator);
            this.function = longUnaryOperator;
        }

        @Override
        public FunctionalPrimitiveIterator.OfLong iterator() {
            return new MappingIterator.LongToLong(((PrimitiveIterable.OfLong)this.iterable).iterator(), this.function);
        }
    }

    public static class LongToInt
    extends MappingIterable<Long, Integer, PrimitiveIterable.OfLong>
    implements FunctionalPrimitiveIterable.OfInt {
        protected final LongToIntFunction function;

        public LongToInt(PrimitiveIterable.OfLong ofLong, LongToIntFunction longToIntFunction) {
            super(ofLong);
            Objects.requireNonNull(longToIntFunction);
            this.function = longToIntFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt iterator() {
            return new MappingIterator.LongToInt(((PrimitiveIterable.OfLong)this.iterable).iterator(), this.function);
        }
    }

    public static class LongToDouble
    extends MappingIterable<Long, Double, PrimitiveIterable.OfLong>
    implements FunctionalPrimitiveIterable.OfDouble {
        protected final LongToDoubleFunction function;

        public LongToDouble(PrimitiveIterable.OfLong ofLong, LongToDoubleFunction longToDoubleFunction) {
            super(ofLong);
            Objects.requireNonNull(longToDoubleFunction);
            this.function = longToDoubleFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfDouble iterator() {
            return new MappingIterator.LongToDouble(((PrimitiveIterable.OfLong)this.iterable).iterator(), this.function);
        }
    }

    public static class LongToObj<E>
    extends MappingIterable<Long, E, PrimitiveIterable.OfLong> {
        protected final LongFunction<? extends E> function;

        public LongToObj(PrimitiveIterable.OfLong ofLong, LongFunction<? extends E> longFunction) {
            super(ofLong);
            Objects.requireNonNull(longFunction);
            this.function = longFunction;
        }

        @Override
        public FunctionalIterator<E> iterator() {
            return new MappingIterator.LongToObj<E>(((PrimitiveIterable.OfLong)this.iterable).iterator(), this.function);
        }
    }

    public static class IntToLong
    extends MappingIterable<Integer, Long, PrimitiveIterable.OfInt>
    implements FunctionalPrimitiveIterable.OfLong {
        protected final IntToLongFunction function;

        public IntToLong(PrimitiveIterable.OfInt ofInt, IntToLongFunction intToLongFunction) {
            super(ofInt);
            Objects.requireNonNull(intToLongFunction);
            this.function = intToLongFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfLong iterator() {
            return new MappingIterator.IntToLong(((PrimitiveIterable.OfInt)this.iterable).iterator(), this.function);
        }
    }

    public static class IntToInt
    extends MappingIterable<Integer, Integer, PrimitiveIterable.OfInt>
    implements FunctionalPrimitiveIterable.OfInt {
        protected final IntUnaryOperator function;

        public IntToInt(PrimitiveIterable.OfInt ofInt, IntUnaryOperator intUnaryOperator) {
            super(ofInt);
            Objects.requireNonNull(intUnaryOperator);
            this.function = intUnaryOperator;
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt iterator() {
            return new MappingIterator.IntToInt(((PrimitiveIterable.OfInt)this.iterable).iterator(), this.function);
        }
    }

    public static class IntToDouble
    extends MappingIterable<Integer, Double, PrimitiveIterable.OfInt>
    implements FunctionalPrimitiveIterable.OfDouble {
        protected final IntToDoubleFunction function;

        public IntToDouble(PrimitiveIterable.OfInt ofInt, IntToDoubleFunction intToDoubleFunction) {
            super(ofInt);
            Objects.requireNonNull(intToDoubleFunction);
            this.function = intToDoubleFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfDouble iterator() {
            return new MappingIterator.IntToDouble(((PrimitiveIterable.OfInt)this.iterable).iterator(), this.function);
        }
    }

    public static class IntToObj<E>
    extends MappingIterable<Integer, E, PrimitiveIterable.OfInt> {
        protected final IntFunction<? extends E> function;

        public IntToObj(PrimitiveIterable.OfInt ofInt, IntFunction<? extends E> intFunction) {
            super(ofInt);
            Objects.requireNonNull(intFunction);
            this.function = intFunction;
        }

        @Override
        public FunctionalIterator<E> iterator() {
            return new MappingIterator.IntToObj<E>(((PrimitiveIterable.OfInt)this.iterable).iterator(), this.function);
        }
    }

    public static class DoubleToLong
    extends MappingIterable<Double, Long, PrimitiveIterable.OfDouble>
    implements FunctionalPrimitiveIterable.OfLong {
        protected final DoubleToLongFunction function;

        public DoubleToLong(PrimitiveIterable.OfDouble ofDouble, DoubleToLongFunction doubleToLongFunction) {
            super(ofDouble);
            Objects.requireNonNull(doubleToLongFunction);
            this.function = doubleToLongFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfLong iterator() {
            return new MappingIterator.DoubleToLong(((PrimitiveIterable.OfDouble)this.iterable).iterator(), this.function);
        }
    }

    public static class DoubleToInt
    extends MappingIterable<Double, Integer, PrimitiveIterable.OfDouble>
    implements FunctionalPrimitiveIterable.OfInt {
        protected final DoubleToIntFunction function;

        public DoubleToInt(PrimitiveIterable.OfDouble ofDouble, DoubleToIntFunction doubleToIntFunction) {
            super(ofDouble);
            Objects.requireNonNull(doubleToIntFunction);
            this.function = doubleToIntFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt iterator() {
            return new MappingIterator.DoubleToInt(((PrimitiveIterable.OfDouble)this.iterable).iterator(), this.function);
        }
    }

    public static class DoubleToDouble
    extends MappingIterable<Double, Double, PrimitiveIterable.OfDouble>
    implements FunctionalPrimitiveIterable.OfDouble {
        protected final DoubleUnaryOperator function;

        public DoubleToDouble(PrimitiveIterable.OfDouble ofDouble, DoubleUnaryOperator doubleUnaryOperator) {
            super(ofDouble);
            Objects.requireNonNull(doubleUnaryOperator);
            this.function = doubleUnaryOperator;
        }

        @Override
        public FunctionalPrimitiveIterator.OfDouble iterator() {
            return new MappingIterator.DoubleToDouble(((PrimitiveIterable.OfDouble)this.iterable).iterator(), this.function);
        }
    }

    public static class DoubleToObj<E>
    extends MappingIterable<Double, E, PrimitiveIterable.OfDouble> {
        protected final DoubleFunction<? extends E> function;

        public DoubleToObj(PrimitiveIterable.OfDouble ofDouble, DoubleFunction<? extends E> doubleFunction) {
            super(ofDouble);
            Objects.requireNonNull(doubleFunction);
            this.function = doubleFunction;
        }

        @Override
        public FunctionalIterator<E> iterator() {
            return new MappingIterator.DoubleToObj<E>(((PrimitiveIterable.OfDouble)this.iterable).iterator(), this.function);
        }
    }

    public static class ObjToLong<S>
    extends MappingIterable<S, Long, Iterable<S>>
    implements FunctionalPrimitiveIterable.OfLong {
        protected final ToLongFunction<? super S> function;

        public ObjToLong(Iterable<S> iterable, ToLongFunction<? super S> toLongFunction) {
            super(iterable);
            Objects.requireNonNull(toLongFunction);
            this.function = toLongFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfLong iterator() {
            return new MappingIterator.ObjToLong<S>(this.iterable.iterator(), this.function);
        }
    }

    public static class ObjToInt<S>
    extends MappingIterable<S, Integer, Iterable<S>>
    implements FunctionalPrimitiveIterable.OfInt {
        protected final ToIntFunction<? super S> function;

        public ObjToInt(Iterable<S> iterable, ToIntFunction<? super S> toIntFunction) {
            super(iterable);
            Objects.requireNonNull(toIntFunction);
            this.function = toIntFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt iterator() {
            return new MappingIterator.ObjToInt<S>(this.iterable.iterator(), this.function);
        }
    }

    public static class ObjToDouble<S>
    extends MappingIterable<S, Double, Iterable<S>>
    implements FunctionalPrimitiveIterable.OfDouble {
        protected final ToDoubleFunction<? super S> function;

        public ObjToDouble(Iterable<S> iterable, ToDoubleFunction<? super S> toDoubleFunction) {
            super(iterable);
            Objects.requireNonNull(toDoubleFunction);
            this.function = toDoubleFunction;
        }

        @Override
        public FunctionalPrimitiveIterator.OfDouble iterator() {
            return new MappingIterator.ObjToDouble<S>(this.iterable.iterator(), this.function);
        }
    }

    public static class ObjToObj<S, E>
    extends MappingIterable<S, E, Iterable<S>> {
        protected final Function<? super S, ? extends E> function;

        public ObjToObj(Iterable<S> iterable, Function<? super S, ? extends E> function) {
            super(iterable);
            Objects.requireNonNull(function);
            this.function = function;
        }

        @Override
        public FunctionalIterator<E> iterator() {
            return new MappingIterator.ObjToObj<S, E>(this.iterable.iterator(), this.function);
        }
    }
}

