/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.EmptyIterator;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public abstract class FilteringIterator<E, I extends Iterator<E>>
implements FunctionalIterator<E> {
    protected I iterator;
    protected boolean hasNext;

    public FilteringIterator(I i) {
        Objects.requireNonNull(i);
        this.iterator = i;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void release() {
        this.hasNext = false;
    }

    protected abstract void seekNext();

    public static class OfLong
    extends FilteringIterator<Long, PrimitiveIterator.OfLong>
    implements FunctionalPrimitiveIterator.OfLong {
        protected final LongPredicate filter;
        protected long next;

        public OfLong(PrimitiveIterator.OfLong ofLong, LongPredicate longPredicate) {
            super(ofLong);
            Objects.requireNonNull(longPredicate);
            this.filter = longPredicate;
            this.seekNext();
        }

        @Override
        public long nextLong() {
            this.requireNext();
            long l = this.next;
            this.seekNext();
            return l;
        }

        @Override
        public void release() {
            super.release();
            this.iterator = EmptyIterator.ofLong();
            this.next = 0L;
        }

        @Override
        protected void seekNext() {
            while (((PrimitiveIterator.OfLong)this.iterator).hasNext()) {
                this.next = ((PrimitiveIterator.OfLong)this.iterator).nextLong();
                if (!this.filter.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }
    }

    public static class OfInt
    extends FilteringIterator<Integer, PrimitiveIterator.OfInt>
    implements FunctionalPrimitiveIterator.OfInt {
        protected final IntPredicate filter;
        protected int next;

        public OfInt(PrimitiveIterator.OfInt ofInt, IntPredicate intPredicate) {
            super(ofInt);
            Objects.requireNonNull(intPredicate);
            this.filter = intPredicate;
            this.seekNext();
        }

        @Override
        public int nextInt() {
            this.requireNext();
            int n = this.next;
            this.seekNext();
            return n;
        }

        @Override
        public void release() {
            super.release();
            this.iterator = EmptyIterator.ofInt();
            this.next = 0;
        }

        @Override
        protected void seekNext() {
            while (((PrimitiveIterator.OfInt)this.iterator).hasNext()) {
                this.next = ((PrimitiveIterator.OfInt)this.iterator).nextInt();
                if (!this.filter.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }
    }

    public static class OfDouble
    extends FilteringIterator<Double, PrimitiveIterator.OfDouble>
    implements FunctionalPrimitiveIterator.OfDouble {
        protected final DoublePredicate filter;
        protected double next;

        public OfDouble(PrimitiveIterator.OfDouble ofDouble, DoublePredicate doublePredicate) {
            super(ofDouble);
            Objects.requireNonNull(doublePredicate);
            this.filter = doublePredicate;
            this.seekNext();
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            double d = this.next;
            this.seekNext();
            return d;
        }

        @Override
        public void release() {
            super.release();
            this.iterator = EmptyIterator.ofDouble();
            this.next = 0.0;
        }

        @Override
        protected void seekNext() {
            while (((PrimitiveIterator.OfDouble)this.iterator).hasNext()) {
                this.next = ((PrimitiveIterator.OfDouble)this.iterator).nextDouble();
                if (!this.filter.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.release();
        }
    }

    public static class Of<E>
    extends FilteringIterator<E, Iterator<E>> {
        protected final Predicate<E> filter;
        protected E next;

        public Of(Iterator<E> iterator, Predicate<? super E> predicate) {
            super(iterator);
            Objects.requireNonNull(predicate);
            this.filter = predicate;
            this.seekNext();
        }

        @Override
        public E next() {
            this.requireNext();
            E e = this.next;
            this.seekNext();
            return e;
        }

        @Override
        public void release() {
            super.release();
            this.iterator = EmptyIterator.of();
            this.next = null;
        }

        @Override
        protected void seekNext() {
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                if (!this.filter.test(this.next)) continue;
                this.hasNext = true;
                return;
            }
            this.release();
        }
    }
}

