/*
 * Decompiled with CFR 0.152.
 */
package automata;

import acceptance.AcceptanceBuchi;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceReach;
import automata.DA;
import automata.LTSFromDA;
import common.IterableBitSet;
import explicit.LTS;
import explicit.LTSSimple;
import explicit.NonProbModelChecker;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import jltl2ba.APElement;
import jltl2ba.LTLFragments;
import jltl2ba.MyBitSet;
import jltl2ba.SimpleLTL;
import jltl2dstar.NBA;
import prism.PrismComponent;
import prism.PrismDevNullLog;
import prism.PrismException;

public class LTL2WDBA
extends PrismComponent {
    public LTL2WDBA(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public DA<BitSet, AcceptanceReach> cosafeltl2dfa(SimpleLTL simpleLTL) throws PrismException {
        DA<BitSet, AcceptanceBuchi> dA = this.ltl2wdba(simpleLTL);
        BitSet bitSet = dA.getAcceptance().getAcceptingStates();
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.flip(0, dA.size());
        LTSFromDA lTSFromDA = new LTSFromDA(dA);
        NonProbModelChecker nonProbModelChecker = new NonProbModelChecker(this);
        nonProbModelChecker.setLog(new PrismDevNullLog());
        BitSet bitSet3 = nonProbModelChecker.computeExistsGlobally(lTSFromDA, bitSet2);
        BitSet bitSet4 = (BitSet)bitSet3.clone();
        bitSet4.flip(0, dA.size());
        DA<BitSet, AcceptanceReach> dA2 = this.toDFA(dA, bitSet4);
        return dA2;
    }

    public DA<BitSet, AcceptanceBuchi> obligation2wdba(SimpleLTL simpleLTL) throws PrismException {
        return this.ltl2wdba(simpleLTL);
    }

    private DA<BitSet, AcceptanceReach> toDFA(DA<BitSet, ? extends AcceptanceOmega> dA, BitSet bitSet) {
        AcceptanceReach acceptanceReach = new AcceptanceReach(bitSet);
        DA.switchAcceptance(dA, acceptanceReach);
        return dA;
    }

    private DA<BitSet, AcceptanceBuchi> ltl2wdba(SimpleLTL simpleLTL) throws PrismException {
        simpleLTL = simpleLTL.simplify();
        NBA nBA = simpleLTL.toNBA();
        PowersetDA powersetDA = this.powersetConstruction(nBA);
        this.determineF(powersetDA);
        return powersetDA.da;
    }

    private PowersetDA powersetConstruction(NBA nBA) throws PrismException {
        DA<APElement, AcceptanceBuchi> dA = new DA<APElement, AcceptanceBuchi>();
        dA.setAcceptance(new AcceptanceBuchi());
        HashMap<BitSet, Object> hashMap = new HashMap<BitSet, Object>();
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        MyBitSet myBitSet = nBA.getFinalStates();
        MyBitSet myBitSet2 = new MyBitSet();
        MyBitSet myBitSet3 = new MyBitSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        BitSet bitSet = new BitSet();
        bitSet.set(nBA.getStartState().getName());
        int n = dA.addState();
        hashMap.put(bitSet, n);
        arrayList.add(bitSet);
        linkedList.add(n);
        dA.setStartState(n);
        dA.setAPList(new ArrayList<String>(nBA.getAPSet().asList()));
        if (bitSet.intersects(myBitSet)) {
            myBitSet2.set(n);
        }
        if (myBitSet.containsAll(bitSet)) {
            myBitSet3.set(n);
        }
        BitSet bitSet2 = new BitSet();
        while (!linkedList.isEmpty()) {
            int n2 = (Integer)linkedList.poll();
            if (bitSet2.get(n2)) continue;
            BitSet bitSet3 = (BitSet)arrayList.get(n2);
            for (APElement aPElement : nBA.getAPSet().elements()) {
                BitSet bitSet4 = new BitSet();
                Object object = IterableBitSet.getSetBits(bitSet3).iterator();
                while (object.hasNext()) {
                    int n3 = (Integer)object.next();
                    bitSet4.or(nBA.get(n3).getEdge(aPElement));
                }
                object = (Integer)hashMap.get(bitSet4);
                if (object == null) {
                    object = dA.addState();
                    hashMap.put(bitSet4, object);
                    arrayList.add(bitSet4);
                    linkedList.add(object);
                    if (bitSet4.intersects(myBitSet)) {
                        myBitSet2.set((Integer)object);
                    }
                    if (myBitSet.containsAll(bitSet4)) {
                        myBitSet3.set((Integer)object);
                    }
                }
                dA.addEdge(n2, aPElement, (Integer)object);
            }
        }
        PowersetDA powersetDA = new PowersetDA();
        powersetDA.nba = nBA;
        powersetDA.da = dA;
        powersetDA.idToState = arrayList;
        powersetDA.powersetOneF = myBitSet2;
        powersetDA.powersetAllF = myBitSet3;
        return powersetDA;
    }

    private void determineF(PowersetDA powersetDA) throws PrismException {
        LTSFromDA lTSFromDA = new LTSFromDA(powersetDA.da);
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, lTSFromDA, sCCConsumerStore);
        sCCComputer.computeSCCs();
        for (BitSet bitSet : sCCConsumerStore.getSCCs()) {
            if (!this.hasAcceptingCycle(powersetDA, bitSet)) continue;
            powersetDA.F.or(bitSet);
        }
        powersetDA.da.getAcceptance().setAcceptingStates(powersetDA.F);
    }

    private boolean hasAcceptingCycle(PowersetDA powersetDA, BitSet bitSet) throws PrismException {
        if (!bitSet.intersects(powersetDA.powersetOneF)) {
            return false;
        }
        if (powersetDA.powersetAllF.containsAll(bitSet)) {
            return true;
        }
        Lasso lasso = this.findLasso(powersetDA, bitSet);
        BuchiLTS buchiLTS = this.buildLTSforLasso(powersetDA, lasso);
        boolean bl = false;
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, buchiLTS.lts, sCCConsumerStore);
        sCCComputer.computeSCCs();
        for (BitSet bitSet2 : sCCConsumerStore.getSCCs()) {
            if (!bitSet2.intersects(buchiLTS.F)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Lasso findLasso(PowersetDA powersetDA, BitSet bitSet) throws PrismException {
        Object object;
        int n;
        int n2;
        int n3 = bitSet.nextSetBit(0);
        Stack<Integer> stack = new Stack<Integer>();
        Stack<Object> stack2 = new Stack<Object>();
        BitSet bitSet2 = new BitSet();
        stack.push(n3);
        bitSet2.set(n3);
        DA<BitSet, AcceptanceBuchi> dA = powersetDA.da;
        while (true) {
            int n4 = (Integer)stack.peek();
            int n5 = dA.getNumEdges(n4);
            boolean bl = false;
            n2 = -1;
            for (n = 0; n < n5; ++n) {
                n2 = powersetDA.da.getEdgeDest(n4, n);
                if (!bitSet.get(n2)) continue;
                object = dA.getEdgeLabel(n4, n);
                stack2.add(object);
                stack.add(n2);
                bl = true;
                break;
            }
            if (!bl) {
                throw new PrismException("Implementation error in findCycle");
            }
            if (bitSet2.get(n2)) break;
            bitSet2.set(n2);
        }
        n = n2;
        object = new Lasso();
        ((Lasso)object).word = new LinkedList();
        ((Lasso)object).cycleStart = n;
        do {
            APElement aPElement = new APElement();
            aPElement.or((BitSet)stack2.pop());
            ((Lasso)object).word.addFirst(aPElement);
            stack.pop();
        } while ((Integer)stack.peek() != n2);
        return object;
    }

    private BuchiLTS buildLTSforLasso(PowersetDA powersetDA, Lasso lasso) {
        Object object;
        HashMap<LassoLTSState, Integer> hashMap = new HashMap<LassoLTSState, Integer>();
        ArrayList<LassoLTSState> arrayList = new ArrayList<LassoLTSState>();
        Stack<Integer> stack = new Stack<Integer>();
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        LTSSimple lTSSimple = new LTSSimple();
        Object object2 = IterableBitSet.getSetBits(powersetDA.idToState.get(lasso.cycleStart)).iterator();
        while (object2.hasNext()) {
            int n = (Integer)object2.next();
            int n2 = lTSSimple.addState();
            stack.push(n2);
            object = new LassoLTSState(n, 0);
            hashMap.put((LassoLTSState)object, n2);
            arrayList.add((LassoLTSState)object);
            if (!powersetDA.nba.get(n).isFinal()) continue;
            bitSet2.set(n2);
        }
        while (!stack.isEmpty()) {
            int n = (Integer)stack.pop();
            if (bitSet.get(n)) continue;
            LassoLTSState lassoLTSState = (LassoLTSState)arrayList.get(n);
            APElement aPElement = lasso.word.get(lassoLTSState.cyclePos);
            object = powersetDA.nba.get(lassoLTSState.nbaState).getEdge(aPElement);
            int n3 = (lassoLTSState.cyclePos + 1) % lasso.word.size();
            Iterator<Integer> iterator = ((MyBitSet)object).iterator();
            while (iterator.hasNext()) {
                int n4 = iterator.next();
                LassoLTSState lassoLTSState2 = new LassoLTSState(n4, n3);
                Integer n5 = (Integer)hashMap.get(lassoLTSState2);
                if (n5 == null) {
                    n5 = lTSSimple.addState();
                    stack.push(n5);
                    hashMap.put(lassoLTSState2, n5);
                    arrayList.add(lassoLTSState2);
                    if (powersetDA.nba.get(n4).isFinal()) {
                        bitSet2.set(n5);
                    }
                }
                lTSSimple.addTransition(n, n5);
            }
        }
        object2 = new BuchiLTS();
        ((BuchiLTS)object2).lts = lTSSimple;
        ((BuchiLTS)object2).F = bitSet2;
        return object2;
    }

    public static void main(String[] stringArray) {
        try {
            DA<BitSet, AcceptanceOmega> dA;
            SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(stringArray[0]);
            PrismComponent prismComponent = new PrismComponent();
            prismComponent.setLog(new PrismDevNullLog());
            LTL2WDBA lTL2WDBA = new LTL2WDBA(prismComponent);
            LTLFragments lTLFragments = LTLFragments.analyse(simpleLTL);
            if (lTLFragments.isSyntacticGuarantee()) {
                dA = lTL2WDBA.cosafeltl2dfa(simpleLTL);
            } else if (lTLFragments.isSyntacticObligation()) {
                dA = lTL2WDBA.obligation2wdba(simpleLTL);
            } else {
                throw new Exception("Can not construct an automaton for " + simpleLTL + ", not syntactically co-safe or obligation");
            }
            PrintStream printStream = stringArray.length < 2 || "-".equals(stringArray[1]) ? System.out : new PrintStream(stringArray[1]);
            String string = stringArray.length < 3 ? "hoa" : stringArray[2];
            dA.print(printStream, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Error: " + exception + ".");
        }
    }

    private static class PowersetDA {
        public NBA nba;
        public DA<BitSet, AcceptanceBuchi> da;
        public MyBitSet powersetOneF;
        public MyBitSet powersetAllF;
        public ArrayList<BitSet> idToState;
        public BitSet F = new BitSet();

        private PowersetDA() {
        }
    }

    private static class Lasso {
        LinkedList<APElement> word;
        int cycleStart;

        private Lasso() {
        }

        public String toString() {
            String string = "Cycle starting at " + this.cycleStart + " with ";
            string = string + this.word.toString();
            return string;
        }
    }

    private static class BuchiLTS {
        LTS lts;
        BitSet F;

        private BuchiLTS() {
        }
    }

    private static class LassoLTSState {
        int nbaState;
        int cyclePos;

        LassoLTSState(int n, int n2) {
            this.nbaState = n;
            this.cyclePos = n2;
        }

        public String toString() {
            return "(" + this.nbaState + "," + this.cyclePos + ")";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.cyclePos;
            n = 31 * n + this.nbaState;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            LassoLTSState lassoLTSState = (LassoLTSState)object;
            if (this.cyclePos != lassoLTSState.cyclePos) {
                return false;
            }
            return this.nbaState == lassoLTSState.nbaState;
        }
    }
}

