/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGeneric;
import acceptance.AcceptanceGenericDD;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabinDD;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceStreettDD;
import acceptance.AcceptanceType;
import common.IterableBitSet;
import common.iterable.FunctionalPrimitiveIterator;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismNotSupportedException;

public class AcceptanceReachDD
implements AcceptanceOmegaDD {
    private JDDNode goalStates;

    public AcceptanceReachDD(JDDNode jDDNode) {
        this.goalStates = jDDNode;
    }

    public AcceptanceReachDD(AcceptanceReach acceptanceReach, JDDVars jDDVars) {
        this.goalStates = JDD.Constant(0.0);
        FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(acceptanceReach.getGoalStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            this.goalStates = JDD.SetVectorElement(this.goalStates, jDDVars, n, 1.0);
        }
    }

    public JDDNode getGoalStates() {
        JDD.Ref(this.goalStates);
        return this.goalStates;
    }

    public void setGoalStates(JDDNode jDDNode) {
        this.clear();
        this.goalStates = jDDNode;
    }

    @Override
    public boolean isBSCCAccepting(JDDNode jDDNode) {
        return JDD.AreIntersecting(this.goalStates, jDDNode);
    }

    @Override
    public AcceptanceReachDD clone() {
        return new AcceptanceReachDD(this.goalStates.copy());
    }

    @Override
    public void intersect(JDDNode jDDNode) {
        this.goalStates = JDD.And(this.goalStates, jDDNode.copy());
    }

    @Override
    public String getSizeStatistics() {
        return "one set of goal states";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.REACH;
    }

    @Override
    public AcceptanceOmegaDD complement(AcceptanceType ... acceptanceTypeArray) throws PrismNotSupportedException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.RABIN)) {
            return this.complementToRabin();
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.STREETT)) {
            return this.complementToStreett();
        }
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + this.getType() + " acceptance to a supported acceptance type");
    }

    public AcceptanceRabinDD complementToRabin() {
        AcceptanceRabinDD acceptanceRabinDD = new AcceptanceRabinDD();
        acceptanceRabinDD.add(new AcceptanceRabinDD.RabinPairDD(this.goalStates.copy(), JDD.Constant(1.0)));
        return acceptanceRabinDD;
    }

    public AcceptanceStreettDD complementToStreett() {
        AcceptanceStreettDD acceptanceStreettDD = new AcceptanceStreettDD();
        acceptanceStreettDD.add(new AcceptanceStreettDD.StreettPairDD(this.goalStates.copy(), JDD.Constant(0.0)));
        return acceptanceStreettDD;
    }

    @Override
    public AcceptanceGenericDD toAcceptanceGeneric() {
        return new AcceptanceGenericDD(AcceptanceGeneric.ElementType.INF, this.goalStates.copy());
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public void clear() {
        if (this.goalStates != null) {
            JDD.Deref(this.goalStates);
        }
    }
}

