/*
 * Decompiled with CFR 0.152.
 */
package com.sri.yices;

import com.sri.yices.Yices;
import com.sri.yices.YicesException;
import java.util.Arrays;
import java.util.List;

public class Types {
    public static final int NULL_TYPE = -1;
    public static final int BOOL = Yices.boolType();
    public static final int INT = Yices.intType();
    public static final int REAL = Yices.realType();
    public static final int BV8 = Yices.bvType(8);
    public static final int BV16 = Yices.bvType(16);
    public static final int BV32 = Yices.bvType(32);
    public static final int BV64 = Yices.bvType(64);

    public static int boolType() {
        return BOOL;
    }

    public static int intType() {
        return INT;
    }

    public static int realType() {
        return REAL;
    }

    public static int bvType(int n) throws RuntimeException {
        if (n <= 0) {
            throw new IllegalArgumentException("nbits must be positive");
        }
        int n2 = Yices.bvType(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int newScalarType(int n) throws RuntimeException {
        if (n <= 0) {
            throw new IllegalArgumentException("card must be positive");
        }
        int n2 = Yices.newScalarType(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int newScalarType(String string, int n) throws RuntimeException {
        int n2 = Types.newScalarType(n);
        Yices.setTypeName(n2, string);
        return n2;
    }

    public static int newUninterpretedType() {
        return Yices.newUninterpretedType();
    }

    public static int newUninterpretedType(String string) {
        int n = Yices.newUninterpretedType();
        Yices.setTypeName(n, string);
        return n;
    }

    public static void declareUninterpretedType(String string) {
        int n = Yices.newUninterpretedType();
        Yices.setTypeName(n, string);
    }

    public static void declareScalarType(String string, int n) throws YicesException {
        int n2 = Types.newScalarType(n);
        Yices.setTypeName(n2, string);
    }

    public static int tupleType(int ... nArray) throws YicesException {
        int n = Yices.tupleType(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int tupleType(List<Integer> list) throws YicesException {
        return Types.tupleType(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int functionType(int[] nArray, int n) throws RuntimeException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("bad function type: empty domain");
        }
        int n2 = Yices.functionType(n, nArray);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int functionType(int ... nArray) throws RuntimeException {
        if (nArray == null || nArray.length < 2) {
            throw new IllegalArgumentException("bad function type");
        }
        int n = nArray[nArray.length - 1];
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length - 1);
        int n2 = Yices.functionType(n, nArray2);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int functionType(List<Integer> list) throws RuntimeException {
        return Types.functionType(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int predicateType(int ... nArray) throws YicesException {
        return Types.functionType(nArray, BOOL);
    }

    public static int predicateType(List<Integer> list) throws YicesException {
        return Types.predicateType(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static boolean isBool(int n) {
        return Yices.typeIsBool(n);
    }

    public static boolean isInt(int n) {
        return Yices.typeIsInt(n);
    }

    public static boolean isReal(int n) {
        return Yices.typeIsReal(n);
    }

    public static boolean isArithmetic(int n) {
        return Yices.typeIsArithmetic(n);
    }

    public static boolean isBitvector(int n) {
        return Yices.typeIsBitvector(n);
    }

    public static boolean isScalar(int n) {
        return Yices.typeIsScalar(n);
    }

    public static boolean isUninterpreted(int n) {
        return Yices.typeIsUninterpreted(n);
    }

    public static boolean isTuple(int n) {
        return Yices.typeIsTuple(n);
    }

    public static boolean isFunction(int n) {
        return Yices.typeIsFunction(n);
    }

    public static boolean isSubtype(int n, int n2) {
        return Yices.isSubtype(n, n2);
    }

    public static boolean areCompatible(int n, int n2) {
        return Yices.areCompatible(n, n2);
    }

    public static int bvSize(int n) throws YicesException {
        int n2 = Yices.bvTypeSize(n);
        if (n2 <= 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int scalarCard(int n) throws YicesException {
        int n2 = Yices.scalarTypeCard(n);
        if (n2 <= 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int numChildren(int n) throws YicesException {
        int n2 = Yices.typeNumChildren(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int child(int n, int n2) throws YicesException {
        int n3 = Yices.typeChild(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int[] children(int n) throws YicesException {
        int[] nArray = Yices.typeChildren(n);
        if (nArray == null) {
            throw new YicesException();
        }
        return nArray;
    }

    public static void setName(int n, String string) throws YicesException {
        int n2 = Yices.setTypeName(n, string);
        if (n2 < 0) {
            throw new YicesException();
        }
    }

    public static String getName(int n) {
        return Yices.getTypeName(n);
    }

    public static int getByName(String string) {
        return Yices.getTypeByName(string);
    }

    public static void removeName(String string) {
        Yices.removeTypeName(string);
    }

    public static String toString(int n) throws YicesException {
        String string = Yices.typeToString(n);
        if (string == null) {
            throw new YicesException();
        }
        return string;
    }

    public static int parse(String string) throws YicesException {
        int n = Yices.parseType(string);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }
}

