//==============================================================================
//	
//	Copyright (c) 2002-
//	Authors:
//	* Joachim Klein <klein@tcs.inf.tu-dresden.de> (TU Dresden)
//	
//------------------------------------------------------------------------------
//	
//	This file is part of PRISM.
//	
//	PRISM is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//	
//	PRISM is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//	
//	You should have received a copy of the GNU General Public License
//	along with PRISM; if not, write to the Free Software Foundation,
//	Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//	
//==============================================================================

package prism;

/**
 * An exception indicating that a given feature is (currently) not supported,
 * e.g., a given combination of model type, engine and property.
 */
public class PrismNotSupportedException extends PrismException
{
	public PrismNotSupportedException(String s)
	{
		super(s);
	}
	
	@Override
	public PrismNotSupportedException prepend(String prefix)
	{
		return new PrismNotSupportedException(prefix + getMessage());
	}
}
