//==============================================================================
//	
//	Copyright (c) 2020-
//	Authors:
//	* Steffen Maercker <steffen.maercker@tu-dresden.de> (TU Dresden)
//	
//------------------------------------------------------------------------------
//	
//	This file is part of PRISM.
//	
//	PRISM is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//	
//	PRISM is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//	
//	You should have received a copy of the GNU General Public License
//	along with PRISM; if not, write to the Free Software Foundation,
//	Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//	
//==============================================================================

package common.functions;

import java.util.Objects;
import java.util.function.LongUnaryOperator;

/**
 * Functional interface for a binary function (long, T) -> long.
 */
@FunctionalInterface
public interface LongObjToLongFunction<T>
{
	/**
	 * Applies this function to the given arguments.
	 */
	long applyAsLong(long i, T t);

	/**
	 * Returns a composed function that first applies this function to
	 * its input, and then applies the {@code after} function to the result.
	 */
	default <V> LongObjToLongFunction<T> andThen(LongUnaryOperator after) {
		Objects.requireNonNull(after);
		return (long l, T t) -> after.applyAsLong(applyAsLong(l, t));
	}
}
