/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import edu.jas.vector.LinAlg;

public class Examples {
    public static void main(String[] stringArray) {
        Examples.example1();
        Examples.example2();
        Examples.example3();
    }

    public static void example1() {
        System.out.println("\n\n example 1");
        BigInteger bigInteger = new BigInteger();
        System.out.println("cfac = " + bigInteger);
        GenMatrixRing<BigInteger> genMatrixRing = new GenMatrixRing<BigInteger>(bigInteger, 5, 5);
        System.out.println("mfac = " + genMatrixRing);
        GenMatrix genMatrix = genMatrixRing.random(3, 0.4f);
        System.out.println("\nm = " + genMatrix);
        genMatrix = genMatrix.multiply(genMatrix);
        System.out.println("\nm = " + genMatrix);
    }

    public static void example2() {
        System.out.println("\n\n example 2");
        BigRational bigRational = new BigRational();
        System.out.println("cfac = " + bigRational);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, 5, 5);
        System.out.println("mfac = " + genMatrixRing);
        GenMatrix genMatrix = genMatrixRing.random(3, 0.4f);
        System.out.println("\nm = " + genMatrix);
        genMatrix = genMatrix.multiply(genMatrix);
        System.out.println("\nm = " + genMatrix);
    }

    public static void example3() {
        System.out.println("\n\n example 3");
        BigRational bigRational = new BigRational(1L, 10L);
        BigRational bigRational2 = new BigRational(6L, 5L);
        BigRational bigRational3 = new BigRational(1L, 9L);
        BigRational bigRational4 = new BigRational(1L, 1L);
        BigRational bigRational5 = bigRational2.sum(bigRational3);
        BigRational bigRational6 = bigRational.multiply(bigRational4);
        BigRational bigRational7 = new BigRational();
        RingElem[][] ringElemArray = new BigRational[][]{{bigRational, bigRational2, bigRational3}, {bigRational4, bigRational5, bigRational6}, {bigRational2, bigRational, bigRational3}};
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational7, ringElemArray.length, ringElemArray[0].length);
        GenMatrix genMatrix = new GenMatrix(genMatrixRing, ringElemArray);
        System.out.println("system = " + genMatrix);
        RingElem[] ringElemArray2 = new BigRational[]{bigRational, bigRational2, bigRational3};
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(bigRational7, ringElemArray2.length);
        GenVector genVector = new GenVector(genVectorModul, ringElemArray2);
        System.out.println("right hand side = " + genVector);
        LinAlg linAlg = new LinAlg();
        GenVector genVector2 = linAlg.solve(genMatrix, genVector);
        System.out.println("solution = " + genVector2);
    }
}

