/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoMiReducer;
import edu.jas.gbufd.PseudoReducer;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.util.Terminator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBasePseudoParallel<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBasePseudoParallel.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final int threads;
    protected final transient ExecutorService pool;
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> red;
    protected final RingFactory<C> cofac;

    public GroebnerBasePseudoParallel(int n, RingFactory<C> ringFactory) {
        this(n, ringFactory, new PseudoReductionPar());
    }

    public GroebnerBasePseudoParallel(int n, RingFactory<C> ringFactory, PseudoReduction<C> pseudoReduction) {
        this(n, ringFactory, pseudoReduction, Executors.newFixedThreadPool(n));
    }

    public GroebnerBasePseudoParallel(int n, RingFactory<C> ringFactory, PseudoReduction<C> pseudoReduction, ExecutorService executorService) {
        this(n, ringFactory, pseudoReduction, executorService, new OrderedPairlist());
    }

    public GroebnerBasePseudoParallel(int n, RingFactory<C> ringFactory, PairList<C> pairList) {
        this(n, ringFactory, new PseudoReductionPar(), Executors.newFixedThreadPool(n), pairList);
    }

    public GroebnerBasePseudoParallel(int n, RingFactory<C> ringFactory, PseudoReduction<C> pseudoReduction, ExecutorService executorService, PairList<C> pairList) {
        super(pseudoReduction, pairList);
        if (!(pseudoReduction instanceof PseudoReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        this.red = pseudoReduction;
        this.cofac = ringFactory;
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.engine = GCDFactory.getImplementation(ringFactory);
        this.pool = executorService;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.shutdown();
        try {
            while (!this.pool.isTerminated()) {
                boolean bl = this.pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        logger.info(this.pool.toString());
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int n = this.pool.shutdownNow().size();
        logger.info(this.pool.toString());
        return n;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = this.engine.basePrimitivePart(list2)).size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        logger.info("start " + pairList);
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            PseudoReducer<C> pseudoReducer = new PseudoReducer<C>(terminator, list2, pairList, this.engine);
            this.pool.execute(pseudoReducer);
        }
        terminator.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug("#parallel list = " + list2.size());
        list2 = this.minimalGB(list2);
        logger.info("" + pairList);
        return list2;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        Object object;
        GenPolynomial<C> genPolynomial;
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list2.size());
        while (list2.size() > 0) {
            genPolynomial = list2.remove(0);
            if (this.red.isTopReducible(list2, genPolynomial) || this.red.isTopReducible(arrayList, genPolynomial)) {
                if (!debug) continue;
                System.out.println("dropped " + genPolynomial);
                object = new ArrayList<GenPolynomial<C>>(list2);
                object.addAll(arrayList);
                if ((genPolynomial = this.red.normalform((List<GenPolynomial<C>>)object, genPolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genPolynomial);
                continue;
            }
            arrayList.add(genPolynomial);
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        Collections.reverse(list2);
        object = new PseudoMiReducer[list2.size()];
        int n = 0;
        arrayList = new ArrayList(list2.size());
        while (list2.size() > 0) {
            genPolynomial = list2.remove(0);
            ArrayList arrayList2 = new ArrayList(list2.size() + arrayList.size());
            arrayList2.addAll(list2);
            arrayList2.addAll(arrayList);
            object[n] = new PseudoMiReducer(arrayList2, genPolynomial, this.engine);
            this.pool.execute((Runnable)object[n]);
            ++n;
            arrayList.add(genPolynomial);
        }
        list2 = arrayList;
        arrayList = new ArrayList(list2.size());
        for (n = 0; n < ((Object)object).length; ++n) {
            genPolynomial = ((PseudoMiReducer)object[n]).getNF();
            arrayList.add(genPolynomial);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }
}

