/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableResidue;
import edu.jas.application.SolvableResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.NotInvertibleException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableResidueTest
extends TestCase {
    SolvableIdeal<BigRational> id;
    SolvableResidueRing<BigRational> fac;
    GenSolvablePolynomialRing<BigRational> mfac;
    List<GenSolvablePolynomial<BigRational>> F;
    SolvableResidue<BigRational> a;
    SolvableResidue<BigRational> b;
    SolvableResidue<BigRational> c;
    SolvableResidue<BigRational> d;
    SolvableResidue<BigRational> e;
    int rl = 4;
    int kl = 2;
    int ll = 3;
    int el = 2;
    float q = 0.2f;
    int il = this.rl == 1 ? 1 : 2;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvableResidueTest.suite());
    }

    public SolvableResidueTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableResidueTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.mfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.rl, termOrder, stringArray);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.mfac);
        if (!this.mfac.isAssociative()) {
            System.out.println("ring not associative: " + this.mfac);
        }
        do {
            this.F = new ArrayList<GenSolvablePolynomial<BigRational>>(this.il);
            for (int i = 0; i < this.il; ++i) {
                GenPolynomial genPolynomial = this.mfac.random(this.kl, this.ll, this.el, this.q);
                while (genPolynomial.isConstant()) {
                    genPolynomial = this.mfac.random(this.kl, this.ll, this.el, this.q);
                }
                this.F.add((GenSolvablePolynomial<BigRational>)genPolynomial);
            }
            this.id = new SolvableIdeal<BigRational>(this.mfac, this.F);
            this.id.doGB();
        } while (this.id.isONE());
        assert (!this.id.isONE()) : "id = " + this.id;
        this.fac = new SolvableResidueRing<BigRational>(this.id);
        this.F = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.id = null;
        this.mfac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        SolvableResidueTest.assertTrue((String)"length( c ) = 1 ", (this.c.val.length() == 1 || this.id.isONE() ? 1 : 0) != 0);
        SolvableResidueTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() || this.id.isONE() ? 1 : 0) != 0);
        SolvableResidueTest.assertTrue((String)"isONE( c )", (this.c.isONE() || this.id.isONE() ? 1 : 0) != 0);
        this.d = this.fac.getZERO();
        SolvableResidueTest.assertTrue((String)"length( d ) = 0", (this.d.val.length() == 0 ? 1 : 0) != 0);
        SolvableResidueTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        SolvableResidueTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (SolvableResidue<BigRational> solvableResidue : this.fac.generators()) {
            SolvableResidueTest.assertFalse((String)"not isZERO( g )", (boolean)solvableResidue.isZERO());
        }
    }

    public void testRandom() {
        for (int i = 1; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            if (this.a.isZERO() || this.a.isONE()) continue;
            SolvableResidueTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.val.length() >= 0 ? 1 : 0) != 0);
            SolvableResidueTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            SolvableResidueTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        SolvableResidueTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        SolvableResidueTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        SolvableResidueTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((SolvableResidue<BigRational>)this.fac.getZERO());
        this.d = this.a.subtract((SolvableResidue<BigRational>)this.fac.getZERO());
        SolvableResidueTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((SolvableResidue)this.fac.getZERO()).sum(this.a);
        this.d = ((SolvableResidue)this.fac.getZERO()).subtract(this.a.negate());
        SolvableResidueTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        List<SolvableResidue<BigRational>> list = this.fac.generators();
        this.a = list.get(1);
        if (this.a.isZERO()) {
            this.a = this.fac.getONE();
        }
        SolvableResidueTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        if (this.b.isZERO()) {
            this.b = this.fac.getONE();
        }
        SolvableResidueTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.a.multiply((BigRational)this.fac.getONE());
        this.d = ((SolvableResidue)this.fac.getONE()).multiply(this.a);
        SolvableResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        SolvableResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.a);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        SolvableResidueTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        SolvableResidueTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.c = this.fac.random(this.kl, this.ll + 1, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        SolvableResidueTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        if (!this.a.isZERO()) {
            try {
                this.c = this.a.inverse();
                this.d = this.c.multiply((BigRational)((Object)this.a));
                SolvableResidueTest.assertTrue((String)("a*1/a = 1: " + this.fac), (boolean)this.d.isONE());
            }
            catch (NotInvertibleException notInvertibleException) {
                // empty catch block
            }
        }
    }
}

