/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class AlgebraicNumberIterator<C extends RingElem<C>>
implements Iterator<AlgebraicNumber<C>> {
    final Iterator<List<C>> iter;
    final List<GenPolynomial<C>> powers;
    final AlgebraicNumberRing<C> aring;
    private static final Logger logger = LogManager.getLogger(AlgebraicNumberIterator.class);

    public AlgebraicNumberIterator(AlgebraicNumberRing<C> algebraicNumberRing) {
        RingFactory ringFactory = algebraicNumberRing.ring.coFac;
        this.aring = algebraicNumberRing;
        long l = algebraicNumberRing.modul.degree(0);
        this.powers = new ArrayList<GenPolynomial<C>>((int)l);
        for (long i = l - 1L; i >= 0L; --i) {
            this.powers.add(algebraicNumberRing.ring.univariate(0, i));
        }
        if (!(ringFactory instanceof Iterable)) {
            throw new IllegalArgumentException("only for iterable coefficients implemented");
        }
        ArrayList<Iterable<Iterable>> arrayList = new ArrayList<Iterable<Iterable>>((int)l);
        Iterable iterable = (Iterable)((Object)ringFactory);
        for (long i = 0L; i < l; ++i) {
            arrayList.add(iterable);
        }
        if (ringFactory.isFinite()) {
            CartesianProduct cartesianProduct = new CartesianProduct(arrayList);
            this.iter = cartesianProduct.iterator();
        } else {
            CartesianProductInfinite cartesianProductInfinite = new CartesianProductInfinite(arrayList);
            this.iter = cartesianProductInfinite.iterator();
        }
        logger.info("iterator for degree {}, finite = {}", (Object)l, (Object)ringFactory.isFinite());
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public AlgebraicNumber<C> next() {
        List<C> list = this.iter.next();
        GenPolynomial<GenPolynomial<RingElem>> genPolynomial = this.aring.ring.getZERO();
        int n = 0;
        for (GenPolynomial<RingElem> genPolynomial2 : this.powers) {
            RingElem ringElem;
            if ((ringElem = (RingElem)list.get(n++)).isZERO()) continue;
            genPolynomial = genPolynomial.sum(genPolynomial2.multiply(ringElem));
        }
        return new AlgebraicNumber<C>(this.aring, genPolynomial);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

