/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import parser.PrismSyntaxHighlighter;
import prism.PrismLangException;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.Style;

class PrismView
extends PlainView {
    static final Style PLAIN_S = new Style(Color.black, 0);
    private GUIMultiModelHandler handler;

    public PrismView(Element element, GUIMultiModelHandler gUIMultiModelHandler) {
        super(element);
        this.handler = gUIMultiModelHandler;
    }

    @Override
    protected float drawUnselectedText(Graphics2D graphics2D, float f, float f2, int n, int n2) throws BadLocationException {
        int n3 = n;
        int n4 = n2;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        try {
            graphics2D.setColor(Color.green);
            Document document = this.getDocument();
            String string = document.getText(n3, n4 - n3);
            Style[] styleArray = this.highlight(string, n - n3, n2 - n);
            String string2 = this.handler.getPrismEditorFontFast().getName();
            int n5 = this.handler.getPrismEditorFontFast().getSize();
            for (int i = 0; i < styleArray.length; ++i) {
                Style style = styleArray[i];
                graphics2D.setColor(style.c);
                graphics2D.setFont(new Font(string2, style.style, n5));
                Segment segment = new Segment();
                document.getText(n + i, 1, segment);
                f = Utilities.drawTabbedText(segment, f, f2, graphics2D, (TabExpander)this, n + i);
            }
            graphics2D.setColor(Color.black);
            graphics2D.setFont(new Font(string2, 0, n5));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return f;
    }

    @Override
    protected float drawSelectedText(Graphics2D graphics2D, float f, float f2, int n, int n2) throws BadLocationException {
        int n3 = n;
        int n4 = n2;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        try {
            graphics2D.setColor(Color.green);
            Document document = this.getDocument();
            String string = document.getText(n3, n4 - n3);
            Style[] styleArray = this.highlight(string, n - n3, n2 - n);
            String string2 = this.handler.getPrismEditorFontFast().getName();
            int n5 = this.handler.getPrismEditorFontFast().getSize();
            for (int i = 0; i < styleArray.length; ++i) {
                Style style = styleArray[i];
                graphics2D.setColor(style.c);
                graphics2D.setFont(new Font(string2, style.style, n5));
                Segment segment = new Segment();
                document.getText(n + i, 1, segment);
                f = Utilities.drawTabbedText(segment, f, f2, graphics2D, (TabExpander)this, n + i);
            }
            graphics2D.setColor(Color.black);
            graphics2D.setFont(new Font(string2, 0, n5));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return f;
    }

    private synchronized Style[] highlight(String object, int n, int n2) {
        int n3;
        int[] nArray;
        if (!((String)object).endsWith("\n")) {
            object = (String)object + "\n";
        }
        try {
            nArray = PrismSyntaxHighlighter.lineForPrismGUI((String)object);
        }
        catch (PrismLangException prismLangException) {
            int n4 = ((String)object).length();
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = 0;
            }
        }
        Style[] styleArray = new Style[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 + n < nArray.length) {
                switch (nArray[n3 + n]) {
                    case 0: {
                        styleArray[n3] = PLAIN_S;
                        break;
                    }
                    case 1: {
                        styleArray[n3] = this.handler.getPrismEditorCommentFast();
                        break;
                    }
                    case 2: {
                        styleArray[n3] = PLAIN_S;
                        break;
                    }
                    case 3: {
                        styleArray[n3] = this.handler.getPrismEditorKeywordFast();
                        break;
                    }
                    case 4: {
                        styleArray[n3] = this.handler.getPrismEditorNumericFast();
                        break;
                    }
                    case 5: {
                        styleArray[n3] = this.handler.getPrismEditorVariableFast();
                        break;
                    }
                    default: {
                        styleArray[n3] = PLAIN_S;
                        break;
                    }
                }
                continue;
            }
            styleArray[n3] = PLAIN_S;
        }
        return styleArray;
    }
}

